/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BatchJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#batch_pool_id BatchJob#batch_pool_id}
    */
    readonly batchPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#common_environment_properties BatchJob#common_environment_properties}
    */
    readonly commonEnvironmentProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#display_name BatchJob#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#id BatchJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#name BatchJob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#priority BatchJob#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#task_retry_maximum BatchJob#task_retry_maximum}
    */
    readonly taskRetryMaximum?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#timeouts BatchJob#timeouts}
    */
    readonly timeouts?: BatchJobTimeouts;
}
export interface BatchJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#create BatchJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#delete BatchJob#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#read BatchJob#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#update BatchJob#update}
    */
    readonly update?: string;
}
export declare function batchJobTimeoutsToTerraform(struct?: BatchJobTimeouts | cdktf.IResolvable): any;
export declare function batchJobTimeoutsToHclTerraform(struct?: BatchJobTimeouts | cdktf.IResolvable): any;
export declare class BatchJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BatchJobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job azurerm_batch_job}
*/
export declare class BatchJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_batch_job";
    /**
    * Generates CDKTF code for importing a BatchJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BatchJob to import
    * @param importFromId The id of the existing BatchJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BatchJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/batch_job azurerm_batch_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchJobConfig
    */
    constructor(scope: Construct, id: string, config: BatchJobConfig);
    private _batchPoolId?;
    get batchPoolId(): string;
    set batchPoolId(value: string);
    get batchPoolIdInput(): string | undefined;
    private _commonEnvironmentProperties?;
    get commonEnvironmentProperties(): {
        [key: string]: string;
    };
    set commonEnvironmentProperties(value: {
        [key: string]: string;
    });
    resetCommonEnvironmentProperties(): void;
    get commonEnvironmentPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _taskRetryMaximum?;
    get taskRetryMaximum(): number;
    set taskRetryMaximum(value: number);
    resetTaskRetryMaximum(): void;
    get taskRetryMaximumInput(): number | undefined;
    private _timeouts;
    get timeouts(): BatchJobTimeoutsOutputReference;
    putTimeouts(value: BatchJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BatchJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
