/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermArcMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#id DataAzurermArcMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#name DataAzurermArcMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#resource_group_name DataAzurermArcMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#timeouts DataAzurermArcMachine#timeouts}
    */
    readonly timeouts?: DataAzurermArcMachineTimeouts;
}
export interface DataAzurermArcMachineAgentExtensionsAllowListStruct {
}
export declare function dataAzurermArcMachineAgentExtensionsAllowListStructToTerraform(struct?: DataAzurermArcMachineAgentExtensionsAllowListStruct): any;
export declare function dataAzurermArcMachineAgentExtensionsAllowListStructToHclTerraform(struct?: DataAzurermArcMachineAgentExtensionsAllowListStruct): any;
export declare class DataAzurermArcMachineAgentExtensionsAllowListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineAgentExtensionsAllowListStruct | undefined;
    set internalValue(value: DataAzurermArcMachineAgentExtensionsAllowListStruct | undefined);
    get publisher(): string;
    get type(): string;
}
export declare class DataAzurermArcMachineAgentExtensionsAllowListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineAgentExtensionsAllowListStructOutputReference;
}
export interface DataAzurermArcMachineAgentExtensionsBlockListStruct {
}
export declare function dataAzurermArcMachineAgentExtensionsBlockListStructToTerraform(struct?: DataAzurermArcMachineAgentExtensionsBlockListStruct): any;
export declare function dataAzurermArcMachineAgentExtensionsBlockListStructToHclTerraform(struct?: DataAzurermArcMachineAgentExtensionsBlockListStruct): any;
export declare class DataAzurermArcMachineAgentExtensionsBlockListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineAgentExtensionsBlockListStruct | undefined;
    set internalValue(value: DataAzurermArcMachineAgentExtensionsBlockListStruct | undefined);
    get publisher(): string;
    get type(): string;
}
export declare class DataAzurermArcMachineAgentExtensionsBlockListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineAgentExtensionsBlockListStructOutputReference;
}
export interface DataAzurermArcMachineAgent {
}
export declare function dataAzurermArcMachineAgentToTerraform(struct?: DataAzurermArcMachineAgent): any;
export declare function dataAzurermArcMachineAgentToHclTerraform(struct?: DataAzurermArcMachineAgent): any;
export declare class DataAzurermArcMachineAgentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineAgent | undefined;
    set internalValue(value: DataAzurermArcMachineAgent | undefined);
    private _extensionsAllowList;
    get extensionsAllowList(): DataAzurermArcMachineAgentExtensionsAllowListStructList;
    private _extensionsBlockList;
    get extensionsBlockList(): DataAzurermArcMachineAgentExtensionsBlockListStructList;
    get extensionsEnabled(): cdktf.IResolvable;
    get guestConfigurationEnabled(): cdktf.IResolvable;
    get incomingConnectionsPorts(): string[];
    get proxyBypass(): string[];
    get proxyUrl(): string;
}
export declare class DataAzurermArcMachineAgentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineAgentOutputReference;
}
export interface DataAzurermArcMachineCloudMetadata {
}
export declare function dataAzurermArcMachineCloudMetadataToTerraform(struct?: DataAzurermArcMachineCloudMetadata): any;
export declare function dataAzurermArcMachineCloudMetadataToHclTerraform(struct?: DataAzurermArcMachineCloudMetadata): any;
export declare class DataAzurermArcMachineCloudMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineCloudMetadata | undefined;
    set internalValue(value: DataAzurermArcMachineCloudMetadata | undefined);
    get provider(): string;
}
export declare class DataAzurermArcMachineCloudMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineCloudMetadataOutputReference;
}
export interface DataAzurermArcMachineIdentity {
}
export declare function dataAzurermArcMachineIdentityToTerraform(struct?: DataAzurermArcMachineIdentity): any;
export declare function dataAzurermArcMachineIdentityToHclTerraform(struct?: DataAzurermArcMachineIdentity): any;
export declare class DataAzurermArcMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineIdentity | undefined;
    set internalValue(value: DataAzurermArcMachineIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermArcMachineIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineIdentityOutputReference;
}
export interface DataAzurermArcMachineLocationData {
}
export declare function dataAzurermArcMachineLocationDataToTerraform(struct?: DataAzurermArcMachineLocationData): any;
export declare function dataAzurermArcMachineLocationDataToHclTerraform(struct?: DataAzurermArcMachineLocationData): any;
export declare class DataAzurermArcMachineLocationDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineLocationData | undefined;
    set internalValue(value: DataAzurermArcMachineLocationData | undefined);
    get city(): string;
    get countryOrRegion(): string;
    get district(): string;
    get name(): string;
}
export declare class DataAzurermArcMachineLocationDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineLocationDataOutputReference;
}
export interface DataAzurermArcMachineOsProfileLinuxPatch {
}
export declare function dataAzurermArcMachineOsProfileLinuxPatchToTerraform(struct?: DataAzurermArcMachineOsProfileLinuxPatch): any;
export declare function dataAzurermArcMachineOsProfileLinuxPatchToHclTerraform(struct?: DataAzurermArcMachineOsProfileLinuxPatch): any;
export declare class DataAzurermArcMachineOsProfileLinuxPatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineOsProfileLinuxPatch | undefined;
    set internalValue(value: DataAzurermArcMachineOsProfileLinuxPatch | undefined);
    get assessmentMode(): string;
    get patchMode(): string;
}
export declare class DataAzurermArcMachineOsProfileLinuxPatchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineOsProfileLinuxPatchOutputReference;
}
export interface DataAzurermArcMachineOsProfileLinux {
}
export declare function dataAzurermArcMachineOsProfileLinuxToTerraform(struct?: DataAzurermArcMachineOsProfileLinux): any;
export declare function dataAzurermArcMachineOsProfileLinuxToHclTerraform(struct?: DataAzurermArcMachineOsProfileLinux): any;
export declare class DataAzurermArcMachineOsProfileLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineOsProfileLinux | undefined;
    set internalValue(value: DataAzurermArcMachineOsProfileLinux | undefined);
    private _patch;
    get patch(): DataAzurermArcMachineOsProfileLinuxPatchList;
}
export declare class DataAzurermArcMachineOsProfileLinuxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineOsProfileLinuxOutputReference;
}
export interface DataAzurermArcMachineOsProfileWindowsPatch {
}
export declare function dataAzurermArcMachineOsProfileWindowsPatchToTerraform(struct?: DataAzurermArcMachineOsProfileWindowsPatch): any;
export declare function dataAzurermArcMachineOsProfileWindowsPatchToHclTerraform(struct?: DataAzurermArcMachineOsProfileWindowsPatch): any;
export declare class DataAzurermArcMachineOsProfileWindowsPatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineOsProfileWindowsPatch | undefined;
    set internalValue(value: DataAzurermArcMachineOsProfileWindowsPatch | undefined);
    get assessmentMode(): string;
    get patchMode(): string;
}
export declare class DataAzurermArcMachineOsProfileWindowsPatchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineOsProfileWindowsPatchOutputReference;
}
export interface DataAzurermArcMachineOsProfileWindows {
}
export declare function dataAzurermArcMachineOsProfileWindowsToTerraform(struct?: DataAzurermArcMachineOsProfileWindows): any;
export declare function dataAzurermArcMachineOsProfileWindowsToHclTerraform(struct?: DataAzurermArcMachineOsProfileWindows): any;
export declare class DataAzurermArcMachineOsProfileWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineOsProfileWindows | undefined;
    set internalValue(value: DataAzurermArcMachineOsProfileWindows | undefined);
    private _patch;
    get patch(): DataAzurermArcMachineOsProfileWindowsPatchList;
}
export declare class DataAzurermArcMachineOsProfileWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineOsProfileWindowsOutputReference;
}
export interface DataAzurermArcMachineOsProfile {
}
export declare function dataAzurermArcMachineOsProfileToTerraform(struct?: DataAzurermArcMachineOsProfile): any;
export declare function dataAzurermArcMachineOsProfileToHclTerraform(struct?: DataAzurermArcMachineOsProfile): any;
export declare class DataAzurermArcMachineOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineOsProfile | undefined;
    set internalValue(value: DataAzurermArcMachineOsProfile | undefined);
    get computerName(): string;
    private _linux;
    get linux(): DataAzurermArcMachineOsProfileLinuxList;
    private _windows;
    get windows(): DataAzurermArcMachineOsProfileWindowsList;
}
export declare class DataAzurermArcMachineOsProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineOsProfileOutputReference;
}
export interface DataAzurermArcMachineServiceStatusExtensionService {
}
export declare function dataAzurermArcMachineServiceStatusExtensionServiceToTerraform(struct?: DataAzurermArcMachineServiceStatusExtensionService): any;
export declare function dataAzurermArcMachineServiceStatusExtensionServiceToHclTerraform(struct?: DataAzurermArcMachineServiceStatusExtensionService): any;
export declare class DataAzurermArcMachineServiceStatusExtensionServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineServiceStatusExtensionService | undefined;
    set internalValue(value: DataAzurermArcMachineServiceStatusExtensionService | undefined);
    get startupType(): string;
    get status(): string;
}
export declare class DataAzurermArcMachineServiceStatusExtensionServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineServiceStatusExtensionServiceOutputReference;
}
export interface DataAzurermArcMachineServiceStatusGuestConfigurationService {
}
export declare function dataAzurermArcMachineServiceStatusGuestConfigurationServiceToTerraform(struct?: DataAzurermArcMachineServiceStatusGuestConfigurationService): any;
export declare function dataAzurermArcMachineServiceStatusGuestConfigurationServiceToHclTerraform(struct?: DataAzurermArcMachineServiceStatusGuestConfigurationService): any;
export declare class DataAzurermArcMachineServiceStatusGuestConfigurationServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineServiceStatusGuestConfigurationService | undefined;
    set internalValue(value: DataAzurermArcMachineServiceStatusGuestConfigurationService | undefined);
    get startupType(): string;
    get status(): string;
}
export declare class DataAzurermArcMachineServiceStatusGuestConfigurationServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineServiceStatusGuestConfigurationServiceOutputReference;
}
export interface DataAzurermArcMachineServiceStatus {
}
export declare function dataAzurermArcMachineServiceStatusToTerraform(struct?: DataAzurermArcMachineServiceStatus): any;
export declare function dataAzurermArcMachineServiceStatusToHclTerraform(struct?: DataAzurermArcMachineServiceStatus): any;
export declare class DataAzurermArcMachineServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermArcMachineServiceStatus | undefined;
    set internalValue(value: DataAzurermArcMachineServiceStatus | undefined);
    private _extensionService;
    get extensionService(): DataAzurermArcMachineServiceStatusExtensionServiceList;
    private _guestConfigurationService;
    get guestConfigurationService(): DataAzurermArcMachineServiceStatusGuestConfigurationServiceList;
}
export declare class DataAzurermArcMachineServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermArcMachineServiceStatusOutputReference;
}
export interface DataAzurermArcMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#read DataAzurermArcMachine#read}
    */
    readonly read?: string;
}
export declare function dataAzurermArcMachineTimeoutsToTerraform(struct?: DataAzurermArcMachineTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermArcMachineTimeoutsToHclTerraform(struct?: DataAzurermArcMachineTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermArcMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermArcMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermArcMachineTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine azurerm_arc_machine}
*/
export declare class DataAzurermArcMachine extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_arc_machine";
    /**
    * Generates CDKTF code for importing a DataAzurermArcMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermArcMachine to import
    * @param importFromId The id of the existing DataAzurermArcMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermArcMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/arc_machine azurerm_arc_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermArcMachineConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermArcMachineConfig);
    get activeDirectoryFqdn(): string;
    private _agent;
    get agent(): DataAzurermArcMachineAgentList;
    get agentVersion(): string;
    get clientPublicKey(): string;
    private _cloudMetadata;
    get cloudMetadata(): DataAzurermArcMachineCloudMetadataList;
    private _detectedProperties;
    get detectedProperties(): cdktf.StringMap;
    get displayName(): string;
    get dnsFqdn(): string;
    get domainName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermArcMachineIdentityList;
    get lastStatusChangeTime(): string;
    get location(): string;
    private _locationData;
    get locationData(): DataAzurermArcMachineLocationDataList;
    get machineFqdn(): string;
    get mssqlDiscovered(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osName(): string;
    private _osProfile;
    get osProfile(): DataAzurermArcMachineOsProfileList;
    get osSku(): string;
    get osType(): string;
    get osVersion(): string;
    get parentClusterResourceId(): string;
    get privateLinkScopeResourceId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceStatus;
    get serviceStatus(): DataAzurermArcMachineServiceStatusList;
    get status(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get vmId(): string;
    get vmUuid(): string;
    private _timeouts;
    get timeouts(): DataAzurermArcMachineTimeoutsOutputReference;
    putTimeouts(value: DataAzurermArcMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermArcMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
