/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevCenterCatalogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#dev_center_id DataAzurermDevCenterCatalog#dev_center_id}
    */
    readonly devCenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#id DataAzurermDevCenterCatalog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#name DataAzurermDevCenterCatalog#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#timeouts DataAzurermDevCenterCatalog#timeouts}
    */
    readonly timeouts?: DataAzurermDevCenterCatalogTimeouts;
}
export interface DataAzurermDevCenterCatalogCatalogAdogit {
}
export declare function dataAzurermDevCenterCatalogCatalogAdogitToTerraform(struct?: DataAzurermDevCenterCatalogCatalogAdogit): any;
export declare function dataAzurermDevCenterCatalogCatalogAdogitToHclTerraform(struct?: DataAzurermDevCenterCatalogCatalogAdogit): any;
export declare class DataAzurermDevCenterCatalogCatalogAdogitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevCenterCatalogCatalogAdogit | undefined;
    set internalValue(value: DataAzurermDevCenterCatalogCatalogAdogit | undefined);
    get branch(): string;
    get keyVaultKeyUrl(): string;
    get path(): string;
    get uri(): string;
}
export declare class DataAzurermDevCenterCatalogCatalogAdogitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevCenterCatalogCatalogAdogitOutputReference;
}
export interface DataAzurermDevCenterCatalogCatalogGithub {
}
export declare function dataAzurermDevCenterCatalogCatalogGithubToTerraform(struct?: DataAzurermDevCenterCatalogCatalogGithub): any;
export declare function dataAzurermDevCenterCatalogCatalogGithubToHclTerraform(struct?: DataAzurermDevCenterCatalogCatalogGithub): any;
export declare class DataAzurermDevCenterCatalogCatalogGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevCenterCatalogCatalogGithub | undefined;
    set internalValue(value: DataAzurermDevCenterCatalogCatalogGithub | undefined);
    get branch(): string;
    get keyVaultKeyUrl(): string;
    get path(): string;
    get uri(): string;
}
export declare class DataAzurermDevCenterCatalogCatalogGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevCenterCatalogCatalogGithubOutputReference;
}
export interface DataAzurermDevCenterCatalogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#read DataAzurermDevCenterCatalog#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevCenterCatalogTimeoutsToTerraform(struct?: DataAzurermDevCenterCatalogTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDevCenterCatalogTimeoutsToHclTerraform(struct?: DataAzurermDevCenterCatalogTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevCenterCatalogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevCenterCatalogTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevCenterCatalogTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog azurerm_dev_center_catalog}
*/
export declare class DataAzurermDevCenterCatalog extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_center_catalog";
    /**
    * Generates CDKTF code for importing a DataAzurermDevCenterCatalog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevCenterCatalog to import
    * @param importFromId The id of the existing DataAzurermDevCenterCatalog that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevCenterCatalog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dev_center_catalog azurerm_dev_center_catalog} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevCenterCatalogConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevCenterCatalogConfig);
    private _catalogAdogit;
    get catalogAdogit(): DataAzurermDevCenterCatalogCatalogAdogitList;
    private _catalogGithub;
    get catalogGithub(): DataAzurermDevCenterCatalogCatalogGithubList;
    private _devCenterId?;
    get devCenterId(): string;
    set devCenterId(value: string);
    get devCenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDevCenterCatalogTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevCenterCatalogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevCenterCatalogTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
