/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDnsSoaRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#id DataAzurermDnsSoaRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#name DataAzurermDnsSoaRecord#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#resource_group_name DataAzurermDnsSoaRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#zone_name DataAzurermDnsSoaRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#timeouts DataAzurermDnsSoaRecord#timeouts}
    */
    readonly timeouts?: DataAzurermDnsSoaRecordTimeouts;
}
export interface DataAzurermDnsSoaRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#read DataAzurermDnsSoaRecord#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDnsSoaRecordTimeoutsToTerraform(struct?: DataAzurermDnsSoaRecordTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDnsSoaRecordTimeoutsToHclTerraform(struct?: DataAzurermDnsSoaRecordTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDnsSoaRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDnsSoaRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDnsSoaRecordTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record azurerm_dns_soa_record}
*/
export declare class DataAzurermDnsSoaRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dns_soa_record";
    /**
    * Generates CDKTF code for importing a DataAzurermDnsSoaRecord resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDnsSoaRecord to import
    * @param importFromId The id of the existing DataAzurermDnsSoaRecord that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDnsSoaRecord to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dns_soa_record azurerm_dns_soa_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDnsSoaRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDnsSoaRecordConfig);
    get email(): string;
    get expireTime(): number;
    get fqdn(): string;
    get hostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get minimumTtl(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get refreshTime(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get retryTime(): number;
    get serialNumber(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get ttl(): number;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDnsSoaRecordTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDnsSoaRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDnsSoaRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
