/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDynatraceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#id DataAzurermDynatraceMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#name DataAzurermDynatraceMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#resource_group_name DataAzurermDynatraceMonitor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#timeouts DataAzurermDynatraceMonitor#timeouts}
    */
    readonly timeouts?: DataAzurermDynatraceMonitorTimeouts;
}
export interface DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfo {
}
export declare function dataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoToTerraform(struct?: DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfo): any;
export declare function dataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoToHclTerraform(struct?: DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfo): any;
export declare class DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfo | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfo | undefined);
    get environmentId(): string;
}
export declare class DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoOutputReference;
}
export interface DataAzurermDynatraceMonitorEnvironmentProperties {
}
export declare function dataAzurermDynatraceMonitorEnvironmentPropertiesToTerraform(struct?: DataAzurermDynatraceMonitorEnvironmentProperties): any;
export declare function dataAzurermDynatraceMonitorEnvironmentPropertiesToHclTerraform(struct?: DataAzurermDynatraceMonitorEnvironmentProperties): any;
export declare class DataAzurermDynatraceMonitorEnvironmentPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDynatraceMonitorEnvironmentProperties | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorEnvironmentProperties | undefined);
    private _environmentInfo;
    get environmentInfo(): DataAzurermDynatraceMonitorEnvironmentPropertiesEnvironmentInfoList;
}
export declare class DataAzurermDynatraceMonitorEnvironmentPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDynatraceMonitorEnvironmentPropertiesOutputReference;
}
export interface DataAzurermDynatraceMonitorIdentity {
}
export declare function dataAzurermDynatraceMonitorIdentityToTerraform(struct?: DataAzurermDynatraceMonitorIdentity): any;
export declare function dataAzurermDynatraceMonitorIdentityToHclTerraform(struct?: DataAzurermDynatraceMonitorIdentity): any;
export declare class DataAzurermDynatraceMonitorIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDynatraceMonitorIdentity | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDynatraceMonitorIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDynatraceMonitorIdentityOutputReference;
}
export interface DataAzurermDynatraceMonitorPlan {
}
export declare function dataAzurermDynatraceMonitorPlanToTerraform(struct?: DataAzurermDynatraceMonitorPlan): any;
export declare function dataAzurermDynatraceMonitorPlanToHclTerraform(struct?: DataAzurermDynatraceMonitorPlan): any;
export declare class DataAzurermDynatraceMonitorPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDynatraceMonitorPlan | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorPlan | undefined);
    get billingCycle(): string;
    get effectiveDate(): string;
    get plan(): string;
    get usageType(): string;
}
export declare class DataAzurermDynatraceMonitorPlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDynatraceMonitorPlanOutputReference;
}
export interface DataAzurermDynatraceMonitorUser {
}
export declare function dataAzurermDynatraceMonitorUserToTerraform(struct?: DataAzurermDynatraceMonitorUser): any;
export declare function dataAzurermDynatraceMonitorUserToHclTerraform(struct?: DataAzurermDynatraceMonitorUser): any;
export declare class DataAzurermDynatraceMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDynatraceMonitorUser | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorUser | undefined);
    get country(): string;
    get email(): string;
    get firstName(): string;
    get lastName(): string;
    get phoneNumber(): string;
}
export declare class DataAzurermDynatraceMonitorUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDynatraceMonitorUserOutputReference;
}
export interface DataAzurermDynatraceMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#read DataAzurermDynatraceMonitor#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDynatraceMonitorTimeoutsToTerraform(struct?: DataAzurermDynatraceMonitorTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDynatraceMonitorTimeoutsToHclTerraform(struct?: DataAzurermDynatraceMonitorTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDynatraceMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDynatraceMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDynatraceMonitorTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor azurerm_dynatrace_monitor}
*/
export declare class DataAzurermDynatraceMonitor extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dynatrace_monitor";
    /**
    * Generates CDKTF code for importing a DataAzurermDynatraceMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDynatraceMonitor to import
    * @param importFromId The id of the existing DataAzurermDynatraceMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDynatraceMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/dynatrace_monitor azurerm_dynatrace_monitor} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDynatraceMonitorConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDynatraceMonitorConfig);
    private _environmentProperties;
    get environmentProperties(): DataAzurermDynatraceMonitorEnvironmentPropertiesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermDynatraceMonitorIdentityList;
    get location(): string;
    get marketplaceSubscription(): string;
    get monitoringEnabled(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _plan;
    get plan(): DataAzurermDynatraceMonitorPlanList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _user;
    get user(): DataAzurermDynatraceMonitorUserList;
    private _timeouts;
    get timeouts(): DataAzurermDynatraceMonitorTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDynatraceMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDynatraceMonitorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
