/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappVolumeGroupOracleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#account_name DataAzurermNetappVolumeGroupOracle#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#id DataAzurermNetappVolumeGroupOracle#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#name DataAzurermNetappVolumeGroupOracle#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#resource_group_name DataAzurermNetappVolumeGroupOracle#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#timeouts DataAzurermNetappVolumeGroupOracle#timeouts}
    */
    readonly timeouts?: DataAzurermNetappVolumeGroupOracleTimeouts;
}
export interface DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplication {
}
export declare function dataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationToTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplication): any;
export declare function dataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationToHclTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplication): any;
export declare class DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplication | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplication | undefined);
    get endpointType(): string;
    get remoteVolumeLocation(): string;
    get remoteVolumeResourceId(): string;
    get replicationFrequency(): string;
}
export declare class DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference;
}
export interface DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy {
}
export declare function dataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyToTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy): any;
export declare function dataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyToHclTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy): any;
export declare class DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy | undefined);
    get snapshotPolicyId(): string;
}
export declare class DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference;
}
export interface DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRule {
}
export declare function dataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleToTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRule): any;
export declare function dataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleToHclTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRule): any;
export declare class DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRule | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRule | undefined);
    get allowedClients(): string;
    get nfsv3Enabled(): cdktf.IResolvable;
    get nfsv41Enabled(): cdktf.IResolvable;
    get rootAccessEnabled(): cdktf.IResolvable;
    get ruleIndex(): number;
    get unixReadOnly(): cdktf.IResolvable;
    get unixReadWrite(): cdktf.IResolvable;
}
export declare class DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleOutputReference;
}
export interface DataAzurermNetappVolumeGroupOracleVolume {
}
export declare function dataAzurermNetappVolumeGroupOracleVolumeToTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolume): any;
export declare function dataAzurermNetappVolumeGroupOracleVolumeToHclTerraform(struct?: DataAzurermNetappVolumeGroupOracleVolume): any;
export declare class DataAzurermNetappVolumeGroupOracleVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupOracleVolume | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupOracleVolume | undefined);
    get capacityPoolId(): string;
    private _dataProtectionReplication;
    get dataProtectionReplication(): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionReplicationList;
    private _dataProtectionSnapshotPolicy;
    get dataProtectionSnapshotPolicy(): DataAzurermNetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyList;
    get encryptionKeySource(): string;
    private _exportPolicyRule;
    get exportPolicyRule(): DataAzurermNetappVolumeGroupOracleVolumeExportPolicyRuleList;
    get id(): string;
    get keyVaultPrivateEndpointId(): string;
    get mountIpAddresses(): string[];
    get name(): string;
    get networkFeatures(): string;
    get protocols(): string[];
    get proximityPlacementGroupId(): string;
    get securityStyle(): string;
    get serviceLevel(): string;
    get snapshotDirectoryVisible(): cdktf.IResolvable;
    get storageQuotaInGb(): number;
    get subnetId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get throughputInMibps(): number;
    get volumePath(): string;
    get volumeSpecName(): string;
    get zone(): string;
}
export declare class DataAzurermNetappVolumeGroupOracleVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupOracleVolumeOutputReference;
}
export interface DataAzurermNetappVolumeGroupOracleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#read DataAzurermNetappVolumeGroupOracle#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappVolumeGroupOracleTimeoutsToTerraform(struct?: DataAzurermNetappVolumeGroupOracleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetappVolumeGroupOracleTimeoutsToHclTerraform(struct?: DataAzurermNetappVolumeGroupOracleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappVolumeGroupOracleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappVolumeGroupOracleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupOracleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle azurerm_netapp_volume_group_oracle}
*/
export declare class DataAzurermNetappVolumeGroupOracle extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_netapp_volume_group_oracle";
    /**
    * Generates CDKTF code for importing a DataAzurermNetappVolumeGroupOracle resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetappVolumeGroupOracle to import
    * @param importFromId The id of the existing DataAzurermNetappVolumeGroupOracle that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetappVolumeGroupOracle to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/netapp_volume_group_oracle azurerm_netapp_volume_group_oracle} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappVolumeGroupOracleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappVolumeGroupOracleConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get applicationIdentifier(): string;
    get groupDescription(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _volume;
    get volume(): DataAzurermNetappVolumeGroupOracleVolumeList;
    private _timeouts;
    get timeouts(): DataAzurermNetappVolumeGroupOracleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappVolumeGroupOracleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetappVolumeGroupOracleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
