/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStaticWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#id DataAzurermStaticWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#name DataAzurermStaticWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#resource_group_name DataAzurermStaticWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#timeouts DataAzurermStaticWebApp#timeouts}
    */
    readonly timeouts?: DataAzurermStaticWebAppTimeouts;
}
export interface DataAzurermStaticWebAppBasicAuth {
}
export declare function dataAzurermStaticWebAppBasicAuthToTerraform(struct?: DataAzurermStaticWebAppBasicAuth): any;
export declare function dataAzurermStaticWebAppBasicAuthToHclTerraform(struct?: DataAzurermStaticWebAppBasicAuth): any;
export declare class DataAzurermStaticWebAppBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStaticWebAppBasicAuth | undefined;
    set internalValue(value: DataAzurermStaticWebAppBasicAuth | undefined);
    get environments(): string;
}
export declare class DataAzurermStaticWebAppBasicAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStaticWebAppBasicAuthOutputReference;
}
export interface DataAzurermStaticWebAppIdentity {
}
export declare function dataAzurermStaticWebAppIdentityToTerraform(struct?: DataAzurermStaticWebAppIdentity): any;
export declare function dataAzurermStaticWebAppIdentityToHclTerraform(struct?: DataAzurermStaticWebAppIdentity): any;
export declare class DataAzurermStaticWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStaticWebAppIdentity | undefined;
    set internalValue(value: DataAzurermStaticWebAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermStaticWebAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStaticWebAppIdentityOutputReference;
}
export interface DataAzurermStaticWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#read DataAzurermStaticWebApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStaticWebAppTimeoutsToTerraform(struct?: DataAzurermStaticWebAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStaticWebAppTimeoutsToHclTerraform(struct?: DataAzurermStaticWebAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStaticWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStaticWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStaticWebAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app azurerm_static_web_app}
*/
export declare class DataAzurermStaticWebApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_static_web_app";
    /**
    * Generates CDKTF code for importing a DataAzurermStaticWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStaticWebApp to import
    * @param importFromId The id of the existing DataAzurermStaticWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStaticWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/static_web_app azurerm_static_web_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStaticWebAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStaticWebAppConfig);
    get apiKey(): string;
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _basicAuth;
    get basicAuth(): DataAzurermStaticWebAppBasicAuthList;
    get configurationFileChangesEnabled(): cdktf.IResolvable;
    get defaultHostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermStaticWebAppIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get previewEnvironmentsEnabled(): cdktf.IResolvable;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get repositoryBranch(): string;
    get repositoryUrl(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuSize(): string;
    get skuTier(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermStaticWebAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStaticWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStaticWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
