/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVpnServerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#id DataAzurermVpnServerConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#name DataAzurermVpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#resource_group_name DataAzurermVpnServerConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#timeouts DataAzurermVpnServerConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermVpnServerConfigurationTimeouts;
}
export interface DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthentication {
}
export declare function dataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationToTerraform(struct?: DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthentication): any;
export declare function dataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationToHclTerraform(struct?: DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthentication): any;
export declare class DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthentication | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthentication | undefined);
    get audience(): string;
    get issuer(): string;
    get tenant(): string;
}
export declare class DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationOutputReference;
}
export interface DataAzurermVpnServerConfigurationClientRevokedCertificate {
}
export declare function dataAzurermVpnServerConfigurationClientRevokedCertificateToTerraform(struct?: DataAzurermVpnServerConfigurationClientRevokedCertificate): any;
export declare function dataAzurermVpnServerConfigurationClientRevokedCertificateToHclTerraform(struct?: DataAzurermVpnServerConfigurationClientRevokedCertificate): any;
export declare class DataAzurermVpnServerConfigurationClientRevokedCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationClientRevokedCertificate | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationClientRevokedCertificate | undefined);
    get name(): string;
    get thumbprint(): string;
}
export declare class DataAzurermVpnServerConfigurationClientRevokedCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationClientRevokedCertificateOutputReference;
}
export interface DataAzurermVpnServerConfigurationClientRootCertificate {
}
export declare function dataAzurermVpnServerConfigurationClientRootCertificateToTerraform(struct?: DataAzurermVpnServerConfigurationClientRootCertificate): any;
export declare function dataAzurermVpnServerConfigurationClientRootCertificateToHclTerraform(struct?: DataAzurermVpnServerConfigurationClientRootCertificate): any;
export declare class DataAzurermVpnServerConfigurationClientRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationClientRootCertificate | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationClientRootCertificate | undefined);
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurermVpnServerConfigurationClientRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationClientRootCertificateOutputReference;
}
export interface DataAzurermVpnServerConfigurationIpsecPolicy {
}
export declare function dataAzurermVpnServerConfigurationIpsecPolicyToTerraform(struct?: DataAzurermVpnServerConfigurationIpsecPolicy): any;
export declare function dataAzurermVpnServerConfigurationIpsecPolicyToHclTerraform(struct?: DataAzurermVpnServerConfigurationIpsecPolicy): any;
export declare class DataAzurermVpnServerConfigurationIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationIpsecPolicy | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationIpsecPolicy | undefined);
    get dhGroup(): string;
    get ikeEncryption(): string;
    get ikeIntegrity(): string;
    get ipsecEncryption(): string;
    get ipsecIntegrity(): string;
    get pfsGroup(): string;
    get saDataSizeKilobytes(): number;
    get saLifetimeSeconds(): number;
}
export declare class DataAzurermVpnServerConfigurationIpsecPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationIpsecPolicyOutputReference;
}
export interface DataAzurermVpnServerConfigurationRadiusClientRootCertificate {
}
export declare function dataAzurermVpnServerConfigurationRadiusClientRootCertificateToTerraform(struct?: DataAzurermVpnServerConfigurationRadiusClientRootCertificate): any;
export declare function dataAzurermVpnServerConfigurationRadiusClientRootCertificateToHclTerraform(struct?: DataAzurermVpnServerConfigurationRadiusClientRootCertificate): any;
export declare class DataAzurermVpnServerConfigurationRadiusClientRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationRadiusClientRootCertificate | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationRadiusClientRootCertificate | undefined);
    get name(): string;
    get thumbprint(): string;
}
export declare class DataAzurermVpnServerConfigurationRadiusClientRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationRadiusClientRootCertificateOutputReference;
}
export interface DataAzurermVpnServerConfigurationRadiusServer {
}
export declare function dataAzurermVpnServerConfigurationRadiusServerToTerraform(struct?: DataAzurermVpnServerConfigurationRadiusServer): any;
export declare function dataAzurermVpnServerConfigurationRadiusServerToHclTerraform(struct?: DataAzurermVpnServerConfigurationRadiusServer): any;
export declare class DataAzurermVpnServerConfigurationRadiusServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationRadiusServer | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationRadiusServer | undefined);
    get address(): string;
    get score(): number;
    get secret(): string;
}
export declare class DataAzurermVpnServerConfigurationRadiusServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationRadiusServerOutputReference;
}
export interface DataAzurermVpnServerConfigurationRadiusServerRootCertificate {
}
export declare function dataAzurermVpnServerConfigurationRadiusServerRootCertificateToTerraform(struct?: DataAzurermVpnServerConfigurationRadiusServerRootCertificate): any;
export declare function dataAzurermVpnServerConfigurationRadiusServerRootCertificateToHclTerraform(struct?: DataAzurermVpnServerConfigurationRadiusServerRootCertificate): any;
export declare class DataAzurermVpnServerConfigurationRadiusServerRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationRadiusServerRootCertificate | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationRadiusServerRootCertificate | undefined);
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurermVpnServerConfigurationRadiusServerRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationRadiusServerRootCertificateOutputReference;
}
export interface DataAzurermVpnServerConfigurationRadius {
}
export declare function dataAzurermVpnServerConfigurationRadiusToTerraform(struct?: DataAzurermVpnServerConfigurationRadius): any;
export declare function dataAzurermVpnServerConfigurationRadiusToHclTerraform(struct?: DataAzurermVpnServerConfigurationRadius): any;
export declare class DataAzurermVpnServerConfigurationRadiusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnServerConfigurationRadius | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationRadius | undefined);
    private _clientRootCertificate;
    get clientRootCertificate(): DataAzurermVpnServerConfigurationRadiusClientRootCertificateList;
    private _server;
    get server(): DataAzurermVpnServerConfigurationRadiusServerList;
    private _serverRootCertificate;
    get serverRootCertificate(): DataAzurermVpnServerConfigurationRadiusServerRootCertificateList;
}
export declare class DataAzurermVpnServerConfigurationRadiusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnServerConfigurationRadiusOutputReference;
}
export interface DataAzurermVpnServerConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#read DataAzurermVpnServerConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVpnServerConfigurationTimeoutsToTerraform(struct?: DataAzurermVpnServerConfigurationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVpnServerConfigurationTimeoutsToHclTerraform(struct?: DataAzurermVpnServerConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVpnServerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVpnServerConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVpnServerConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration azurerm_vpn_server_configuration}
*/
export declare class DataAzurermVpnServerConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_vpn_server_configuration";
    /**
    * Generates CDKTF code for importing a DataAzurermVpnServerConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVpnServerConfiguration to import
    * @param importFromId The id of the existing DataAzurermVpnServerConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVpnServerConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/data-sources/vpn_server_configuration azurerm_vpn_server_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVpnServerConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVpnServerConfigurationConfig);
    private _azureActiveDirectoryAuthentication;
    get azureActiveDirectoryAuthentication(): DataAzurermVpnServerConfigurationAzureActiveDirectoryAuthenticationList;
    private _clientRevokedCertificate;
    get clientRevokedCertificate(): DataAzurermVpnServerConfigurationClientRevokedCertificateList;
    private _clientRootCertificate;
    get clientRootCertificate(): DataAzurermVpnServerConfigurationClientRootCertificateList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): DataAzurermVpnServerConfigurationIpsecPolicyList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _radius;
    get radius(): DataAzurermVpnServerConfigurationRadiusList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get vpnAuthenticationTypes(): string[];
    get vpnProtocols(): string[];
    private _timeouts;
    get timeouts(): DataAzurermVpnServerConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVpnServerConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVpnServerConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
