/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryTriggerScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#activated DataFactoryTriggerSchedule#activated}
    */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#annotations DataFactoryTriggerSchedule#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#data_factory_id DataFactoryTriggerSchedule#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#description DataFactoryTriggerSchedule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#end_time DataFactoryTriggerSchedule#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#frequency DataFactoryTriggerSchedule#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#id DataFactoryTriggerSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#interval DataFactoryTriggerSchedule#interval}
    */
    readonly interval?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#name DataFactoryTriggerSchedule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#pipeline_name DataFactoryTriggerSchedule#pipeline_name}
    */
    readonly pipelineName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#pipeline_parameters DataFactoryTriggerSchedule#pipeline_parameters}
    */
    readonly pipelineParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#start_time DataFactoryTriggerSchedule#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#time_zone DataFactoryTriggerSchedule#time_zone}
    */
    readonly timeZone?: string;
    /**
    * pipeline block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#pipeline DataFactoryTriggerSchedule#pipeline}
    */
    readonly pipeline?: DataFactoryTriggerSchedulePipeline[] | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#schedule DataFactoryTriggerSchedule#schedule}
    */
    readonly schedule?: DataFactoryTriggerScheduleSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#timeouts DataFactoryTriggerSchedule#timeouts}
    */
    readonly timeouts?: DataFactoryTriggerScheduleTimeouts;
}
export interface DataFactoryTriggerSchedulePipeline {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#name DataFactoryTriggerSchedule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#parameters DataFactoryTriggerSchedule#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerSchedulePipelineToTerraform(struct?: DataFactoryTriggerSchedulePipeline | cdktf.IResolvable): any;
export declare function dataFactoryTriggerSchedulePipelineToHclTerraform(struct?: DataFactoryTriggerSchedulePipeline | cdktf.IResolvable): any;
export declare class DataFactoryTriggerSchedulePipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryTriggerSchedulePipeline | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerSchedulePipeline | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class DataFactoryTriggerSchedulePipelineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryTriggerSchedulePipeline[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryTriggerSchedulePipelineOutputReference;
}
export interface DataFactoryTriggerScheduleScheduleMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#week DataFactoryTriggerSchedule#week}
    */
    readonly week?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#weekday DataFactoryTriggerSchedule#weekday}
    */
    readonly weekday: string;
}
export declare function dataFactoryTriggerScheduleScheduleMonthlyToTerraform(struct?: DataFactoryTriggerScheduleScheduleMonthly | cdktf.IResolvable): any;
export declare function dataFactoryTriggerScheduleScheduleMonthlyToHclTerraform(struct?: DataFactoryTriggerScheduleScheduleMonthly | cdktf.IResolvable): any;
export declare class DataFactoryTriggerScheduleScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryTriggerScheduleScheduleMonthly | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerScheduleScheduleMonthly | cdktf.IResolvable | undefined);
    private _week?;
    get week(): number;
    set week(value: number);
    resetWeek(): void;
    get weekInput(): number | undefined;
    private _weekday?;
    get weekday(): string;
    set weekday(value: string);
    get weekdayInput(): string | undefined;
}
export declare class DataFactoryTriggerScheduleScheduleMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryTriggerScheduleScheduleMonthlyOutputReference;
}
export interface DataFactoryTriggerScheduleSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#days_of_month DataFactoryTriggerSchedule#days_of_month}
    */
    readonly daysOfMonth?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#days_of_week DataFactoryTriggerSchedule#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#hours DataFactoryTriggerSchedule#hours}
    */
    readonly hours?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#minutes DataFactoryTriggerSchedule#minutes}
    */
    readonly minutes?: number[];
    /**
    * monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#monthly DataFactoryTriggerSchedule#monthly}
    */
    readonly monthly?: DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable;
}
export declare function dataFactoryTriggerScheduleScheduleToTerraform(struct?: DataFactoryTriggerScheduleScheduleOutputReference | DataFactoryTriggerScheduleSchedule): any;
export declare function dataFactoryTriggerScheduleScheduleToHclTerraform(struct?: DataFactoryTriggerScheduleScheduleOutputReference | DataFactoryTriggerScheduleSchedule): any;
export declare class DataFactoryTriggerScheduleScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryTriggerScheduleSchedule | undefined;
    set internalValue(value: DataFactoryTriggerScheduleSchedule | undefined);
    private _daysOfMonth?;
    get daysOfMonth(): number[];
    set daysOfMonth(value: number[]);
    resetDaysOfMonth(): void;
    get daysOfMonthInput(): number[] | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _hours?;
    get hours(): number[];
    set hours(value: number[]);
    resetHours(): void;
    get hoursInput(): number[] | undefined;
    private _minutes?;
    get minutes(): number[];
    set minutes(value: number[]);
    resetMinutes(): void;
    get minutesInput(): number[] | undefined;
    private _monthly;
    get monthly(): DataFactoryTriggerScheduleScheduleMonthlyList;
    putMonthly(value: DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable): void;
    resetMonthly(): void;
    get monthlyInput(): cdktf.IResolvable | DataFactoryTriggerScheduleScheduleMonthly[] | undefined;
}
export interface DataFactoryTriggerScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#create DataFactoryTriggerSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#delete DataFactoryTriggerSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#read DataFactoryTriggerSchedule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#update DataFactoryTriggerSchedule#update}
    */
    readonly update?: string;
}
export declare function dataFactoryTriggerScheduleTimeoutsToTerraform(struct?: DataFactoryTriggerScheduleTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryTriggerScheduleTimeoutsToHclTerraform(struct?: DataFactoryTriggerScheduleTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryTriggerScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryTriggerScheduleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerScheduleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule}
*/
export declare class DataFactoryTriggerSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_trigger_schedule";
    /**
    * Generates CDKTF code for importing a DataFactoryTriggerSchedule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryTriggerSchedule to import
    * @param importFromId The id of the existing DataFactoryTriggerSchedule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryTriggerSchedule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryTriggerScheduleConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerScheduleConfig);
    private _activated?;
    get activated(): boolean | cdktf.IResolvable;
    set activated(value: boolean | cdktf.IResolvable);
    resetActivated(): void;
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pipelineName?;
    get pipelineName(): string;
    set pipelineName(value: string);
    resetPipelineName(): void;
    get pipelineNameInput(): string | undefined;
    private _pipelineParameters?;
    get pipelineParameters(): {
        [key: string]: string;
    };
    set pipelineParameters(value: {
        [key: string]: string;
    });
    resetPipelineParameters(): void;
    get pipelineParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _pipeline;
    get pipeline(): DataFactoryTriggerSchedulePipelineList;
    putPipeline(value: DataFactoryTriggerSchedulePipeline[] | cdktf.IResolvable): void;
    resetPipeline(): void;
    get pipelineInput(): cdktf.IResolvable | DataFactoryTriggerSchedulePipeline[] | undefined;
    private _schedule;
    get schedule(): DataFactoryTriggerScheduleScheduleOutputReference;
    putSchedule(value: DataFactoryTriggerScheduleSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): DataFactoryTriggerScheduleSchedule | undefined;
    private _timeouts;
    get timeouts(): DataFactoryTriggerScheduleTimeoutsOutputReference;
    putTimeouts(value: DataFactoryTriggerScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryTriggerScheduleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
