/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#backup_repeating_time_intervals DataProtectionBackupPolicyPostgresqlFlexibleServer#backup_repeating_time_intervals}
    */
    readonly backupRepeatingTimeIntervals: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#id DataProtectionBackupPolicyPostgresqlFlexibleServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#name DataProtectionBackupPolicyPostgresqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#time_zone DataProtectionBackupPolicyPostgresqlFlexibleServer#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#vault_id DataProtectionBackupPolicyPostgresqlFlexibleServer#vault_id}
    */
    readonly vaultId: string;
    /**
    * default_retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#default_retention_rule DataProtectionBackupPolicyPostgresqlFlexibleServer#default_retention_rule}
    */
    readonly defaultRetentionRule: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule;
    /**
    * retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#retention_rule DataProtectionBackupPolicyPostgresqlFlexibleServer#retention_rule}
    */
    readonly retentionRule?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#timeouts DataProtectionBackupPolicyPostgresqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#data_store_type DataProtectionBackupPolicyPostgresqlFlexibleServer#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#duration DataProtectionBackupPolicyPostgresqlFlexibleServer#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule {
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#life_cycle DataProtectionBackupPolicyPostgresqlFlexibleServer#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule | undefined);
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle[] | undefined;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#absolute_criteria DataProtectionBackupPolicyPostgresqlFlexibleServer#absolute_criteria}
    */
    readonly absoluteCriteria?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#days_of_week DataProtectionBackupPolicyPostgresqlFlexibleServer#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#months_of_year DataProtectionBackupPolicyPostgresqlFlexibleServer#months_of_year}
    */
    readonly monthsOfYear?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#scheduled_backup_times DataProtectionBackupPolicyPostgresqlFlexibleServer#scheduled_backup_times}
    */
    readonly scheduledBackupTimes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#weeks_of_month DataProtectionBackupPolicyPostgresqlFlexibleServer#weeks_of_month}
    */
    readonly weeksOfMonth?: string[];
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    get absoluteCriteria(): string;
    set absoluteCriteria(value: string);
    resetAbsoluteCriteria(): void;
    get absoluteCriteriaInput(): string | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _monthsOfYear?;
    get monthsOfYear(): string[];
    set monthsOfYear(value: string[]);
    resetMonthsOfYear(): void;
    get monthsOfYearInput(): string[] | undefined;
    private _scheduledBackupTimes?;
    get scheduledBackupTimes(): string[];
    set scheduledBackupTimes(value: string[]);
    resetScheduledBackupTimes(): void;
    get scheduledBackupTimesInput(): string[] | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): string[];
    set weeksOfMonth(value: string[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): string[] | undefined;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#data_store_type DataProtectionBackupPolicyPostgresqlFlexibleServer#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#duration DataProtectionBackupPolicyPostgresqlFlexibleServer#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#name DataProtectionBackupPolicyPostgresqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#priority DataProtectionBackupPolicyPostgresqlFlexibleServer#priority}
    */
    readonly priority: number;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#criteria DataProtectionBackupPolicyPostgresqlFlexibleServer#criteria}
    */
    readonly criteria: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria;
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#life_cycle DataProtectionBackupPolicyPostgresqlFlexibleServer#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _criteria;
    get criteria(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaOutputReference;
    putCriteria(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria): void;
    get criteriaInput(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria | undefined;
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle[] | undefined;
}
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleOutputReference;
}
export interface DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#create DataProtectionBackupPolicyPostgresqlFlexibleServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#delete DataProtectionBackupPolicyPostgresqlFlexibleServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#read DataProtectionBackupPolicyPostgresqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerTimeoutsToTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyPostgresqlFlexibleServerTimeoutsToHclTerraform(struct?: DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server azurerm_data_protection_backup_policy_postgresql_flexible_server}
*/
export declare class DataProtectionBackupPolicyPostgresqlFlexibleServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_policy_postgresql_flexible_server";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupPolicyPostgresqlFlexibleServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupPolicyPostgresqlFlexibleServer to import
    * @param importFromId The id of the existing DataProtectionBackupPolicyPostgresqlFlexibleServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupPolicyPostgresqlFlexibleServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/data_protection_backup_policy_postgresql_flexible_server azurerm_data_protection_backup_policy_postgresql_flexible_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupPolicyPostgresqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyPostgresqlFlexibleServerConfig);
    private _backupRepeatingTimeIntervals?;
    get backupRepeatingTimeIntervals(): string[];
    set backupRepeatingTimeIntervals(value: string[]);
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    get vaultIdInput(): string | undefined;
    private _defaultRetentionRule;
    get defaultRetentionRule(): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleOutputReference;
    putDefaultRetentionRule(value: DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule): void;
    get defaultRetentionRuleInput(): DataProtectionBackupPolicyPostgresqlFlexibleServerDefaultRetentionRule | undefined;
    private _retentionRule;
    get retentionRule(): DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRuleList;
    putRetentionRule(value: DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule[] | cdktf.IResolvable): void;
    resetRetentionRule(): void;
    get retentionRuleInput(): cdktf.IResolvable | DataProtectionBackupPolicyPostgresqlFlexibleServerRetentionRule[] | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupPolicyPostgresqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupPolicyPostgresqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
