/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabricksVirtualNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#allow_forwarded_traffic DatabricksVirtualNetworkPeering#allow_forwarded_traffic}
    */
    readonly allowForwardedTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#allow_gateway_transit DatabricksVirtualNetworkPeering#allow_gateway_transit}
    */
    readonly allowGatewayTransit?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#allow_virtual_network_access DatabricksVirtualNetworkPeering#allow_virtual_network_access}
    */
    readonly allowVirtualNetworkAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#id DatabricksVirtualNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#name DatabricksVirtualNetworkPeering#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#remote_address_space_prefixes DatabricksVirtualNetworkPeering#remote_address_space_prefixes}
    */
    readonly remoteAddressSpacePrefixes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#remote_virtual_network_id DatabricksVirtualNetworkPeering#remote_virtual_network_id}
    */
    readonly remoteVirtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#resource_group_name DatabricksVirtualNetworkPeering#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#use_remote_gateways DatabricksVirtualNetworkPeering#use_remote_gateways}
    */
    readonly useRemoteGateways?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#workspace_id DatabricksVirtualNetworkPeering#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#timeouts DatabricksVirtualNetworkPeering#timeouts}
    */
    readonly timeouts?: DatabricksVirtualNetworkPeeringTimeouts;
}
export interface DatabricksVirtualNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#create DatabricksVirtualNetworkPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#delete DatabricksVirtualNetworkPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#read DatabricksVirtualNetworkPeering#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#update DatabricksVirtualNetworkPeering#update}
    */
    readonly update?: string;
}
export declare function databricksVirtualNetworkPeeringTimeoutsToTerraform(struct?: DatabricksVirtualNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare function databricksVirtualNetworkPeeringTimeoutsToHclTerraform(struct?: DatabricksVirtualNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class DatabricksVirtualNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabricksVirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabricksVirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering azurerm_databricks_virtual_network_peering}
*/
export declare class DatabricksVirtualNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_databricks_virtual_network_peering";
    /**
    * Generates CDKTF code for importing a DatabricksVirtualNetworkPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatabricksVirtualNetworkPeering to import
    * @param importFromId The id of the existing DatabricksVirtualNetworkPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatabricksVirtualNetworkPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/databricks_virtual_network_peering azurerm_databricks_virtual_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabricksVirtualNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DatabricksVirtualNetworkPeeringConfig);
    get addressSpacePrefixes(): string[];
    private _allowForwardedTraffic?;
    get allowForwardedTraffic(): boolean | cdktf.IResolvable;
    set allowForwardedTraffic(value: boolean | cdktf.IResolvable);
    resetAllowForwardedTraffic(): void;
    get allowForwardedTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGatewayTransit?;
    get allowGatewayTransit(): boolean | cdktf.IResolvable;
    set allowGatewayTransit(value: boolean | cdktf.IResolvable);
    resetAllowGatewayTransit(): void;
    get allowGatewayTransitInput(): boolean | cdktf.IResolvable | undefined;
    private _allowVirtualNetworkAccess?;
    get allowVirtualNetworkAccess(): boolean | cdktf.IResolvable;
    set allowVirtualNetworkAccess(value: boolean | cdktf.IResolvable);
    resetAllowVirtualNetworkAccess(): void;
    get allowVirtualNetworkAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _remoteAddressSpacePrefixes?;
    get remoteAddressSpacePrefixes(): string[];
    set remoteAddressSpacePrefixes(value: string[]);
    get remoteAddressSpacePrefixesInput(): string[] | undefined;
    private _remoteVirtualNetworkId?;
    get remoteVirtualNetworkId(): string;
    set remoteVirtualNetworkId(value: string);
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _useRemoteGateways?;
    get useRemoteGateways(): boolean | cdktf.IResolvable;
    set useRemoteGateways(value: boolean | cdktf.IResolvable);
    resetUseRemoteGateways(): void;
    get useRemoteGatewaysInput(): boolean | cdktf.IResolvable | undefined;
    get virtualNetworkId(): string;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DatabricksVirtualNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: DatabricksVirtualNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabricksVirtualNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
