/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsCaaRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#id DnsCaaRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#name DnsCaaRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#resource_group_name DnsCaaRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#tags DnsCaaRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#ttl DnsCaaRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#zone_name DnsCaaRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * record block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#record DnsCaaRecord#record}
    */
    readonly record: DnsCaaRecordRecord[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#timeouts DnsCaaRecord#timeouts}
    */
    readonly timeouts?: DnsCaaRecordTimeouts;
}
export interface DnsCaaRecordRecord {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#flags DnsCaaRecord#flags}
    */
    readonly flags: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#tag DnsCaaRecord#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#value DnsCaaRecord#value}
    */
    readonly value: string;
}
export declare function dnsCaaRecordRecordToTerraform(struct?: DnsCaaRecordRecord | cdktf.IResolvable): any;
export declare function dnsCaaRecordRecordToHclTerraform(struct?: DnsCaaRecordRecord | cdktf.IResolvable): any;
export declare class DnsCaaRecordRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsCaaRecordRecord | cdktf.IResolvable | undefined;
    set internalValue(value: DnsCaaRecordRecord | cdktf.IResolvable | undefined);
    private _flags?;
    get flags(): number;
    set flags(value: number);
    get flagsInput(): number | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DnsCaaRecordRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsCaaRecordRecord[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsCaaRecordRecordOutputReference;
}
export interface DnsCaaRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#create DnsCaaRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#delete DnsCaaRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#read DnsCaaRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#update DnsCaaRecord#update}
    */
    readonly update?: string;
}
export declare function dnsCaaRecordTimeoutsToTerraform(struct?: DnsCaaRecordTimeouts | cdktf.IResolvable): any;
export declare function dnsCaaRecordTimeoutsToHclTerraform(struct?: DnsCaaRecordTimeouts | cdktf.IResolvable): any;
export declare class DnsCaaRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsCaaRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DnsCaaRecordTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record azurerm_dns_caa_record}
*/
export declare class DnsCaaRecord extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dns_caa_record";
    /**
    * Generates CDKTF code for importing a DnsCaaRecord resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DnsCaaRecord to import
    * @param importFromId The id of the existing DnsCaaRecord that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DnsCaaRecord to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/dns_caa_record azurerm_dns_caa_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsCaaRecordConfig
    */
    constructor(scope: Construct, id: string, config: DnsCaaRecordConfig);
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _record;
    get record(): DnsCaaRecordRecordList;
    putRecord(value: DnsCaaRecordRecord[] | cdktf.IResolvable): void;
    get recordInput(): cdktf.IResolvable | DnsCaaRecordRecord[] | undefined;
    private _timeouts;
    get timeouts(): DnsCaaRecordTimeoutsOutputReference;
    putTimeouts(value: DnsCaaRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DnsCaaRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
