/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventhubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#id Eventhub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#message_retention Eventhub#message_retention}
    */
    readonly messageRetention?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#name Eventhub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#namespace_id Eventhub#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#namespace_name Eventhub#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#partition_count Eventhub#partition_count}
    */
    readonly partitionCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#resource_group_name Eventhub#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#status Eventhub#status}
    */
    readonly status?: string;
    /**
    * capture_description block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#capture_description Eventhub#capture_description}
    */
    readonly captureDescription?: EventhubCaptureDescription;
    /**
    * retention_description block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#retention_description Eventhub#retention_description}
    */
    readonly retentionDescription?: EventhubRetentionDescription;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#timeouts Eventhub#timeouts}
    */
    readonly timeouts?: EventhubTimeouts;
}
export interface EventhubCaptureDescriptionDestination {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#archive_name_format Eventhub#archive_name_format}
    */
    readonly archiveNameFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#blob_container_name Eventhub#blob_container_name}
    */
    readonly blobContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#name Eventhub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#storage_account_id Eventhub#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function eventhubCaptureDescriptionDestinationToTerraform(struct?: EventhubCaptureDescriptionDestinationOutputReference | EventhubCaptureDescriptionDestination): any;
export declare function eventhubCaptureDescriptionDestinationToHclTerraform(struct?: EventhubCaptureDescriptionDestinationOutputReference | EventhubCaptureDescriptionDestination): any;
export declare class EventhubCaptureDescriptionDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubCaptureDescriptionDestination | undefined;
    set internalValue(value: EventhubCaptureDescriptionDestination | undefined);
    private _archiveNameFormat?;
    get archiveNameFormat(): string;
    set archiveNameFormat(value: string);
    get archiveNameFormatInput(): string | undefined;
    private _blobContainerName?;
    get blobContainerName(): string;
    set blobContainerName(value: string);
    get blobContainerNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export interface EventhubCaptureDescription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#enabled Eventhub#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#encoding Eventhub#encoding}
    */
    readonly encoding: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#interval_in_seconds Eventhub#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#size_limit_in_bytes Eventhub#size_limit_in_bytes}
    */
    readonly sizeLimitInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#skip_empty_archives Eventhub#skip_empty_archives}
    */
    readonly skipEmptyArchives?: boolean | cdktf.IResolvable;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#destination Eventhub#destination}
    */
    readonly destination: EventhubCaptureDescriptionDestination;
}
export declare function eventhubCaptureDescriptionToTerraform(struct?: EventhubCaptureDescriptionOutputReference | EventhubCaptureDescription): any;
export declare function eventhubCaptureDescriptionToHclTerraform(struct?: EventhubCaptureDescriptionOutputReference | EventhubCaptureDescription): any;
export declare class EventhubCaptureDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubCaptureDescription | undefined;
    set internalValue(value: EventhubCaptureDescription | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    get encodingInput(): string | undefined;
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    resetIntervalInSeconds(): void;
    get intervalInSecondsInput(): number | undefined;
    private _sizeLimitInBytes?;
    get sizeLimitInBytes(): number;
    set sizeLimitInBytes(value: number);
    resetSizeLimitInBytes(): void;
    get sizeLimitInBytesInput(): number | undefined;
    private _skipEmptyArchives?;
    get skipEmptyArchives(): boolean | cdktf.IResolvable;
    set skipEmptyArchives(value: boolean | cdktf.IResolvable);
    resetSkipEmptyArchives(): void;
    get skipEmptyArchivesInput(): boolean | cdktf.IResolvable | undefined;
    private _destination;
    get destination(): EventhubCaptureDescriptionDestinationOutputReference;
    putDestination(value: EventhubCaptureDescriptionDestination): void;
    get destinationInput(): EventhubCaptureDescriptionDestination | undefined;
}
export interface EventhubRetentionDescription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#cleanup_policy Eventhub#cleanup_policy}
    */
    readonly cleanupPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#retention_time_in_hours Eventhub#retention_time_in_hours}
    */
    readonly retentionTimeInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#tombstone_retention_time_in_hours Eventhub#tombstone_retention_time_in_hours}
    */
    readonly tombstoneRetentionTimeInHours?: number;
}
export declare function eventhubRetentionDescriptionToTerraform(struct?: EventhubRetentionDescriptionOutputReference | EventhubRetentionDescription): any;
export declare function eventhubRetentionDescriptionToHclTerraform(struct?: EventhubRetentionDescriptionOutputReference | EventhubRetentionDescription): any;
export declare class EventhubRetentionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubRetentionDescription | undefined;
    set internalValue(value: EventhubRetentionDescription | undefined);
    private _cleanupPolicy?;
    get cleanupPolicy(): string;
    set cleanupPolicy(value: string);
    get cleanupPolicyInput(): string | undefined;
    private _retentionTimeInHours?;
    get retentionTimeInHours(): number;
    set retentionTimeInHours(value: number);
    resetRetentionTimeInHours(): void;
    get retentionTimeInHoursInput(): number | undefined;
    private _tombstoneRetentionTimeInHours?;
    get tombstoneRetentionTimeInHours(): number;
    set tombstoneRetentionTimeInHours(value: number);
    resetTombstoneRetentionTimeInHours(): void;
    get tombstoneRetentionTimeInHoursInput(): number | undefined;
}
export interface EventhubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#create Eventhub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#delete Eventhub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#read Eventhub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#update Eventhub#update}
    */
    readonly update?: string;
}
export declare function eventhubTimeoutsToTerraform(struct?: EventhubTimeouts | cdktf.IResolvable): any;
export declare function eventhubTimeoutsToHclTerraform(struct?: EventhubTimeouts | cdktf.IResolvable): any;
export declare class EventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub azurerm_eventhub}
*/
export declare class Eventhub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventhub";
    /**
    * Generates CDKTF code for importing a Eventhub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Eventhub to import
    * @param importFromId The id of the existing Eventhub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Eventhub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/eventhub azurerm_eventhub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventhubConfig
    */
    constructor(scope: Construct, id: string, config: EventhubConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _messageRetention?;
    get messageRetention(): number;
    set messageRetention(value: number);
    resetMessageRetention(): void;
    get messageRetentionInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    private _partitionCount?;
    get partitionCount(): number;
    set partitionCount(value: number);
    get partitionCountInput(): number | undefined;
    get partitionIds(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _captureDescription;
    get captureDescription(): EventhubCaptureDescriptionOutputReference;
    putCaptureDescription(value: EventhubCaptureDescription): void;
    resetCaptureDescription(): void;
    get captureDescriptionInput(): EventhubCaptureDescription | undefined;
    private _retentionDescription;
    get retentionDescription(): EventhubRetentionDescriptionOutputReference;
    putRetentionDescription(value: EventhubRetentionDescription): void;
    resetRetentionDescription(): void;
    get retentionDescriptionInput(): EventhubRetentionDescription | undefined;
    private _timeouts;
    get timeouts(): EventhubTimeoutsOutputReference;
    putTimeouts(value: EventhubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventhubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
