/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#custom_block_response_body FrontdoorFirewallPolicy#custom_block_response_body}
    */
    readonly customBlockResponseBody?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#custom_block_response_status_code FrontdoorFirewallPolicy#custom_block_response_status_code}
    */
    readonly customBlockResponseStatusCode?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#enabled FrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#id FrontdoorFirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#mode FrontdoorFirewallPolicy#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#name FrontdoorFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#redirect_url FrontdoorFirewallPolicy#redirect_url}
    */
    readonly redirectUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#resource_group_name FrontdoorFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#tags FrontdoorFirewallPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * custom_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#custom_rule FrontdoorFirewallPolicy#custom_rule}
    */
    readonly customRule?: FrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable;
    /**
    * managed_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#managed_rule FrontdoorFirewallPolicy#managed_rule}
    */
    readonly managedRule?: FrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#timeouts FrontdoorFirewallPolicy#timeouts}
    */
    readonly timeouts?: FrontdoorFirewallPolicyTimeouts;
}
export interface FrontdoorFirewallPolicyCustomRuleMatchCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_values FrontdoorFirewallPolicy#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_variable FrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#negation_condition FrontdoorFirewallPolicy#negation_condition}
    */
    readonly negationCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#operator FrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#selector FrontdoorFirewallPolicy#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#transforms FrontdoorFirewallPolicy#transforms}
    */
    readonly transforms?: string[];
}
export declare function frontdoorFirewallPolicyCustomRuleMatchConditionToTerraform(struct?: FrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyCustomRuleMatchConditionToHclTerraform(struct?: FrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyCustomRuleMatchConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _negationCondition?;
    get negationCondition(): boolean | cdktf.IResolvable;
    set negationCondition(value: boolean | cdktf.IResolvable);
    resetNegationCondition(): void;
    get negationConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class FrontdoorFirewallPolicyCustomRuleMatchConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyCustomRuleMatchConditionOutputReference;
}
export interface FrontdoorFirewallPolicyCustomRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#action FrontdoorFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#enabled FrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#name FrontdoorFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#priority FrontdoorFirewallPolicy#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#rate_limit_duration_in_minutes FrontdoorFirewallPolicy#rate_limit_duration_in_minutes}
    */
    readonly rateLimitDurationInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#rate_limit_threshold FrontdoorFirewallPolicy#rate_limit_threshold}
    */
    readonly rateLimitThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#type FrontdoorFirewallPolicy#type}
    */
    readonly type: string;
    /**
    * match_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_condition FrontdoorFirewallPolicy#match_condition}
    */
    readonly matchCondition?: FrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable;
}
export declare function frontdoorFirewallPolicyCustomRuleToTerraform(struct?: FrontdoorFirewallPolicyCustomRule | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyCustomRuleToHclTerraform(struct?: FrontdoorFirewallPolicyCustomRule | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyCustomRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyCustomRule | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyCustomRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _rateLimitDurationInMinutes?;
    get rateLimitDurationInMinutes(): number;
    set rateLimitDurationInMinutes(value: number);
    resetRateLimitDurationInMinutes(): void;
    get rateLimitDurationInMinutesInput(): number | undefined;
    private _rateLimitThreshold?;
    get rateLimitThreshold(): number;
    set rateLimitThreshold(value: number);
    resetRateLimitThreshold(): void;
    get rateLimitThresholdInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _matchCondition;
    get matchCondition(): FrontdoorFirewallPolicyCustomRuleMatchConditionList;
    putMatchCondition(value: FrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable): void;
    resetMatchCondition(): void;
    get matchConditionInput(): cdktf.IResolvable | FrontdoorFirewallPolicyCustomRuleMatchCondition[] | undefined;
}
export declare class FrontdoorFirewallPolicyCustomRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyCustomRuleOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRuleExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_variable FrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#operator FrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#selector FrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleExclusionToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleExclusionOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRuleOverrideExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_variable FrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#operator FrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#selector FrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleOverrideExclusionToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleOverrideExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleOverrideExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleOverrideExclusionOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#match_variable FrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#operator FrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#selector FrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleExclusionToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRuleOverrideRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#action FrontdoorFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#enabled FrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#rule_id FrontdoorFirewallPolicy#rule_id}
    */
    readonly ruleId: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#exclusion FrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleOverrideRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleId?;
    get ruleId(): string;
    set ruleId(value: string);
    get ruleIdInput(): string | undefined;
    private _exclusion;
    get exclusion(): FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionList;
    putExclusion(value: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleOverrideRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleOverrideRuleOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRuleOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#rule_group_name FrontdoorFirewallPolicy#rule_group_name}
    */
    readonly ruleGroupName: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#exclusion FrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#rule FrontdoorFirewallPolicy#rule}
    */
    readonly rule?: FrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleOverrideToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable | undefined);
    private _ruleGroupName?;
    get ruleGroupName(): string;
    set ruleGroupName(value: string);
    get ruleGroupNameInput(): string | undefined;
    private _exclusion;
    get exclusion(): FrontdoorFirewallPolicyManagedRuleOverrideExclusionList;
    putExclusion(value: FrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | undefined;
    private _rule;
    get rule(): FrontdoorFirewallPolicyManagedRuleOverrideRuleList;
    putRule(value: FrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRuleOverrideRule[] | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleOverrideOutputReference;
}
export interface FrontdoorFirewallPolicyManagedRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#type FrontdoorFirewallPolicy#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#version FrontdoorFirewallPolicy#version}
    */
    readonly version: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#exclusion FrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable;
    /**
    * override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#override FrontdoorFirewallPolicy#override}
    */
    readonly override?: FrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable;
}
export declare function frontdoorFirewallPolicyManagedRuleToTerraform(struct?: FrontdoorFirewallPolicyManagedRule | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyManagedRuleToHclTerraform(struct?: FrontdoorFirewallPolicyManagedRule | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyManagedRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFirewallPolicyManagedRule | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyManagedRule | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _exclusion;
    get exclusion(): FrontdoorFirewallPolicyManagedRuleExclusionList;
    putExclusion(value: FrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRuleExclusion[] | undefined;
    private _override;
    get override(): FrontdoorFirewallPolicyManagedRuleOverrideList;
    putOverride(value: FrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable): void;
    resetOverride(): void;
    get overrideInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRuleOverride[] | undefined;
}
export declare class FrontdoorFirewallPolicyManagedRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFirewallPolicyManagedRuleOutputReference;
}
export interface FrontdoorFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#create FrontdoorFirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#delete FrontdoorFirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#read FrontdoorFirewallPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#update FrontdoorFirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function frontdoorFirewallPolicyTimeoutsToTerraform(struct?: FrontdoorFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare function frontdoorFirewallPolicyTimeoutsToHclTerraform(struct?: FrontdoorFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorFirewallPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFirewallPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy azurerm_frontdoor_firewall_policy}
*/
export declare class FrontdoorFirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor_firewall_policy";
    /**
    * Generates CDKTF code for importing a FrontdoorFirewallPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FrontdoorFirewallPolicy to import
    * @param importFromId The id of the existing FrontdoorFirewallPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FrontdoorFirewallPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/frontdoor_firewall_policy azurerm_frontdoor_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorFirewallPolicyConfig);
    private _customBlockResponseBody?;
    get customBlockResponseBody(): string;
    set customBlockResponseBody(value: string);
    resetCustomBlockResponseBody(): void;
    get customBlockResponseBodyInput(): string | undefined;
    private _customBlockResponseStatusCode?;
    get customBlockResponseStatusCode(): number;
    set customBlockResponseStatusCode(value: number);
    resetCustomBlockResponseStatusCode(): void;
    get customBlockResponseStatusCodeInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get frontendEndpointIds(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    resetRedirectUrl(): void;
    get redirectUrlInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customRule;
    get customRule(): FrontdoorFirewallPolicyCustomRuleList;
    putCustomRule(value: FrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable): void;
    resetCustomRule(): void;
    get customRuleInput(): cdktf.IResolvable | FrontdoorFirewallPolicyCustomRule[] | undefined;
    private _managedRule;
    get managedRule(): FrontdoorFirewallPolicyManagedRuleList;
    putManagedRule(value: FrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable): void;
    resetManagedRule(): void;
    get managedRuleInput(): cdktf.IResolvable | FrontdoorFirewallPolicyManagedRule[] | undefined;
    private _timeouts;
    get timeouts(): FrontdoorFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: FrontdoorFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FrontdoorFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
