/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#endpoint Iothub#endpoint}
    */
    readonly endpoint?: IothubEndpoint[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#enrichment Iothub#enrichment}
    */
    readonly enrichment?: IothubEnrichment[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#event_hub_partition_count Iothub#event_hub_partition_count}
    */
    readonly eventHubPartitionCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#event_hub_retention_in_days Iothub#event_hub_retention_in_days}
    */
    readonly eventHubRetentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#id Iothub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#local_authentication_enabled Iothub#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#location Iothub#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#min_tls_version Iothub#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#name Iothub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#public_network_access_enabled Iothub#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#resource_group_name Iothub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#route Iothub#route}
    */
    readonly route?: IothubRoute[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#tags Iothub#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * cloud_to_device block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#cloud_to_device Iothub#cloud_to_device}
    */
    readonly cloudToDevice?: IothubCloudToDevice;
    /**
    * fallback_route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#fallback_route Iothub#fallback_route}
    */
    readonly fallbackRoute?: IothubFallbackRoute;
    /**
    * file_upload block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#file_upload Iothub#file_upload}
    */
    readonly fileUpload?: IothubFileUpload;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#identity Iothub#identity}
    */
    readonly identity?: IothubIdentity;
    /**
    * network_rule_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#network_rule_set Iothub#network_rule_set}
    */
    readonly networkRuleSet?: IothubNetworkRuleSet[] | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#sku Iothub#sku}
    */
    readonly sku: IothubSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#timeouts Iothub#timeouts}
    */
    readonly timeouts?: IothubTimeouts;
}
export interface IothubEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#authentication_type Iothub#authentication_type}
    */
    readonly authenticationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#batch_frequency_in_seconds Iothub#batch_frequency_in_seconds}
    */
    readonly batchFrequencyInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#connection_string Iothub#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#container_name Iothub#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#encoding Iothub#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#endpoint_uri Iothub#endpoint_uri}
    */
    readonly endpointUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#entity_path Iothub#entity_path}
    */
    readonly entityPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#file_name_format Iothub#file_name_format}
    */
    readonly fileNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#identity_id Iothub#identity_id}
    */
    readonly identityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#max_chunk_size_in_bytes Iothub#max_chunk_size_in_bytes}
    */
    readonly maxChunkSizeInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#name Iothub#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#resource_group_name Iothub#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#type Iothub#type}
    */
    readonly type?: string;
}
export declare function iothubEndpointToTerraform(struct?: IothubEndpoint | cdktf.IResolvable): any;
export declare function iothubEndpointToHclTerraform(struct?: IothubEndpoint | cdktf.IResolvable): any;
export declare class IothubEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubEndpoint | cdktf.IResolvable | undefined;
    set internalValue(value: IothubEndpoint | cdktf.IResolvable | undefined);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    resetAuthenticationType(): void;
    get authenticationTypeInput(): string | undefined;
    private _batchFrequencyInSeconds?;
    get batchFrequencyInSeconds(): number;
    set batchFrequencyInSeconds(value: number);
    resetBatchFrequencyInSeconds(): void;
    get batchFrequencyInSecondsInput(): number | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _endpointUri?;
    get endpointUri(): string;
    set endpointUri(value: string);
    resetEndpointUri(): void;
    get endpointUriInput(): string | undefined;
    private _entityPath?;
    get entityPath(): string;
    set entityPath(value: string);
    resetEntityPath(): void;
    get entityPathInput(): string | undefined;
    private _fileNameFormat?;
    get fileNameFormat(): string;
    set fileNameFormat(value: string);
    resetFileNameFormat(): void;
    get fileNameFormatInput(): string | undefined;
    private _identityId?;
    get identityId(): string;
    set identityId(value: string);
    resetIdentityId(): void;
    get identityIdInput(): string | undefined;
    private _maxChunkSizeInBytes?;
    get maxChunkSizeInBytes(): number;
    set maxChunkSizeInBytes(value: number);
    resetMaxChunkSizeInBytes(): void;
    get maxChunkSizeInBytesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class IothubEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubEndpoint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubEndpointOutputReference;
}
export interface IothubEnrichment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#endpoint_names Iothub#endpoint_names}
    */
    readonly endpointNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#key Iothub#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#value Iothub#value}
    */
    readonly value?: string;
}
export declare function iothubEnrichmentToTerraform(struct?: IothubEnrichment | cdktf.IResolvable): any;
export declare function iothubEnrichmentToHclTerraform(struct?: IothubEnrichment | cdktf.IResolvable): any;
export declare class IothubEnrichmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubEnrichment | cdktf.IResolvable | undefined;
    set internalValue(value: IothubEnrichment | cdktf.IResolvable | undefined);
    private _endpointNames?;
    get endpointNames(): string[];
    set endpointNames(value: string[]);
    resetEndpointNames(): void;
    get endpointNamesInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class IothubEnrichmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubEnrichment[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubEnrichmentOutputReference;
}
export interface IothubRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#condition Iothub#condition}
    */
    readonly condition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#enabled Iothub#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#endpoint_names Iothub#endpoint_names}
    */
    readonly endpointNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#name Iothub#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#source Iothub#source}
    */
    readonly source?: string;
}
export declare function iothubRouteToTerraform(struct?: IothubRoute | cdktf.IResolvable): any;
export declare function iothubRouteToHclTerraform(struct?: IothubRoute | cdktf.IResolvable): any;
export declare class IothubRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubRoute | cdktf.IResolvable | undefined;
    set internalValue(value: IothubRoute | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointNames?;
    get endpointNames(): string[];
    set endpointNames(value: string[]);
    resetEndpointNames(): void;
    get endpointNamesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class IothubRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubRoute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubRouteOutputReference;
}
export interface IothubSharedAccessPolicy {
}
export declare function iothubSharedAccessPolicyToTerraform(struct?: IothubSharedAccessPolicy): any;
export declare function iothubSharedAccessPolicyToHclTerraform(struct?: IothubSharedAccessPolicy): any;
export declare class IothubSharedAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubSharedAccessPolicy | undefined;
    set internalValue(value: IothubSharedAccessPolicy | undefined);
    get keyName(): string;
    get permissions(): string;
    get primaryKey(): string;
    get secondaryKey(): string;
}
export declare class IothubSharedAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubSharedAccessPolicyOutputReference;
}
export interface IothubCloudToDeviceFeedback {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#lock_duration Iothub#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#max_delivery_count Iothub#max_delivery_count}
    */
    readonly maxDeliveryCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#time_to_live Iothub#time_to_live}
    */
    readonly timeToLive?: string;
}
export declare function iothubCloudToDeviceFeedbackToTerraform(struct?: IothubCloudToDeviceFeedback | cdktf.IResolvable): any;
export declare function iothubCloudToDeviceFeedbackToHclTerraform(struct?: IothubCloudToDeviceFeedback | cdktf.IResolvable): any;
export declare class IothubCloudToDeviceFeedbackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubCloudToDeviceFeedback | cdktf.IResolvable | undefined;
    set internalValue(value: IothubCloudToDeviceFeedback | cdktf.IResolvable | undefined);
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    resetMaxDeliveryCount(): void;
    get maxDeliveryCountInput(): number | undefined;
    private _timeToLive?;
    get timeToLive(): string;
    set timeToLive(value: string);
    resetTimeToLive(): void;
    get timeToLiveInput(): string | undefined;
}
export declare class IothubCloudToDeviceFeedbackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubCloudToDeviceFeedback[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubCloudToDeviceFeedbackOutputReference;
}
export interface IothubCloudToDevice {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#default_ttl Iothub#default_ttl}
    */
    readonly defaultTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#max_delivery_count Iothub#max_delivery_count}
    */
    readonly maxDeliveryCount?: number;
    /**
    * feedback block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#feedback Iothub#feedback}
    */
    readonly feedback?: IothubCloudToDeviceFeedback[] | cdktf.IResolvable;
}
export declare function iothubCloudToDeviceToTerraform(struct?: IothubCloudToDeviceOutputReference | IothubCloudToDevice): any;
export declare function iothubCloudToDeviceToHclTerraform(struct?: IothubCloudToDeviceOutputReference | IothubCloudToDevice): any;
export declare class IothubCloudToDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubCloudToDevice | undefined;
    set internalValue(value: IothubCloudToDevice | undefined);
    private _defaultTtl?;
    get defaultTtl(): string;
    set defaultTtl(value: string);
    resetDefaultTtl(): void;
    get defaultTtlInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    resetMaxDeliveryCount(): void;
    get maxDeliveryCountInput(): number | undefined;
    private _feedback;
    get feedback(): IothubCloudToDeviceFeedbackList;
    putFeedback(value: IothubCloudToDeviceFeedback[] | cdktf.IResolvable): void;
    resetFeedback(): void;
    get feedbackInput(): cdktf.IResolvable | IothubCloudToDeviceFeedback[] | undefined;
}
export interface IothubFallbackRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#condition Iothub#condition}
    */
    readonly condition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#enabled Iothub#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#endpoint_names Iothub#endpoint_names}
    */
    readonly endpointNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#source Iothub#source}
    */
    readonly source?: string;
}
export declare function iothubFallbackRouteToTerraform(struct?: IothubFallbackRouteOutputReference | IothubFallbackRoute): any;
export declare function iothubFallbackRouteToHclTerraform(struct?: IothubFallbackRouteOutputReference | IothubFallbackRoute): any;
export declare class IothubFallbackRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubFallbackRoute | undefined;
    set internalValue(value: IothubFallbackRoute | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointNames?;
    get endpointNames(): string[];
    set endpointNames(value: string[]);
    resetEndpointNames(): void;
    get endpointNamesInput(): string[] | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface IothubFileUpload {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#authentication_type Iothub#authentication_type}
    */
    readonly authenticationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#connection_string Iothub#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#container_name Iothub#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#default_ttl Iothub#default_ttl}
    */
    readonly defaultTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#identity_id Iothub#identity_id}
    */
    readonly identityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#lock_duration Iothub#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#max_delivery_count Iothub#max_delivery_count}
    */
    readonly maxDeliveryCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#notifications Iothub#notifications}
    */
    readonly notifications?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#sas_ttl Iothub#sas_ttl}
    */
    readonly sasTtl?: string;
}
export declare function iothubFileUploadToTerraform(struct?: IothubFileUploadOutputReference | IothubFileUpload): any;
export declare function iothubFileUploadToHclTerraform(struct?: IothubFileUploadOutputReference | IothubFileUpload): any;
export declare class IothubFileUploadOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubFileUpload | undefined;
    set internalValue(value: IothubFileUpload | undefined);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    resetAuthenticationType(): void;
    get authenticationTypeInput(): string | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): string;
    set defaultTtl(value: string);
    resetDefaultTtl(): void;
    get defaultTtlInput(): string | undefined;
    private _identityId?;
    get identityId(): string;
    set identityId(value: string);
    resetIdentityId(): void;
    get identityIdInput(): string | undefined;
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    resetMaxDeliveryCount(): void;
    get maxDeliveryCountInput(): number | undefined;
    private _notifications?;
    get notifications(): boolean | cdktf.IResolvable;
    set notifications(value: boolean | cdktf.IResolvable);
    resetNotifications(): void;
    get notificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _sasTtl?;
    get sasTtl(): string;
    set sasTtl(value: string);
    resetSasTtl(): void;
    get sasTtlInput(): string | undefined;
}
export interface IothubIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#identity_ids Iothub#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#type Iothub#type}
    */
    readonly type: string;
}
export declare function iothubIdentityToTerraform(struct?: IothubIdentityOutputReference | IothubIdentity): any;
export declare function iothubIdentityToHclTerraform(struct?: IothubIdentityOutputReference | IothubIdentity): any;
export declare class IothubIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubIdentity | undefined;
    set internalValue(value: IothubIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface IothubNetworkRuleSetIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#action Iothub#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#ip_mask Iothub#ip_mask}
    */
    readonly ipMask: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#name Iothub#name}
    */
    readonly name: string;
}
export declare function iothubNetworkRuleSetIpRuleToTerraform(struct?: IothubNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare function iothubNetworkRuleSetIpRuleToHclTerraform(struct?: IothubNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare class IothubNetworkRuleSetIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubNetworkRuleSetIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: IothubNetworkRuleSetIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    get ipMaskInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class IothubNetworkRuleSetIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubNetworkRuleSetIpRuleOutputReference;
}
export interface IothubNetworkRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#apply_to_builtin_eventhub_endpoint Iothub#apply_to_builtin_eventhub_endpoint}
    */
    readonly applyToBuiltinEventhubEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#default_action Iothub#default_action}
    */
    readonly defaultAction?: string;
    /**
    * ip_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#ip_rule Iothub#ip_rule}
    */
    readonly ipRule?: IothubNetworkRuleSetIpRule[] | cdktf.IResolvable;
}
export declare function iothubNetworkRuleSetToTerraform(struct?: IothubNetworkRuleSet | cdktf.IResolvable): any;
export declare function iothubNetworkRuleSetToHclTerraform(struct?: IothubNetworkRuleSet | cdktf.IResolvable): any;
export declare class IothubNetworkRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubNetworkRuleSet | cdktf.IResolvable | undefined;
    set internalValue(value: IothubNetworkRuleSet | cdktf.IResolvable | undefined);
    private _applyToBuiltinEventhubEndpoint?;
    get applyToBuiltinEventhubEndpoint(): boolean | cdktf.IResolvable;
    set applyToBuiltinEventhubEndpoint(value: boolean | cdktf.IResolvable);
    resetApplyToBuiltinEventhubEndpoint(): void;
    get applyToBuiltinEventhubEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    private _ipRule;
    get ipRule(): IothubNetworkRuleSetIpRuleList;
    putIpRule(value: IothubNetworkRuleSetIpRule[] | cdktf.IResolvable): void;
    resetIpRule(): void;
    get ipRuleInput(): cdktf.IResolvable | IothubNetworkRuleSetIpRule[] | undefined;
}
export declare class IothubNetworkRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubNetworkRuleSet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubNetworkRuleSetOutputReference;
}
export interface IothubSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#capacity Iothub#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#name Iothub#name}
    */
    readonly name: string;
}
export declare function iothubSkuToTerraform(struct?: IothubSkuOutputReference | IothubSku): any;
export declare function iothubSkuToHclTerraform(struct?: IothubSkuOutputReference | IothubSku): any;
export declare class IothubSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubSku | undefined;
    set internalValue(value: IothubSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface IothubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#create Iothub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#delete Iothub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#read Iothub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#update Iothub#update}
    */
    readonly update?: string;
}
export declare function iothubTimeoutsToTerraform(struct?: IothubTimeouts | cdktf.IResolvable): any;
export declare function iothubTimeoutsToHclTerraform(struct?: IothubTimeouts | cdktf.IResolvable): any;
export declare class IothubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub azurerm_iothub}
*/
export declare class Iothub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub";
    /**
    * Generates CDKTF code for importing a Iothub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Iothub to import
    * @param importFromId The id of the existing Iothub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Iothub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/iothub azurerm_iothub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubConfig
    */
    constructor(scope: Construct, id: string, config: IothubConfig);
    private _endpoint;
    get endpoint(): IothubEndpointList;
    putEndpoint(value: IothubEndpoint[] | cdktf.IResolvable): void;
    resetEndpoint(): void;
    get endpointInput(): cdktf.IResolvable | IothubEndpoint[] | undefined;
    private _enrichment;
    get enrichment(): IothubEnrichmentList;
    putEnrichment(value: IothubEnrichment[] | cdktf.IResolvable): void;
    resetEnrichment(): void;
    get enrichmentInput(): cdktf.IResolvable | IothubEnrichment[] | undefined;
    get eventHubEventsEndpoint(): string;
    get eventHubEventsNamespace(): string;
    get eventHubEventsPath(): string;
    get eventHubOperationsEndpoint(): string;
    get eventHubOperationsPath(): string;
    private _eventHubPartitionCount?;
    get eventHubPartitionCount(): number;
    set eventHubPartitionCount(value: number);
    resetEventHubPartitionCount(): void;
    get eventHubPartitionCountInput(): number | undefined;
    private _eventHubRetentionInDays?;
    get eventHubRetentionInDays(): number;
    set eventHubRetentionInDays(value: number);
    resetEventHubRetentionInDays(): void;
    get eventHubRetentionInDaysInput(): number | undefined;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _route;
    get route(): IothubRouteList;
    putRoute(value: IothubRoute[] | cdktf.IResolvable): void;
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | IothubRoute[] | undefined;
    private _sharedAccessPolicy;
    get sharedAccessPolicy(): IothubSharedAccessPolicyList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    private _cloudToDevice;
    get cloudToDevice(): IothubCloudToDeviceOutputReference;
    putCloudToDevice(value: IothubCloudToDevice): void;
    resetCloudToDevice(): void;
    get cloudToDeviceInput(): IothubCloudToDevice | undefined;
    private _fallbackRoute;
    get fallbackRoute(): IothubFallbackRouteOutputReference;
    putFallbackRoute(value: IothubFallbackRoute): void;
    resetFallbackRoute(): void;
    get fallbackRouteInput(): IothubFallbackRoute | undefined;
    private _fileUpload;
    get fileUpload(): IothubFileUploadOutputReference;
    putFileUpload(value: IothubFileUpload): void;
    resetFileUpload(): void;
    get fileUploadInput(): IothubFileUpload | undefined;
    private _identity;
    get identity(): IothubIdentityOutputReference;
    putIdentity(value: IothubIdentity): void;
    resetIdentity(): void;
    get identityInput(): IothubIdentity | undefined;
    private _networkRuleSet;
    get networkRuleSet(): IothubNetworkRuleSetList;
    putNetworkRuleSet(value: IothubNetworkRuleSet[] | cdktf.IResolvable): void;
    resetNetworkRuleSet(): void;
    get networkRuleSetInput(): cdktf.IResolvable | IothubNetworkRuleSet[] | undefined;
    private _sku;
    get sku(): IothubSkuOutputReference;
    putSku(value: IothubSku): void;
    get skuInput(): IothubSku | undefined;
    private _timeouts;
    get timeouts(): IothubTimeoutsOutputReference;
    putTimeouts(value: IothubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
