/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbOutboundRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#allocated_outbound_ports LbOutboundRule#allocated_outbound_ports}
    */
    readonly allocatedOutboundPorts?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#backend_address_pool_id LbOutboundRule#backend_address_pool_id}
    */
    readonly backendAddressPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#enable_tcp_reset LbOutboundRule#enable_tcp_reset}
    */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#id LbOutboundRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#idle_timeout_in_minutes LbOutboundRule#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#loadbalancer_id LbOutboundRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#name LbOutboundRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#protocol LbOutboundRule#protocol}
    */
    readonly protocol: string;
    /**
    * frontend_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#frontend_ip_configuration LbOutboundRule#frontend_ip_configuration}
    */
    readonly frontendIpConfiguration?: LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#timeouts LbOutboundRule#timeouts}
    */
    readonly timeouts?: LbOutboundRuleTimeouts;
}
export interface LbOutboundRuleFrontendIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#name LbOutboundRule#name}
    */
    readonly name: string;
}
export declare function lbOutboundRuleFrontendIpConfigurationToTerraform(struct?: LbOutboundRuleFrontendIpConfiguration | cdktf.IResolvable): any;
export declare function lbOutboundRuleFrontendIpConfigurationToHclTerraform(struct?: LbOutboundRuleFrontendIpConfiguration | cdktf.IResolvable): any;
export declare class LbOutboundRuleFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LbOutboundRuleFrontendIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: LbOutboundRuleFrontendIpConfiguration | cdktf.IResolvable | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class LbOutboundRuleFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LbOutboundRuleFrontendIpConfigurationOutputReference;
}
export interface LbOutboundRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#create LbOutboundRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#delete LbOutboundRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#read LbOutboundRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#update LbOutboundRule#update}
    */
    readonly update?: string;
}
export declare function lbOutboundRuleTimeoutsToTerraform(struct?: LbOutboundRuleTimeouts | cdktf.IResolvable): any;
export declare function lbOutboundRuleTimeoutsToHclTerraform(struct?: LbOutboundRuleTimeouts | cdktf.IResolvable): any;
export declare class LbOutboundRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbOutboundRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbOutboundRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule azurerm_lb_outbound_rule}
*/
export declare class LbOutboundRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_outbound_rule";
    /**
    * Generates CDKTF code for importing a LbOutboundRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LbOutboundRule to import
    * @param importFromId The id of the existing LbOutboundRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LbOutboundRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/lb_outbound_rule azurerm_lb_outbound_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbOutboundRuleConfig
    */
    constructor(scope: Construct, id: string, config: LbOutboundRuleConfig);
    private _allocatedOutboundPorts?;
    get allocatedOutboundPorts(): number;
    set allocatedOutboundPorts(value: number);
    resetAllocatedOutboundPorts(): void;
    get allocatedOutboundPortsInput(): number | undefined;
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    get backendAddressPoolIdInput(): string | undefined;
    private _enableTcpReset?;
    get enableTcpReset(): boolean | cdktf.IResolvable;
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    resetEnableTcpReset(): void;
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): LbOutboundRuleFrontendIpConfigurationList;
    putFrontendIpConfiguration(value: LbOutboundRuleFrontendIpConfiguration[] | cdktf.IResolvable): void;
    resetFrontendIpConfiguration(): void;
    get frontendIpConfigurationInput(): cdktf.IResolvable | LbOutboundRuleFrontendIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): LbOutboundRuleTimeoutsOutputReference;
    putTimeouts(value: LbOutboundRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbOutboundRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
