/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppTriggerRecurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#frequency LogicAppTriggerRecurrence#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#id LogicAppTriggerRecurrence#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#interval LogicAppTriggerRecurrence#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#logic_app_id LogicAppTriggerRecurrence#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#name LogicAppTriggerRecurrence#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#start_time LogicAppTriggerRecurrence#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#time_zone LogicAppTriggerRecurrence#time_zone}
    */
    readonly timeZone?: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#schedule LogicAppTriggerRecurrence#schedule}
    */
    readonly schedule?: LogicAppTriggerRecurrenceSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#timeouts LogicAppTriggerRecurrence#timeouts}
    */
    readonly timeouts?: LogicAppTriggerRecurrenceTimeouts;
}
export interface LogicAppTriggerRecurrenceSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#at_these_hours LogicAppTriggerRecurrence#at_these_hours}
    */
    readonly atTheseHours?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#at_these_minutes LogicAppTriggerRecurrence#at_these_minutes}
    */
    readonly atTheseMinutes?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#on_these_days LogicAppTriggerRecurrence#on_these_days}
    */
    readonly onTheseDays?: string[];
}
export declare function logicAppTriggerRecurrenceScheduleToTerraform(struct?: LogicAppTriggerRecurrenceScheduleOutputReference | LogicAppTriggerRecurrenceSchedule): any;
export declare function logicAppTriggerRecurrenceScheduleToHclTerraform(struct?: LogicAppTriggerRecurrenceScheduleOutputReference | LogicAppTriggerRecurrenceSchedule): any;
export declare class LogicAppTriggerRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppTriggerRecurrenceSchedule | undefined;
    set internalValue(value: LogicAppTriggerRecurrenceSchedule | undefined);
    private _atTheseHours?;
    get atTheseHours(): number[];
    set atTheseHours(value: number[]);
    resetAtTheseHours(): void;
    get atTheseHoursInput(): number[] | undefined;
    private _atTheseMinutes?;
    get atTheseMinutes(): number[];
    set atTheseMinutes(value: number[]);
    resetAtTheseMinutes(): void;
    get atTheseMinutesInput(): number[] | undefined;
    private _onTheseDays?;
    get onTheseDays(): string[];
    set onTheseDays(value: string[]);
    resetOnTheseDays(): void;
    get onTheseDaysInput(): string[] | undefined;
}
export interface LogicAppTriggerRecurrenceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#create LogicAppTriggerRecurrence#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#delete LogicAppTriggerRecurrence#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#read LogicAppTriggerRecurrence#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#update LogicAppTriggerRecurrence#update}
    */
    readonly update?: string;
}
export declare function logicAppTriggerRecurrenceTimeoutsToTerraform(struct?: LogicAppTriggerRecurrenceTimeouts | cdktf.IResolvable): any;
export declare function logicAppTriggerRecurrenceTimeoutsToHclTerraform(struct?: LogicAppTriggerRecurrenceTimeouts | cdktf.IResolvable): any;
export declare class LogicAppTriggerRecurrenceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppTriggerRecurrenceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppTriggerRecurrenceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence azurerm_logic_app_trigger_recurrence}
*/
export declare class LogicAppTriggerRecurrence extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_trigger_recurrence";
    /**
    * Generates CDKTF code for importing a LogicAppTriggerRecurrence resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogicAppTriggerRecurrence to import
    * @param importFromId The id of the existing LogicAppTriggerRecurrence that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogicAppTriggerRecurrence to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/logic_app_trigger_recurrence azurerm_logic_app_trigger_recurrence} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppTriggerRecurrenceConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppTriggerRecurrenceConfig);
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _schedule;
    get schedule(): LogicAppTriggerRecurrenceScheduleOutputReference;
    putSchedule(value: LogicAppTriggerRecurrenceSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): LogicAppTriggerRecurrenceSchedule | undefined;
    private _timeouts;
    get timeouts(): LogicAppTriggerRecurrenceTimeoutsOutputReference;
    putTimeouts(value: LogicAppTriggerRecurrenceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppTriggerRecurrenceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
