/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MongoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#administrator_password MongoCluster#administrator_password}
    */
    readonly administratorPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#administrator_username MongoCluster#administrator_username}
    */
    readonly administratorUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#compute_tier MongoCluster#compute_tier}
    */
    readonly computeTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#create_mode MongoCluster#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#high_availability_mode MongoCluster#high_availability_mode}
    */
    readonly highAvailabilityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#id MongoCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#location MongoCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#name MongoCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#preview_features MongoCluster#preview_features}
    */
    readonly previewFeatures?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#public_network_access MongoCluster#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#resource_group_name MongoCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#shard_count MongoCluster#shard_count}
    */
    readonly shardCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#source_location MongoCluster#source_location}
    */
    readonly sourceLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#source_server_id MongoCluster#source_server_id}
    */
    readonly sourceServerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#storage_size_in_gb MongoCluster#storage_size_in_gb}
    */
    readonly storageSizeInGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#tags MongoCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#version MongoCluster#version}
    */
    readonly version?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#timeouts MongoCluster#timeouts}
    */
    readonly timeouts?: MongoClusterTimeouts;
}
export interface MongoClusterConnectionStrings {
}
export declare function mongoClusterConnectionStringsToTerraform(struct?: MongoClusterConnectionStrings): any;
export declare function mongoClusterConnectionStringsToHclTerraform(struct?: MongoClusterConnectionStrings): any;
export declare class MongoClusterConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MongoClusterConnectionStrings | undefined;
    set internalValue(value: MongoClusterConnectionStrings | undefined);
    get description(): string;
    get name(): string;
    get value(): string;
}
export declare class MongoClusterConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MongoClusterConnectionStringsOutputReference;
}
export interface MongoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#create MongoCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#delete MongoCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#read MongoCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#update MongoCluster#update}
    */
    readonly update?: string;
}
export declare function mongoClusterTimeoutsToTerraform(struct?: MongoClusterTimeouts | cdktf.IResolvable): any;
export declare function mongoClusterTimeoutsToHclTerraform(struct?: MongoClusterTimeouts | cdktf.IResolvable): any;
export declare class MongoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MongoClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster azurerm_mongo_cluster}
*/
export declare class MongoCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mongo_cluster";
    /**
    * Generates CDKTF code for importing a MongoCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MongoCluster to import
    * @param importFromId The id of the existing MongoCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MongoCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/mongo_cluster azurerm_mongo_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MongoClusterConfig
    */
    constructor(scope: Construct, id: string, config: MongoClusterConfig);
    private _administratorPassword?;
    get administratorPassword(): string;
    set administratorPassword(value: string);
    resetAdministratorPassword(): void;
    get administratorPasswordInput(): string | undefined;
    private _administratorUsername?;
    get administratorUsername(): string;
    set administratorUsername(value: string);
    resetAdministratorUsername(): void;
    get administratorUsernameInput(): string | undefined;
    private _computeTier?;
    get computeTier(): string;
    set computeTier(value: string);
    resetComputeTier(): void;
    get computeTierInput(): string | undefined;
    private _connectionStrings;
    get connectionStrings(): MongoClusterConnectionStringsList;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _highAvailabilityMode?;
    get highAvailabilityMode(): string;
    set highAvailabilityMode(value: string);
    resetHighAvailabilityMode(): void;
    get highAvailabilityModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _previewFeatures?;
    get previewFeatures(): string[];
    set previewFeatures(value: string[]);
    resetPreviewFeatures(): void;
    get previewFeaturesInput(): string[] | undefined;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shardCount?;
    get shardCount(): number;
    set shardCount(value: number);
    resetShardCount(): void;
    get shardCountInput(): number | undefined;
    private _sourceLocation?;
    get sourceLocation(): string;
    set sourceLocation(value: string);
    resetSourceLocation(): void;
    get sourceLocationInput(): string | undefined;
    private _sourceServerId?;
    get sourceServerId(): string;
    set sourceServerId(value: string);
    resetSourceServerId(): void;
    get sourceServerIdInput(): string | undefined;
    private _storageSizeInGb?;
    get storageSizeInGb(): number;
    set storageSizeInGb(value: number);
    resetStorageSizeInGb(): void;
    get storageSizeInGbInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): MongoClusterTimeoutsOutputReference;
    putTimeouts(value: MongoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MongoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
