/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetappVolumeGroupOracleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#account_name NetappVolumeGroupOracle#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#application_identifier NetappVolumeGroupOracle#application_identifier}
    */
    readonly applicationIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#group_description NetappVolumeGroupOracle#group_description}
    */
    readonly groupDescription: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#id NetappVolumeGroupOracle#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#location NetappVolumeGroupOracle#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#name NetappVolumeGroupOracle#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#resource_group_name NetappVolumeGroupOracle#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#timeouts NetappVolumeGroupOracle#timeouts}
    */
    readonly timeouts?: NetappVolumeGroupOracleTimeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#volume NetappVolumeGroupOracle#volume}
    */
    readonly volume: NetappVolumeGroupOracleVolume[] | cdktf.IResolvable;
}
export interface NetappVolumeGroupOracleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#create NetappVolumeGroupOracle#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#delete NetappVolumeGroupOracle#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#read NetappVolumeGroupOracle#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#update NetappVolumeGroupOracle#update}
    */
    readonly update?: string;
}
export declare function netappVolumeGroupOracleTimeoutsToTerraform(struct?: NetappVolumeGroupOracleTimeouts | cdktf.IResolvable): any;
export declare function netappVolumeGroupOracleTimeoutsToHclTerraform(struct?: NetappVolumeGroupOracleTimeouts | cdktf.IResolvable): any;
export declare class NetappVolumeGroupOracleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupOracleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupOracleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NetappVolumeGroupOracleVolumeDataProtectionReplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#endpoint_type NetappVolumeGroupOracle#endpoint_type}
    */
    readonly endpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#remote_volume_location NetappVolumeGroupOracle#remote_volume_location}
    */
    readonly remoteVolumeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#remote_volume_resource_id NetappVolumeGroupOracle#remote_volume_resource_id}
    */
    readonly remoteVolumeResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#replication_frequency NetappVolumeGroupOracle#replication_frequency}
    */
    readonly replicationFrequency: string;
}
export declare function netappVolumeGroupOracleVolumeDataProtectionReplicationToTerraform(struct?: NetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference | NetappVolumeGroupOracleVolumeDataProtectionReplication): any;
export declare function netappVolumeGroupOracleVolumeDataProtectionReplicationToHclTerraform(struct?: NetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference | NetappVolumeGroupOracleVolumeDataProtectionReplication): any;
export declare class NetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupOracleVolumeDataProtectionReplication | undefined;
    set internalValue(value: NetappVolumeGroupOracleVolumeDataProtectionReplication | undefined);
    private _endpointType?;
    get endpointType(): string;
    set endpointType(value: string);
    resetEndpointType(): void;
    get endpointTypeInput(): string | undefined;
    private _remoteVolumeLocation?;
    get remoteVolumeLocation(): string;
    set remoteVolumeLocation(value: string);
    get remoteVolumeLocationInput(): string | undefined;
    private _remoteVolumeResourceId?;
    get remoteVolumeResourceId(): string;
    set remoteVolumeResourceId(value: string);
    get remoteVolumeResourceIdInput(): string | undefined;
    private _replicationFrequency?;
    get replicationFrequency(): string;
    set replicationFrequency(value: string);
    get replicationFrequencyInput(): string | undefined;
}
export interface NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#snapshot_policy_id NetappVolumeGroupOracle#snapshot_policy_id}
    */
    readonly snapshotPolicyId: string;
}
export declare function netappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyToTerraform(struct?: NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy): any;
export declare function netappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyToHclTerraform(struct?: NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy): any;
export declare class NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy | undefined;
    set internalValue(value: NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy | undefined);
    private _snapshotPolicyId?;
    get snapshotPolicyId(): string;
    set snapshotPolicyId(value: string);
    get snapshotPolicyIdInput(): string | undefined;
}
export interface NetappVolumeGroupOracleVolumeExportPolicyRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#allowed_clients NetappVolumeGroupOracle#allowed_clients}
    */
    readonly allowedClients: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#nfsv3_enabled NetappVolumeGroupOracle#nfsv3_enabled}
    */
    readonly nfsv3Enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#nfsv41_enabled NetappVolumeGroupOracle#nfsv41_enabled}
    */
    readonly nfsv41Enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#root_access_enabled NetappVolumeGroupOracle#root_access_enabled}
    */
    readonly rootAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#rule_index NetappVolumeGroupOracle#rule_index}
    */
    readonly ruleIndex: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#unix_read_only NetappVolumeGroupOracle#unix_read_only}
    */
    readonly unixReadOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#unix_read_write NetappVolumeGroupOracle#unix_read_write}
    */
    readonly unixReadWrite?: boolean | cdktf.IResolvable;
}
export declare function netappVolumeGroupOracleVolumeExportPolicyRuleToTerraform(struct?: NetappVolumeGroupOracleVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare function netappVolumeGroupOracleVolumeExportPolicyRuleToHclTerraform(struct?: NetappVolumeGroupOracleVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare class NetappVolumeGroupOracleVolumeExportPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetappVolumeGroupOracleVolumeExportPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupOracleVolumeExportPolicyRule | cdktf.IResolvable | undefined);
    private _allowedClients?;
    get allowedClients(): string;
    set allowedClients(value: string);
    get allowedClientsInput(): string | undefined;
    private _nfsv3Enabled?;
    get nfsv3Enabled(): boolean | cdktf.IResolvable;
    set nfsv3Enabled(value: boolean | cdktf.IResolvable);
    get nfsv3EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _nfsv41Enabled?;
    get nfsv41Enabled(): boolean | cdktf.IResolvable;
    set nfsv41Enabled(value: boolean | cdktf.IResolvable);
    get nfsv41EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rootAccessEnabled?;
    get rootAccessEnabled(): boolean | cdktf.IResolvable;
    set rootAccessEnabled(value: boolean | cdktf.IResolvable);
    resetRootAccessEnabled(): void;
    get rootAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleIndex?;
    get ruleIndex(): number;
    set ruleIndex(value: number);
    get ruleIndexInput(): number | undefined;
    private _unixReadOnly?;
    get unixReadOnly(): boolean | cdktf.IResolvable;
    set unixReadOnly(value: boolean | cdktf.IResolvable);
    resetUnixReadOnly(): void;
    get unixReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _unixReadWrite?;
    get unixReadWrite(): boolean | cdktf.IResolvable;
    set unixReadWrite(value: boolean | cdktf.IResolvable);
    resetUnixReadWrite(): void;
    get unixReadWriteInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class NetappVolumeGroupOracleVolumeExportPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetappVolumeGroupOracleVolumeExportPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetappVolumeGroupOracleVolumeExportPolicyRuleOutputReference;
}
export interface NetappVolumeGroupOracleVolume {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#capacity_pool_id NetappVolumeGroupOracle#capacity_pool_id}
    */
    readonly capacityPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#encryption_key_source NetappVolumeGroupOracle#encryption_key_source}
    */
    readonly encryptionKeySource?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#key_vault_private_endpoint_id NetappVolumeGroupOracle#key_vault_private_endpoint_id}
    */
    readonly keyVaultPrivateEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#name NetappVolumeGroupOracle#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#network_features NetappVolumeGroupOracle#network_features}
    */
    readonly networkFeatures?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#protocols NetappVolumeGroupOracle#protocols}
    */
    readonly protocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#proximity_placement_group_id NetappVolumeGroupOracle#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#security_style NetappVolumeGroupOracle#security_style}
    */
    readonly securityStyle: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#service_level NetappVolumeGroupOracle#service_level}
    */
    readonly serviceLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#snapshot_directory_visible NetappVolumeGroupOracle#snapshot_directory_visible}
    */
    readonly snapshotDirectoryVisible: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#storage_quota_in_gb NetappVolumeGroupOracle#storage_quota_in_gb}
    */
    readonly storageQuotaInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#subnet_id NetappVolumeGroupOracle#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#tags NetappVolumeGroupOracle#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#throughput_in_mibps NetappVolumeGroupOracle#throughput_in_mibps}
    */
    readonly throughputInMibps: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#volume_path NetappVolumeGroupOracle#volume_path}
    */
    readonly volumePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#volume_spec_name NetappVolumeGroupOracle#volume_spec_name}
    */
    readonly volumeSpecName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#zone NetappVolumeGroupOracle#zone}
    */
    readonly zone?: string;
    /**
    * data_protection_replication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#data_protection_replication NetappVolumeGroupOracle#data_protection_replication}
    */
    readonly dataProtectionReplication?: NetappVolumeGroupOracleVolumeDataProtectionReplication;
    /**
    * data_protection_snapshot_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#data_protection_snapshot_policy NetappVolumeGroupOracle#data_protection_snapshot_policy}
    */
    readonly dataProtectionSnapshotPolicy?: NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy;
    /**
    * export_policy_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#export_policy_rule NetappVolumeGroupOracle#export_policy_rule}
    */
    readonly exportPolicyRule: NetappVolumeGroupOracleVolumeExportPolicyRule[] | cdktf.IResolvable;
}
export declare function netappVolumeGroupOracleVolumeToTerraform(struct?: NetappVolumeGroupOracleVolume | cdktf.IResolvable): any;
export declare function netappVolumeGroupOracleVolumeToHclTerraform(struct?: NetappVolumeGroupOracleVolume | cdktf.IResolvable): any;
export declare class NetappVolumeGroupOracleVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetappVolumeGroupOracleVolume | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupOracleVolume | cdktf.IResolvable | undefined);
    private _capacityPoolId?;
    get capacityPoolId(): string;
    set capacityPoolId(value: string);
    get capacityPoolIdInput(): string | undefined;
    private _encryptionKeySource?;
    get encryptionKeySource(): string;
    set encryptionKeySource(value: string);
    resetEncryptionKeySource(): void;
    get encryptionKeySourceInput(): string | undefined;
    get id(): string;
    private _keyVaultPrivateEndpointId?;
    get keyVaultPrivateEndpointId(): string;
    set keyVaultPrivateEndpointId(value: string);
    resetKeyVaultPrivateEndpointId(): void;
    get keyVaultPrivateEndpointIdInput(): string | undefined;
    get mountIpAddresses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkFeatures?;
    get networkFeatures(): string;
    set networkFeatures(value: string);
    resetNetworkFeatures(): void;
    get networkFeaturesInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    get protocolsInput(): string[] | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _securityStyle?;
    get securityStyle(): string;
    set securityStyle(value: string);
    get securityStyleInput(): string | undefined;
    private _serviceLevel?;
    get serviceLevel(): string;
    set serviceLevel(value: string);
    get serviceLevelInput(): string | undefined;
    private _snapshotDirectoryVisible?;
    get snapshotDirectoryVisible(): boolean | cdktf.IResolvable;
    set snapshotDirectoryVisible(value: boolean | cdktf.IResolvable);
    get snapshotDirectoryVisibleInput(): boolean | cdktf.IResolvable | undefined;
    private _storageQuotaInGb?;
    get storageQuotaInGb(): number;
    set storageQuotaInGb(value: number);
    get storageQuotaInGbInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _throughputInMibps?;
    get throughputInMibps(): number;
    set throughputInMibps(value: number);
    get throughputInMibpsInput(): number | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
    private _volumeSpecName?;
    get volumeSpecName(): string;
    set volumeSpecName(value: string);
    get volumeSpecNameInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _dataProtectionReplication;
    get dataProtectionReplication(): NetappVolumeGroupOracleVolumeDataProtectionReplicationOutputReference;
    putDataProtectionReplication(value: NetappVolumeGroupOracleVolumeDataProtectionReplication): void;
    resetDataProtectionReplication(): void;
    get dataProtectionReplicationInput(): NetappVolumeGroupOracleVolumeDataProtectionReplication | undefined;
    private _dataProtectionSnapshotPolicy;
    get dataProtectionSnapshotPolicy(): NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicyOutputReference;
    putDataProtectionSnapshotPolicy(value: NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy): void;
    resetDataProtectionSnapshotPolicy(): void;
    get dataProtectionSnapshotPolicyInput(): NetappVolumeGroupOracleVolumeDataProtectionSnapshotPolicy | undefined;
    private _exportPolicyRule;
    get exportPolicyRule(): NetappVolumeGroupOracleVolumeExportPolicyRuleList;
    putExportPolicyRule(value: NetappVolumeGroupOracleVolumeExportPolicyRule[] | cdktf.IResolvable): void;
    get exportPolicyRuleInput(): cdktf.IResolvable | NetappVolumeGroupOracleVolumeExportPolicyRule[] | undefined;
}
export declare class NetappVolumeGroupOracleVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetappVolumeGroupOracleVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetappVolumeGroupOracleVolumeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle azurerm_netapp_volume_group_oracle}
*/
export declare class NetappVolumeGroupOracle extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_netapp_volume_group_oracle";
    /**
    * Generates CDKTF code for importing a NetappVolumeGroupOracle resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetappVolumeGroupOracle to import
    * @param importFromId The id of the existing NetappVolumeGroupOracle that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetappVolumeGroupOracle to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/netapp_volume_group_oracle azurerm_netapp_volume_group_oracle} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetappVolumeGroupOracleConfig
    */
    constructor(scope: Construct, id: string, config: NetappVolumeGroupOracleConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _applicationIdentifier?;
    get applicationIdentifier(): string;
    set applicationIdentifier(value: string);
    get applicationIdentifierInput(): string | undefined;
    private _groupDescription?;
    get groupDescription(): string;
    set groupDescription(value: string);
    get groupDescriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetappVolumeGroupOracleTimeoutsOutputReference;
    putTimeouts(value: NetappVolumeGroupOracleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetappVolumeGroupOracleTimeouts | undefined;
    private _volume;
    get volume(): NetappVolumeGroupOracleVolumeList;
    putVolume(value: NetappVolumeGroupOracleVolume[] | cdktf.IResolvable): void;
    get volumeInput(): cdktf.IResolvable | NetappVolumeGroupOracleVolume[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
