/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#custom_network_interface_name PrivateEndpoint#custom_network_interface_name}
    */
    readonly customNetworkInterfaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#id PrivateEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#location PrivateEndpoint#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#name PrivateEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#resource_group_name PrivateEndpoint#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#subnet_id PrivateEndpoint#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#tags PrivateEndpoint#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#ip_configuration PrivateEndpoint#ip_configuration}
    */
    readonly ipConfiguration?: PrivateEndpointIpConfiguration[] | cdktf.IResolvable;
    /**
    * private_dns_zone_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_dns_zone_group PrivateEndpoint#private_dns_zone_group}
    */
    readonly privateDnsZoneGroup?: PrivateEndpointPrivateDnsZoneGroup;
    /**
    * private_service_connection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_service_connection PrivateEndpoint#private_service_connection}
    */
    readonly privateServiceConnection: PrivateEndpointPrivateServiceConnection;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#timeouts PrivateEndpoint#timeouts}
    */
    readonly timeouts?: PrivateEndpointTimeouts;
}
export interface PrivateEndpointCustomDnsConfigs {
}
export declare function privateEndpointCustomDnsConfigsToTerraform(struct?: PrivateEndpointCustomDnsConfigs): any;
export declare function privateEndpointCustomDnsConfigsToHclTerraform(struct?: PrivateEndpointCustomDnsConfigs): any;
export declare class PrivateEndpointCustomDnsConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateEndpointCustomDnsConfigs | undefined;
    set internalValue(value: PrivateEndpointCustomDnsConfigs | undefined);
    get fqdn(): string;
    get ipAddresses(): string[];
}
export declare class PrivateEndpointCustomDnsConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateEndpointCustomDnsConfigsOutputReference;
}
export interface PrivateEndpointNetworkInterface {
}
export declare function privateEndpointNetworkInterfaceToTerraform(struct?: PrivateEndpointNetworkInterface): any;
export declare function privateEndpointNetworkInterfaceToHclTerraform(struct?: PrivateEndpointNetworkInterface): any;
export declare class PrivateEndpointNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateEndpointNetworkInterface | undefined;
    set internalValue(value: PrivateEndpointNetworkInterface | undefined);
    get id(): string;
    get name(): string;
}
export declare class PrivateEndpointNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateEndpointNetworkInterfaceOutputReference;
}
export interface PrivateEndpointPrivateDnsZoneConfigsRecordSets {
}
export declare function privateEndpointPrivateDnsZoneConfigsRecordSetsToTerraform(struct?: PrivateEndpointPrivateDnsZoneConfigsRecordSets): any;
export declare function privateEndpointPrivateDnsZoneConfigsRecordSetsToHclTerraform(struct?: PrivateEndpointPrivateDnsZoneConfigsRecordSets): any;
export declare class PrivateEndpointPrivateDnsZoneConfigsRecordSetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateEndpointPrivateDnsZoneConfigsRecordSets | undefined;
    set internalValue(value: PrivateEndpointPrivateDnsZoneConfigsRecordSets | undefined);
    get fqdn(): string;
    get ipAddresses(): string[];
    get name(): string;
    get ttl(): number;
    get type(): string;
}
export declare class PrivateEndpointPrivateDnsZoneConfigsRecordSetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateEndpointPrivateDnsZoneConfigsRecordSetsOutputReference;
}
export interface PrivateEndpointPrivateDnsZoneConfigs {
}
export declare function privateEndpointPrivateDnsZoneConfigsToTerraform(struct?: PrivateEndpointPrivateDnsZoneConfigs): any;
export declare function privateEndpointPrivateDnsZoneConfigsToHclTerraform(struct?: PrivateEndpointPrivateDnsZoneConfigs): any;
export declare class PrivateEndpointPrivateDnsZoneConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateEndpointPrivateDnsZoneConfigs | undefined;
    set internalValue(value: PrivateEndpointPrivateDnsZoneConfigs | undefined);
    get id(): string;
    get name(): string;
    get privateDnsZoneId(): string;
    private _recordSets;
    get recordSets(): PrivateEndpointPrivateDnsZoneConfigsRecordSetsList;
}
export declare class PrivateEndpointPrivateDnsZoneConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateEndpointPrivateDnsZoneConfigsOutputReference;
}
export interface PrivateEndpointIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#member_name PrivateEndpoint#member_name}
    */
    readonly memberName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#name PrivateEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_ip_address PrivateEndpoint#private_ip_address}
    */
    readonly privateIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#subresource_name PrivateEndpoint#subresource_name}
    */
    readonly subresourceName?: string;
}
export declare function privateEndpointIpConfigurationToTerraform(struct?: PrivateEndpointIpConfiguration | cdktf.IResolvable): any;
export declare function privateEndpointIpConfigurationToHclTerraform(struct?: PrivateEndpointIpConfiguration | cdktf.IResolvable): any;
export declare class PrivateEndpointIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateEndpointIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateEndpointIpConfiguration | cdktf.IResolvable | undefined);
    private _memberName?;
    get memberName(): string;
    set memberName(value: string);
    resetMemberName(): void;
    get memberNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    get privateIpAddressInput(): string | undefined;
    private _subresourceName?;
    get subresourceName(): string;
    set subresourceName(value: string);
    resetSubresourceName(): void;
    get subresourceNameInput(): string | undefined;
}
export declare class PrivateEndpointIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivateEndpointIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateEndpointIpConfigurationOutputReference;
}
export interface PrivateEndpointPrivateDnsZoneGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#name PrivateEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_dns_zone_ids PrivateEndpoint#private_dns_zone_ids}
    */
    readonly privateDnsZoneIds: string[];
}
export declare function privateEndpointPrivateDnsZoneGroupToTerraform(struct?: PrivateEndpointPrivateDnsZoneGroupOutputReference | PrivateEndpointPrivateDnsZoneGroup): any;
export declare function privateEndpointPrivateDnsZoneGroupToHclTerraform(struct?: PrivateEndpointPrivateDnsZoneGroupOutputReference | PrivateEndpointPrivateDnsZoneGroup): any;
export declare class PrivateEndpointPrivateDnsZoneGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateEndpointPrivateDnsZoneGroup | undefined;
    set internalValue(value: PrivateEndpointPrivateDnsZoneGroup | undefined);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateDnsZoneIds?;
    get privateDnsZoneIds(): string[];
    set privateDnsZoneIds(value: string[]);
    get privateDnsZoneIdsInput(): string[] | undefined;
}
export interface PrivateEndpointPrivateServiceConnection {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#is_manual_connection PrivateEndpoint#is_manual_connection}
    */
    readonly isManualConnection: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#name PrivateEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_connection_resource_alias PrivateEndpoint#private_connection_resource_alias}
    */
    readonly privateConnectionResourceAlias?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#private_connection_resource_id PrivateEndpoint#private_connection_resource_id}
    */
    readonly privateConnectionResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#request_message PrivateEndpoint#request_message}
    */
    readonly requestMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#subresource_names PrivateEndpoint#subresource_names}
    */
    readonly subresourceNames?: string[];
}
export declare function privateEndpointPrivateServiceConnectionToTerraform(struct?: PrivateEndpointPrivateServiceConnectionOutputReference | PrivateEndpointPrivateServiceConnection): any;
export declare function privateEndpointPrivateServiceConnectionToHclTerraform(struct?: PrivateEndpointPrivateServiceConnectionOutputReference | PrivateEndpointPrivateServiceConnection): any;
export declare class PrivateEndpointPrivateServiceConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateEndpointPrivateServiceConnection | undefined;
    set internalValue(value: PrivateEndpointPrivateServiceConnection | undefined);
    private _isManualConnection?;
    get isManualConnection(): boolean | cdktf.IResolvable;
    set isManualConnection(value: boolean | cdktf.IResolvable);
    get isManualConnectionInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateConnectionResourceAlias?;
    get privateConnectionResourceAlias(): string;
    set privateConnectionResourceAlias(value: string);
    resetPrivateConnectionResourceAlias(): void;
    get privateConnectionResourceAliasInput(): string | undefined;
    private _privateConnectionResourceId?;
    get privateConnectionResourceId(): string;
    set privateConnectionResourceId(value: string);
    resetPrivateConnectionResourceId(): void;
    get privateConnectionResourceIdInput(): string | undefined;
    get privateIpAddress(): string;
    private _requestMessage?;
    get requestMessage(): string;
    set requestMessage(value: string);
    resetRequestMessage(): void;
    get requestMessageInput(): string | undefined;
    private _subresourceNames?;
    get subresourceNames(): string[];
    set subresourceNames(value: string[]);
    resetSubresourceNames(): void;
    get subresourceNamesInput(): string[] | undefined;
}
export interface PrivateEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#create PrivateEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#delete PrivateEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#read PrivateEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#update PrivateEndpoint#update}
    */
    readonly update?: string;
}
export declare function privateEndpointTimeoutsToTerraform(struct?: PrivateEndpointTimeouts | cdktf.IResolvable): any;
export declare function privateEndpointTimeoutsToHclTerraform(struct?: PrivateEndpointTimeouts | cdktf.IResolvable): any;
export declare class PrivateEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint azurerm_private_endpoint}
*/
export declare class PrivateEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_private_endpoint";
    /**
    * Generates CDKTF code for importing a PrivateEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PrivateEndpoint to import
    * @param importFromId The id of the existing PrivateEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PrivateEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/private_endpoint azurerm_private_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateEndpointConfig
    */
    constructor(scope: Construct, id: string, config: PrivateEndpointConfig);
    private _customDnsConfigs;
    get customDnsConfigs(): PrivateEndpointCustomDnsConfigsList;
    private _customNetworkInterfaceName?;
    get customNetworkInterfaceName(): string;
    set customNetworkInterfaceName(value: string);
    resetCustomNetworkInterfaceName(): void;
    get customNetworkInterfaceNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): PrivateEndpointNetworkInterfaceList;
    private _privateDnsZoneConfigs;
    get privateDnsZoneConfigs(): PrivateEndpointPrivateDnsZoneConfigsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ipConfiguration;
    get ipConfiguration(): PrivateEndpointIpConfigurationList;
    putIpConfiguration(value: PrivateEndpointIpConfiguration[] | cdktf.IResolvable): void;
    resetIpConfiguration(): void;
    get ipConfigurationInput(): cdktf.IResolvable | PrivateEndpointIpConfiguration[] | undefined;
    private _privateDnsZoneGroup;
    get privateDnsZoneGroup(): PrivateEndpointPrivateDnsZoneGroupOutputReference;
    putPrivateDnsZoneGroup(value: PrivateEndpointPrivateDnsZoneGroup): void;
    resetPrivateDnsZoneGroup(): void;
    get privateDnsZoneGroupInput(): PrivateEndpointPrivateDnsZoneGroup | undefined;
    private _privateServiceConnection;
    get privateServiceConnection(): PrivateEndpointPrivateServiceConnectionOutputReference;
    putPrivateServiceConnection(value: PrivateEndpointPrivateServiceConnection): void;
    get privateServiceConnectionInput(): PrivateEndpointPrivateServiceConnection | undefined;
    private _timeouts;
    get timeouts(): PrivateEndpointTimeoutsOutputReference;
    putTimeouts(value: PrivateEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivateEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
