/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedisCacheAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#id RedisCacheAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#name RedisCacheAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#permissions RedisCacheAccessPolicy#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#redis_cache_id RedisCacheAccessPolicy#redis_cache_id}
    */
    readonly redisCacheId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#timeouts RedisCacheAccessPolicy#timeouts}
    */
    readonly timeouts?: RedisCacheAccessPolicyTimeouts;
}
export interface RedisCacheAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#create RedisCacheAccessPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#delete RedisCacheAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#read RedisCacheAccessPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#update RedisCacheAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function redisCacheAccessPolicyTimeoutsToTerraform(struct?: RedisCacheAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare function redisCacheAccessPolicyTimeoutsToHclTerraform(struct?: RedisCacheAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class RedisCacheAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisCacheAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RedisCacheAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy azurerm_redis_cache_access_policy}
*/
export declare class RedisCacheAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_redis_cache_access_policy";
    /**
    * Generates CDKTF code for importing a RedisCacheAccessPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RedisCacheAccessPolicy to import
    * @param importFromId The id of the existing RedisCacheAccessPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RedisCacheAccessPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/redis_cache_access_policy azurerm_redis_cache_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedisCacheAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: RedisCacheAccessPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    get permissionsInput(): string | undefined;
    private _redisCacheId?;
    get redisCacheId(): string;
    set redisCacheId(value: string);
    get redisCacheIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): RedisCacheAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: RedisCacheAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RedisCacheAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
