/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusSubscriptionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#action ServicebusSubscriptionRule#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#filter_type ServicebusSubscriptionRule#filter_type}
    */
    readonly filterType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#id ServicebusSubscriptionRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#name ServicebusSubscriptionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#sql_filter ServicebusSubscriptionRule#sql_filter}
    */
    readonly sqlFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#subscription_id ServicebusSubscriptionRule#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * correlation_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#correlation_filter ServicebusSubscriptionRule#correlation_filter}
    */
    readonly correlationFilter?: ServicebusSubscriptionRuleCorrelationFilter;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#timeouts ServicebusSubscriptionRule#timeouts}
    */
    readonly timeouts?: ServicebusSubscriptionRuleTimeouts;
}
export interface ServicebusSubscriptionRuleCorrelationFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#content_type ServicebusSubscriptionRule#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#correlation_id ServicebusSubscriptionRule#correlation_id}
    */
    readonly correlationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#label ServicebusSubscriptionRule#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#message_id ServicebusSubscriptionRule#message_id}
    */
    readonly messageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#properties ServicebusSubscriptionRule#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#reply_to ServicebusSubscriptionRule#reply_to}
    */
    readonly replyTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#reply_to_session_id ServicebusSubscriptionRule#reply_to_session_id}
    */
    readonly replyToSessionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#session_id ServicebusSubscriptionRule#session_id}
    */
    readonly sessionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#to ServicebusSubscriptionRule#to}
    */
    readonly to?: string;
}
export declare function servicebusSubscriptionRuleCorrelationFilterToTerraform(struct?: ServicebusSubscriptionRuleCorrelationFilterOutputReference | ServicebusSubscriptionRuleCorrelationFilter): any;
export declare function servicebusSubscriptionRuleCorrelationFilterToHclTerraform(struct?: ServicebusSubscriptionRuleCorrelationFilterOutputReference | ServicebusSubscriptionRuleCorrelationFilter): any;
export declare class ServicebusSubscriptionRuleCorrelationFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusSubscriptionRuleCorrelationFilter | undefined;
    set internalValue(value: ServicebusSubscriptionRuleCorrelationFilter | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _correlationId?;
    get correlationId(): string;
    set correlationId(value: string);
    resetCorrelationId(): void;
    get correlationIdInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _messageId?;
    get messageId(): string;
    set messageId(value: string);
    resetMessageId(): void;
    get messageIdInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _replyTo?;
    get replyTo(): string;
    set replyTo(value: string);
    resetReplyTo(): void;
    get replyToInput(): string | undefined;
    private _replyToSessionId?;
    get replyToSessionId(): string;
    set replyToSessionId(value: string);
    resetReplyToSessionId(): void;
    get replyToSessionIdInput(): string | undefined;
    private _sessionId?;
    get sessionId(): string;
    set sessionId(value: string);
    resetSessionId(): void;
    get sessionIdInput(): string | undefined;
    private _to?;
    get to(): string;
    set to(value: string);
    resetTo(): void;
    get toInput(): string | undefined;
}
export interface ServicebusSubscriptionRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#create ServicebusSubscriptionRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#delete ServicebusSubscriptionRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#read ServicebusSubscriptionRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#update ServicebusSubscriptionRule#update}
    */
    readonly update?: string;
}
export declare function servicebusSubscriptionRuleTimeoutsToTerraform(struct?: ServicebusSubscriptionRuleTimeouts | cdktf.IResolvable): any;
export declare function servicebusSubscriptionRuleTimeoutsToHclTerraform(struct?: ServicebusSubscriptionRuleTimeouts | cdktf.IResolvable): any;
export declare class ServicebusSubscriptionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusSubscriptionRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusSubscriptionRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule azurerm_servicebus_subscription_rule}
*/
export declare class ServicebusSubscriptionRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_subscription_rule";
    /**
    * Generates CDKTF code for importing a ServicebusSubscriptionRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServicebusSubscriptionRule to import
    * @param importFromId The id of the existing ServicebusSubscriptionRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServicebusSubscriptionRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/servicebus_subscription_rule azurerm_servicebus_subscription_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusSubscriptionRuleConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusSubscriptionRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _filterType?;
    get filterType(): string;
    set filterType(value: string);
    get filterTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sqlFilter?;
    get sqlFilter(): string;
    set sqlFilter(value: string);
    resetSqlFilter(): void;
    get sqlFilterInput(): string | undefined;
    get sqlFilterCompatibilityLevel(): number;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _correlationFilter;
    get correlationFilter(): ServicebusSubscriptionRuleCorrelationFilterOutputReference;
    putCorrelationFilter(value: ServicebusSubscriptionRuleCorrelationFilter): void;
    resetCorrelationFilter(): void;
    get correlationFilterInput(): ServicebusSubscriptionRuleCorrelationFilter | undefined;
    private _timeouts;
    get timeouts(): ServicebusSubscriptionRuleTimeoutsOutputReference;
    putTimeouts(value: ServicebusSubscriptionRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicebusSubscriptionRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
