/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticWebAppCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#domain_name StaticWebAppCustomDomain#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#id StaticWebAppCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#static_web_app_id StaticWebAppCustomDomain#static_web_app_id}
    */
    readonly staticWebAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#validation_type StaticWebAppCustomDomain#validation_type}
    */
    readonly validationType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#timeouts StaticWebAppCustomDomain#timeouts}
    */
    readonly timeouts?: StaticWebAppCustomDomainTimeouts;
}
export interface StaticWebAppCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#create StaticWebAppCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#delete StaticWebAppCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#read StaticWebAppCustomDomain#read}
    */
    readonly read?: string;
}
export declare function staticWebAppCustomDomainTimeoutsToTerraform(struct?: StaticWebAppCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function staticWebAppCustomDomainTimeoutsToHclTerraform(struct?: StaticWebAppCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class StaticWebAppCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticWebAppCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StaticWebAppCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain azurerm_static_web_app_custom_domain}
*/
export declare class StaticWebAppCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_static_web_app_custom_domain";
    /**
    * Generates CDKTF code for importing a StaticWebAppCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticWebAppCustomDomain to import
    * @param importFromId The id of the existing StaticWebAppCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticWebAppCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/static_web_app_custom_domain azurerm_static_web_app_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticWebAppCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: StaticWebAppCustomDomainConfig);
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _staticWebAppId?;
    get staticWebAppId(): string;
    set staticWebAppId(value: string);
    get staticWebAppIdInput(): string | undefined;
    get validationToken(): string;
    private _validationType?;
    get validationType(): string;
    set validationType(value: string);
    get validationTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): StaticWebAppCustomDomainTimeoutsOutputReference;
    putTimeouts(value: StaticWebAppCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StaticWebAppCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
