/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageSyncGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#id StorageSyncGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#name StorageSyncGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#storage_sync_id StorageSyncGroup#storage_sync_id}
    */
    readonly storageSyncId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#timeouts StorageSyncGroup#timeouts}
    */
    readonly timeouts?: StorageSyncGroupTimeouts;
}
export interface StorageSyncGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#create StorageSyncGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#delete StorageSyncGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#read StorageSyncGroup#read}
    */
    readonly read?: string;
}
export declare function storageSyncGroupTimeoutsToTerraform(struct?: StorageSyncGroupTimeouts | cdktf.IResolvable): any;
export declare function storageSyncGroupTimeoutsToHclTerraform(struct?: StorageSyncGroupTimeouts | cdktf.IResolvable): any;
export declare class StorageSyncGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageSyncGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageSyncGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group azurerm_storage_sync_group}
*/
export declare class StorageSyncGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_sync_group";
    /**
    * Generates CDKTF code for importing a StorageSyncGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageSyncGroup to import
    * @param importFromId The id of the existing StorageSyncGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageSyncGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/storage_sync_group azurerm_storage_sync_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageSyncGroupConfig
    */
    constructor(scope: Construct, id: string, config: StorageSyncGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageSyncId?;
    get storageSyncId(): string;
    set storageSyncId(value: string);
    get storageSyncIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageSyncGroupTimeoutsOutputReference;
    putTimeouts(value: StorageSyncGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageSyncGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
