/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#id TrafficManagerProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#max_return TrafficManagerProfile#max_return}
    */
    readonly maxReturn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#name TrafficManagerProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#profile_status TrafficManagerProfile#profile_status}
    */
    readonly profileStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#resource_group_name TrafficManagerProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#tags TrafficManagerProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#traffic_routing_method TrafficManagerProfile#traffic_routing_method}
    */
    readonly trafficRoutingMethod: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#traffic_view_enabled TrafficManagerProfile#traffic_view_enabled}
    */
    readonly trafficViewEnabled?: boolean | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#dns_config TrafficManagerProfile#dns_config}
    */
    readonly dnsConfig: TrafficManagerProfileDnsConfig;
    /**
    * monitor_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#monitor_config TrafficManagerProfile#monitor_config}
    */
    readonly monitorConfig: TrafficManagerProfileMonitorConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#timeouts TrafficManagerProfile#timeouts}
    */
    readonly timeouts?: TrafficManagerProfileTimeouts;
}
export interface TrafficManagerProfileDnsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#relative_name TrafficManagerProfile#relative_name}
    */
    readonly relativeName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#ttl TrafficManagerProfile#ttl}
    */
    readonly ttl: number;
}
export declare function trafficManagerProfileDnsConfigToTerraform(struct?: TrafficManagerProfileDnsConfigOutputReference | TrafficManagerProfileDnsConfig): any;
export declare function trafficManagerProfileDnsConfigToHclTerraform(struct?: TrafficManagerProfileDnsConfigOutputReference | TrafficManagerProfileDnsConfig): any;
export declare class TrafficManagerProfileDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerProfileDnsConfig | undefined;
    set internalValue(value: TrafficManagerProfileDnsConfig | undefined);
    private _relativeName?;
    get relativeName(): string;
    set relativeName(value: string);
    get relativeNameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
}
export interface TrafficManagerProfileMonitorConfigCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#name TrafficManagerProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#value TrafficManagerProfile#value}
    */
    readonly value: string;
}
export declare function trafficManagerProfileMonitorConfigCustomHeaderToTerraform(struct?: TrafficManagerProfileMonitorConfigCustomHeader | cdktf.IResolvable): any;
export declare function trafficManagerProfileMonitorConfigCustomHeaderToHclTerraform(struct?: TrafficManagerProfileMonitorConfigCustomHeader | cdktf.IResolvable): any;
export declare class TrafficManagerProfileMonitorConfigCustomHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TrafficManagerProfileMonitorConfigCustomHeader | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerProfileMonitorConfigCustomHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class TrafficManagerProfileMonitorConfigCustomHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TrafficManagerProfileMonitorConfigCustomHeaderOutputReference;
}
export interface TrafficManagerProfileMonitorConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#expected_status_code_ranges TrafficManagerProfile#expected_status_code_ranges}
    */
    readonly expectedStatusCodeRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#interval_in_seconds TrafficManagerProfile#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#path TrafficManagerProfile#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#port TrafficManagerProfile#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#protocol TrafficManagerProfile#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#timeout_in_seconds TrafficManagerProfile#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#tolerated_number_of_failures TrafficManagerProfile#tolerated_number_of_failures}
    */
    readonly toleratedNumberOfFailures?: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#custom_header TrafficManagerProfile#custom_header}
    */
    readonly customHeader?: TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable;
}
export declare function trafficManagerProfileMonitorConfigToTerraform(struct?: TrafficManagerProfileMonitorConfigOutputReference | TrafficManagerProfileMonitorConfig): any;
export declare function trafficManagerProfileMonitorConfigToHclTerraform(struct?: TrafficManagerProfileMonitorConfigOutputReference | TrafficManagerProfileMonitorConfig): any;
export declare class TrafficManagerProfileMonitorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerProfileMonitorConfig | undefined;
    set internalValue(value: TrafficManagerProfileMonitorConfig | undefined);
    private _expectedStatusCodeRanges?;
    get expectedStatusCodeRanges(): string[];
    set expectedStatusCodeRanges(value: string[]);
    resetExpectedStatusCodeRanges(): void;
    get expectedStatusCodeRangesInput(): string[] | undefined;
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    resetIntervalInSeconds(): void;
    get intervalInSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _toleratedNumberOfFailures?;
    get toleratedNumberOfFailures(): number;
    set toleratedNumberOfFailures(value: number);
    resetToleratedNumberOfFailures(): void;
    get toleratedNumberOfFailuresInput(): number | undefined;
    private _customHeader;
    get customHeader(): TrafficManagerProfileMonitorConfigCustomHeaderList;
    putCustomHeader(value: TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable): void;
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerProfileMonitorConfigCustomHeader[] | undefined;
}
export interface TrafficManagerProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#create TrafficManagerProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#delete TrafficManagerProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#read TrafficManagerProfile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#update TrafficManagerProfile#update}
    */
    readonly update?: string;
}
export declare function trafficManagerProfileTimeoutsToTerraform(struct?: TrafficManagerProfileTimeouts | cdktf.IResolvable): any;
export declare function trafficManagerProfileTimeoutsToHclTerraform(struct?: TrafficManagerProfileTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile azurerm_traffic_manager_profile}
*/
export declare class TrafficManagerProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_profile";
    /**
    * Generates CDKTF code for importing a TrafficManagerProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TrafficManagerProfile to import
    * @param importFromId The id of the existing TrafficManagerProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TrafficManagerProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/traffic_manager_profile azurerm_traffic_manager_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerProfileConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerProfileConfig);
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxReturn?;
    get maxReturn(): number;
    set maxReturn(value: number);
    resetMaxReturn(): void;
    get maxReturnInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileStatus?;
    get profileStatus(): string;
    set profileStatus(value: string);
    resetProfileStatus(): void;
    get profileStatusInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trafficRoutingMethod?;
    get trafficRoutingMethod(): string;
    set trafficRoutingMethod(value: string);
    get trafficRoutingMethodInput(): string | undefined;
    private _trafficViewEnabled?;
    get trafficViewEnabled(): boolean | cdktf.IResolvable;
    set trafficViewEnabled(value: boolean | cdktf.IResolvable);
    resetTrafficViewEnabled(): void;
    get trafficViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsConfig;
    get dnsConfig(): TrafficManagerProfileDnsConfigOutputReference;
    putDnsConfig(value: TrafficManagerProfileDnsConfig): void;
    get dnsConfigInput(): TrafficManagerProfileDnsConfig | undefined;
    private _monitorConfig;
    get monitorConfig(): TrafficManagerProfileMonitorConfigOutputReference;
    putMonitorConfig(value: TrafficManagerProfileMonitorConfig): void;
    get monitorConfigInput(): TrafficManagerProfileMonitorConfig | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerProfileTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TrafficManagerProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
