/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineRunCommandConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#error_blob_uri VirtualMachineRunCommand#error_blob_uri}
    */
    readonly errorBlobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#id VirtualMachineRunCommand#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#location VirtualMachineRunCommand#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#name VirtualMachineRunCommand#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#output_blob_uri VirtualMachineRunCommand#output_blob_uri}
    */
    readonly outputBlobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#run_as_password VirtualMachineRunCommand#run_as_password}
    */
    readonly runAsPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#run_as_user VirtualMachineRunCommand#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#tags VirtualMachineRunCommand#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#virtual_machine_id VirtualMachineRunCommand#virtual_machine_id}
    */
    readonly virtualMachineId: string;
    /**
    * error_blob_managed_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#error_blob_managed_identity VirtualMachineRunCommand#error_blob_managed_identity}
    */
    readonly errorBlobManagedIdentity?: VirtualMachineRunCommandErrorBlobManagedIdentity;
    /**
    * output_blob_managed_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#output_blob_managed_identity VirtualMachineRunCommand#output_blob_managed_identity}
    */
    readonly outputBlobManagedIdentity?: VirtualMachineRunCommandOutputBlobManagedIdentity;
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#parameter VirtualMachineRunCommand#parameter}
    */
    readonly parameter?: VirtualMachineRunCommandParameter[] | cdktf.IResolvable;
    /**
    * protected_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#protected_parameter VirtualMachineRunCommand#protected_parameter}
    */
    readonly protectedParameter?: VirtualMachineRunCommandProtectedParameter[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#source VirtualMachineRunCommand#source}
    */
    readonly source: VirtualMachineRunCommandSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#timeouts VirtualMachineRunCommand#timeouts}
    */
    readonly timeouts?: VirtualMachineRunCommandTimeouts;
}
export interface VirtualMachineRunCommandInstanceView {
}
export declare function virtualMachineRunCommandInstanceViewToTerraform(struct?: VirtualMachineRunCommandInstanceView): any;
export declare function virtualMachineRunCommandInstanceViewToHclTerraform(struct?: VirtualMachineRunCommandInstanceView): any;
export declare class VirtualMachineRunCommandInstanceViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineRunCommandInstanceView | undefined;
    set internalValue(value: VirtualMachineRunCommandInstanceView | undefined);
    get endTime(): string;
    get errorMessage(): string;
    get executionMessage(): string;
    get executionState(): string;
    get exitCode(): number;
    get output(): string;
    get startTime(): string;
}
export declare class VirtualMachineRunCommandInstanceViewList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineRunCommandInstanceViewOutputReference;
}
export interface VirtualMachineRunCommandErrorBlobManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#client_id VirtualMachineRunCommand#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#object_id VirtualMachineRunCommand#object_id}
    */
    readonly objectId?: string;
}
export declare function virtualMachineRunCommandErrorBlobManagedIdentityToTerraform(struct?: VirtualMachineRunCommandErrorBlobManagedIdentityOutputReference | VirtualMachineRunCommandErrorBlobManagedIdentity): any;
export declare function virtualMachineRunCommandErrorBlobManagedIdentityToHclTerraform(struct?: VirtualMachineRunCommandErrorBlobManagedIdentityOutputReference | VirtualMachineRunCommandErrorBlobManagedIdentity): any;
export declare class VirtualMachineRunCommandErrorBlobManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRunCommandErrorBlobManagedIdentity | undefined;
    set internalValue(value: VirtualMachineRunCommandErrorBlobManagedIdentity | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
}
export interface VirtualMachineRunCommandOutputBlobManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#client_id VirtualMachineRunCommand#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#object_id VirtualMachineRunCommand#object_id}
    */
    readonly objectId?: string;
}
export declare function virtualMachineRunCommandOutputBlobManagedIdentityToTerraform(struct?: VirtualMachineRunCommandOutputBlobManagedIdentityOutputReference | VirtualMachineRunCommandOutputBlobManagedIdentity): any;
export declare function virtualMachineRunCommandOutputBlobManagedIdentityToHclTerraform(struct?: VirtualMachineRunCommandOutputBlobManagedIdentityOutputReference | VirtualMachineRunCommandOutputBlobManagedIdentity): any;
export declare class VirtualMachineRunCommandOutputBlobManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRunCommandOutputBlobManagedIdentity | undefined;
    set internalValue(value: VirtualMachineRunCommandOutputBlobManagedIdentity | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
}
export interface VirtualMachineRunCommandParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#name VirtualMachineRunCommand#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#value VirtualMachineRunCommand#value}
    */
    readonly value: string;
}
export declare function virtualMachineRunCommandParameterToTerraform(struct?: VirtualMachineRunCommandParameter | cdktf.IResolvable): any;
export declare function virtualMachineRunCommandParameterToHclTerraform(struct?: VirtualMachineRunCommandParameter | cdktf.IResolvable): any;
export declare class VirtualMachineRunCommandParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineRunCommandParameter | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineRunCommandParameter | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class VirtualMachineRunCommandParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineRunCommandParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineRunCommandParameterOutputReference;
}
export interface VirtualMachineRunCommandProtectedParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#name VirtualMachineRunCommand#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#value VirtualMachineRunCommand#value}
    */
    readonly value: string;
}
export declare function virtualMachineRunCommandProtectedParameterToTerraform(struct?: VirtualMachineRunCommandProtectedParameter | cdktf.IResolvable): any;
export declare function virtualMachineRunCommandProtectedParameterToHclTerraform(struct?: VirtualMachineRunCommandProtectedParameter | cdktf.IResolvable): any;
export declare class VirtualMachineRunCommandProtectedParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineRunCommandProtectedParameter | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineRunCommandProtectedParameter | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class VirtualMachineRunCommandProtectedParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineRunCommandProtectedParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineRunCommandProtectedParameterOutputReference;
}
export interface VirtualMachineRunCommandSourceScriptUriManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#client_id VirtualMachineRunCommand#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#object_id VirtualMachineRunCommand#object_id}
    */
    readonly objectId?: string;
}
export declare function virtualMachineRunCommandSourceScriptUriManagedIdentityToTerraform(struct?: VirtualMachineRunCommandSourceScriptUriManagedIdentityOutputReference | VirtualMachineRunCommandSourceScriptUriManagedIdentity): any;
export declare function virtualMachineRunCommandSourceScriptUriManagedIdentityToHclTerraform(struct?: VirtualMachineRunCommandSourceScriptUriManagedIdentityOutputReference | VirtualMachineRunCommandSourceScriptUriManagedIdentity): any;
export declare class VirtualMachineRunCommandSourceScriptUriManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRunCommandSourceScriptUriManagedIdentity | undefined;
    set internalValue(value: VirtualMachineRunCommandSourceScriptUriManagedIdentity | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
}
export interface VirtualMachineRunCommandSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#command_id VirtualMachineRunCommand#command_id}
    */
    readonly commandId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#script VirtualMachineRunCommand#script}
    */
    readonly script?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#script_uri VirtualMachineRunCommand#script_uri}
    */
    readonly scriptUri?: string;
    /**
    * script_uri_managed_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#script_uri_managed_identity VirtualMachineRunCommand#script_uri_managed_identity}
    */
    readonly scriptUriManagedIdentity?: VirtualMachineRunCommandSourceScriptUriManagedIdentity;
}
export declare function virtualMachineRunCommandSourceToTerraform(struct?: VirtualMachineRunCommandSourceOutputReference | VirtualMachineRunCommandSource): any;
export declare function virtualMachineRunCommandSourceToHclTerraform(struct?: VirtualMachineRunCommandSourceOutputReference | VirtualMachineRunCommandSource): any;
export declare class VirtualMachineRunCommandSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRunCommandSource | undefined;
    set internalValue(value: VirtualMachineRunCommandSource | undefined);
    private _commandId?;
    get commandId(): string;
    set commandId(value: string);
    resetCommandId(): void;
    get commandIdInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    resetScript(): void;
    get scriptInput(): string | undefined;
    private _scriptUri?;
    get scriptUri(): string;
    set scriptUri(value: string);
    resetScriptUri(): void;
    get scriptUriInput(): string | undefined;
    private _scriptUriManagedIdentity;
    get scriptUriManagedIdentity(): VirtualMachineRunCommandSourceScriptUriManagedIdentityOutputReference;
    putScriptUriManagedIdentity(value: VirtualMachineRunCommandSourceScriptUriManagedIdentity): void;
    resetScriptUriManagedIdentity(): void;
    get scriptUriManagedIdentityInput(): VirtualMachineRunCommandSourceScriptUriManagedIdentity | undefined;
}
export interface VirtualMachineRunCommandTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#create VirtualMachineRunCommand#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#delete VirtualMachineRunCommand#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#read VirtualMachineRunCommand#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#update VirtualMachineRunCommand#update}
    */
    readonly update?: string;
}
export declare function virtualMachineRunCommandTimeoutsToTerraform(struct?: VirtualMachineRunCommandTimeouts | cdktf.IResolvable): any;
export declare function virtualMachineRunCommandTimeoutsToHclTerraform(struct?: VirtualMachineRunCommandTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineRunCommandTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineRunCommandTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineRunCommandTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command azurerm_virtual_machine_run_command}
*/
export declare class VirtualMachineRunCommand extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine_run_command";
    /**
    * Generates CDKTF code for importing a VirtualMachineRunCommand resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineRunCommand to import
    * @param importFromId The id of the existing VirtualMachineRunCommand that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineRunCommand to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.0/docs/resources/virtual_machine_run_command azurerm_virtual_machine_run_command} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineRunCommandConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineRunCommandConfig);
    private _errorBlobUri?;
    get errorBlobUri(): string;
    set errorBlobUri(value: string);
    resetErrorBlobUri(): void;
    get errorBlobUriInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceView;
    get instanceView(): VirtualMachineRunCommandInstanceViewList;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outputBlobUri?;
    get outputBlobUri(): string;
    set outputBlobUri(value: string);
    resetOutputBlobUri(): void;
    get outputBlobUriInput(): string | undefined;
    private _runAsPassword?;
    get runAsPassword(): string;
    set runAsPassword(value: string);
    resetRunAsPassword(): void;
    get runAsPasswordInput(): string | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    private _errorBlobManagedIdentity;
    get errorBlobManagedIdentity(): VirtualMachineRunCommandErrorBlobManagedIdentityOutputReference;
    putErrorBlobManagedIdentity(value: VirtualMachineRunCommandErrorBlobManagedIdentity): void;
    resetErrorBlobManagedIdentity(): void;
    get errorBlobManagedIdentityInput(): VirtualMachineRunCommandErrorBlobManagedIdentity | undefined;
    private _outputBlobManagedIdentity;
    get outputBlobManagedIdentity(): VirtualMachineRunCommandOutputBlobManagedIdentityOutputReference;
    putOutputBlobManagedIdentity(value: VirtualMachineRunCommandOutputBlobManagedIdentity): void;
    resetOutputBlobManagedIdentity(): void;
    get outputBlobManagedIdentityInput(): VirtualMachineRunCommandOutputBlobManagedIdentity | undefined;
    private _parameter;
    get parameter(): VirtualMachineRunCommandParameterList;
    putParameter(value: VirtualMachineRunCommandParameter[] | cdktf.IResolvable): void;
    resetParameter(): void;
    get parameterInput(): cdktf.IResolvable | VirtualMachineRunCommandParameter[] | undefined;
    private _protectedParameter;
    get protectedParameter(): VirtualMachineRunCommandProtectedParameterList;
    putProtectedParameter(value: VirtualMachineRunCommandProtectedParameter[] | cdktf.IResolvable): void;
    resetProtectedParameter(): void;
    get protectedParameterInput(): cdktf.IResolvable | VirtualMachineRunCommandProtectedParameter[] | undefined;
    private _source;
    get source(): VirtualMachineRunCommandSourceOutputReference;
    putSource(value: VirtualMachineRunCommandSource): void;
    get sourceInput(): VirtualMachineRunCommandSource | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineRunCommandTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineRunCommandTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachineRunCommandTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
