# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from cs3.sharing.ocm.v1beta1 import ocm_api_pb2 as cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2


class OcmAPIStub(object):
    """OCM Share Provider API

    The OCM Share Provider API is meant to manipulate share
    resources from the perspective of the creator or the share and
    from the perspective of the receiver of the share.

    The following APIs match the OCM v1.1 spec including multi-protocol shares.

    The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL
    NOT", "SHOULD", "SHOULD NOT", "RECOMMENDED",  "MAY", and
    "OPTIONAL" in this document are to be interpreted as described in
    RFC 2119.

    The following are global requirements that apply to all methods:
    Any method MUST return CODE_OK on a succesful operation.
    Any method MAY return NOT_IMPLEMENTED.
    Any method MAY return INTERNAL.
    Any method MAY return UNKNOWN.
    Any method MAY return UNAUTHENTICATED.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/CreateOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareResponse.FromString,
                )
        self.RemoveOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/RemoveOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareResponse.FromString,
                )
        self.GetOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/GetOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareResponse.FromString,
                )
        self.GetOCMShareByToken = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/GetOCMShareByToken',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenResponse.FromString,
                )
        self.ListOCMShares = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/ListOCMShares',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesResponse.FromString,
                )
        self.UpdateOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/UpdateOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareResponse.FromString,
                )
        self.ListReceivedOCMShares = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/ListReceivedOCMShares',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesResponse.FromString,
                )
        self.UpdateReceivedOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/UpdateReceivedOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareResponse.FromString,
                )
        self.GetReceivedOCMShare = channel.unary_unary(
                '/cs3.sharing.ocm.v1beta1.OcmAPI/GetReceivedOCMShare',
                request_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareRequest.SerializeToString,
                response_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareResponse.FromString,
                )


class OcmAPIServicer(object):
    """OCM Share Provider API

    The OCM Share Provider API is meant to manipulate share
    resources from the perspective of the creator or the share and
    from the perspective of the receiver of the share.

    The following APIs match the OCM v1.1 spec including multi-protocol shares.

    The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL
    NOT", "SHOULD", "SHOULD NOT", "RECOMMENDED",  "MAY", and
    "OPTIONAL" in this document are to be interpreted as described in
    RFC 2119.

    The following are global requirements that apply to all methods:
    Any method MUST return CODE_OK on a succesful operation.
    Any method MAY return NOT_IMPLEMENTED.
    Any method MAY return INTERNAL.
    Any method MAY return UNKNOWN.
    Any method MAY return UNAUTHENTICATED.
    """

    def CreateOCMShare(self, request, context):
        """Creates a new ocm share.
        MUST return CODE_NOT_FOUND if the resource reference does not exist.
        MUST return CODE_ALREADY_EXISTS if the share already exists for the 4-tuple consisting of
        (owner, shared_resource, grantee).
        New shares MUST be created in the state SHARE_STATE_PENDING, and MUST be sent
        to the remote system using the OCM API at:
        https://cs3org.github.io/OCM-API/docs.html?branch=v1.1.0&repo=OCM-API&user=cs3org#/paths/~1shares/post
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveOCMShare(self, request, context):
        """Removes a share.
        MUST return CODE_NOT_FOUND if the share reference does not exist.
        This action SHALL be notified to the remote system
        using the OCM API at:
        https://cs3org.github.io/OCM-API/docs.html?branch=v1.1.0&repo=OCM-API&user=cs3org#/paths/~1notifications/post
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetOCMShare(self, request, context):
        """Gets share information for a single share.
        MUST return CODE_NOT_FOUND if the share reference does not exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetOCMShareByToken(self, request, context):
        """Gets share information for a single share by its unlisted token.
        MUST return CODE_NOT_FOUND if the share does not exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListOCMShares(self, request, context):
        """List the shares the authenticated principal has created,
        both as owner and creator. If a filter is specified, only
        shares satisfying the filter MUST be returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateOCMShare(self, request, context):
        """Updates a share.
        MUST return CODE_NOT_FOUND if the share reference does not exist.
        This action SHALL be notified to the remote system
        using the OCM API at:
        https://cs3org.github.io/OCM-API/docs.html?branch=v1.1.0&repo=OCM-API&user=cs3org#/paths/~1notifications/post
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListReceivedOCMShares(self, request, context):
        """List all shares the authenticated principal has received.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateReceivedOCMShare(self, request, context):
        """Update the received share to change the share state or the display name.
        MUST return CODE_NOT_FOUND if the share reference does not exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetReceivedOCMShare(self, request, context):
        """Get the information for the given received share reference.
        MUST return CODE_NOT_FOUND if the received share reference does not exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_OcmAPIServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareResponse.SerializeToString,
            ),
            'RemoveOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareResponse.SerializeToString,
            ),
            'GetOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.GetOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareResponse.SerializeToString,
            ),
            'GetOCMShareByToken': grpc.unary_unary_rpc_method_handler(
                    servicer.GetOCMShareByToken,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenResponse.SerializeToString,
            ),
            'ListOCMShares': grpc.unary_unary_rpc_method_handler(
                    servicer.ListOCMShares,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesResponse.SerializeToString,
            ),
            'UpdateOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareResponse.SerializeToString,
            ),
            'ListReceivedOCMShares': grpc.unary_unary_rpc_method_handler(
                    servicer.ListReceivedOCMShares,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesResponse.SerializeToString,
            ),
            'UpdateReceivedOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateReceivedOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareResponse.SerializeToString,
            ),
            'GetReceivedOCMShare': grpc.unary_unary_rpc_method_handler(
                    servicer.GetReceivedOCMShare,
                    request_deserializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareRequest.FromString,
                    response_serializer=cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'cs3.sharing.ocm.v1beta1.OcmAPI', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class OcmAPI(object):
    """OCM Share Provider API

    The OCM Share Provider API is meant to manipulate share
    resources from the perspective of the creator or the share and
    from the perspective of the receiver of the share.

    The following APIs match the OCM v1.1 spec including multi-protocol shares.

    The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL
    NOT", "SHOULD", "SHOULD NOT", "RECOMMENDED",  "MAY", and
    "OPTIONAL" in this document are to be interpreted as described in
    RFC 2119.

    The following are global requirements that apply to all methods:
    Any method MUST return CODE_OK on a succesful operation.
    Any method MAY return NOT_IMPLEMENTED.
    Any method MAY return INTERNAL.
    Any method MAY return UNKNOWN.
    Any method MAY return UNAUTHENTICATED.
    """

    @staticmethod
    def CreateOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/CreateOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.CreateOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RemoveOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/RemoveOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.RemoveOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/GetOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetOCMShareByToken(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/GetOCMShareByToken',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetOCMShareByTokenResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListOCMShares(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/ListOCMShares',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListOCMSharesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/UpdateOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListReceivedOCMShares(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/ListReceivedOCMShares',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.ListReceivedOCMSharesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateReceivedOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/UpdateReceivedOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.UpdateReceivedOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetReceivedOCMShare(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/cs3.sharing.ocm.v1beta1.OcmAPI/GetReceivedOCMShare',
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareRequest.SerializeToString,
            cs3_dot_sharing_dot_ocm_dot_v1beta1_dot_ocm__api__pb2.GetReceivedOCMShareResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
