/*
 * Decompiled with CFR 0.152.
 */
package spec;

import config.Config;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CertoraFileCache;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lspec/CVLSource;", "", "()V", "isImported", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "origpath", "getOrigpath", "getReader", "Ljava/io/Reader;", "File", "Raw", "Lspec/CVLSource$File;", "Lspec/CVLSource$Raw;", "Shared"})
public abstract class CVLSource {
    private CVLSource() {
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getOrigpath();

    @NotNull
    public abstract Reader getReader();

    public abstract boolean isImported();

    public /* synthetic */ CVLSource(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001a"}, d2={"Lspec/CVLSource$File;", "Lspec/CVLSource;", "filepath", "", "origpath", "isImported", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getFilepath", "()Ljava/lang/String;", "()Z", "name", "getName", "getOrigpath", "component1", "component2", "component3", "copy", "equals", "other", "", "getReader", "Ljava/io/Reader;", "hashCode", "", "toString", "Shared"})
    public static final class File
    extends CVLSource {
        @NotNull
        private final String filepath;
        @NotNull
        private final String origpath;
        private final boolean isImported;

        public File(@NotNull String filepath, @NotNull String origpath, boolean isImported) {
            Intrinsics.checkNotNullParameter(filepath, "filepath");
            Intrinsics.checkNotNullParameter(origpath, "origpath");
            super(null);
            this.filepath = filepath;
            this.origpath = origpath;
            this.isImported = isImported;
        }

        @NotNull
        public final String getFilepath() {
            return this.filepath;
        }

        @Override
        @NotNull
        public String getOrigpath() {
            return this.origpath;
        }

        @Override
        public boolean isImported() {
            return this.isImported;
        }

        @Override
        @NotNull
        public String getName() {
            return this.filepath;
        }

        @Override
        @NotNull
        public Reader getReader() {
            Reader reader;
            try {
                String path = Config.INSTANCE.prependSourcesDir(this.filepath);
                reader = CertoraFileCache.INSTANCE.getContentReader(path);
            }
            catch (Exception e) {
                Logger.Companion.alwaysError("Could not access content of " + this.getOrigpath(), e);
                throw e;
            }
            return reader;
        }

        @NotNull
        public final String component1() {
            return this.filepath;
        }

        @NotNull
        public final String component2() {
            return this.origpath;
        }

        public final boolean component3() {
            return this.isImported;
        }

        @NotNull
        public final File copy(@NotNull String filepath, @NotNull String origpath, boolean isImported) {
            Intrinsics.checkNotNullParameter(filepath, "filepath");
            Intrinsics.checkNotNullParameter(origpath, "origpath");
            return new File(filepath, origpath, isImported);
        }

        public static /* synthetic */ File copy$default(File file, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = file.filepath;
            }
            if ((n & 2) != 0) {
                string2 = file.origpath;
            }
            if ((n & 4) != 0) {
                bl = file.isImported;
            }
            return file.copy(string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "File(filepath=" + this.filepath + ", origpath=" + this.origpath + ", isImported=" + this.isImported + ")";
        }

        public int hashCode() {
            int result2 = this.filepath.hashCode();
            result2 = result2 * 31 + this.origpath.hashCode();
            int n = this.isImported ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof File)) {
                return false;
            }
            File file = (File)other;
            if (!Intrinsics.areEqual(this.filepath, file.filepath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.origpath, file.origpath)) {
                return false;
            }
            return this.isImported == file.isImported;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lspec/CVLSource$Raw;", "Lspec/CVLSource;", "name", "", "rawTxt", "isImported", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "()Z", "getName", "()Ljava/lang/String;", "origpath", "getOrigpath", "getRawTxt", "component1", "component2", "component3", "copy", "equals", "other", "", "getReader", "Ljava/io/Reader;", "hashCode", "", "toString", "Shared"})
    public static final class Raw
    extends CVLSource {
        @NotNull
        private final String name;
        @NotNull
        private final String rawTxt;
        private final boolean isImported;

        public Raw(@NotNull String name, @NotNull String rawTxt, boolean isImported) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(rawTxt, "rawTxt");
            super(null);
            this.name = name;
            this.rawTxt = rawTxt;
            this.isImported = isImported;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getRawTxt() {
            return this.rawTxt;
        }

        @Override
        public boolean isImported() {
            return this.isImported;
        }

        @Override
        @NotNull
        public String getOrigpath() {
            return this.getName();
        }

        @Override
        @NotNull
        public Reader getReader() {
            return new StringReader(this.rawTxt);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.rawTxt;
        }

        public final boolean component3() {
            return this.isImported;
        }

        @NotNull
        public final Raw copy(@NotNull String name, @NotNull String rawTxt, boolean isImported) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(rawTxt, "rawTxt");
            return new Raw(name, rawTxt, isImported);
        }

        public static /* synthetic */ Raw copy$default(Raw raw, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = raw.name;
            }
            if ((n & 2) != 0) {
                string2 = raw.rawTxt;
            }
            if ((n & 4) != 0) {
                bl = raw.isImported;
            }
            return raw.copy(string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "Raw(name=" + this.name + ", rawTxt=" + this.rawTxt + ", isImported=" + this.isImported + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.rawTxt.hashCode();
            int n = this.isImported ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Raw)) {
                return false;
            }
            Raw raw = (Raw)other;
            if (!Intrinsics.areEqual(this.name, raw.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rawTxt, raw.rawTxt)) {
                return false;
            }
            return this.isImported == raw.isImported;
        }
    }
}

