/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonClassDiscriminator;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a*\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a%\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001aE\u0010\u0019\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0014*\u00020\u001a2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00140\f2\u0006\u0010\u001b\u001a\u0002H\u00142\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001dH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"checkKind", "", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "throwSerializerNotFound", "", "type", "", "jsonTree", "Lkotlinx/serialization/json/JsonObject;", "validateIfSealed", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "actualSerializer", "", "classDiscriminator", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lkotlinx/serialization/json/Json;", "decodeSerializableValuePolymorphic", "T", "Lkotlinx/serialization/json/JsonDecoder;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lkotlinx/serialization/json/JsonEncoder;", "value", "ifPolymorphic", "Lkotlin/Function1;", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nPolymorphic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 2 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,92:1\n247#2,7:93\n*S KotlinDebug\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n*L\n65#1:93,7\n*E\n"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value2, @NotNull Function1<? super String, Unit> ifPolymorphic) {
        Intrinsics.checkNotNullParameter($this$encodePolymorphically, "<this>");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, "ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically, value2);
            return;
        }
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer2;
        String baseClassDiscriminator = PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically.getJson());
        Encoder encoder2 = $this$encodePolymorphically;
        Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Any");
        SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, encoder2, value2);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, baseClassDiscriminator);
        PolymorphicKt.checkKind(actualSerializer.getDescriptor().getKind());
        ifPolymorphic.invoke(baseClassDiscriminator);
        actualSerializer.serialize($this$encodePolymorphically, value2);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer2, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<? extends T> deserializer) {
        void value$iv;
        Intrinsics.checkNotNullParameter($this$decodeSerializableValuePolymorphic, "<this>");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type2 = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? ((JsonPrimitive)jsonElement2).getContent() : null;
        DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull($this$decodeSerializableValuePolymorphic, type2);
        if (deserializationStrategy == null) {
            PolymorphicKt.throwSerializerNotFound(type2, jsonTree);
            throw new KotlinNothingValueException();
        }
        DeserializationStrategy actualSerializer = deserializationStrategy;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    @JvmName(name="throwSerializerNotFound")
    @NotNull
    public static final Void throwSerializerNotFound(@Nullable String type2, @NotNull JsonObject jsonTree) {
        Intrinsics.checkNotNullParameter(jsonTree, "jsonTree");
        String suffix = type2 == null ? "missing class discriminator ('null')" : "class discriminator '" + type2 + '\'';
        throw JsonExceptionsKt.JsonDecodingException(-1, "Polymorphic serializer was not found for " + suffix, jsonTree.toString());
    }

    @NotNull
    public static final String classDiscriminator(@NotNull SerialDescriptor $this$classDiscriminator, @NotNull Json json2) {
        Intrinsics.checkNotNullParameter($this$classDiscriminator, "<this>");
        Intrinsics.checkNotNullParameter(json2, "json");
        for (Annotation annotation : $this$classDiscriminator.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json2.getConfiguration().getClassDiscriminator();
    }
}

