/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import datastructures.stdcollections.ListsKt;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import parallel.EndOfLineParallel;
import parallel.FilteringFanOut;
import parallel.Parallel;
import parallel.RaceFinish;
import parallel.Sem;
import parallel.Thunk;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0016R\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lparallel/FinishingRaceJob;", "T", "Lparallel/EndOfLineParallel;", "", "job", "Lparallel/Thunk;", "id", "", "fanOut", "Lparallel/FilteringFanOut;", "(Lparallel/Thunk;ILparallel/FilteringFanOut;)V", "deps", "", "Lparallel/Parallel;", "getDeps", "()Ljava/util/List;", "getFanOut", "()Lparallel/FilteringFanOut;", "getId", "()I", "getJob", "()Lparallel/Thunk;", "lock", "Lparallel/Sem;", "getLock", "()Lparallel/Sem;", "result", "getResult", "()Lkotlin/Unit;", "Lkotlin/Unit;", "dbgPrnt", "msg", "", "sched", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
final class FinishingRaceJob<T>
extends EndOfLineParallel<Unit> {
    @NotNull
    private final Thunk<T> job;
    private final int id;
    @NotNull
    private final FilteringFanOut<T> fanOut;
    @NotNull
    private final Sem lock;
    @NotNull
    private final Unit result;

    public FinishingRaceJob(@NotNull Thunk<T> job, int id, @NotNull FilteringFanOut<T> fanOut2) {
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(fanOut2, "fanOut");
        this.job = job;
        this.id = id;
        this.fanOut = fanOut2;
        this.lock = this.fanOut.getLock();
        this.result = Unit.INSTANCE;
    }

    @NotNull
    public final Thunk<T> getJob() {
        return this.job;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final FilteringFanOut<T> getFanOut() {
        return this.fanOut;
    }

    @NotNull
    public final Sem getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbgPrnt(String msg) {
        Sem sem = this.lock;
        synchronized (sem) {
            boolean bl = false;
            System.out.println((Object)(this.lock + " " + this.id + " : " + msg + " (status: " + this.fanOut.getStatus() + " done: " + this.done()));
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return ListsKt.listOf();
    }

    @Override
    @NotNull
    public Unit getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sched(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        long startTimeMillis = System.currentTimeMillis();
        Sem sem = this.lock;
        synchronized (sem) {
            boolean bl = false;
            if (this.fanOut.getStatus() != 0) {
                if (!(this.fanOut.getStatus() != this.id)) {
                    boolean $i$a$-check-FinishingRaceJob$sched$1$32 = false;
                    String $i$a$-check-FinishingRaceJob$sched$1$32 = "this job is just starting; it can't have won the race";
                    throw new IllegalStateException($i$a$-check-FinishingRaceJob$sched$1$32.toString());
                }
                if (!(this.fanOut.getStatus() != -1 || this.fanOut.getExceptionThrown() != null)) {
                    boolean bl2 = false;
                    String string = "status indicates that all jobs have finished unsuccessfully and without throwing an exception, but this one is just starting";
                    throw new IllegalStateException(string.toString());
                }
                this.fanOut.registerSkipped(this.id);
                return;
            }
            if (this.fanOut.getStartTimeOfFirstThunk() == null) {
                this.fanOut.setStartTimeOfFirstThunk(System.currentTimeMillis());
            } else {
                long l = System.currentTimeMillis();
                Long l2 = this.fanOut.getStartTimeOfFirstThunk();
                Intrinsics.checkNotNull(l2);
                long elapsedTimeInRace = l - l2;
                if (this.job.getMaximumAllowedDelay() != null && this.job.getMaximumAllowedDelay().toMillis() > elapsedTimeInRace) {
                    this.fanOut.registerSkippedDelayed(this.id);
                    return;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        Ref.BooleanRef taskDone = new Ref.BooleanRef();
        Future<?> fut = ioPool.submit(() -> FinishingRaceJob.sched$lambda$6(this, taskDone));
        Sem sem2 = this.lock;
        synchronized (sem2) {
            boolean bl = false;
            boolean hitTimeout = false;
            while (this.fanOut.getStatus() == 0 && !taskDone.element && !hitTimeout) {
                if (this.job.getTimeout() != null) {
                    long timeRemaining = this.job.getTimeout().toMillis() - (System.currentTimeMillis() - startTimeMillis);
                    if (timeRemaining <= 0L) {
                        hitTimeout = true;
                        continue;
                    }
                    this.lock.wait(timeRemaining);
                    continue;
                }
                this.lock.wait();
            }
            if (!taskDone.element) {
                fut.cancel(true);
                if (hitTimeout) {
                    this.fanOut.registerTimeout(this.id);
                } else if (this.fanOut.getStatus() != this.id) {
                    this.fanOut.registerLostRace(this.id);
                } else {
                    throw new IllegalStateException(("RaceJob " + this.id + " won yet is not done").toString());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sched$lambda$6(FinishingRaceJob this$0, Ref.BooleanRef $taskDone) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($taskDone, "$taskDone");
        try {
            RaceFinish res2 = this$0.job.getThunk().invoke();
            Sem sem = this$0.lock;
            synchronized (sem) {
                boolean $i$a$-synchronized-FinishingRaceJob$sched$fut$1$32 = false;
                RaceFinish raceFinish = res2;
                if (raceFinish instanceof RaceFinish.DQF) {
                    this$0.fanOut.registerDqf(this$0.id, res2.getRes());
                } else if (raceFinish instanceof RaceFinish.Full) {
                    this$0.fanOut.registerFull(this$0.id, res2.getRes());
                }
                $taskDone.element = true;
                Unit $i$a$-synchronized-FinishingRaceJob$sched$fut$1$32 = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            Sem sem = this$0.lock;
            synchronized (sem) {
                boolean bl = false;
                this$0.fanOut.registerException(new IllegalStateException("thunk " + this$0.id + " in FinishingRaceJob threw an exception; thunks should catch their own exceptions", e));
                $taskDone.element = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

