#pragma once

#include <sasktran2/internal_common.h>

namespace sasktran2::math::unitsphere::lebedev {
    static double g_lebedev_xyzw_3890[4 * 3890] = {
        1.0, 0.0, 6.123233995736766e-17, 1.8073952522e-05,
        -1.0, 1.2246467991473532e-16, 6.123233995736766e-17, 1.8073952522e-05,
        6.123233995736766e-17, 1.0, 6.123233995736766e-17, 1.8073952522e-05,
        6.123233995736766e-17, -1.0, 6.123233995736766e-17, 1.8073952522e-05,
        0.0, 0.0, 1.0, 1.8073952522e-05,
        7.498798913309288e-33, 1.2246467991473532e-16, -1.0, 1.8073952522e-05,
        4.329780281177467e-17, 0.7071067811865476, 0.7071067811865475, 0.000284800878224,
        4.329780281177467e-17, 0.7071067811865476, -0.7071067811865475, 0.000284800878224,
        4.329780281177467e-17, -0.7071067811865476, 0.7071067811865475, 0.000284800878224,
        4.329780281177467e-17, -0.7071067811865476, -0.7071067811865475, 0.000284800878224,
        0.7071067811865476, 0.0, 0.7071067811865475, 0.000284800878224,
        0.7071067811865476, 0.0, -0.7071067811865475, 0.000284800878224,
        -0.7071067811865476, 8.659560562354934e-17, 0.7071067811865475, 0.000284800878224,
        -0.7071067811865476, 8.659560562354934e-17, -0.7071067811865475, 0.000284800878224,
        0.7071067811865476, 0.7071067811865475, 6.123233995736766e-17, 0.000284800878224,
        0.7071067811865476, -0.7071067811865475, 6.123233995736766e-17, 0.000284800878224,
        -0.7071067811865475, 0.7071067811865476, 6.123233995736766e-17, 0.000284800878224,
        -0.7071067811865475, -0.7071067811865476, 6.123233995736766e-17, 0.000284800878224,
        0.5773502691896258, 0.5773502691896257, 0.5773502691896257, 0.000283606583753,
        0.5773502691896258, 0.5773502691896257, -0.5773502691896257, 0.000283606583753,
        0.5773502691896258, -0.5773502691896257, 0.5773502691896257, 0.000283606583753,
        0.5773502691896258, -0.5773502691896257, -0.5773502691896257, 0.000283606583753,
        -0.5773502691896257, 0.5773502691896258, 0.5773502691896257, 0.000283606583753,
        -0.5773502691896257, 0.5773502691896258, -0.5773502691896257, 0.000283606583753,
        -0.5773502691896257, -0.5773502691896258, 0.5773502691896257, 0.000283606583753,
        -0.5773502691896257, -0.5773502691896258, -0.5773502691896257, 0.000283606583753,
        0.01587876419858454, 0.015878764198584538, 0.9997478330534413, 7.0131492667e-05,
        0.015878764198584423, 0.01587876419858442, -0.9997478330534413, 7.0131492667e-05,
        0.01587876419858454, -0.015878764198584538, 0.9997478330534413, 7.0131492667e-05,
        0.015878764198584423, -0.01587876419858442, -0.9997478330534413, 7.0131492667e-05,
        -0.015878764198584538, 0.01587876419858454, 0.9997478330534413, 7.0131492667e-05,
        -0.01587876419858442, 0.015878764198584423, -0.9997478330534413, 7.0131492667e-05,
        -0.015878764198584538, -0.01587876419858454, 0.9997478330534413, 7.0131492667e-05,
        -0.01587876419858442, -0.015878764198584423, -0.9997478330534413, 7.0131492667e-05,
        0.01587876419858326, 0.9997478330534413, 0.01587876419858333, 7.0131492667e-05,
        0.01587876419858326, -0.9997478330534413, 0.01587876419858333, 7.0131492667e-05,
        0.01587876419858326, 0.9997478330534413, -0.01587876419858343, 7.0131492667e-05,
        0.01587876419858326, -0.9997478330534413, -0.01587876419858343, 7.0131492667e-05,
        -0.015878764198583584, 0.9997478330534413, 0.01587876419858333, 7.0131492667e-05,
        -0.015878764198583584, -0.9997478330534413, 0.01587876419858333, 7.0131492667e-05,
        -0.015878764198583584, 0.9997478330534413, -0.01587876419858343, 7.0131492667e-05,
        -0.015878764198583584, -0.9997478330534413, -0.01587876419858343, 7.0131492667e-05,
        0.9997478330534413, 0.015878764198582463, 0.01587876419858333, 7.0131492667e-05,
        -0.9997478330534413, 0.015878764198582213, 0.01587876419858333, 7.0131492667e-05,
        0.9997478330534413, 0.015878764198582463, -0.01587876419858343, 7.0131492667e-05,
        -0.9997478330534413, 0.015878764198582213, -0.01587876419858343, 7.0131492667e-05,
        0.9997478330534413, -0.015878764198582463, 0.01587876419858333, 7.0131492667e-05,
        -0.9997478330534413, -0.015878764198582213, 0.01587876419858333, 7.0131492667e-05,
        0.9997478330534413, -0.015878764198582463, -0.01587876419858343, 7.0131492667e-05,
        -0.9997478330534413, -0.015878764198582213, -0.01587876419858343, 7.0131492667e-05,
        0.04069193593751184, 0.040691935937511844, 0.9983427931824393, 0.000116279802196,
        0.04069193593751169, 0.0406919359375117, -0.9983427931824393, 0.000116279802196,
        0.04069193593751184, -0.040691935937511844, 0.9983427931824393, 0.000116279802196,
        0.04069193593751169, -0.0406919359375117, -0.9983427931824393, 0.000116279802196,
        -0.04069193593751184, 0.040691935937511844, 0.9983427931824393, 0.000116279802196,
        -0.04069193593751169, 0.0406919359375117, -0.9983427931824393, 0.000116279802196,
        -0.04069193593751184, -0.040691935937511844, 0.9983427931824393, 0.000116279802196,
        -0.04069193593751169, -0.0406919359375117, -0.9983427931824393, 0.000116279802196,
        0.04069193593751214, 0.9983427931824393, 0.04069193593751212, 0.000116279802196,
        0.04069193593751214, -0.9983427931824393, 0.04069193593751212, 0.000116279802196,
        0.04069193593751214, 0.9983427931824393, -0.040691935937512, 0.000116279802196,
        0.04069193593751214, -0.9983427931824393, -0.040691935937512, 0.000116279802196,
        -0.040691935937512025, 0.9983427931824393, 0.04069193593751212, 0.000116279802196,
        -0.040691935937512025, -0.9983427931824393, 0.04069193593751212, 0.000116279802196,
        -0.040691935937512025, 0.9983427931824393, -0.040691935937512, 0.000116279802196,
        -0.040691935937512025, -0.9983427931824393, -0.040691935937512, 0.000116279802196,
        0.9983427931824392, 0.040691935937513635, 0.04069193593751212, 0.000116279802196,
        -0.9983427931824392, 0.04069193593751354, 0.04069193593751212, 0.000116279802196,
        0.9983427931824392, 0.040691935937513635, -0.040691935937512, 0.000116279802196,
        -0.9983427931824392, 0.04069193593751354, -0.040691935937512, 0.000116279802196,
        0.9983427931824392, -0.040691935937513635, 0.04069193593751212, 0.000116279802196,
        -0.9983427931824392, -0.04069193593751354, 0.04069193593751212, 0.000116279802196,
        0.9983427931824392, -0.040691935937513635, -0.040691935937512, 0.000116279802196,
        -0.9983427931824392, -0.04069193593751354, -0.040691935937512, 0.000116279802196,
        0.07025888115257996, 0.07025888115257994, 0.9950514455234841, 0.000151872858397,
        0.07025888115257992, 0.0702588811525799, -0.9950514455234841, 0.000151872858397,
        0.07025888115257996, -0.07025888115257994, 0.9950514455234841, 0.000151872858397,
        0.07025888115257992, -0.0702588811525799, -0.9950514455234841, 0.000151872858397,
        -0.07025888115257994, 0.07025888115257996, 0.9950514455234841, 0.000151872858397,
        -0.0702588811525799, 0.07025888115257992, -0.9950514455234841, 0.000151872858397,
        -0.07025888115257994, -0.07025888115257996, 0.9950514455234841, 0.000151872858397,
        -0.0702588811525799, -0.07025888115257992, -0.9950514455234841, 0.000151872858397,
        0.07025888115257993, 0.9950514455234841, 0.07025888115258, 0.000151872858397,
        0.07025888115257993, -0.9950514455234841, 0.07025888115258, 0.000151872858397,
        0.07025888115257993, 0.9950514455234841, -0.07025888115257989, 0.000151872858397,
        0.07025888115257993, -0.9950514455234841, -0.07025888115257989, 0.000151872858397,
        -0.07025888115258003, 0.9950514455234841, 0.07025888115258, 0.000151872858397,
        -0.07025888115258003, -0.9950514455234841, 0.07025888115258, 0.000151872858397,
        -0.07025888115258003, 0.9950514455234841, -0.07025888115257989, 0.000151872858397,
        -0.07025888115258003, -0.9950514455234841, -0.07025888115257989, 0.000151872858397,
        0.9950514455234841, 0.07025888115258021, 0.07025888115258, 0.000151872858397,
        -0.9950514455234841, 0.07025888115258022, 0.07025888115258, 0.000151872858397,
        0.9950514455234841, 0.07025888115258021, -0.07025888115257989, 0.000151872858397,
        -0.9950514455234841, 0.07025888115258022, -0.07025888115257989, 0.000151872858397,
        0.9950514455234841, -0.07025888115258021, 0.07025888115258, 0.000151872858397,
        -0.9950514455234841, -0.07025888115258022, 0.07025888115258, 0.000151872858397,
        0.9950514455234841, -0.07025888115258021, -0.07025888115257989, 0.000151872858397,
        -0.9950514455234841, -0.07025888115258022, -0.07025888115257989, 0.000151872858397,
        0.10274954500287069, 0.1027495450028707, 0.9893862046761144, 0.000179879610822,
        0.10274954500287026, 0.10274954500287027, -0.9893862046761145, 0.000179879610822,
        0.10274954500287069, -0.1027495450028707, 0.9893862046761144, 0.000179879610822,
        0.10274954500287026, -0.10274954500287027, -0.9893862046761145, 0.000179879610822,
        -0.10274954500287069, 0.1027495450028707, 0.9893862046761144, 0.000179879610822,
        -0.10274954500287026, 0.10274954500287027, -0.9893862046761145, 0.000179879610822,
        -0.10274954500287069, -0.1027495450028707, 0.9893862046761144, 0.000179879610822,
        -0.10274954500287026, -0.10274954500287027, -0.9893862046761145, 0.000179879610822,
        0.10274954500287041, 0.9893862046761145, 0.10274954500287031, 0.000179879610822,
        0.10274954500287041, -0.9893862046761145, 0.10274954500287031, 0.000179879610822,
        0.10274954500287041, 0.9893862046761145, -0.10274954500287041, 0.000179879610822,
        0.10274954500287041, -0.9893862046761145, -0.10274954500287041, 0.000179879610822,
        -0.10274954500287051, 0.9893862046761145, 0.10274954500287031, 0.000179879610822,
        -0.10274954500287051, -0.9893862046761145, 0.10274954500287031, 0.000179879610822,
        -0.10274954500287051, 0.9893862046761145, -0.10274954500287041, 0.000179879610822,
        -0.10274954500287051, -0.9893862046761145, -0.10274954500287041, 0.000179879610822,
        0.9893862046761145, 0.1027495450028703, 0.10274954500287031, 0.000179879610822,
        -0.9893862046761145, 0.10274954500287047, 0.10274954500287031, 0.000179879610822,
        0.9893862046761145, 0.1027495450028703, -0.10274954500287041, 0.000179879610822,
        -0.9893862046761145, 0.10274954500287047, -0.10274954500287041, 0.000179879610822,
        0.9893862046761145, -0.1027495450028703, 0.10274954500287031, 0.000179879610822,
        -0.9893862046761145, -0.10274954500287047, 0.10274954500287031, 0.000179879610822,
        0.9893862046761145, -0.1027495450028703, -0.10274954500287041, 0.000179879610822,
        -0.9893862046761145, -0.10274954500287047, -0.10274954500287041, 0.000179879610822,
        0.13714577308934253, 0.1371457730893425, 0.9810107409439782, 0.000202259338597,
        0.13714577308934245, 0.13714577308934242, -0.9810107409439782, 0.000202259338597,
        0.13714577308934253, -0.1371457730893425, 0.9810107409439782, 0.000202259338597,
        0.13714577308934245, -0.13714577308934242, -0.9810107409439782, 0.000202259338597,
        -0.1371457730893425, 0.13714577308934253, 0.9810107409439782, 0.000202259338597,
        -0.13714577308934242, 0.13714577308934245, -0.9810107409439782, 0.000202259338597,
        -0.1371457730893425, -0.13714577308934253, 0.9810107409439782, 0.000202259338597,
        -0.13714577308934242, -0.13714577308934245, -0.9810107409439782, 0.000202259338597,
        0.13714577308934256, 0.9810107409439782, 0.1371457730893427, 0.000202259338597,
        0.13714577308934256, -0.9810107409439782, 0.1371457730893427, 0.000202259338597,
        0.13714577308934256, 0.9810107409439782, -0.1371457730893428, 0.000202259338597,
        0.13714577308934256, -0.9810107409439782, -0.1371457730893428, 0.000202259338597,
        -0.13714577308934264, 0.9810107409439782, 0.1371457730893427, 0.000202259338597,
        -0.13714577308934264, -0.9810107409439782, 0.1371457730893427, 0.000202259338597,
        -0.13714577308934264, 0.9810107409439782, -0.1371457730893428, 0.000202259338597,
        -0.13714577308934264, -0.9810107409439782, -0.1371457730893428, 0.000202259338597,
        0.9810107409439782, 0.13714577308934228, 0.1371457730893427, 0.000202259338597,
        -0.9810107409439782, 0.1371457730893424, 0.1371457730893427, 0.000202259338597,
        0.9810107409439782, 0.13714577308934228, -0.1371457730893428, 0.000202259338597,
        -0.9810107409439782, 0.1371457730893424, -0.1371457730893428, 0.000202259338597,
        0.9810107409439782, -0.13714577308934228, 0.1371457730893427, 0.000202259338597,
        -0.9810107409439782, -0.1371457730893424, 0.1371457730893427, 0.000202259338597,
        0.9810107409439782, -0.13714577308934228, -0.1371457730893428, 0.000202259338597,
        -0.9810107409439782, -0.1371457730893424, -0.1371457730893428, 0.000202259338597,
        0.17277585326719522, 0.1727758532671952, 0.9696891301110812, 0.000220309310558,
        0.17277585326719516, 0.17277585326719513, -0.9696891301110812, 0.000220309310558,
        0.17277585326719522, -0.1727758532671952, 0.9696891301110812, 0.000220309310558,
        0.17277585326719516, -0.17277585326719513, -0.9696891301110812, 0.000220309310558,
        -0.1727758532671952, 0.17277585326719522, 0.9696891301110812, 0.000220309310558,
        -0.17277585326719513, 0.17277585326719516, -0.9696891301110812, 0.000220309310558,
        -0.1727758532671952, -0.17277585326719522, 0.9696891301110812, 0.000220309310558,
        -0.17277585326719513, -0.17277585326719516, -0.9696891301110812, 0.000220309310558,
        0.17277585326719538, 0.9696891301110812, 0.1727758532671951, 0.000220309310558,
        0.17277585326719538, -0.9696891301110812, 0.1727758532671951, 0.000220309310558,
        0.17277585326719538, 0.969689130111081, -0.1727758532671954, 0.000220309310558,
        0.17277585326719538, -0.969689130111081, -0.1727758532671954, 0.000220309310558,
        -0.17277585326719527, 0.9696891301110813, 0.1727758532671951, 0.000220309310558,
        -0.17277585326719527, -0.9696891301110813, 0.1727758532671951, 0.000220309310558,
        -0.17277585326719525, 0.9696891301110812, -0.1727758532671954, 0.000220309310558,
        -0.17277585326719525, -0.9696891301110812, -0.1727758532671954, 0.000220309310558,
        0.9696891301110813, 0.172775853267195, 0.1727758532671951, 0.000220309310558,
        -0.9696891301110813, 0.17277585326719502, 0.1727758532671951, 0.000220309310558,
        0.9696891301110812, 0.17277585326719497, -0.1727758532671954, 0.000220309310558,
        -0.9696891301110812, 0.172775853267195, -0.1727758532671954, 0.000220309310558,
        0.9696891301110813, -0.172775853267195, 0.1727758532671951, 0.000220309310558,
        -0.9696891301110813, -0.17277585326719502, 0.1727758532671951, 0.000220309310558,
        0.9696891301110812, -0.17277585326719497, -0.1727758532671954, 0.000220309310558,
        -0.9696891301110812, -0.172775853267195, -0.1727758532671954, 0.000220309310558,
        0.20914920389290373, 0.2091492038929037, 0.9552555789012327, 0.00023492942343,
        0.20914920389290356, 0.20914920389290353, -0.9552555789012328, 0.00023492942343,
        0.20914920389290373, -0.2091492038929037, 0.9552555789012327, 0.00023492942343,
        0.20914920389290356, -0.20914920389290353, -0.9552555789012328, 0.00023492942343,
        -0.2091492038929037, 0.20914920389290373, 0.9552555789012327, 0.00023492942343,
        -0.20914920389290353, 0.20914920389290356, -0.9552555789012328, 0.00023492942343,
        -0.2091492038929037, -0.20914920389290373, 0.9552555789012327, 0.00023492942343,
        -0.20914920389290353, -0.20914920389290356, -0.9552555789012328, 0.00023492942343,
        0.20914920389290378, 0.9552555789012326, 0.2091492038929037, 0.00023492942343,
        0.20914920389290378, -0.9552555789012326, 0.2091492038929037, 0.00023492942343,
        0.20914920389290378, 0.9552555789012326, -0.20914920389290378, 0.00023492942343,
        0.20914920389290378, -0.9552555789012326, -0.20914920389290378, 0.00023492942343,
        -0.20914920389290365, 0.9552555789012326, 0.2091492038929037, 0.00023492942343,
        -0.20914920389290365, -0.9552555789012326, 0.2091492038929037, 0.00023492942343,
        -0.20914920389290365, 0.9552555789012326, -0.20914920389290378, 0.00023492942343,
        -0.20914920389290365, -0.9552555789012326, -0.20914920389290378, 0.00023492942343,
        0.9552555789012327, 0.20914920389290323, 0.2091492038929037, 0.00023492942343,
        -0.9552555789012327, 0.2091492038929032, 0.2091492038929037, 0.00023492942343,
        0.9552555789012327, 0.20914920389290323, -0.20914920389290378, 0.00023492942343,
        -0.9552555789012327, 0.2091492038929032, -0.20914920389290378, 0.00023492942343,
        0.9552555789012327, -0.20914920389290323, 0.2091492038929037, 0.00023492942343,
        -0.9552555789012327, -0.2091492038929032, 0.2091492038929037, 0.00023492942343,
        0.9552555789012327, -0.20914920389290323, -0.20914920389290378, 0.00023492942343,
        -0.9552555789012327, -0.2091492038929032, -0.20914920389290378, 0.00023492942343,
        0.24588132817519154, 0.2458813281751916, 0.9375951924522691, 0.000246768205875,
        0.2458813281751913, 0.24588132817519132, -0.9375951924522692, 0.000246768205875,
        0.24588132817519154, -0.2458813281751916, 0.9375951924522691, 0.000246768205875,
        0.2458813281751913, -0.24588132817519132, -0.9375951924522692, 0.000246768205875,
        -0.24588132817519154, 0.2458813281751916, 0.9375951924522691, 0.000246768205875,
        -0.2458813281751913, 0.24588132817519132, -0.9375951924522692, 0.000246768205875,
        -0.24588132817519154, -0.2458813281751916, 0.9375951924522691, 0.000246768205875,
        -0.2458813281751913, -0.24588132817519132, -0.9375951924522692, 0.000246768205875,
        0.2458813281751915, 0.9375951924522692, 0.24588132817519148, 0.000246768205875,
        0.2458813281751915, -0.9375951924522692, 0.24588132817519148, 0.000246768205875,
        0.24588132817519148, 0.9375951924522691, -0.24588132817519157, 0.000246768205875,
        0.24588132817519148, -0.9375951924522691, -0.24588132817519157, 0.000246768205875,
        -0.24588132817519182, 0.9375951924522691, 0.24588132817519148, 0.000246768205875,
        -0.24588132817519182, -0.9375951924522691, 0.24588132817519148, 0.000246768205875,
        -0.2458813281751918, 0.937595192452269, -0.24588132817519157, 0.000246768205875,
        -0.2458813281751918, -0.937595192452269, -0.24588132817519157, 0.000246768205875,
        0.9375951924522692, 0.2458813281751915, 0.24588132817519148, 0.000246768205875,
        -0.9375951924522692, 0.24588132817519157, 0.24588132817519148, 0.000246768205875,
        0.9375951924522691, 0.24588132817519148, -0.24588132817519157, 0.000246768205875,
        -0.9375951924522691, 0.24588132817519154, -0.24588132817519157, 0.000246768205875,
        0.9375951924522692, -0.2458813281751915, 0.24588132817519148, 0.000246768205875,
        -0.9375951924522692, -0.24588132817519157, 0.24588132817519148, 0.000246768205875,
        0.9375951924522691, -0.24588132817519148, -0.24588132817519157, 0.000246768205875,
        -0.9375951924522691, -0.24588132817519154, -0.24588132817519157, 0.000246768205875,
        0.28265458594500653, 0.2826545859450066, 0.9166312072412295, 0.000256309268357,
        0.2826545859450064, 0.2826545859450065, -0.9166312072412296, 0.000256309268357,
        0.28265458594500653, -0.2826545859450066, 0.9166312072412295, 0.000256309268357,
        0.2826545859450064, -0.2826545859450065, -0.9166312072412296, 0.000256309268357,
        -0.28265458594500653, 0.2826545859450066, 0.9166312072412295, 0.000256309268357,
        -0.2826545859450064, 0.2826545859450065, -0.9166312072412296, 0.000256309268357,
        -0.28265458594500653, -0.2826545859450066, 0.9166312072412295, 0.000256309268357,
        -0.2826545859450064, -0.2826545859450065, -0.9166312072412296, 0.000256309268357,
        0.28265458594500664, 0.9166312072412295, 0.2826545859450066, 0.000256309268357,
        0.28265458594500664, -0.9166312072412295, 0.2826545859450066, 0.000256309268357,
        0.28265458594500664, 0.9166312072412295, -0.2826545859450067, 0.000256309268357,
        0.28265458594500664, -0.9166312072412295, -0.2826545859450067, 0.000256309268357,
        -0.28265458594500653, 0.9166312072412295, 0.2826545859450066, 0.000256309268357,
        -0.28265458594500653, -0.9166312072412295, 0.2826545859450066, 0.000256309268357,
        -0.28265458594500653, 0.9166312072412295, -0.2826545859450067, 0.000256309268357,
        -0.28265458594500653, -0.9166312072412295, -0.2826545859450067, 0.000256309268357,
        0.9166312072412295, 0.2826545859450067, 0.2826545859450066, 0.000256309268357,
        -0.9166312072412296, 0.2826545859450063, 0.2826545859450066, 0.000256309268357,
        0.9166312072412295, 0.2826545859450067, -0.2826545859450067, 0.000256309268357,
        -0.9166312072412296, 0.2826545859450063, -0.2826545859450067, 0.000256309268357,
        0.9166312072412295, -0.2826545859450067, 0.2826545859450066, 0.000256309268357,
        -0.9166312072412296, -0.2826545859450063, 0.2826545859450066, 0.000256309268357,
        0.9166312072412295, -0.2826545859450067, -0.2826545859450067, 0.000256309268357,
        -0.9166312072412296, -0.2826545859450063, -0.2826545859450067, 0.000256309268357,
        0.31919572917996214, 0.3191957291799621, 0.8923161844024485, 0.000263925389676,
        0.3191957291799621, 0.31919572917996203, -0.8923161844024486, 0.000263925389676,
        0.31919572917996214, -0.3191957291799621, 0.8923161844024485, 0.000263925389676,
        0.3191957291799621, -0.31919572917996203, -0.8923161844024486, 0.000263925389676,
        -0.3191957291799621, 0.31919572917996214, 0.8923161844024485, 0.000263925389676,
        -0.31919572917996203, 0.3191957291799621, -0.8923161844024486, 0.000263925389676,
        -0.3191957291799621, -0.31919572917996214, 0.8923161844024485, 0.000263925389676,
        -0.31919572917996203, -0.3191957291799621, -0.8923161844024486, 0.000263925389676,
        0.31919572917996225, 0.8923161844024485, 0.31919572917996225, 0.000263925389676,
        0.31919572917996225, -0.8923161844024485, 0.31919572917996225, 0.000263925389676,
        0.3191957291799622, 0.8923161844024484, -0.3191957291799623, 0.000263925389676,
        0.3191957291799622, -0.8923161844024484, -0.3191957291799623, 0.000263925389676,
        -0.3191957291799621, 0.8923161844024485, 0.31919572917996225, 0.000263925389676,
        -0.3191957291799621, -0.8923161844024485, 0.31919572917996225, 0.000263925389676,
        -0.31919572917996203, 0.8923161844024484, -0.3191957291799623, 0.000263925389676,
        -0.31919572917996203, -0.8923161844024484, -0.3191957291799623, 0.000263925389676,
        0.8923161844024485, 0.3191957291799622, 0.31919572917996225, 0.000263925389676,
        -0.8923161844024485, 0.31919572917996225, 0.31919572917996225, 0.000263925389676,
        0.8923161844024484, 0.31919572917996214, -0.3191957291799623, 0.000263925389676,
        -0.8923161844024484, 0.31919572917996225, -0.3191957291799623, 0.000263925389676,
        0.8923161844024485, -0.3191957291799622, 0.31919572917996225, 0.000263925389676,
        -0.8923161844024485, -0.31919572917996225, 0.31919572917996225, 0.000263925389676,
        0.8923161844024484, -0.31919572917996214, -0.3191957291799623, 0.000263925389676,
        -0.8923161844024484, -0.31919572917996225, -0.3191957291799623, 0.000263925389676,
        0.3552621469299578, 0.35526214692995783, 0.8646257074118454, 0.000269913747927,
        0.3552621469299578, 0.35526214692995783, -0.8646257074118454, 0.000269913747927,
        0.3552621469299578, -0.35526214692995783, 0.8646257074118454, 0.000269913747927,
        0.3552621469299578, -0.35526214692995783, -0.8646257074118454, 0.000269913747927,
        -0.3552621469299578, 0.35526214692995783, 0.8646257074118454, 0.000269913747927,
        -0.3552621469299578, 0.35526214692995783, -0.8646257074118454, 0.000269913747927,
        -0.3552621469299578, -0.35526214692995783, 0.8646257074118454, 0.000269913747927,
        -0.3552621469299578, -0.35526214692995783, -0.8646257074118454, 0.000269913747927,
        0.35526214692995794, 0.8646257074118453, 0.3552621469299579, 0.000269913747927,
        0.35526214692995794, -0.8646257074118453, 0.3552621469299579, 0.000269913747927,
        0.35526214692995794, 0.8646257074118453, -0.3552621469299577, 0.000269913747927,
        0.35526214692995794, -0.8646257074118453, -0.3552621469299577, 0.000269913747927,
        -0.355262146929958, 0.8646257074118453, 0.3552621469299579, 0.000269913747927,
        -0.355262146929958, -0.8646257074118453, 0.3552621469299579, 0.000269913747927,
        -0.355262146929958, 0.8646257074118453, -0.3552621469299577, 0.000269913747927,
        -0.355262146929958, -0.8646257074118453, -0.3552621469299577, 0.000269913747927,
        0.8646257074118455, 0.3552621469299575, 0.3552621469299579, 0.000269913747927,
        -0.8646257074118456, 0.3552621469299572, 0.3552621469299579, 0.000269913747927,
        0.8646257074118455, 0.3552621469299575, -0.3552621469299577, 0.000269913747927,
        -0.8646257074118456, 0.3552621469299572, -0.3552621469299577, 0.000269913747927,
        0.8646257074118455, -0.3552621469299575, 0.3552621469299579, 0.000269913747927,
        -0.8646257074118456, -0.3552621469299572, 0.3552621469299579, 0.000269913747927,
        0.8646257074118455, -0.3552621469299575, -0.3552621469299577, 0.000269913747927,
        -0.8646257074118456, -0.3552621469299572, -0.3552621469299577, 0.000269913747927,
        0.390632950340623, 0.39063295034062295, 0.8335537152555681, 0.000274519642017,
        0.390632950340623, 0.39063295034062295, -0.8335537152555681, 0.000274519642017,
        0.390632950340623, -0.39063295034062295, 0.8335537152555681, 0.000274519642017,
        0.390632950340623, -0.39063295034062295, -0.8335537152555681, 0.000274519642017,
        -0.39063295034062295, 0.390632950340623, 0.8335537152555681, 0.000274519642017,
        -0.39063295034062295, 0.390632950340623, -0.8335537152555681, 0.000274519642017,
        -0.39063295034062295, -0.390632950340623, 0.8335537152555681, 0.000274519642017,
        -0.39063295034062295, -0.390632950340623, -0.8335537152555681, 0.000274519642017,
        0.39063295034062306, 0.8335537152555681, 0.3906329503406229, 0.000274519642017,
        0.39063295034062306, -0.8335537152555681, 0.3906329503406229, 0.000274519642017,
        0.390632950340623, 0.833553715255568, -0.39063295034062323, 0.000274519642017,
        0.390632950340623, -0.833553715255568, -0.39063295034062323, 0.000274519642017,
        -0.39063295034062295, 0.8335537152555682, 0.3906329503406229, 0.000274519642017,
        -0.39063295034062295, -0.8335537152555682, 0.3906329503406229, 0.000274519642017,
        -0.3906329503406229, 0.8335537152555681, -0.39063295034062323, 0.000274519642017,
        -0.3906329503406229, -0.8335537152555681, -0.39063295034062323, 0.000274519642017,
        0.8335537152555682, 0.39063295034062295, 0.3906329503406229, 0.000274519642017,
        -0.8335537152555681, 0.3906329503406231, 0.3906329503406229, 0.000274519642017,
        0.8335537152555681, 0.3906329503406229, -0.39063295034062323, 0.000274519642017,
        -0.833553715255568, 0.39063295034062306, -0.39063295034062323, 0.000274519642017,
        0.8335537152555682, -0.39063295034062295, 0.3906329503406229, 0.000274519642017,
        -0.8335537152555681, -0.3906329503406231, 0.3906329503406229, 0.000274519642017,
        0.8335537152555681, -0.3906329503406229, -0.39063295034062323, 0.000274519642017,
        -0.833553715255568, -0.39063295034062306, -0.39063295034062323, 0.000274519642017,
        0.4251028614093031, 0.42510286140930303, 0.7991089502960442, 0.00027795291974,
        0.4251028614093028, 0.42510286140930276, -0.7991089502960446, 0.00027795291974,
        0.4251028614093031, -0.42510286140930303, 0.7991089502960442, 0.00027795291974,
        0.4251028614093028, -0.42510286140930276, -0.7991089502960446, 0.00027795291974,
        -0.42510286140930303, 0.4251028614093031, 0.7991089502960442, 0.00027795291974,
        -0.42510286140930276, 0.4251028614093028, -0.7991089502960446, 0.00027795291974,
        -0.42510286140930303, -0.4251028614093031, 0.7991089502960442, 0.00027795291974,
        -0.42510286140930276, -0.4251028614093028, -0.7991089502960446, 0.00027795291974,
        0.4251028614093031, 0.7991089502960443, 0.425102861409303, 0.00027795291974,
        0.4251028614093031, -0.7991089502960443, 0.425102861409303, 0.00027795291974,
        0.425102861409303, 0.7991089502960441, -0.4251028614093033, 0.00027795291974,
        0.425102861409303, -0.7991089502960441, -0.4251028614093033, 0.00027795291974,
        -0.4251028614093032, 0.7991089502960443, 0.425102861409303, 0.00027795291974,
        -0.4251028614093032, -0.7991089502960443, 0.425102861409303, 0.00027795291974,
        -0.4251028614093031, 0.7991089502960441, -0.4251028614093033, 0.00027795291974,
        -0.4251028614093031, -0.7991089502960441, -0.4251028614093033, 0.00027795291974,
        0.7991089502960443, 0.4251028614093031, 0.425102861409303, 0.00027795291974,
        -0.7991089502960445, 0.425102861409303, 0.425102861409303, 0.00027795291974,
        0.7991089502960441, 0.425102861409303, -0.4251028614093033, 0.00027795291974,
        -0.7991089502960442, 0.42510286140930287, -0.4251028614093033, 0.00027795291974,
        0.7991089502960443, -0.4251028614093031, 0.425102861409303, 0.00027795291974,
        -0.7991089502960445, -0.425102861409303, 0.425102861409303, 0.00027795291974,
        0.7991089502960441, -0.425102861409303, -0.4251028614093033, 0.00027795291974,
        -0.7991089502960442, -0.42510286140930287, -0.4251028614093033, 0.00027795291974,
        0.4584777520111871, 0.45847775201118707, 0.7613122236123212, 0.000280399608668,
        0.4584777520111872, 0.4584777520111871, -0.7613122236123211, 0.000280399608668,
        0.4584777520111871, -0.45847775201118707, 0.7613122236123212, 0.000280399608668,
        0.4584777520111872, -0.4584777520111871, -0.7613122236123211, 0.000280399608668,
        -0.45847775201118707, 0.4584777520111871, 0.7613122236123212, 0.000280399608668,
        -0.4584777520111871, 0.4584777520111872, -0.7613122236123211, 0.000280399608668,
        -0.45847775201118707, -0.4584777520111871, 0.7613122236123212, 0.000280399608668,
        -0.4584777520111871, -0.4584777520111872, -0.7613122236123211, 0.000280399608668,
        0.45847775201118696, 0.7613122236123213, 0.45847775201118696, 0.000280399608668,
        0.45847775201118696, -0.7613122236123213, 0.45847775201118696, 0.000280399608668,
        0.45847775201118696, 0.7613122236123213, -0.45847775201118685, 0.000280399608668,
        0.45847775201118696, -0.7613122236123213, -0.45847775201118685, 0.000280399608668,
        -0.45847775201118685, 0.7613122236123214, 0.45847775201118696, 0.000280399608668,
        -0.45847775201118685, -0.7613122236123214, 0.45847775201118696, 0.000280399608668,
        -0.45847775201118685, 0.7613122236123214, -0.45847775201118685, 0.000280399608668,
        -0.45847775201118685, -0.7613122236123214, -0.45847775201118685, 0.000280399608668,
        0.7613122236123213, 0.45847775201118707, 0.45847775201118696, 0.000280399608668,
        -0.7613122236123213, 0.45847775201118707, 0.45847775201118696, 0.000280399608668,
        0.7613122236123213, 0.45847775201118707, -0.45847775201118685, 0.000280399608668,
        -0.7613122236123213, 0.45847775201118707, -0.45847775201118685, 0.000280399608668,
        0.7613122236123213, -0.45847775201118707, 0.45847775201118696, 0.000280399608668,
        -0.7613122236123213, -0.45847775201118707, 0.45847775201118696, 0.000280399608668,
        0.7613122236123213, -0.45847775201118707, -0.45847775201118685, 0.000280399608668,
        -0.7613122236123213, -0.45847775201118707, -0.45847775201118685, 0.000280399608668,
        0.49057113587101936, 0.49057113587101925, 0.7201943635578077, 0.000282030235672,
        0.49057113587101925, 0.4905711358710192, -0.7201943635578079, 0.000282030235672,
        0.49057113587101936, -0.49057113587101925, 0.7201943635578077, 0.000282030235672,
        0.49057113587101925, -0.4905711358710192, -0.7201943635578079, 0.000282030235672,
        -0.49057113587101925, 0.49057113587101936, 0.7201943635578077, 0.000282030235672,
        -0.4905711358710192, 0.49057113587101925, -0.7201943635578079, 0.000282030235672,
        -0.49057113587101925, -0.49057113587101936, 0.7201943635578077, 0.000282030235672,
        -0.4905711358710192, -0.49057113587101925, -0.7201943635578079, 0.000282030235672,
        0.4905711358710192, 0.7201943635578077, 0.49057113587101936, 0.000282030235672,
        0.4905711358710192, -0.7201943635578077, 0.49057113587101936, 0.000282030235672,
        0.49057113587101925, 0.7201943635578079, -0.49057113587101925, 0.000282030235672,
        0.49057113587101925, -0.7201943635578079, -0.49057113587101925, 0.000282030235672,
        -0.4905711358710192, 0.7201943635578079, 0.49057113587101936, 0.000282030235672,
        -0.4905711358710192, -0.7201943635578079, 0.49057113587101936, 0.000282030235672,
        -0.49057113587101925, 0.720194363557808, -0.49057113587101925, 0.000282030235672,
        -0.49057113587101925, -0.720194363557808, -0.49057113587101925, 0.000282030235672,
        0.7201943635578077, 0.49057113587101925, 0.49057113587101936, 0.000282030235672,
        -0.7201943635578077, 0.49057113587101925, 0.49057113587101936, 0.000282030235672,
        0.7201943635578079, 0.4905711358710193, -0.49057113587101925, 0.000282030235672,
        -0.7201943635578079, 0.4905711358710193, -0.49057113587101925, 0.000282030235672,
        0.7201943635578077, -0.49057113587101925, 0.49057113587101936, 0.000282030235672,
        -0.7201943635578077, -0.49057113587101925, 0.49057113587101936, 0.000282030235672,
        0.7201943635578079, -0.4905711358710193, -0.49057113587101925, 0.000282030235672,
        -0.7201943635578079, -0.4905711358710193, -0.49057113587101925, 0.000282030235672,
        0.5212011669847385, 0.5212011669847384, 0.6757948557569031, 0.000283005674749,
        0.5212011669847386, 0.5212011669847385, -0.675794855756903, 0.000283005674749,
        0.5212011669847385, -0.5212011669847384, 0.6757948557569031, 0.000283005674749,
        0.5212011669847386, -0.5212011669847385, -0.675794855756903, 0.000283005674749,
        -0.5212011669847384, 0.5212011669847385, 0.6757948557569031, 0.000283005674749,
        -0.5212011669847385, 0.5212011669847386, -0.675794855756903, 0.000283005674749,
        -0.5212011669847384, -0.5212011669847385, 0.6757948557569031, 0.000283005674749,
        -0.5212011669847385, -0.5212011669847386, -0.675794855756903, 0.000283005674749,
        0.5212011669847384, 0.6757948557569031, 0.5212011669847385, 0.000283005674749,
        0.5212011669847384, -0.6757948557569031, 0.5212011669847385, 0.000283005674749,
        0.5212011669847385, 0.6757948557569032, -0.5212011669847384, 0.000283005674749,
        0.5212011669847385, -0.6757948557569032, -0.5212011669847384, 0.000283005674749,
        -0.5212011669847384, 0.6757948557569031, 0.5212011669847385, 0.000283005674749,
        -0.5212011669847384, -0.6757948557569031, 0.5212011669847385, 0.000283005674749,
        -0.5212011669847385, 0.6757948557569032, -0.5212011669847384, 0.000283005674749,
        -0.5212011669847385, -0.6757948557569032, -0.5212011669847384, 0.000283005674749,
        0.675794855756903, 0.5212011669847386, 0.5212011669847385, 0.000283005674749,
        -0.6757948557569032, 0.5212011669847383, 0.5212011669847385, 0.000283005674749,
        0.6757948557569031, 0.5212011669847387, -0.5212011669847384, 0.000283005674749,
        -0.6757948557569033, 0.5212011669847383, -0.5212011669847384, 0.000283005674749,
        0.675794855756903, -0.5212011669847386, 0.5212011669847385, 0.000283005674749,
        -0.6757948557569032, -0.5212011669847383, 0.5212011669847385, 0.000283005674749,
        0.6757948557569031, -0.5212011669847387, -0.5212011669847384, 0.000283005674749,
        -0.6757948557569033, -0.5212011669847383, -0.5212011669847384, 0.000283005674749,
        0.5501878488737995, 0.5501878488737995, 0.6281613342949742, 0.000283480895078,
        0.5501878488737995, 0.5501878488737995, -0.6281613342949742, 0.000283480895078,
        0.5501878488737995, -0.5501878488737995, 0.6281613342949742, 0.000283480895078,
        0.5501878488737995, -0.5501878488737995, -0.6281613342949742, 0.000283480895078,
        -0.5501878488737995, 0.5501878488737995, 0.6281613342949742, 0.000283480895078,
        -0.5501878488737995, 0.5501878488737995, -0.6281613342949742, 0.000283480895078,
        -0.5501878488737995, -0.5501878488737995, 0.6281613342949742, 0.000283480895078,
        -0.5501878488737995, -0.5501878488737995, -0.6281613342949742, 0.000283480895078,
        0.5501878488737995, 0.6281613342949743, 0.5501878488737995, 0.000283480895078,
        0.5501878488737995, -0.6281613342949743, 0.5501878488737995, 0.000283480895078,
        0.5501878488737995, 0.6281613342949742, -0.5501878488737996, 0.000283480895078,
        0.5501878488737995, -0.6281613342949742, -0.5501878488737996, 0.000283480895078,
        -0.5501878488737993, 0.6281613342949743, 0.5501878488737995, 0.000283480895078,
        -0.5501878488737993, -0.6281613342949743, 0.5501878488737995, 0.000283480895078,
        -0.5501878488737993, 0.6281613342949742, -0.5501878488737996, 0.000283480895078,
        -0.5501878488737993, -0.6281613342949742, -0.5501878488737996, 0.000283480895078,
        0.6281613342949743, 0.5501878488737995, 0.5501878488737995, 0.000283480895078,
        -0.6281613342949744, 0.5501878488737993, 0.5501878488737995, 0.000283480895078,
        0.6281613342949742, 0.5501878488737995, -0.5501878488737996, 0.000283480895078,
        -0.6281613342949744, 0.5501878488737992, -0.5501878488737996, 0.000283480895078,
        0.6281613342949743, -0.5501878488737995, 0.5501878488737995, 0.000283480895078,
        -0.6281613342949744, -0.5501878488737993, 0.5501878488737995, 0.000283480895078,
        0.6281613342949742, -0.5501878488737995, -0.5501878488737996, 0.000283480895078,
        -0.6281613342949744, -0.5501878488737992, -0.5501878488737996, 0.000283480895078,
        0.6025037877479342, 0.6025037877479341, 0.5234294331605592, 0.000283528233908,
        0.6025037877479343, 0.6025037877479342, -0.5234294331605591, 0.000283528233908,
        0.6025037877479342, -0.6025037877479341, 0.5234294331605592, 0.000283528233908,
        0.6025037877479343, -0.6025037877479342, -0.5234294331605591, 0.000283528233908,
        -0.6025037877479341, 0.6025037877479342, 0.5234294331605592, 0.000283528233908,
        -0.6025037877479342, 0.6025037877479343, -0.5234294331605591, 0.000283528233908,
        -0.6025037877479341, -0.6025037877479342, 0.5234294331605592, 0.000283528233908,
        -0.6025037877479342, -0.6025037877479343, -0.5234294331605591, 0.000283528233908,
        0.6025037877479341, 0.5234294331605593, 0.6025037877479342, 0.000283528233908,
        0.6025037877479341, -0.5234294331605593, 0.6025037877479342, 0.000283528233908,
        0.6025037877479342, 0.5234294331605596, -0.6025037877479341, 0.000283528233908,
        0.6025037877479342, -0.5234294331605596, -0.6025037877479341, 0.000283528233908,
        -0.602503787747934, 0.5234294331605593, 0.6025037877479342, 0.000283528233908,
        -0.602503787747934, -0.5234294331605593, 0.6025037877479342, 0.000283528233908,
        -0.6025037877479342, 0.5234294331605596, -0.6025037877479341, 0.000283528233908,
        -0.6025037877479342, -0.5234294331605596, -0.6025037877479341, 0.000283528233908,
        0.5234294331605593, 0.6025037877479341, 0.6025037877479342, 0.000283528233908,
        -0.5234294331605593, 0.6025037877479342, 0.6025037877479342, 0.000283528233908,
        0.5234294331605595, 0.6025037877479342, -0.6025037877479341, 0.000283528233908,
        -0.5234294331605595, 0.6025037877479343, -0.6025037877479341, 0.000283528233908,
        0.5234294331605593, -0.6025037877479341, 0.6025037877479342, 0.000283528233908,
        -0.5234294331605593, -0.6025037877479342, 0.6025037877479342, 0.000283528233908,
        0.5234294331605595, -0.6025037877479342, -0.6025037877479341, 0.000283528233908,
        -0.5234294331605595, -0.6025037877479343, -0.6025037877479341, 0.000283528233908,
        0.6254572689549016, 0.6254572689549015, 0.46648302158058413, 0.000283381926707,
        0.6254572689549017, 0.6254572689549016, -0.466483021580584, 0.000283381926707,
        0.6254572689549016, -0.6254572689549015, 0.46648302158058413, 0.000283381926707,
        0.6254572689549017, -0.6254572689549016, -0.466483021580584, 0.000283381926707,
        -0.6254572689549015, 0.6254572689549016, 0.46648302158058413, 0.000283381926707,
        -0.6254572689549016, 0.6254572689549017, -0.466483021580584, 0.000283381926707,
        -0.6254572689549015, -0.6254572689549016, 0.46648302158058413, 0.000283381926707,
        -0.6254572689549016, -0.6254572689549017, -0.466483021580584, 0.000283381926707,
        0.6254572689549015, 0.46648302158058425, 0.6254572689549016, 0.000283381926707,
        0.6254572689549015, -0.46648302158058425, 0.6254572689549016, 0.000283381926707,
        0.6254572689549015, 0.46648302158058425, -0.6254572689549016, 0.000283381926707,
        0.6254572689549015, -0.46648302158058425, -0.6254572689549016, 0.000283381926707,
        -0.6254572689549016, 0.46648302158058413, 0.6254572689549016, 0.000283381926707,
        -0.6254572689549016, -0.46648302158058413, 0.6254572689549016, 0.000283381926707,
        -0.6254572689549016, 0.46648302158058413, -0.6254572689549016, 0.000283381926707,
        -0.6254572689549016, -0.46648302158058413, -0.6254572689549016, 0.000283381926707,
        0.466483021580584, 0.6254572689549016, 0.6254572689549016, 0.000283381926707,
        -0.466483021580584, 0.6254572689549016, 0.6254572689549016, 0.000283381926707,
        0.466483021580584, 0.6254572689549016, -0.6254572689549016, 0.000283381926707,
        -0.466483021580584, 0.6254572689549016, -0.6254572689549016, 0.000283381926707,
        0.466483021580584, -0.6254572689549016, 0.6254572689549016, 0.000283381926707,
        -0.466483021580584, -0.6254572689549016, 0.6254572689549016, 0.000283381926707,
        0.466483021580584, -0.6254572689549016, -0.6254572689549016, 0.000283381926707,
        -0.466483021580584, -0.6254572689549016, -0.6254572689549016, 0.000283381926707,
        0.6460107179528249, 0.6460107179528248, 0.4066205904527604, 0.000283285833691,
        0.6460107179528249, 0.6460107179528248, -0.40662059045276044, 0.000283285833691,
        0.6460107179528249, -0.6460107179528248, 0.4066205904527604, 0.000283285833691,
        0.6460107179528249, -0.6460107179528248, -0.40662059045276044, 0.000283285833691,
        -0.6460107179528248, 0.6460107179528249, 0.4066205904527604, 0.000283285833691,
        -0.6460107179528248, 0.6460107179528249, -0.40662059045276044, 0.000283285833691,
        -0.6460107179528248, -0.6460107179528249, 0.4066205904527604, 0.000283285833691,
        -0.6460107179528248, -0.6460107179528249, -0.40662059045276044, 0.000283285833691,
        0.6460107179528248, 0.40662059045276067, 0.6460107179528248, 0.000283285833691,
        0.6460107179528248, -0.40662059045276067, 0.6460107179528248, 0.000283285833691,
        0.6460107179528249, 0.4066205904527607, -0.6460107179528247, 0.000283285833691,
        0.6460107179528249, -0.4066205904527607, -0.6460107179528247, 0.000283285833691,
        -0.6460107179528248, 0.40662059045276067, 0.6460107179528248, 0.000283285833691,
        -0.6460107179528248, -0.40662059045276067, 0.6460107179528248, 0.000283285833691,
        -0.6460107179528249, 0.4066205904527607, -0.6460107179528247, 0.000283285833691,
        -0.6460107179528249, -0.4066205904527607, -0.6460107179528247, 0.000283285833691,
        0.40662059045276056, 0.6460107179528248, 0.6460107179528248, 0.000283285833691,
        -0.4066205904527605, 0.6460107179528249, 0.6460107179528248, 0.000283285833691,
        0.4066205904527606, 0.6460107179528249, -0.6460107179528247, 0.000283285833691,
        -0.40662059045276056, 0.6460107179528249, -0.6460107179528247, 0.000283285833691,
        0.40662059045276056, -0.6460107179528248, 0.6460107179528248, 0.000283285833691,
        -0.4066205904527605, -0.6460107179528249, 0.6460107179528248, 0.000283285833691,
        0.4066205904527606, -0.6460107179528249, -0.6460107179528247, 0.000283285833691,
        -0.40662059045276056, -0.6460107179528249, -0.6460107179528247, 0.000283285833691,
        0.6639541138154251, 0.663954113815425, 0.3439910892670724, 0.000283326823545,
        0.6639541138154251, 0.663954113815425, -0.3439910892670725, 0.000283326823545,
        0.6639541138154251, -0.663954113815425, 0.3439910892670724, 0.000283326823545,
        0.6639541138154251, -0.663954113815425, -0.3439910892670725, 0.000283326823545,
        -0.663954113815425, 0.6639541138154251, 0.3439910892670724, 0.000283326823545,
        -0.663954113815425, 0.6639541138154251, -0.3439910892670725, 0.000283326823545,
        -0.663954113815425, -0.6639541138154251, 0.3439910892670724, 0.000283326823545,
        -0.663954113815425, -0.6639541138154251, -0.3439910892670725, 0.000283326823545,
        0.6639541138154251, 0.34399108926707245, 0.6639541138154251, 0.000283326823545,
        0.6639541138154251, -0.34399108926707245, 0.6639541138154251, 0.000283326823545,
        0.6639541138154251, 0.34399108926707245, -0.6639541138154252, 0.000283326823545,
        0.6639541138154251, -0.34399108926707245, -0.6639541138154252, 0.000283326823545,
        -0.6639541138154251, 0.34399108926707234, 0.6639541138154251, 0.000283326823545,
        -0.6639541138154251, -0.34399108926707234, 0.6639541138154251, 0.000283326823545,
        -0.6639541138154251, 0.34399108926707234, -0.6639541138154252, 0.000283326823545,
        -0.6639541138154251, -0.34399108926707234, -0.6639541138154252, 0.000283326823545,
        0.3439910892670723, 0.6639541138154251, 0.6639541138154251, 0.000283326823545,
        -0.34399108926707256, 0.663954113815425, 0.6639541138154251, 0.000283326823545,
        0.3439910892670723, 0.6639541138154251, -0.6639541138154252, 0.000283326823545,
        -0.34399108926707256, 0.663954113815425, -0.6639541138154252, 0.000283326823545,
        0.3439910892670723, -0.6639541138154251, 0.6639541138154251, 0.000283326823545,
        -0.34399108926707256, -0.663954113815425, 0.6639541138154251, 0.000283326823545,
        0.3439910892670723, -0.6639541138154251, -0.6639541138154252, 0.000283326823545,
        -0.34399108926707256, -0.663954113815425, -0.6639541138154252, 0.000283326823545,
        0.6790688515667496, 0.6790688515667495, 0.27880277915335056, 0.000283543267703,
        0.6790688515667495, 0.6790688515667493, -0.27880277915335067, 0.000283543267703,
        0.6790688515667496, -0.6790688515667495, 0.27880277915335056, 0.000283543267703,
        0.6790688515667495, -0.6790688515667493, -0.27880277915335067, 0.000283543267703,
        -0.6790688515667495, 0.6790688515667496, 0.27880277915335056, 0.000283543267703,
        -0.6790688515667493, 0.6790688515667495, -0.27880277915335067, 0.000283543267703,
        -0.6790688515667495, -0.6790688515667496, 0.27880277915335056, 0.000283543267703,
        -0.6790688515667493, -0.6790688515667495, -0.27880277915335067, 0.000283543267703,
        0.6790688515667495, 0.2788027791533505, 0.6790688515667495, 0.000283543267703,
        0.6790688515667495, -0.2788027791533505, 0.6790688515667495, 0.000283543267703,
        0.6790688515667492, 0.27880277915335044, -0.6790688515667498, 0.000283543267703,
        0.6790688515667492, -0.27880277915335044, -0.6790688515667498, 0.000283543267703,
        -0.6790688515667495, 0.2788027791533506, 0.6790688515667495, 0.000283543267703,
        -0.6790688515667495, -0.2788027791533506, 0.6790688515667495, 0.000283543267703,
        -0.6790688515667492, 0.2788027791533505, -0.6790688515667498, 0.000283543267703,
        -0.6790688515667492, -0.2788027791533505, -0.6790688515667498, 0.000283543267703,
        0.2788027791533505, 0.6790688515667495, 0.6790688515667495, 0.000283543267703,
        -0.2788027791533506, 0.6790688515667495, 0.6790688515667495, 0.000283543267703,
        0.27880277915335044, 0.6790688515667492, -0.6790688515667498, 0.000283543267703,
        -0.2788027791533505, 0.6790688515667492, -0.6790688515667498, 0.000283543267703,
        0.2788027791533505, -0.6790688515667495, 0.6790688515667495, 0.000283543267703,
        -0.2788027791533506, -0.6790688515667495, 0.6790688515667495, 0.000283543267703,
        0.27880277915335044, -0.6790688515667492, -0.6790688515667498, 0.000283543267703,
        -0.2788027791533505, -0.6790688515667492, -0.6790688515667498, 0.000283543267703,
        0.6911338580371512, 0.6911338580371513, 0.21134800815093058, 0.000283909172274,
        0.6911338580371511, 0.6911338580371512, -0.2113480081509309, 0.000283909172274,
        0.6911338580371512, -0.6911338580371513, 0.21134800815093058, 0.000283909172274,
        0.6911338580371511, -0.6911338580371512, -0.2113480081509309, 0.000283909172274,
        -0.6911338580371512, 0.6911338580371513, 0.21134800815093058, 0.000283909172274,
        -0.6911338580371511, 0.6911338580371512, -0.2113480081509309, 0.000283909172274,
        -0.6911338580371512, -0.6911338580371513, 0.21134800815093058, 0.000283909172274,
        -0.6911338580371511, -0.6911338580371512, -0.2113480081509309, 0.000283909172274,
        0.6911338580371512, 0.2113480081509304, 0.6911338580371512, 0.000283909172274,
        0.6911338580371512, -0.2113480081509304, 0.6911338580371512, 0.000283909172274,
        0.6911338580371511, 0.21134800815093038, -0.6911338580371514, 0.000283909172274,
        0.6911338580371511, -0.21134800815093038, -0.6911338580371514, 0.000283909172274,
        -0.6911338580371512, 0.2113480081509305, 0.6911338580371512, 0.000283909172274,
        -0.6911338580371512, -0.2113480081509305, 0.6911338580371512, 0.000283909172274,
        -0.6911338580371511, 0.21134800815093047, -0.6911338580371514, 0.000283909172274,
        -0.6911338580371511, -0.21134800815093047, -0.6911338580371514, 0.000283909172274,
        0.21134800815093047, 0.6911338580371512, 0.6911338580371512, 0.000283909172274,
        -0.2113480081509305, 0.6911338580371512, 0.6911338580371512, 0.000283909172274,
        0.21134800815093044, 0.6911338580371511, -0.6911338580371514, 0.000283909172274,
        -0.21134800815093047, 0.6911338580371511, -0.6911338580371514, 0.000283909172274,
        0.21134800815093047, -0.6911338580371512, 0.6911338580371512, 0.000283909172274,
        -0.2113480081509305, -0.6911338580371512, 0.6911338580371512, 0.000283909172274,
        0.21134800815093044, -0.6911338580371511, -0.6911338580371514, 0.000283909172274,
        -0.21134800815093047, -0.6911338580371511, -0.6911338580371514, 0.000283909172274,
        0.6999385956126489, 0.699938595612649, 0.1420279012855753, 0.000284330817888,
        0.6999385956126489, 0.699938595612649, -0.1420279012855754, 0.000284330817888,
        0.6999385956126489, -0.699938595612649, 0.1420279012855753, 0.000284330817888,
        0.6999385956126489, -0.699938595612649, -0.1420279012855754, 0.000284330817888,
        -0.6999385956126489, 0.699938595612649, 0.1420279012855753, 0.000284330817888,
        -0.6999385956126489, 0.699938595612649, -0.1420279012855754, 0.000284330817888,
        -0.6999385956126489, -0.699938595612649, 0.1420279012855753, 0.000284330817888,
        -0.6999385956126489, -0.699938595612649, -0.1420279012855754, 0.000284330817888,
        0.699938595612649, 0.14202790128557527, 0.699938595612649, 0.000284330817888,
        0.699938595612649, -0.14202790128557527, 0.699938595612649, 0.000284330817888,
        0.6999385956126489, 0.14202790128557524, -0.6999385956126492, 0.000284330817888,
        0.6999385956126489, -0.14202790128557524, -0.6999385956126492, 0.000284330817888,
        -0.699938595612649, 0.14202790128557527, 0.699938595612649, 0.000284330817888,
        -0.699938595612649, -0.14202790128557527, 0.699938595612649, 0.000284330817888,
        -0.6999385956126489, 0.14202790128557524, -0.6999385956126492, 0.000284330817888,
        -0.6999385956126489, -0.14202790128557524, -0.6999385956126492, 0.000284330817888,
        0.14202790128557524, 0.699938595612649, 0.699938595612649, 0.000284330817888,
        -0.1420279012855753, 0.699938595612649, 0.699938595612649, 0.000284330817888,
        0.14202790128557521, 0.6999385956126489, -0.6999385956126492, 0.000284330817888,
        -0.1420279012855753, 0.6999385956126489, -0.6999385956126492, 0.000284330817888,
        0.14202790128557524, -0.699938595612649, 0.699938595612649, 0.000284330817888,
        -0.1420279012855753, -0.699938595612649, 0.699938595612649, 0.000284330817888,
        0.14202790128557521, -0.6999385956126489, -0.6999385956126492, 0.000284330817888,
        -0.1420279012855753, -0.6999385956126489, -0.6999385956126492, 0.000284330817888,
        0.7053037748656896, 0.7053037748656895, 0.07136645094452433, 0.000284670355053,
        0.7053037748656896, 0.7053037748656895, -0.07136645094452443, 0.000284670355053,
        0.7053037748656896, -0.7053037748656895, 0.07136645094452433, 0.000284670355053,
        0.7053037748656896, -0.7053037748656895, -0.07136645094452443, 0.000284670355053,
        -0.7053037748656895, 0.7053037748656896, 0.07136645094452433, 0.000284670355053,
        -0.7053037748656895, 0.7053037748656896, -0.07136645094452443, 0.000284670355053,
        -0.7053037748656895, -0.7053037748656896, 0.07136645094452433, 0.000284670355053,
        -0.7053037748656895, -0.7053037748656896, -0.07136645094452443, 0.000284670355053,
        0.7053037748656896, 0.07136645094452403, 0.7053037748656896, 0.000284670355053,
        0.7053037748656896, -0.07136645094452403, 0.7053037748656896, 0.000284670355053,
        0.7053037748656896, 0.07136645094452403, -0.7053037748656896, 0.000284670355053,
        0.7053037748656896, -0.07136645094452403, -0.7053037748656896, 0.000284670355053,
        -0.7053037748656896, 0.07136645094452403, 0.7053037748656896, 0.000284670355053,
        -0.7053037748656896, -0.07136645094452403, 0.7053037748656896, 0.000284670355053,
        -0.7053037748656896, 0.07136645094452403, -0.7053037748656896, 0.000284670355053,
        -0.7053037748656896, -0.07136645094452403, -0.7053037748656896, 0.000284670355053,
        0.07136645094452446, 0.7053037748656895, 0.7053037748656896, 0.000284670355053,
        -0.07136645094452437, 0.7053037748656896, 0.7053037748656896, 0.000284670355053,
        0.07136645094452446, 0.7053037748656895, -0.7053037748656896, 0.000284670355053,
        -0.07136645094452437, 0.7053037748656896, -0.7053037748656896, 0.000284670355053,
        0.07136645094452446, -0.7053037748656895, 0.7053037748656896, 0.000284670355053,
        -0.07136645094452437, -0.7053037748656896, 0.7053037748656896, 0.000284670355053,
        0.07136645094452446, -0.7053037748656895, -0.7053037748656896, 0.000284670355053,
        -0.07136645094452437, -0.7053037748656896, -0.7053037748656896, 0.000284670355053,
        0.047322243871801034, 0.998879675053476, 6.123233995736766e-17, 0.000105119340697,
        0.047322243871801034, -0.998879675053476, 6.123233995736766e-17, 0.000105119340697,
        -0.04732224387180113, 0.998879675053476, 6.123233995736766e-17, 0.000105119340697,
        -0.04732224387180113, -0.998879675053476, 6.123233995736766e-17, 0.000105119340697,
        0.998879675053476, 0.04732224387180155, 6.123233995736766e-17, 0.000105119340697,
        0.998879675053476, -0.04732224387180155, 6.123233995736766e-17, 0.000105119340697,
        -0.998879675053476, 0.04732224387180154, 6.123233995736766e-17, 0.000105119340697,
        -0.998879675053476, -0.04732224387180154, 6.123233995736766e-17, 0.000105119340697,
        0.04732224387180155, 0.0, 0.998879675053476, 0.000105119340697,
        0.04732224387180154, 0.0, -0.998879675053476, 0.000105119340697,
        -0.04732224387180155, 5.795303448607221e-18, 0.998879675053476, 0.000105119340697,
        -0.04732224387180154, 5.7953034486072205e-18, -0.998879675053476, 0.000105119340697,
        0.998879675053476, 0.0, 0.047322243871801034, 0.000105119340697,
        0.998879675053476, 0.0, -0.04732224387180113, 0.000105119340697,
        -0.998879675053476, 1.2232747967875877e-16, 0.047322243871801034, 0.000105119340697,
        -0.998879675053476, 1.2232747967875877e-16, -0.04732224387180113, 0.000105119340697,
        2.8976517243036106e-18, 0.04732224387180155, 0.998879675053476, 0.000105119340697,
        2.8976517243036103e-18, 0.04732224387180154, -0.998879675053476, 0.000105119340697,
        2.8976517243036106e-18, -0.04732224387180155, 0.998879675053476, 0.000105119340697,
        2.8976517243036103e-18, -0.04732224387180154, -0.998879675053476, 0.000105119340697,
        6.116373983937939e-17, 0.998879675053476, 0.047322243871801034, 0.000105119340697,
        6.116373983937939e-17, 0.998879675053476, -0.04732224387180113, 0.000105119340697,
        6.116373983937939e-17, -0.998879675053476, 0.047322243871801034, 0.000105119340697,
        6.116373983937939e-17, -0.998879675053476, -0.04732224387180113, 0.000105119340697,
        0.12021005293268024, 0.9927484793108082, 6.123233995736766e-17, 0.00016578718388,
        0.12021005293268024, -0.9927484793108082, 6.123233995736766e-17, 0.00016578718388,
        -0.12021005293268033, 0.9927484793108082, 6.123233995736766e-17, 0.00016578718388,
        -0.12021005293268033, -0.9927484793108082, 6.123233995736766e-17, 0.00016578718388,
        0.9927484793108082, 0.12021005293268018, 6.123233995736766e-17, 0.00016578718388,
        0.9927484793108082, -0.12021005293268018, 6.123233995736766e-17, 0.00016578718388,
        -0.9927484793108082, 0.1202100529326803, 6.123233995736766e-17, 0.00016578718388,
        -0.9927484793108082, -0.1202100529326803, 6.123233995736766e-17, 0.00016578718388,
        0.12021005293268018, 0.0, 0.9927484793108082, 0.00016578718388,
        0.1202100529326803, 0.0, -0.9927484793108082, 0.00016578718388,
        -0.12021005293268018, 1.472148565493407e-17, 0.9927484793108082, 0.00016578718388,
        -0.1202100529326803, 1.4721485654934084e-17, -0.9927484793108082, 0.00016578718388,
        0.9927484793108082, 0.0, 0.12021005293268024, 0.00016578718388,
        0.9927484793108082, 0.0, -0.12021005293268033, 0.00016578718388,
        -0.9927484793108082, 1.2157662475463836e-16, 0.12021005293268024, 0.00016578718388,
        -0.9927484793108082, 1.2157662475463836e-16, -0.12021005293268033, 0.00016578718388,
        7.360742827467035e-18, 0.12021005293268018, 0.9927484793108082, 0.00016578718388,
        7.360742827467042e-18, 0.1202100529326803, -0.9927484793108082, 0.00016578718388,
        7.360742827467035e-18, -0.12021005293268018, 0.9927484793108082, 0.00016578718388,
        7.360742827467042e-18, -0.1202100529326803, -0.9927484793108082, 0.00016578718388,
        6.078831237731918e-17, 0.9927484793108082, 0.12021005293268024, 0.00016578718388,
        6.078831237731918e-17, 0.9927484793108082, -0.12021005293268033, 0.00016578718388,
        6.078831237731918e-17, -0.9927484793108082, 0.12021005293268024, 0.00016578718388,
        6.078831237731918e-17, -0.9927484793108082, -0.12021005293268033, 0.00016578718388,
        0.2034304820664855, 0.9790893927350032, 6.123233995736766e-17, 0.000206464811371,
        0.2034304820664855, -0.9790893927350032, 6.123233995736766e-17, 0.000206464811371,
        -0.20343048206648562, 0.9790893927350032, 6.123233995736766e-17, 0.000206464811371,
        -0.20343048206648562, -0.9790893927350032, 6.123233995736766e-17, 0.000206464811371,
        0.9790893927350032, 0.2034304820664856, 6.123233995736766e-17, 0.000206464811371,
        0.9790893927350032, -0.2034304820664856, 6.123233995736766e-17, 0.000206464811371,
        -0.9790893927350032, 0.20343048206648578, 6.123233995736766e-17, 0.000206464811371,
        -0.9790893927350032, -0.20343048206648578, 6.123233995736766e-17, 0.000206464811371,
        0.2034304820664856, 0.0, 0.9790893927350032, 0.000206464811371,
        0.20343048206648578, 0.0, -0.9790893927350032, 0.000206464811371,
        -0.2034304820664856, 2.4913048871172462e-17, 0.9790893927350032, 0.000206464811371,
        -0.20343048206648578, 2.4913048871172487e-17, -0.9790893927350032, 0.000206464811371,
        0.9790893927350032, 0.0, 0.2034304820664855, 0.000206464811371,
        0.9790893927350032, 0.0, -0.20343048206648562, 0.000206464811371,
        -0.9790893927350032, 1.1990386908920475e-16, 0.2034304820664855, 0.000206464811371,
        -0.9790893927350032, 1.1990386908920475e-16, -0.20343048206648562, 0.000206464811371,
        1.2456524435586231e-17, 0.2034304820664856, 0.9790893927350032, 0.000206464811371,
        1.2456524435586243e-17, 0.20343048206648578, -0.9790893927350032, 0.000206464811371,
        1.2456524435586231e-17, -0.2034304820664856, 0.9790893927350032, 0.000206464811371,
        1.2456524435586243e-17, -0.20343048206648578, -0.9790893927350032, 0.000206464811371,
        5.995193454460237e-17, 0.9790893927350032, 0.2034304820664855, 0.000206464811371,
        5.995193454460237e-17, 0.9790893927350032, -0.20343048206648562, 0.000206464811371,
        5.995193454460237e-17, -0.9790893927350032, 0.2034304820664855, 0.000206464811371,
        5.995193454460237e-17, -0.9790893927350032, -0.20343048206648562, 0.000206464811371,
        0.2912285643573001, 0.9566535022161294, 6.123233995736766e-17, 0.000234794274582,
        0.2912285643573001, -0.9566535022161294, 6.123233995736766e-17, 0.000234794274582,
        -0.29122856435730043, 0.9566535022161293, 6.123233995736766e-17, 0.000234794274582,
        -0.29122856435730043, -0.9566535022161293, 6.123233995736766e-17, 0.000234794274582,
        0.9566535022161293, 0.29122856435730043, 6.123233995736766e-17, 0.000234794274582,
        0.9566535022161293, -0.29122856435730043, 6.123233995736766e-17, 0.000234794274582,
        -0.9566535022161294, 0.2912285643573, 6.123233995736766e-17, 0.000234794274582,
        -0.9566535022161294, -0.2912285643573, 6.123233995736766e-17, 0.000234794274582,
        0.29122856435730043, 0.0, 0.9566535022161293, 0.000234794274582,
        0.2912285643573, 0.0, -0.9566535022161294, 0.000234794274582,
        -0.29122856435730043, 3.5665212916044694e-17, 0.9566535022161293, 0.000234794274582,
        -0.2912285643573, 3.566521291604464e-17, -0.9566535022161294, 0.000234794274582,
        0.9566535022161294, 0.0, 0.2912285643573001, 0.000234794274582,
        0.9566535022161293, 0.0, -0.29122856435730043, 0.000234794274582,
        -0.9566535022161294, 1.1715626493820882e-16, 0.2912285643573001, 0.000234794274582,
        -0.9566535022161293, 1.1715626493820882e-16, -0.29122856435730043, 0.000234794274582,
        1.7832606458022347e-17, 0.29122856435730043, 0.9566535022161293, 0.000234794274582,
        1.783260645802232e-17, 0.2912285643573, -0.9566535022161294, 0.000234794274582,
        1.7832606458022347e-17, -0.29122856435730043, 0.9566535022161293, 0.000234794274582,
        1.783260645802232e-17, -0.2912285643573, -0.9566535022161294, 0.000234794274582,
        5.857813246910441e-17, 0.9566535022161294, 0.2912285643573001, 0.000234794274582,
        5.857813246910441e-17, 0.9566535022161293, -0.29122856435730043, 0.000234794274582,
        5.857813246910441e-17, -0.9566535022161294, 0.2912285643573001, 0.000234794274582,
        5.857813246910441e-17, -0.9566535022161293, -0.29122856435730043, 0.000234794274582,
        0.3802361792726768, 0.9248894247271491, 6.123233995736766e-17, 0.00025477753266,
        0.3802361792726768, -0.9248894247271491, 6.123233995736766e-17, 0.00025477753266,
        -0.38023617927267683, 0.9248894247271491, 6.123233995736766e-17, 0.00025477753266,
        -0.38023617927267683, -0.9248894247271491, 6.123233995736766e-17, 0.00025477753266,
        0.9248894247271491, 0.38023617927267683, 6.123233995736766e-17, 0.00025477753266,
        0.9248894247271491, -0.38023617927267683, 6.123233995736766e-17, 0.00025477753266,
        -0.9248894247271491, 0.38023617927267683, 6.123233995736766e-17, 0.00025477753266,
        -0.9248894247271491, -0.38023617927267683, 6.123233995736766e-17, 0.00025477753266,
        0.38023617927267683, 0.0, 0.9248894247271491, 0.00025477753266,
        0.38023617927267683, 0.0, -0.9248894247271491, 0.00025477753266,
        -0.38023617927267683, 4.6565501986630283e-17, 0.9248894247271491, 0.00025477753266,
        -0.38023617927267683, 4.6565501986630283e-17, -0.9248894247271491, 0.00025477753266,
        0.9248894247271491, 0.0, 0.3802361792726768, 0.00025477753266,
        0.9248894247271491, 0.0, -0.38023617927267683, 0.00025477753266,
        -0.9248894247271491, 1.13266287355734e-16, 0.3802361792726768, 0.00025477753266,
        -0.9248894247271491, 1.13266287355734e-16, -0.38023617927267683, 0.00025477753266,
        2.3282750993315142e-17, 0.38023617927267683, 0.9248894247271491, 0.00025477753266,
        2.3282750993315142e-17, 0.38023617927267683, -0.9248894247271491, 0.00025477753266,
        2.3282750993315142e-17, -0.38023617927267683, 0.9248894247271491, 0.00025477753266,
        2.3282750993315142e-17, -0.38023617927267683, -0.9248894247271491, 0.00025477753266,
        5.6633143677867e-17, 0.9248894247271491, 0.3802361792726768, 0.00025477753266,
        5.6633143677867e-17, 0.9248894247271491, -0.38023617927267683, 0.00025477753266,
        5.6633143677867e-17, -0.9248894247271491, 0.3802361792726768, 0.00025477753266,
        5.6633143677867e-17, -0.9248894247271491, -0.38023617927267683, 0.00025477753266,
        0.46805985110561454, 0.883696766873677, 6.123233995736766e-17, 0.000268687668485,
        0.46805985110561454, -0.883696766873677, 6.123233995736766e-17, 0.000268687668485,
        -0.46805985110561443, 0.8836967668736772, 6.123233995736766e-17, 0.000268687668485,
        -0.46805985110561443, -0.8836967668736772, 6.123233995736766e-17, 0.000268687668485,
        0.883696766873677, 0.46805985110561454, 6.123233995736766e-17, 0.000268687668485,
        0.883696766873677, -0.46805985110561454, 6.123233995736766e-17, 0.000268687668485,
        -0.883696766873677, 0.4680598511056146, 6.123233995736766e-17, 0.000268687668485,
        -0.883696766873677, -0.4680598511056146, 6.123233995736766e-17, 0.000268687668485,
        0.46805985110561454, 0.0, 0.883696766873677, 0.000268687668485,
        0.4680598511056146, 0.0, -0.883696766873677, 0.000268687668485,
        -0.46805985110561454, 5.732079984658776e-17, 0.883696766873677, 0.000268687668485,
        -0.4680598511056146, 5.732079984658777e-17, -0.883696766873677, 0.000268687668485,
        0.883696766873677, 0.0, 0.46805985110561454, 0.000268687668485,
        0.8836967668736772, 0.0, -0.46805985110561443, 0.000268687668485,
        -0.883696766873677, 1.0822164169687134e-16, 0.46805985110561454, 0.000268687668485,
        -0.8836967668736772, 1.0822164169687135e-16, -0.46805985110561443, 0.000268687668485,
        2.866039992329388e-17, 0.46805985110561454, 0.883696766873677, 0.000268687668485,
        2.8660399923293885e-17, 0.4680598511056146, -0.883696766873677, 0.000268687668485,
        2.866039992329388e-17, -0.46805985110561454, 0.883696766873677, 0.000268687668485,
        2.8660399923293885e-17, -0.4680598511056146, -0.883696766873677, 0.000268687668485,
        5.411082084843567e-17, 0.883696766873677, 0.46805985110561454, 0.000268687668485,
        5.4110820848435674e-17, 0.8836967668736772, -0.46805985110561443, 0.000268687668485,
        5.411082084843567e-17, -0.883696766873677, 0.46805985110561454, 0.000268687668485,
        5.4110820848435674e-17, -0.8836967668736772, -0.46805985110561443, 0.000268687668485,
        0.5528151052155599, 0.8333039418156556, 6.123233995736766e-17, 0.000277866575552,
        0.5528151052155599, -0.8333039418156556, 6.123233995736766e-17, 0.000277866575552,
        -0.5528151052155598, 0.8333039418156556, 6.123233995736766e-17, 0.000277866575552,
        -0.5528151052155598, -0.8333039418156556, 6.123233995736766e-17, 0.000277866575552,
        0.8333039418156556, 0.5528151052155598, 6.123233995736766e-17, 0.000277866575552,
        0.8333039418156556, -0.5528151052155598, 6.123233995736766e-17, 0.000277866575552,
        -0.8333039418156555, 0.5528151052155599, 6.123233995736766e-17, 0.000277866575552,
        -0.8333039418156555, -0.5528151052155599, 6.123233995736766e-17, 0.000277866575552,
        0.5528151052155598, 0.0, 0.8333039418156556, 0.000277866575552,
        0.5528151052155599, 0.0, -0.8333039418156555, 0.000277866575552,
        -0.5528151052155598, 6.770032491225426e-17, 0.8333039418156556, 0.000277866575552,
        -0.5528151052155599, 6.770032491225427e-17, -0.8333039418156555, 0.000277866575552,
        0.8333039418156556, 0.0, 0.5528151052155599, 0.000277866575552,
        0.8333039418156556, 0.0, -0.5528151052155598, 0.000277866575552,
        -0.8333039418156556, 1.0205030050614149e-16, 0.5528151052155599, 0.000277866575552,
        -0.8333039418156556, 1.0205030050614149e-16, -0.5528151052155598, 0.000277866575552,
        3.385016245612713e-17, 0.5528151052155598, 0.8333039418156556, 0.000277866575552,
        3.3850162456127137e-17, 0.5528151052155599, -0.8333039418156555, 0.000277866575552,
        3.385016245612713e-17, -0.5528151052155598, 0.8333039418156556, 0.000277866575552,
        3.3850162456127137e-17, -0.5528151052155599, -0.8333039418156555, 0.000277866575552,
        5.102515025307074e-17, 0.8333039418156556, 0.5528151052155599, 0.000277866575552,
        5.102515025307074e-17, 0.8333039418156556, -0.5528151052155598, 0.000277866575552,
        5.102515025307074e-17, -0.8333039418156556, 0.5528151052155599, 0.000277866575552,
        5.102515025307074e-17, -0.8333039418156556, -0.5528151052155598, 0.000277866575552,
        0.6329386307803041, 0.7742019695570104, 6.123233995736766e-17, 0.000283099661678,
        0.6329386307803041, -0.7742019695570104, 6.123233995736766e-17, 0.000283099661678,
        -0.6329386307803041, 0.7742019695570104, 6.123233995736766e-17, 0.000283099661678,
        -0.6329386307803041, -0.7742019695570104, 6.123233995736766e-17, 0.000283099661678,
        0.7742019695570104, 0.632938630780304, 6.123233995736766e-17, 0.000283099661678,
        0.7742019695570104, -0.632938630780304, 6.123233995736766e-17, 0.000283099661678,
        -0.7742019695570105, 0.6329386307803039, 6.123233995736766e-17, 0.000283099661678,
        -0.7742019695570105, -0.6329386307803039, 6.123233995736766e-17, 0.000283099661678,
        0.632938630780304, 0.0, 0.7742019695570104, 0.000283099661678,
        0.6329386307803039, 0.0, -0.7742019695570105, 0.000283099661678,
        -0.632938630780304, 7.751262682418076e-17, 0.7742019695570104, 0.000283099661678,
        -0.6329386307803039, 7.751262682418075e-17, -0.7742019695570105, 0.000283099661678,
        0.7742019695570104, 0.0, 0.6329386307803041, 0.000283099661678,
        0.7742019695570104, 0.0, -0.6329386307803041, 0.000283099661678,
        -0.7742019695570104, 9.481239639115694e-17, 0.6329386307803041, 0.000283099661678,
        -0.7742019695570104, 9.481239639115694e-17, -0.6329386307803041, 0.000283099661678,
        3.875631341209038e-17, 0.632938630780304, 0.7742019695570104, 0.000283099661678,
        3.8756313412090376e-17, 0.6329386307803039, -0.7742019695570105, 0.000283099661678,
        3.875631341209038e-17, -0.632938630780304, 0.7742019695570104, 0.000283099661678,
        3.8756313412090376e-17, -0.6329386307803039, -0.7742019695570105, 0.000283099661678,
        4.740619819557847e-17, 0.7742019695570104, 0.6329386307803041, 0.000283099661678,
        4.740619819557847e-17, 0.7742019695570104, -0.6329386307803041, 0.000283099661678,
        4.740619819557847e-17, -0.7742019695570104, 0.6329386307803041, 0.000283099661678,
        4.740619819557847e-17, -0.7742019695570104, -0.6329386307803041, 0.000283099661678,
        0.08056516651369071, 0.02363454684003123, 0.9964690974336774, 0.000140306334017,
        0.08056516651369089, 0.023634546840031287, -0.9964690974336774, 0.000140306334017,
        0.08056516651369071, -0.02363454684003123, 0.9964690974336774, 0.000140306334017,
        0.08056516651369089, -0.023634546840031287, -0.9964690974336774, 0.000140306334017,
        -0.08056516651369071, 0.02363454684003122, 0.9964690974336774, 0.000140306334017,
        -0.08056516651369089, 0.023634546840031277, -0.9964690974336774, 0.000140306334017,
        -0.08056516651369071, -0.02363454684003122, 0.9964690974336774, 0.000140306334017,
        -0.08056516651369089, -0.023634546840031277, -0.9964690974336774, 0.000140306334017,
        0.08056516651369067, 0.9964690974336774, 0.023634546840031325, 0.000140306334017,
        0.08056516651369067, 0.9964690974336774, -0.023634546840031204, 0.000140306334017,
        0.08056516651369067, -0.9964690974336774, 0.023634546840031325, 0.000140306334017,
        0.08056516651369067, -0.9964690974336774, -0.023634546840031204, 0.000140306334017,
        -0.08056516651369076, 0.9964690974336774, 0.023634546840031325, 0.000140306334017,
        -0.08056516651369076, 0.9964690974336774, -0.023634546840031204, 0.000140306334017,
        -0.08056516651369076, -0.9964690974336774, 0.023634546840031325, 0.000140306334017,
        -0.08056516651369076, -0.9964690974336774, -0.023634546840031204, 0.000140306334017,
        0.02363454684003123, 0.08056516651369071, 0.9964690974336774, 0.000140306334017,
        0.023634546840031287, 0.08056516651369089, -0.9964690974336774, 0.000140306334017,
        0.02363454684003123, -0.08056516651369071, 0.9964690974336774, 0.000140306334017,
        0.023634546840031287, -0.08056516651369089, -0.9964690974336774, 0.000140306334017,
        -0.02363454684003124, 0.08056516651369071, 0.9964690974336774, 0.000140306334017,
        -0.023634546840031294, 0.08056516651369089, -0.9964690974336774, 0.000140306334017,
        -0.02363454684003124, -0.08056516651369071, 0.9964690974336774, 0.000140306334017,
        -0.023634546840031294, -0.08056516651369089, -0.9964690974336774, 0.000140306334017,
        0.023634546840031342, 0.9964690974336774, 0.08056516651369058, 0.000140306334017,
        0.023634546840031342, 0.9964690974336774, -0.08056516651369068, 0.000140306334017,
        0.023634546840031342, -0.9964690974336774, 0.08056516651369058, 0.000140306334017,
        0.023634546840031342, -0.9964690974336774, -0.08056516651369068, 0.000140306334017,
        -0.023634546840031224, 0.9964690974336774, 0.08056516651369058, 0.000140306334017,
        -0.023634546840031224, 0.9964690974336774, -0.08056516651369068, 0.000140306334017,
        -0.023634546840031224, -0.9964690974336774, 0.08056516651369058, 0.000140306334017,
        -0.023634546840031224, -0.9964690974336774, -0.08056516651369068, 0.000140306334017,
        0.9964690974336774, 0.08056516651369021, 0.023634546840031325, 0.000140306334017,
        0.9964690974336774, 0.08056516651369021, -0.023634546840031204, 0.000140306334017,
        0.9964690974336774, -0.08056516651369021, 0.023634546840031325, 0.000140306334017,
        0.9964690974336774, -0.08056516651369021, -0.023634546840031204, 0.000140306334017,
        -0.9964690974336774, 0.08056516651369007, 0.023634546840031325, 0.000140306334017,
        -0.9964690974336774, 0.08056516651369007, -0.023634546840031204, 0.000140306334017,
        -0.9964690974336774, -0.08056516651369007, 0.023634546840031325, 0.000140306334017,
        -0.9964690974336774, -0.08056516651369007, -0.023634546840031204, 0.000140306334017,
        0.9964690974336774, 0.02363454684003304, 0.08056516651369058, 0.000140306334017,
        0.9964690974336774, 0.02363454684003304, -0.08056516651369068, 0.000140306334017,
        0.9964690974336774, -0.02363454684003304, 0.08056516651369058, 0.000140306334017,
        0.9964690974336774, -0.02363454684003304, -0.08056516651369068, 0.000140306334017,
        -0.9964690974336774, 0.023634546840032956, 0.08056516651369058, 0.000140306334017,
        -0.9964690974336774, 0.023634546840032956, -0.08056516651369068, 0.000140306334017,
        -0.9964690974336774, -0.023634546840032956, 0.08056516651369058, 0.000140306334017,
        -0.9964690974336774, -0.023634546840032956, -0.08056516651369068, 0.000140306334017,
        0.11564760771393899, 0.051912916325459406, 0.991932800117341, 0.000169650412594,
        0.11564760771393844, 0.051912916325459156, -0.9919328001173411, 0.000169650412594,
        0.11564760771393899, -0.051912916325459406, 0.991932800117341, 0.000169650412594,
        0.11564760771393844, -0.051912916325459156, -0.9919328001173411, 0.000169650412594,
        -0.11564760771393899, 0.05191291632545943, 0.991932800117341, 0.000169650412594,
        -0.11564760771393844, 0.05191291632545917, -0.9919328001173411, 0.000169650412594,
        -0.11564760771393899, -0.05191291632545943, 0.991932800117341, 0.000169650412594,
        -0.11564760771393844, -0.05191291632545917, -0.9919328001173411, 0.000169650412594,
        0.1156476077139389, 0.991932800117341, 0.05191291632545941, 0.000169650412594,
        0.1156476077139389, 0.991932800117341, -0.05191291632545929, 0.000169650412594,
        0.1156476077139389, -0.991932800117341, 0.05191291632545941, 0.000169650412594,
        0.1156476077139389, -0.991932800117341, -0.05191291632545929, 0.000169650412594,
        -0.11564760771393899, 0.991932800117341, 0.05191291632545941, 0.000169650412594,
        -0.11564760771393899, 0.991932800117341, -0.05191291632545929, 0.000169650412594,
        -0.11564760771393899, -0.991932800117341, 0.05191291632545941, 0.000169650412594,
        -0.11564760771393899, -0.991932800117341, -0.05191291632545929, 0.000169650412594,
        0.05191291632545939, 0.115647607713939, 0.991932800117341, 0.000169650412594,
        0.05191291632545914, 0.11564760771393845, -0.9919328001173411, 0.000169650412594,
        0.05191291632545939, -0.115647607713939, 0.991932800117341, 0.000169650412594,
        0.05191291632545914, -0.11564760771393845, -0.9919328001173411, 0.000169650412594,
        -0.0519129163254594, 0.11564760771393899, 0.991932800117341, 0.000169650412594,
        -0.05191291632545915, 0.11564760771393844, -0.9919328001173411, 0.000169650412594,
        -0.0519129163254594, -0.11564760771393899, 0.991932800117341, 0.000169650412594,
        -0.05191291632545915, -0.11564760771393844, -0.9919328001173411, 0.000169650412594,
        0.05191291632545945, 0.9919328001173411, 0.11564760771393878, 0.000169650412594,
        0.05191291632545945, 0.9919328001173411, -0.11564760771393888, 0.000169650412594,
        0.05191291632545945, -0.9919328001173411, 0.11564760771393878, 0.000169650412594,
        0.05191291632545945, -0.9919328001173411, -0.11564760771393888, 0.000169650412594,
        -0.05191291632545932, 0.9919328001173411, 0.11564760771393878, 0.000169650412594,
        -0.05191291632545932, 0.9919328001173411, -0.11564760771393888, 0.000169650412594,
        -0.05191291632545932, -0.9919328001173411, 0.11564760771393878, 0.000169650412594,
        -0.05191291632545932, -0.9919328001173411, -0.11564760771393888, 0.000169650412594,
        0.991932800117341, 0.11564760771393905, 0.05191291632545941, 0.000169650412594,
        0.991932800117341, 0.11564760771393905, -0.05191291632545929, 0.000169650412594,
        0.991932800117341, -0.11564760771393905, 0.05191291632545941, 0.000169650412594,
        0.991932800117341, -0.11564760771393905, -0.05191291632545929, 0.000169650412594,
        -0.991932800117341, 0.11564760771393895, 0.05191291632545941, 0.000169650412594,
        -0.991932800117341, 0.11564760771393895, -0.05191291632545929, 0.000169650412594,
        -0.991932800117341, -0.11564760771393895, 0.05191291632545941, 0.000169650412594,
        -0.991932800117341, -0.11564760771393895, -0.05191291632545929, 0.000169650412594,
        0.9919328001173411, 0.05191291632545872, 0.11564760771393878, 0.000169650412594,
        0.9919328001173411, 0.05191291632545872, -0.11564760771393888, 0.000169650412594,
        0.9919328001173411, -0.05191291632545872, 0.11564760771393878, 0.000169650412594,
        0.9919328001173411, -0.05191291632545872, -0.11564760771393888, 0.000169650412594,
        -0.9919328001173411, 0.05191291632545862, 0.11564760771393878, 0.000169650412594,
        -0.9919328001173411, 0.05191291632545862, -0.11564760771393888, 0.000169650412594,
        -0.9919328001173411, -0.05191291632545862, 0.11564760771393878, 0.000169650412594,
        -0.9919328001173411, -0.05191291632545862, -0.11564760771393888, 0.000169650412594,
        0.15204733827604247, 0.08322715736994533, 0.9848628570513202, 0.000193578724275,
        0.15204733827604233, 0.08322715736994526, -0.9848628570513202, 0.000193578724275,
        0.15204733827604247, -0.08322715736994533, 0.9848628570513202, 0.000193578724275,
        0.15204733827604233, -0.08322715736994526, -0.9848628570513202, 0.000193578724275,
        -0.15204733827604247, 0.08322715736994532, 0.9848628570513202, 0.000193578724275,
        -0.15204733827604236, 0.08322715736994525, -0.9848628570513202, 0.000193578724275,
        -0.15204733827604247, -0.08322715736994532, 0.9848628570513202, 0.000193578724275,
        -0.15204733827604236, -0.08322715736994525, -0.9848628570513202, 0.000193578724275,
        0.15204733827604203, 0.9848628570513203, 0.08322715736994506, 0.000193578724275,
        0.15204733827604203, 0.9848628570513203, -0.08322715736994517, 0.000193578724275,
        0.15204733827604203, -0.9848628570513203, 0.08322715736994506, 0.000193578724275,
        0.15204733827604203, -0.9848628570513203, -0.08322715736994517, 0.000193578724275,
        -0.1520473382760421, 0.9848628570513203, 0.08322715736994506, 0.000193578724275,
        -0.1520473382760421, 0.9848628570513203, -0.08322715736994517, 0.000193578724275,
        -0.1520473382760421, -0.9848628570513203, 0.08322715736994506, 0.000193578724275,
        -0.1520473382760421, -0.9848628570513203, -0.08322715736994517, 0.000193578724275,
        0.08322715736994538, 0.15204733827604244, 0.9848628570513202, 0.000193578724275,
        0.0832271573699453, 0.1520473382760423, -0.9848628570513202, 0.000193578724275,
        0.08322715736994538, -0.15204733827604244, 0.9848628570513202, 0.000193578724275,
        0.0832271573699453, -0.1520473382760423, -0.9848628570513202, 0.000193578724275,
        -0.08322715736994536, 0.15204733827604244, 0.9848628570513202, 0.000193578724275,
        -0.08322715736994529, 0.1520473382760423, -0.9848628570513202, 0.000193578724275,
        -0.08322715736994536, -0.15204733827604244, 0.9848628570513202, 0.000193578724275,
        -0.08322715736994529, -0.1520473382760423, -0.9848628570513202, 0.000193578724275,
        0.0832271573699451, 0.9848628570513202, 0.152047338276042, 0.000193578724275,
        0.0832271573699451, 0.9848628570513202, -0.1520473382760421, 0.000193578724275,
        0.0832271573699451, -0.9848628570513202, 0.152047338276042, 0.000193578724275,
        0.0832271573699451, -0.9848628570513202, -0.1520473382760421, 0.000193578724275,
        -0.08322715736994521, 0.9848628570513202, 0.152047338276042, 0.000193578724275,
        -0.08322715736994521, 0.9848628570513202, -0.1520473382760421, 0.000193578724275,
        -0.08322715736994521, -0.9848628570513202, 0.152047338276042, 0.000193578724275,
        -0.08322715736994521, -0.9848628570513202, -0.1520473382760421, 0.000193578724275,
        0.9848628570513203, 0.15204733827604186, 0.08322715736994506, 0.000193578724275,
        0.9848628570513203, 0.15204733827604186, -0.08322715736994517, 0.000193578724275,
        0.9848628570513203, -0.15204733827604186, 0.08322715736994506, 0.000193578724275,
        0.9848628570513203, -0.15204733827604186, -0.08322715736994517, 0.000193578724275,
        -0.9848628570513203, 0.15204733827604164, 0.08322715736994506, 0.000193578724275,
        -0.9848628570513203, 0.15204733827604164, -0.08322715736994517, 0.000193578724275,
        -0.9848628570513203, -0.15204733827604164, 0.08322715736994506, 0.000193578724275,
        -0.9848628570513203, -0.15204733827604164, -0.08322715736994517, 0.000193578724275,
        0.9848628570513203, 0.08322715736994431, 0.152047338276042, 0.000193578724275,
        0.9848628570513203, 0.08322715736994431, -0.1520473382760421, 0.000193578724275,
        0.9848628570513203, -0.08322715736994431, 0.152047338276042, 0.000193578724275,
        0.9848628570513203, -0.08322715736994431, -0.1520473382760421, 0.000193578724275,
        -0.9848628570513203, 0.08322715736994407, 0.152047338276042, 0.000193578724275,
        -0.9848628570513203, 0.08322715736994407, -0.1520473382760421, 0.000193578724275,
        -0.9848628570513203, -0.08322715736994407, 0.152047338276042, 0.000193578724275,
        -0.9848628570513203, -0.08322715736994407, -0.1520473382760421, 0.000193578724275,
        0.18929866997459308, 0.1165855667993712, 0.9749737530620604, 0.000213061451052,
        0.18929866997459316, 0.11658556679937125, -0.9749737530620604, 0.000213061451052,
        0.18929866997459308, -0.1165855667993712, 0.9749737530620604, 0.000213061451052,
        0.18929866997459316, -0.11658556679937125, -0.9749737530620604, 0.000213061451052,
        -0.18929866997459305, 0.11658556679937121, 0.9749737530620604, 0.000213061451052,
        -0.18929866997459313, 0.11658556679937128, -0.9749737530620604, 0.000213061451052,
        -0.18929866997459305, -0.11658556679937121, 0.9749737530620604, 0.000213061451052,
        -0.18929866997459313, -0.11658556679937128, -0.9749737530620604, 0.000213061451052,
        0.1892986699745932, 0.9749737530620604, 0.11658556679937118, 0.000213061451052,
        0.1892986699745932, 0.9749737530620604, -0.11658556679937128, 0.000213061451052,
        0.1892986699745932, -0.9749737530620604, 0.11658556679937118, 0.000213061451052,
        0.1892986699745932, -0.9749737530620604, -0.11658556679937128, 0.000213061451052,
        -0.18929866997459305, 0.9749737530620605, 0.11658556679937118, 0.000213061451052,
        -0.18929866997459305, 0.9749737530620605, -0.11658556679937128, 0.000213061451052,
        -0.18929866997459305, -0.9749737530620605, 0.11658556679937118, 0.000213061451052,
        -0.18929866997459305, -0.9749737530620605, -0.11658556679937128, 0.000213061451052,
        0.11658556679937121, 0.18929866997459308, 0.9749737530620604, 0.000213061451052,
        0.11658556679937128, 0.18929866997459316, -0.9749737530620604, 0.000213061451052,
        0.11658556679937121, -0.18929866997459308, 0.9749737530620604, 0.000213061451052,
        0.11658556679937128, -0.18929866997459316, -0.9749737530620604, 0.000213061451052,
        -0.1165855667993712, 0.18929866997459308, 0.9749737530620604, 0.000213061451052,
        -0.11658556679937125, 0.18929866997459316, -0.9749737530620604, 0.000213061451052,
        -0.1165855667993712, -0.18929866997459308, 0.9749737530620604, 0.000213061451052,
        -0.11658556679937125, -0.18929866997459316, -0.9749737530620604, 0.000213061451052,
        0.11658556679937108, 0.9749737530620602, 0.18929866997459302, 0.000213061451052,
        0.11658556679937108, 0.9749737530620602, -0.18929866997459313, 0.000213061451052,
        0.11658556679937108, -0.9749737530620602, 0.18929866997459302, 0.000213061451052,
        0.11658556679937108, -0.9749737530620602, -0.18929866997459313, 0.000213061451052,
        -0.1165855667993712, 0.9749737530620602, 0.18929866997459302, 0.000213061451052,
        -0.1165855667993712, 0.9749737530620602, -0.18929866997459313, 0.000213061451052,
        -0.1165855667993712, -0.9749737530620602, 0.18929866997459302, 0.000213061451052,
        -0.1165855667993712, -0.9749737530620602, -0.18929866997459313, 0.000213061451052,
        0.9749737530620604, 0.18929866997459344, 0.11658556679937118, 0.000213061451052,
        0.9749737530620604, 0.18929866997459344, -0.11658556679937128, 0.000213061451052,
        0.9749737530620604, -0.18929866997459344, 0.11658556679937118, 0.000213061451052,
        0.9749737530620604, -0.18929866997459344, -0.11658556679937128, 0.000213061451052,
        -0.9749737530620604, 0.18929866997459324, 0.11658556679937118, 0.000213061451052,
        -0.9749737530620604, 0.18929866997459324, -0.11658556679937128, 0.000213061451052,
        -0.9749737530620604, -0.18929866997459324, 0.11658556679937118, 0.000213061451052,
        -0.9749737530620604, -0.18929866997459324, -0.11658556679937128, 0.000213061451052,
        0.9749737530620604, 0.11658556679937063, 0.18929866997459302, 0.000213061451052,
        0.9749737530620604, 0.11658556679937063, -0.18929866997459313, 0.000213061451052,
        0.9749737530620604, -0.11658556679937063, 0.18929866997459302, 0.000213061451052,
        0.9749737530620604, -0.11658556679937063, -0.18929866997459313, 0.000213061451052,
        -0.9749737530620604, 0.1165855667993705, 0.18929866997459302, 0.000213061451052,
        -0.9749737530620604, 0.1165855667993705, -0.18929866997459313, 0.000213061451052,
        -0.9749737530620604, -0.1165855667993705, 0.18929866997459302, 0.000213061451052,
        -0.9749737530620604, -0.1165855667993705, -0.18929866997459313, 0.000213061451052,
        0.2270194446777791, 0.15130771674095037, 0.9620645230923096, 0.000228938126593,
        0.2270194446777789, 0.15130771674095025, -0.9620645230923097, 0.000228938126593,
        0.2270194446777791, -0.15130771674095037, 0.9620645230923096, 0.000228938126593,
        0.2270194446777789, -0.15130771674095025, -0.9620645230923097, 0.000228938126593,
        -0.22701944467777907, 0.15130771674095042, 0.9620645230923096, 0.000228938126593,
        -0.22701944467777888, 0.15130771674095028, -0.9620645230923097, 0.000228938126593,
        -0.22701944467777907, -0.15130771674095042, 0.9620645230923096, 0.000228938126593,
        -0.22701944467777888, -0.15130771674095028, -0.9620645230923097, 0.000228938126593,
        0.2270194446777791, 0.9620645230923097, 0.15130771674095048, 0.000228938126593,
        0.2270194446777791, 0.9620645230923097, -0.15130771674095034, 0.000228938126593,
        0.2270194446777791, -0.9620645230923097, 0.15130771674095048, 0.000228938126593,
        0.2270194446777791, -0.9620645230923097, -0.15130771674095034, 0.000228938126593,
        -0.2270194446777792, 0.9620645230923096, 0.15130771674095048, 0.000228938126593,
        -0.2270194446777792, 0.9620645230923096, -0.15130771674095034, 0.000228938126593,
        -0.2270194446777792, -0.9620645230923096, 0.15130771674095048, 0.000228938126593,
        -0.2270194446777792, -0.9620645230923096, -0.15130771674095034, 0.000228938126593,
        0.1513077167409503, 0.22701944467777913, 0.9620645230923096, 0.000228938126593,
        0.1513077167409502, 0.22701944467777896, -0.9620645230923097, 0.000228938126593,
        0.1513077167409503, -0.22701944467777913, 0.9620645230923096, 0.000228938126593,
        0.1513077167409502, -0.22701944467777896, -0.9620645230923097, 0.000228938126593,
        -0.15130771674095034, 0.2270194446777791, 0.9620645230923096, 0.000228938126593,
        -0.15130771674095023, 0.2270194446777789, -0.9620645230923097, 0.000228938126593,
        -0.15130771674095034, -0.2270194446777791, 0.9620645230923096, 0.000228938126593,
        -0.15130771674095023, -0.2270194446777789, -0.9620645230923097, 0.000228938126593,
        0.15130771674095034, 0.9620645230923095, 0.2270194446777791, 0.000228938126593,
        0.15130771674095034, 0.9620645230923095, -0.2270194446777792, 0.000228938126593,
        0.15130771674095034, -0.9620645230923095, 0.2270194446777791, 0.000228938126593,
        0.15130771674095034, -0.9620645230923095, -0.2270194446777792, 0.000228938126593,
        -0.15130771674095064, 0.9620645230923095, 0.2270194446777791, 0.000228938126593,
        -0.15130771674095064, 0.9620645230923095, -0.2270194446777792, 0.000228938126593,
        -0.15130771674095064, -0.9620645230923095, 0.2270194446777791, 0.000228938126593,
        -0.15130771674095064, -0.9620645230923095, -0.2270194446777792, 0.000228938126593,
        0.9620645230923096, 0.22701944467777943, 0.15130771674095048, 0.000228938126593,
        0.9620645230923096, 0.22701944467777943, -0.15130771674095034, 0.000228938126593,
        0.9620645230923096, -0.22701944467777943, 0.15130771674095048, 0.000228938126593,
        0.9620645230923096, -0.22701944467777943, -0.15130771674095034, 0.000228938126593,
        -0.9620645230923096, 0.22701944467777938, 0.15130771674095048, 0.000228938126593,
        -0.9620645230923096, 0.22701944467777938, -0.15130771674095034, 0.000228938126593,
        -0.9620645230923096, -0.22701944467777938, 0.15130771674095048, 0.000228938126593,
        -0.9620645230923096, -0.22701944467777938, -0.15130771674095034, 0.000228938126593,
        0.9620645230923096, 0.1513077167409499, 0.2270194446777791, 0.000228938126593,
        0.9620645230923096, 0.1513077167409499, -0.2270194446777792, 0.000228938126593,
        0.9620645230923096, -0.1513077167409499, 0.2270194446777791, 0.000228938126593,
        0.9620645230923096, -0.1513077167409499, -0.2270194446777792, 0.000228938126593,
        -0.9620645230923096, 0.15130771674094975, 0.2270194446777791, 0.000228938126593,
        -0.9620645230923096, 0.15130771674094975, -0.2270194446777792, 0.000228938126593,
        -0.9620645230923096, -0.15130771674094975, 0.2270194446777791, 0.000228938126593,
        -0.9620645230923096, -0.15130771674094975, -0.2270194446777792, 0.000228938126593,
        0.2648908185093274, 0.18688820258078606, 0.9459945316996191, 0.000241863029282,
        0.2648908185093274, 0.18688820258078606, -0.9459945316996191, 0.000241863029282,
        0.2648908185093274, -0.18688820258078606, 0.9459945316996191, 0.000241863029282,
        0.2648908185093274, -0.18688820258078606, -0.9459945316996191, 0.000241863029282,
        -0.2648908185093274, 0.1868882025807861, 0.9459945316996191, 0.000241863029282,
        -0.2648908185093274, 0.1868882025807861, -0.9459945316996191, 0.000241863029282,
        -0.2648908185093274, -0.1868882025807861, 0.9459945316996191, 0.000241863029282,
        -0.2648908185093274, -0.1868882025807861, -0.9459945316996191, 0.000241863029282,
        0.2648908185093272, 0.9459945316996191, 0.18688820258078584, 0.000241863029282,
        0.2648908185093272, 0.9459945316996191, -0.18688820258078614, 0.000241863029282,
        0.2648908185093272, -0.9459945316996191, 0.18688820258078584, 0.000241863029282,
        0.2648908185093272, -0.9459945316996191, -0.18688820258078614, 0.000241863029282,
        -0.2648908185093275, 0.945994531699619, 0.18688820258078584, 0.000241863029282,
        -0.2648908185093275, 0.945994531699619, -0.18688820258078614, 0.000241863029282,
        -0.2648908185093275, -0.945994531699619, 0.18688820258078584, 0.000241863029282,
        -0.2648908185093275, -0.945994531699619, -0.18688820258078614, 0.000241863029282,
        0.18688820258078598, 0.26489081850932744, 0.9459945316996191, 0.000241863029282,
        0.18688820258078598, 0.26489081850932744, -0.9459945316996191, 0.000241863029282,
        0.18688820258078598, -0.26489081850932744, 0.9459945316996191, 0.000241863029282,
        0.18688820258078598, -0.26489081850932744, -0.9459945316996191, 0.000241863029282,
        -0.18688820258078603, 0.2648908185093274, 0.9459945316996191, 0.000241863029282,
        -0.18688820258078603, 0.2648908185093274, -0.9459945316996191, 0.000241863029282,
        -0.18688820258078603, -0.2648908185093274, 0.9459945316996191, 0.000241863029282,
        -0.18688820258078603, -0.2648908185093274, -0.9459945316996191, 0.000241863029282,
        0.186888202580786, 0.9459945316996193, 0.26489081850932694, 0.000241863029282,
        0.186888202580786, 0.9459945316996192, -0.2648908185093273, 0.000241863029282,
        0.186888202580786, -0.9459945316996193, 0.26489081850932694, 0.000241863029282,
        0.186888202580786, -0.9459945316996192, -0.2648908185093273, 0.000241863029282,
        -0.1868882025807859, 0.9459945316996193, 0.26489081850932694, 0.000241863029282,
        -0.1868882025807859, 0.9459945316996192, -0.2648908185093273, 0.000241863029282,
        -0.1868882025807859, -0.9459945316996193, 0.26489081850932694, 0.000241863029282,
        -0.1868882025807859, -0.9459945316996192, -0.2648908185093273, 0.000241863029282,
        0.9459945316996191, 0.2648908185093273, 0.18688820258078584, 0.000241863029282,
        0.9459945316996191, 0.2648908185093273, -0.18688820258078614, 0.000241863029282,
        0.9459945316996191, -0.2648908185093273, 0.18688820258078584, 0.000241863029282,
        0.9459945316996191, -0.2648908185093273, -0.18688820258078614, 0.000241863029282,
        -0.9459945316996191, 0.2648908185093275, 0.18688820258078584, 0.000241863029282,
        -0.9459945316996191, 0.2648908185093275, -0.18688820258078614, 0.000241863029282,
        -0.9459945316996191, -0.2648908185093275, 0.18688820258078584, 0.000241863029282,
        -0.9459945316996191, -0.2648908185093275, -0.18688820258078614, 0.000241863029282,
        0.9459945316996193, 0.1868882025807858, 0.26489081850932694, 0.000241863029282,
        0.9459945316996192, 0.18688820258078578, -0.2648908185093273, 0.000241863029282,
        0.9459945316996193, -0.1868882025807858, 0.26489081850932694, 0.000241863029282,
        0.9459945316996192, -0.18688820258078578, -0.2648908185093273, 0.000241863029282,
        -0.9459945316996193, 0.18688820258078567, 0.26489081850932694, 0.000241863029282,
        -0.9459945316996192, 0.18688820258078565, -0.2648908185093273, 0.000241863029282,
        -0.9459945316996193, -0.18688820258078567, 0.26489081850932694, 0.000241863029282,
        -0.9459945316996192, -0.18688820258078565, -0.2648908185093273, 0.000241863029282,
        0.30263892595741354, 0.2229277629776224, 0.9266676281111454, 0.000252340049563,
        0.30263892595741343, 0.2229277629776223, -0.9266676281111456, 0.000252340049563,
        0.30263892595741354, -0.2229277629776224, 0.9266676281111454, 0.000252340049563,
        0.30263892595741343, -0.2229277629776223, -0.9266676281111456, 0.000252340049563,
        -0.30263892595741354, 0.2229277629776224, 0.9266676281111454, 0.000252340049563,
        -0.30263892595741343, 0.2229277629776223, -0.9266676281111456, 0.000252340049563,
        -0.30263892595741354, -0.2229277629776224, 0.9266676281111454, 0.000252340049563,
        -0.30263892595741343, -0.2229277629776223, -0.9266676281111456, 0.000252340049563,
        0.3026389259574135, 0.9266676281111456, 0.22292776297762232, 0.000252340049563,
        0.3026389259574135, 0.9266676281111456, -0.22292776297762243, 0.000252340049563,
        0.3026389259574135, -0.9266676281111456, 0.22292776297762232, 0.000252340049563,
        0.3026389259574135, -0.9266676281111456, -0.22292776297762243, 0.000252340049563,
        -0.3026389259574136, 0.9266676281111456, 0.22292776297762232, 0.000252340049563,
        -0.3026389259574136, 0.9266676281111456, -0.22292776297762243, 0.000252340049563,
        -0.3026389259574136, -0.9266676281111456, 0.22292776297762232, 0.000252340049563,
        -0.3026389259574136, -0.9266676281111456, -0.22292776297762243, 0.000252340049563,
        0.2229277629776224, 0.3026389259574136, 0.9266676281111454, 0.000252340049563,
        0.2229277629776223, 0.3026389259574135, -0.9266676281111456, 0.000252340049563,
        0.2229277629776224, -0.3026389259574136, 0.9266676281111454, 0.000252340049563,
        0.2229277629776223, -0.3026389259574135, -0.9266676281111456, 0.000252340049563,
        -0.22292776297762235, 0.3026389259574136, 0.9266676281111454, 0.000252340049563,
        -0.22292776297762226, 0.3026389259574135, -0.9266676281111456, 0.000252340049563,
        -0.22292776297762235, -0.3026389259574136, 0.9266676281111454, 0.000252340049563,
        -0.22292776297762226, -0.3026389259574135, -0.9266676281111456, 0.000252340049563,
        0.2229277629776223, 0.9266676281111454, 0.30263892595741354, 0.000252340049563,
        0.2229277629776223, 0.9266676281111454, -0.30263892595741365, 0.000252340049563,
        0.2229277629776223, -0.9266676281111454, 0.30263892595741354, 0.000252340049563,
        0.2229277629776223, -0.9266676281111454, -0.30263892595741365, 0.000252340049563,
        -0.2229277629776224, 0.9266676281111454, 0.30263892595741354, 0.000252340049563,
        -0.2229277629776224, 0.9266676281111454, -0.30263892595741365, 0.000252340049563,
        -0.2229277629776224, -0.9266676281111454, 0.30263892595741354, 0.000252340049563,
        -0.2229277629776224, -0.9266676281111454, -0.30263892595741365, 0.000252340049563,
        0.9266676281111454, 0.30263892595741376, 0.22292776297762232, 0.000252340049563,
        0.9266676281111454, 0.30263892595741376, -0.22292776297762243, 0.000252340049563,
        0.9266676281111454, -0.30263892595741376, 0.22292776297762232, 0.000252340049563,
        0.9266676281111454, -0.30263892595741376, -0.22292776297762243, 0.000252340049563,
        -0.9266676281111454, 0.30263892595741376, 0.22292776297762232, 0.000252340049563,
        -0.9266676281111454, 0.30263892595741376, -0.22292776297762243, 0.000252340049563,
        -0.9266676281111454, -0.30263892595741376, 0.22292776297762232, 0.000252340049563,
        -0.9266676281111454, -0.30263892595741376, -0.22292776297762243, 0.000252340049563,
        0.9266676281111454, 0.2229277629776223, 0.30263892595741354, 0.000252340049563,
        0.9266676281111454, 0.2229277629776223, -0.30263892595741365, 0.000252340049563,
        0.9266676281111454, -0.2229277629776223, 0.30263892595741354, 0.000252340049563,
        0.9266676281111454, -0.2229277629776223, -0.30263892595741365, 0.000252340049563,
        -0.9266676281111454, 0.22292776297762237, 0.30263892595741354, 0.000252340049563,
        -0.9266676281111454, 0.22292776297762237, -0.30263892595741365, 0.000252340049563,
        -0.9266676281111454, -0.22292776297762237, 0.30263892595741354, 0.000252340049563,
        -0.9266676281111454, -0.22292776297762237, -0.30263892595741365, 0.000252340049563,
        0.3400220296151385, 0.25909518407462356, 0.9040214073603229, 0.000260762397345,
        0.34002202961513806, 0.25909518407462323, -0.9040214073603231, 0.000260762397345,
        0.3400220296151385, -0.25909518407462356, 0.9040214073603229, 0.000260762397345,
        0.34002202961513806, -0.25909518407462323, -0.9040214073603231, 0.000260762397345,
        -0.3400220296151385, 0.25909518407462356, 0.9040214073603229, 0.000260762397345,
        -0.34002202961513806, 0.25909518407462323, -0.9040214073603231, 0.000260762397345,
        -0.3400220296151385, -0.25909518407462356, 0.9040214073603229, 0.000260762397345,
        -0.34002202961513806, -0.25909518407462323, -0.9040214073603231, 0.000260762397345,
        0.34002202961513844, 0.9040214073603229, 0.2590951840746235, 0.000260762397345,
        0.34002202961513844, 0.9040214073603229, -0.25909518407462356, 0.000260762397345,
        0.34002202961513844, -0.9040214073603229, 0.2590951840746235, 0.000260762397345,
        0.34002202961513844, -0.9040214073603229, -0.25909518407462356, 0.000260762397345,
        -0.34002202961513833, 0.9040214073603229, 0.2590951840746235, 0.000260762397345,
        -0.34002202961513833, 0.9040214073603229, -0.25909518407462356, 0.000260762397345,
        -0.34002202961513833, -0.9040214073603229, 0.2590951840746235, 0.000260762397345,
        -0.34002202961513833, -0.9040214073603229, -0.25909518407462356, 0.000260762397345,
        0.25909518407462356, 0.34002202961513844, 0.9040214073603229, 0.000260762397345,
        0.25909518407462323, 0.340022029615138, -0.9040214073603231, 0.000260762397345,
        0.25909518407462356, -0.34002202961513844, 0.9040214073603229, 0.000260762397345,
        0.25909518407462323, -0.340022029615138, -0.9040214073603231, 0.000260762397345,
        -0.2590951840746237, 0.3400220296151384, 0.9040214073603229, 0.000260762397345,
        -0.25909518407462334, 0.34002202961513794, -0.9040214073603231, 0.000260762397345,
        -0.2590951840746237, -0.3400220296151384, 0.9040214073603229, 0.000260762397345,
        -0.25909518407462334, -0.34002202961513794, -0.9040214073603231, 0.000260762397345,
        0.25909518407462356, 0.9040214073603229, 0.34002202961513844, 0.000260762397345,
        0.25909518407462356, 0.9040214073603229, -0.34002202961513855, 0.000260762397345,
        0.25909518407462356, -0.9040214073603229, 0.34002202961513844, 0.000260762397345,
        0.25909518407462356, -0.9040214073603229, -0.34002202961513855, 0.000260762397345,
        -0.25909518407462345, 0.9040214073603229, 0.34002202961513844, 0.000260762397345,
        -0.25909518407462345, 0.9040214073603229, -0.34002202961513855, 0.000260762397345,
        -0.25909518407462345, -0.9040214073603229, 0.34002202961513844, 0.000260762397345,
        -0.25909518407462345, -0.9040214073603229, -0.34002202961513855, 0.000260762397345,
        0.9040214073603229, 0.3400220296151384, 0.2590951840746235, 0.000260762397345,
        0.9040214073603229, 0.3400220296151384, -0.25909518407462356, 0.000260762397345,
        0.9040214073603229, -0.3400220296151384, 0.2590951840746235, 0.000260762397345,
        0.9040214073603229, -0.3400220296151384, -0.25909518407462356, 0.000260762397345,
        -0.9040214073603229, 0.34002202961513833, 0.2590951840746235, 0.000260762397345,
        -0.9040214073603229, 0.34002202961513833, -0.25909518407462356, 0.000260762397345,
        -0.9040214073603229, -0.34002202961513833, 0.2590951840746235, 0.000260762397345,
        -0.9040214073603229, -0.34002202961513833, -0.25909518407462356, 0.000260762397345,
        0.9040214073603229, 0.2590951840746234, 0.34002202961513844, 0.000260762397345,
        0.9040214073603229, 0.2590951840746234, -0.34002202961513855, 0.000260762397345,
        0.9040214073603229, -0.2590951840746234, 0.34002202961513844, 0.000260762397345,
        0.9040214073603229, -0.2590951840746234, -0.34002202961513855, 0.000260762397345,
        -0.904021407360323, 0.25909518407462323, 0.34002202961513844, 0.000260762397345,
        -0.904021407360323, 0.25909518407462323, -0.34002202961513855, 0.000260762397345,
        -0.904021407360323, -0.25909518407462323, 0.34002202961513844, 0.000260762397345,
        -0.904021407360323, -0.25909518407462323, -0.34002202961513855, 0.000260762397345,
        0.3768217953335509, 0.2951047291750847, 0.878019665713758, 0.000267444103269,
        0.3768217953335508, 0.2951047291750846, -0.8780196657137581, 0.000267444103269,
        0.3768217953335509, -0.2951047291750847, 0.878019665713758, 0.000267444103269,
        0.3768217953335508, -0.2951047291750846, -0.8780196657137581, 0.000267444103269,
        -0.376821795333551, 0.2951047291750846, 0.878019665713758, 0.000267444103269,
        -0.37682179533355087, 0.29510472917508457, -0.8780196657137581, 0.000267444103269,
        -0.376821795333551, -0.2951047291750846, 0.878019665713758, 0.000267444103269,
        -0.37682179533355087, -0.29510472917508457, -0.8780196657137581, 0.000267444103269,
        0.37682179533355104, 0.878019665713758, 0.29510472917508457, 0.000267444103269,
        0.37682179533355104, 0.878019665713758, -0.2951047291750847, 0.000267444103269,
        0.37682179533355104, -0.878019665713758, 0.29510472917508457, 0.000267444103269,
        0.37682179533355104, -0.878019665713758, -0.2951047291750847, 0.000267444103269,
        -0.37682179533355115, 0.8780196657137579, 0.29510472917508457, 0.000267444103269,
        -0.37682179533355115, 0.8780196657137579, -0.2951047291750847, 0.000267444103269,
        -0.37682179533355115, -0.8780196657137579, 0.29510472917508457, 0.000267444103269,
        -0.37682179533355115, -0.8780196657137579, -0.2951047291750847, 0.000267444103269,
        0.2951047291750846, 0.376821795333551, 0.878019665713758, 0.000267444103269,
        0.29510472917508457, 0.37682179533355087, -0.8780196657137581, 0.000267444103269,
        0.2951047291750846, -0.376821795333551, 0.878019665713758, 0.000267444103269,
        0.29510472917508457, -0.37682179533355087, -0.8780196657137581, 0.000267444103269,
        -0.2951047291750849, 0.37682179533355076, 0.878019665713758, 0.000267444103269,
        -0.2951047291750848, 0.37682179533355065, -0.8780196657137581, 0.000267444103269,
        -0.2951047291750849, -0.37682179533355076, 0.878019665713758, 0.000267444103269,
        -0.2951047291750848, -0.37682179533355065, -0.8780196657137581, 0.000267444103269,
        0.29510472917508473, 0.878019665713758, 0.37682179533355087, 0.000267444103269,
        0.29510472917508473, 0.878019665713758, -0.3768217953335512, 0.000267444103269,
        0.29510472917508473, -0.878019665713758, 0.37682179533355087, 0.000267444103269,
        0.29510472917508473, -0.878019665713758, -0.3768217953335512, 0.000267444103269,
        -0.2951047291750846, 0.878019665713758, 0.37682179533355087, 0.000267444103269,
        -0.2951047291750846, 0.878019665713758, -0.3768217953335512, 0.000267444103269,
        -0.2951047291750846, -0.878019665713758, 0.37682179533355087, 0.000267444103269,
        -0.2951047291750846, -0.878019665713758, -0.3768217953335512, 0.000267444103269,
        0.878019665713758, 0.3768217953335509, 0.29510472917508457, 0.000267444103269,
        0.878019665713758, 0.3768217953335509, -0.2951047291750847, 0.000267444103269,
        0.878019665713758, -0.3768217953335509, 0.29510472917508457, 0.000267444103269,
        0.878019665713758, -0.3768217953335509, -0.2951047291750847, 0.000267444103269,
        -0.8780196657137579, 0.3768217953335511, 0.29510472917508457, 0.000267444103269,
        -0.8780196657137579, 0.3768217953335511, -0.2951047291750847, 0.000267444103269,
        -0.8780196657137579, -0.3768217953335511, 0.29510472917508457, 0.000267444103269,
        -0.8780196657137579, -0.3768217953335511, -0.2951047291750847, 0.000267444103269,
        0.878019665713758, 0.29510472917508496, 0.37682179533355087, 0.000267444103269,
        0.8780196657137579, 0.2951047291750849, -0.3768217953335512, 0.000267444103269,
        0.878019665713758, -0.29510472917508496, 0.37682179533355087, 0.000267444103269,
        0.8780196657137579, -0.2951047291750849, -0.3768217953335512, 0.000267444103269,
        -0.878019665713758, 0.2951047291750848, 0.37682179533355087, 0.000267444103269,
        -0.878019665713758, 0.2951047291750848, -0.3768217953335512, 0.000267444103269,
        -0.878019665713758, -0.2951047291750848, 0.37682179533355087, 0.000267444103269,
        -0.878019665713758, -0.2951047291750848, -0.3768217953335512, 0.000267444103269,
        0.4128372900921885, 0.330701971416993, 0.8486469100929153, 0.000272643236034,
        0.4128372900921884, 0.33070197141699287, -0.8486469100929153, 0.000272643236034,
        0.4128372900921885, -0.330701971416993, 0.8486469100929153, 0.000272643236034,
        0.4128372900921884, -0.33070197141699287, -0.8486469100929153, 0.000272643236034,
        -0.4128372900921885, 0.33070197141699303, 0.8486469100929153, 0.000272643236034,
        -0.4128372900921884, 0.330701971416993, -0.8486469100929153, 0.000272643236034,
        -0.4128372900921885, -0.33070197141699303, 0.8486469100929153, 0.000272643236034,
        -0.4128372900921884, -0.330701971416993, -0.8486469100929153, 0.000272643236034,
        0.41283729009218856, 0.8486469100929153, 0.33070197141699287, 0.000272643236034,
        0.4128372900921885, 0.8486469100929152, -0.330701971416993, 0.000272643236034,
        0.41283729009218856, -0.8486469100929153, 0.33070197141699287, 0.000272643236034,
        0.4128372900921885, -0.8486469100929152, -0.330701971416993, 0.000272643236034,
        -0.41283729009218845, 0.8486469100929154, 0.33070197141699287, 0.000272643236034,
        -0.4128372900921884, 0.8486469100929153, -0.330701971416993, 0.000272643236034,
        -0.41283729009218845, -0.8486469100929154, 0.33070197141699287, 0.000272643236034,
        -0.4128372900921884, -0.8486469100929153, -0.330701971416993, 0.000272643236034,
        0.33070197141699303, 0.41283729009218845, 0.8486469100929153, 0.000272643236034,
        0.330701971416993, 0.41283729009218834, -0.8486469100929153, 0.000272643236034,
        0.33070197141699303, -0.41283729009218845, 0.8486469100929153, 0.000272643236034,
        0.330701971416993, -0.41283729009218834, -0.8486469100929153, 0.000272643236034,
        -0.33070197141699315, 0.4128372900921884, 0.8486469100929153, 0.000272643236034,
        -0.3307019714169931, 0.4128372900921883, -0.8486469100929153, 0.000272643236034,
        -0.33070197141699315, -0.4128372900921884, 0.8486469100929153, 0.000272643236034,
        -0.3307019714169931, -0.4128372900921883, -0.8486469100929153, 0.000272643236034,
        0.3307019714169929, 0.8486469100929153, 0.41283729009218845, 0.000272643236034,
        0.330701971416993, 0.8486469100929154, -0.41283729009218834, 0.000272643236034,
        0.3307019714169929, -0.8486469100929153, 0.41283729009218845, 0.000272643236034,
        0.330701971416993, -0.8486469100929154, -0.41283729009218834, 0.000272643236034,
        -0.3307019714169932, 0.8486469100929152, 0.41283729009218845, 0.000272643236034,
        -0.33070197141699326, 0.8486469100929153, -0.41283729009218834, 0.000272643236034,
        -0.3307019714169932, -0.8486469100929152, 0.41283729009218845, 0.000272643236034,
        -0.33070197141699326, -0.8486469100929153, -0.41283729009218834, 0.000272643236034,
        0.8486469100929154, 0.41283729009218834, 0.33070197141699287, 0.000272643236034,
        0.8486469100929153, 0.4128372900921883, -0.330701971416993, 0.000272643236034,
        0.8486469100929154, -0.41283729009218834, 0.33070197141699287, 0.000272643236034,
        0.8486469100929153, -0.4128372900921883, -0.330701971416993, 0.000272643236034,
        -0.8486469100929156, 0.4128372900921878, 0.33070197141699287, 0.000272643236034,
        -0.8486469100929155, 0.4128372900921878, -0.330701971416993, 0.000272643236034,
        -0.8486469100929156, -0.4128372900921878, 0.33070197141699287, 0.000272643236034,
        -0.8486469100929155, -0.4128372900921878, -0.330701971416993, 0.000272643236034,
        0.8486469100929153, 0.3307019714169929, 0.41283729009218845, 0.000272643236034,
        0.8486469100929154, 0.3307019714169929, -0.41283729009218834, 0.000272643236034,
        0.8486469100929153, -0.3307019714169929, 0.41283729009218845, 0.000272643236034,
        0.8486469100929154, -0.3307019714169929, -0.41283729009218834, 0.000272643236034,
        -0.8486469100929155, 0.3307019714169924, 0.41283729009218845, 0.000272643236034,
        -0.8486469100929156, 0.3307019714169925, -0.41283729009218834, 0.000272643236034,
        -0.8486469100929155, -0.3307019714169924, 0.41283729009218845, 0.000272643236034,
        -0.8486469100929156, -0.3307019714169925, -0.41283729009218834, 0.000272643236034,
        0.44788071318156303, 0.36565441010876326, 0.8159042340421986, 0.000276578768592,
        0.4478807131815631, 0.3656544101087633, -0.8159042340421986, 0.000276578768592,
        0.44788071318156303, -0.36565441010876326, 0.8159042340421986, 0.000276578768592,
        0.4478807131815631, -0.3656544101087633, -0.8159042340421986, 0.000276578768592,
        -0.4478807131815631, 0.36565441010876326, 0.8159042340421986, 0.000276578768592,
        -0.44788071318156314, 0.3656544101087633, -0.8159042340421986, 0.000276578768592,
        -0.4478807131815631, -0.36565441010876326, 0.8159042340421986, 0.000276578768592,
        -0.44788071318156314, -0.3656544101087633, -0.8159042340421986, 0.000276578768592,
        0.44788071318156303, 0.8159042340421985, 0.3656544101087634, 0.000276578768592,
        0.44788071318156303, 0.8159042340421985, -0.3656544101087635, 0.000276578768592,
        0.44788071318156303, -0.8159042340421985, 0.3656544101087634, 0.000276578768592,
        0.44788071318156303, -0.8159042340421985, -0.3656544101087635, 0.000276578768592,
        -0.44788071318156314, 0.8159042340421985, 0.3656544101087634, 0.000276578768592,
        -0.44788071318156314, 0.8159042340421985, -0.3656544101087635, 0.000276578768592,
        -0.44788071318156314, -0.8159042340421985, 0.3656544101087634, 0.000276578768592,
        -0.44788071318156314, -0.8159042340421985, -0.3656544101087635, 0.000276578768592,
        0.3656544101087634, 0.44788071318156286, 0.8159042340421986, 0.000276578768592,
        0.36565441010876343, 0.447880713181563, -0.8159042340421986, 0.000276578768592,
        0.3656544101087634, -0.44788071318156286, 0.8159042340421986, 0.000276578768592,
        0.36565441010876343, -0.447880713181563, -0.8159042340421986, 0.000276578768592,
        -0.3656544101087633, 0.4478807131815629, 0.8159042340421986, 0.000276578768592,
        -0.3656544101087634, 0.44788071318156303, -0.8159042340421986, 0.000276578768592,
        -0.3656544101087633, -0.4478807131815629, 0.8159042340421986, 0.000276578768592,
        -0.3656544101087634, -0.44788071318156303, -0.8159042340421986, 0.000276578768592,
        0.36565441010876343, 0.8159042340421986, 0.447880713181563, 0.000276578768592,
        0.36565441010876343, 0.8159042340421986, -0.4478807131815631, 0.000276578768592,
        0.36565441010876343, -0.8159042340421986, 0.447880713181563, 0.000276578768592,
        0.36565441010876343, -0.8159042340421986, -0.4478807131815631, 0.000276578768592,
        -0.3656544101087633, 0.8159042340421986, 0.447880713181563, 0.000276578768592,
        -0.3656544101087633, 0.8159042340421986, -0.4478807131815631, 0.000276578768592,
        -0.3656544101087633, -0.8159042340421986, 0.447880713181563, 0.000276578768592,
        -0.3656544101087633, -0.8159042340421986, -0.4478807131815631, 0.000276578768592,
        0.8159042340421986, 0.4478807131815629, 0.3656544101087634, 0.000276578768592,
        0.8159042340421986, 0.4478807131815629, -0.3656544101087635, 0.000276578768592,
        0.8159042340421986, -0.4478807131815629, 0.3656544101087634, 0.000276578768592,
        0.8159042340421986, -0.4478807131815629, -0.3656544101087635, 0.000276578768592,
        -0.8159042340421986, 0.4478807131815629, 0.3656544101087634, 0.000276578768592,
        -0.8159042340421986, 0.4478807131815629, -0.3656544101087635, 0.000276578768592,
        -0.8159042340421986, -0.4478807131815629, 0.3656544101087634, 0.000276578768592,
        -0.8159042340421986, -0.4478807131815629, -0.3656544101087635, 0.000276578768592,
        0.8159042340421986, 0.36565441010876343, 0.447880713181563, 0.000276578768592,
        0.8159042340421986, 0.36565441010876343, -0.4478807131815631, 0.000276578768592,
        0.8159042340421986, -0.36565441010876343, 0.447880713181563, 0.000276578768592,
        0.8159042340421986, -0.36565441010876343, -0.4478807131815631, 0.000276578768592,
        -0.8159042340421987, 0.36565441010876326, 0.447880713181563, 0.000276578768592,
        -0.8159042340421987, 0.36565441010876326, -0.4478807131815631, 0.000276578768592,
        -0.8159042340421987, -0.36565441010876326, 0.447880713181563, 0.000276578768592,
        -0.8159042340421987, -0.36565441010876326, -0.4478807131815631, 0.000276578768592,
        0.4817742034089258, 0.39974489519396955, 0.7798061526405504, 0.000279442869064,
        0.48177420340892585, 0.3997448951939696, -0.7798061526405503, 0.000279442869064,
        0.4817742034089258, -0.39974489519396955, 0.7798061526405504, 0.000279442869064,
        0.48177420340892585, -0.3997448951939696, -0.7798061526405503, 0.000279442869064,
        -0.48177420340892585, 0.3997448951939694, 0.7798061526405504, 0.000279442869064,
        -0.4817742034089259, 0.39974489519396944, -0.7798061526405503, 0.000279442869064,
        -0.48177420340892585, -0.3997448951939694, 0.7798061526405504, 0.000279442869064,
        -0.4817742034089259, -0.39974489519396944, -0.7798061526405503, 0.000279442869064,
        0.4817742034089257, 0.7798061526405504, 0.3997448951939695, 0.000279442869064,
        0.4817742034089256, 0.7798061526405503, -0.3997448951939698, 0.000279442869064,
        0.4817742034089257, -0.7798061526405504, 0.3997448951939695, 0.000279442869064,
        0.4817742034089256, -0.7798061526405503, -0.3997448951939698, 0.000279442869064,
        -0.4817742034089258, 0.7798061526405504, 0.3997448951939695, 0.000279442869064,
        -0.48177420340892574, 0.7798061526405503, -0.3997448951939698, 0.000279442869064,
        -0.4817742034089258, -0.7798061526405504, 0.3997448951939695, 0.000279442869064,
        -0.48177420340892574, -0.7798061526405503, -0.3997448951939698, 0.000279442869064,
        0.39974489519396955, 0.4817742034089258, 0.7798061526405504, 0.000279442869064,
        0.3997448951939696, 0.48177420340892585, -0.7798061526405503, 0.000279442869064,
        0.39974489519396955, -0.4817742034089258, 0.7798061526405504, 0.000279442869064,
        0.3997448951939696, -0.48177420340892585, -0.7798061526405503, 0.000279442869064,
        -0.39974489519396955, 0.4817742034089258, 0.7798061526405504, 0.000279442869064,
        -0.3997448951939696, 0.48177420340892585, -0.7798061526405503, 0.000279442869064,
        -0.39974489519396955, -0.4817742034089258, 0.7798061526405504, 0.000279442869064,
        -0.3997448951939696, -0.48177420340892585, -0.7798061526405503, 0.000279442869064,
        0.39974489519396955, 0.7798061526405504, 0.4817742034089257, 0.000279442869064,
        0.3997448951939696, 0.7798061526405505, -0.48177420340892557, 0.000279442869064,
        0.39974489519396955, -0.7798061526405504, 0.4817742034089257, 0.000279442869064,
        0.3997448951939696, -0.7798061526405505, -0.48177420340892557, 0.000279442869064,
        -0.3997448951939696, 0.7798061526405503, 0.4817742034089257, 0.000279442869064,
        -0.39974489519396966, 0.7798061526405504, -0.48177420340892557, 0.000279442869064,
        -0.3997448951939696, -0.7798061526405503, 0.4817742034089257, 0.000279442869064,
        -0.39974489519396966, -0.7798061526405504, -0.48177420340892557, 0.000279442869064,
        0.7798061526405504, 0.4817742034089258, 0.3997448951939695, 0.000279442869064,
        0.7798061526405503, 0.48177420340892574, -0.3997448951939698, 0.000279442869064,
        0.7798061526405504, -0.4817742034089258, 0.3997448951939695, 0.000279442869064,
        0.7798061526405503, -0.48177420340892574, -0.3997448951939698, 0.000279442869064,
        -0.7798061526405503, 0.48177420340892596, 0.3997448951939695, 0.000279442869064,
        -0.7798061526405502, 0.4817742034089259, -0.3997448951939698, 0.000279442869064,
        -0.7798061526405503, -0.48177420340892596, 0.3997448951939695, 0.000279442869064,
        -0.7798061526405502, -0.4817742034089259, -0.3997448951939698, 0.000279442869064,
        0.7798061526405504, 0.39974489519396955, 0.4817742034089257, 0.000279442869064,
        0.7798061526405505, 0.3997448951939696, -0.48177420340892557, 0.000279442869064,
        0.7798061526405504, -0.39974489519396955, 0.4817742034089257, 0.000279442869064,
        0.7798061526405505, -0.3997448951939696, -0.48177420340892557, 0.000279442869064,
        -0.7798061526405505, 0.3997448951939694, 0.4817742034089257, 0.000279442869064,
        -0.7798061526405506, 0.39974489519396944, -0.48177420340892557, 0.000279442869064,
        -0.7798061526405505, -0.3997448951939694, 0.4817742034089257, 0.000279442869064,
        -0.7798061526405506, -0.39974489519396944, -0.48177420340892557, 0.000279442869064,
        0.5143472814653343, 0.43276671108120246, 0.7403781789255942, 0.000281409900206,
        0.5143472814653341, 0.43276671108120235, -0.7403781789255943, 0.000281409900206,
        0.5143472814653343, -0.43276671108120246, 0.7403781789255942, 0.000281409900206,
        0.5143472814653341, -0.43276671108120235, -0.7403781789255943, 0.000281409900206,
        -0.5143472814653343, 0.43276671108120246, 0.7403781789255942, 0.000281409900206,
        -0.5143472814653341, 0.43276671108120235, -0.7403781789255943, 0.000281409900206,
        -0.5143472814653343, -0.43276671108120246, 0.7403781789255942, 0.000281409900206,
        -0.5143472814653341, -0.43276671108120235, -0.7403781789255943, 0.000281409900206,
        0.5143472814653344, 0.7403781789255943, 0.43276671108120235, 0.000281409900206,
        0.5143472814653344, 0.7403781789255943, -0.43276671108120224, 0.000281409900206,
        0.5143472814653344, -0.7403781789255943, 0.43276671108120235, 0.000281409900206,
        0.5143472814653344, -0.7403781789255943, -0.43276671108120224, 0.000281409900206,
        -0.5143472814653344, 0.7403781789255943, 0.43276671108120235, 0.000281409900206,
        -0.5143472814653344, 0.7403781789255943, -0.43276671108120224, 0.000281409900206,
        -0.5143472814653344, -0.7403781789255943, 0.43276671108120235, 0.000281409900206,
        -0.5143472814653344, -0.7403781789255943, -0.43276671108120224, 0.000281409900206,
        0.43276671108120246, 0.5143472814653344, 0.7403781789255942, 0.000281409900206,
        0.43276671108120235, 0.5143472814653343, -0.7403781789255943, 0.000281409900206,
        0.43276671108120246, -0.5143472814653344, 0.7403781789255942, 0.000281409900206,
        0.43276671108120235, -0.5143472814653343, -0.7403781789255943, 0.000281409900206,
        -0.43276671108120235, 0.5143472814653344, 0.7403781789255942, 0.000281409900206,
        -0.4327667110812023, 0.5143472814653343, -0.7403781789255943, 0.000281409900206,
        -0.43276671108120235, -0.5143472814653344, 0.7403781789255942, 0.000281409900206,
        -0.4327667110812023, -0.5143472814653343, -0.7403781789255943, 0.000281409900206,
        0.43276671108120235, 0.7403781789255942, 0.5143472814653344, 0.000281409900206,
        0.43276671108120235, 0.7403781789255942, -0.5143472814653345, 0.000281409900206,
        0.43276671108120235, -0.7403781789255942, 0.5143472814653344, 0.000281409900206,
        0.43276671108120235, -0.7403781789255942, -0.5143472814653345, 0.000281409900206,
        -0.43276671108120235, 0.7403781789255942, 0.5143472814653344, 0.000281409900206,
        -0.43276671108120235, 0.7403781789255942, -0.5143472814653345, 0.000281409900206,
        -0.43276671108120235, -0.7403781789255942, 0.5143472814653344, 0.000281409900206,
        -0.43276671108120235, -0.7403781789255942, -0.5143472814653345, 0.000281409900206,
        0.7403781789255942, 0.5143472814653345, 0.43276671108120235, 0.000281409900206,
        0.7403781789255942, 0.5143472814653345, -0.43276671108120224, 0.000281409900206,
        0.7403781789255942, -0.5143472814653345, 0.43276671108120235, 0.000281409900206,
        0.7403781789255942, -0.5143472814653345, -0.43276671108120224, 0.000281409900206,
        -0.7403781789255942, 0.5143472814653345, 0.43276671108120235, 0.000281409900206,
        -0.7403781789255942, 0.5143472814653345, -0.43276671108120224, 0.000281409900206,
        -0.7403781789255942, -0.5143472814653345, 0.43276671108120235, 0.000281409900206,
        -0.7403781789255942, -0.5143472814653345, -0.43276671108120224, 0.000281409900206,
        0.7403781789255942, 0.43276671108120257, 0.5143472814653344, 0.000281409900206,
        0.7403781789255942, 0.43276671108120257, -0.5143472814653345, 0.000281409900206,
        0.7403781789255942, -0.43276671108120257, 0.5143472814653344, 0.000281409900206,
        0.7403781789255942, -0.43276671108120257, -0.5143472814653345, 0.000281409900206,
        -0.7403781789255942, 0.43276671108120246, 0.5143472814653344, 0.000281409900206,
        -0.7403781789255942, 0.43276671108120246, -0.5143472814653345, 0.000281409900206,
        -0.7403781789255942, -0.43276671108120246, 0.5143472814653344, 0.000281409900206,
        -0.7403781789255942, -0.43276671108120246, -0.5143472814653345, 0.000281409900206,
        0.545434621390565, 0.46451961235322936, 0.6976550748957083, 0.000282642953158,
        0.545434621390565, 0.4645196123532293, -0.6976550748957085, 0.000282642953158,
        0.545434621390565, -0.46451961235322936, 0.6976550748957083, 0.000282642953158,
        0.545434621390565, -0.4645196123532293, -0.6976550748957085, 0.000282642953158,
        -0.5454346213905651, 0.4645196123532293, 0.6976550748957083, 0.000282642953158,
        -0.545434621390565, 0.4645196123532292, -0.6976550748957085, 0.000282642953158,
        -0.5454346213905651, -0.4645196123532293, 0.6976550748957083, 0.000282642953158,
        -0.545434621390565, -0.4645196123532292, -0.6976550748957085, 0.000282642953158,
        0.545434621390565, 0.6976550748957084, 0.4645196123532294, 0.000282642953158,
        0.5454346213905649, 0.6976550748957083, -0.46451961235322947, 0.000282642953158,
        0.545434621390565, -0.6976550748957084, 0.4645196123532294, 0.000282642953158,
        0.5454346213905649, -0.6976550748957083, -0.46451961235322947, 0.000282642953158,
        -0.5454346213905652, 0.6976550748957083, 0.4645196123532294, 0.000282642953158,
        -0.5454346213905651, 0.6976550748957082, -0.46451961235322947, 0.000282642953158,
        -0.5454346213905652, -0.6976550748957083, 0.4645196123532294, 0.000282642953158,
        -0.5454346213905651, -0.6976550748957082, -0.46451961235322947, 0.000282642953158,
        0.46451961235322936, 0.545434621390565, 0.6976550748957083, 0.000282642953158,
        0.4645196123532293, 0.545434621390565, -0.6976550748957085, 0.000282642953158,
        0.46451961235322936, -0.545434621390565, 0.6976550748957083, 0.000282642953158,
        0.4645196123532293, -0.545434621390565, -0.6976550748957085, 0.000282642953158,
        -0.4645196123532294, 0.545434621390565, 0.6976550748957083, 0.000282642953158,
        -0.46451961235322936, 0.545434621390565, -0.6976550748957085, 0.000282642953158,
        -0.4645196123532294, -0.545434621390565, 0.6976550748957083, 0.000282642953158,
        -0.46451961235322936, -0.545434621390565, -0.6976550748957085, 0.000282642953158,
        0.46451961235322936, 0.6976550748957084, 0.545434621390565, 0.000282642953158,
        0.4645196123532293, 0.6976550748957083, -0.5454346213905652, 0.000282642953158,
        0.46451961235322936, -0.6976550748957084, 0.545434621390565, 0.000282642953158,
        0.4645196123532293, -0.6976550748957083, -0.5454346213905652, 0.000282642953158,
        -0.4645196123532296, 0.6976550748957083, 0.545434621390565, 0.000282642953158,
        -0.4645196123532295, 0.6976550748957082, -0.5454346213905652, 0.000282642953158,
        -0.4645196123532296, -0.6976550748957083, 0.545434621390565, 0.000282642953158,
        -0.4645196123532295, -0.6976550748957082, -0.5454346213905652, 0.000282642953158,
        0.6976550748957084, 0.545434621390565, 0.4645196123532294, 0.000282642953158,
        0.6976550748957083, 0.5454346213905649, -0.46451961235322947, 0.000282642953158,
        0.6976550748957084, -0.545434621390565, 0.4645196123532294, 0.000282642953158,
        0.6976550748957083, -0.5454346213905649, -0.46451961235322947, 0.000282642953158,
        -0.6976550748957084, 0.545434621390565, 0.4645196123532294, 0.000282642953158,
        -0.6976550748957083, 0.5454346213905649, -0.46451961235322947, 0.000282642953158,
        -0.6976550748957084, -0.545434621390565, 0.4645196123532294, 0.000282642953158,
        -0.6976550748957083, -0.5454346213905649, -0.46451961235322947, 0.000282642953158,
        0.6976550748957085, 0.4645196123532293, 0.545434621390565, 0.000282642953158,
        0.6976550748957084, 0.46451961235322925, -0.5454346213905652, 0.000282642953158,
        0.6976550748957085, -0.4645196123532293, 0.545434621390565, 0.000282642953158,
        0.6976550748957084, -0.46451961235322925, -0.5454346213905652, 0.000282642953158,
        -0.6976550748957085, 0.46451961235322936, 0.545434621390565, 0.000282642953158,
        -0.6976550748957084, 0.4645196123532293, -0.5454346213905652, 0.000282642953158,
        -0.6976550748957085, -0.46451961235322936, 0.545434621390565, 0.000282642953158,
        -0.6976550748957084, -0.4645196123532293, -0.5454346213905652, 0.000282642953158,
        0.5748739313170252, 0.4948063555703344, 0.6516798551277397, 0.000283298354255,
        0.5748739313170251, 0.49480635557033426, -0.6516798551277401, 0.000283298354255,
        0.5748739313170252, -0.4948063555703344, 0.6516798551277397, 0.000283298354255,
        0.5748739313170251, -0.49480635557033426, -0.6516798551277401, 0.000283298354255,
        -0.5748739313170252, 0.4948063555703344, 0.6516798551277397, 0.000283298354255,
        -0.5748739313170251, 0.49480635557033426, -0.6516798551277401, 0.000283298354255,
        -0.5748739313170252, -0.4948063555703344, 0.6516798551277397, 0.000283298354255,
        -0.5748739313170251, -0.49480635557033426, -0.6516798551277401, 0.000283298354255,
        0.5748739313170251, 0.6516798551277397, 0.4948063555703346, 0.000283298354255,
        0.5748739313170251, 0.6516798551277397, -0.49480635557033464, 0.000283298354255,
        0.5748739313170251, -0.6516798551277397, 0.4948063555703346, 0.000283298354255,
        0.5748739313170251, -0.6516798551277397, -0.49480635557033464, 0.000283298354255,
        -0.574873931317025, 0.6516798551277398, 0.4948063555703346, 0.000283298354255,
        -0.574873931317025, 0.6516798551277398, -0.49480635557033464, 0.000283298354255,
        -0.574873931317025, -0.6516798551277398, 0.4948063555703346, 0.000283298354255,
        -0.574873931317025, -0.6516798551277398, -0.49480635557033464, 0.000283298354255,
        0.4948063555703345, 0.5748739313170252, 0.6516798551277397, 0.000283298354255,
        0.4948063555703343, 0.5748739313170251, -0.6516798551277401, 0.000283298354255,
        0.4948063555703345, -0.5748739313170252, 0.6516798551277397, 0.000283298354255,
        0.4948063555703343, -0.5748739313170251, -0.6516798551277401, 0.000283298354255,
        -0.4948063555703346, 0.5748739313170252, 0.6516798551277397, 0.000283298354255,
        -0.4948063555703344, 0.574873931317025, -0.6516798551277401, 0.000283298354255,
        -0.4948063555703346, -0.5748739313170252, 0.6516798551277397, 0.000283298354255,
        -0.4948063555703344, -0.574873931317025, -0.6516798551277401, 0.000283298354255,
        0.49480635557033453, 0.6516798551277398, 0.5748739313170251, 0.000283298354255,
        0.49480635557033453, 0.6516798551277398, -0.5748739313170251, 0.000283298354255,
        0.49480635557033453, -0.6516798551277398, 0.5748739313170251, 0.000283298354255,
        0.49480635557033453, -0.6516798551277398, -0.5748739313170251, 0.000283298354255,
        -0.4948063555703346, 0.6516798551277397, 0.5748739313170251, 0.000283298354255,
        -0.4948063555703346, 0.6516798551277397, -0.5748739313170251, 0.000283298354255,
        -0.4948063555703346, -0.6516798551277397, 0.5748739313170251, 0.000283298354255,
        -0.4948063555703346, -0.6516798551277397, -0.5748739313170251, 0.000283298354255,
        0.6516798551277396, 0.5748739313170252, 0.4948063555703346, 0.000283298354255,
        0.6516798551277396, 0.5748739313170252, -0.49480635557033464, 0.000283298354255,
        0.6516798551277396, -0.5748739313170252, 0.4948063555703346, 0.000283298354255,
        0.6516798551277396, -0.5748739313170252, -0.49480635557033464, 0.000283298354255,
        -0.6516798551277397, 0.5748739313170251, 0.4948063555703346, 0.000283298354255,
        -0.6516798551277397, 0.5748739313170251, -0.49480635557033464, 0.000283298354255,
        -0.6516798551277397, -0.5748739313170251, 0.4948063555703346, 0.000283298354255,
        -0.6516798551277397, -0.5748739313170251, -0.49480635557033464, 0.000283298354255,
        0.6516798551277397, 0.4948063555703346, 0.5748739313170251, 0.000283298354255,
        0.6516798551277397, 0.4948063555703346, -0.5748739313170251, 0.000283298354255,
        0.6516798551277397, -0.4948063555703346, 0.5748739313170251, 0.000283298354255,
        0.6516798551277397, -0.4948063555703346, -0.5748739313170251, 0.000283298354255,
        -0.6516798551277398, 0.4948063555703344, 0.5748739313170251, 0.000283298354255,
        -0.6516798551277398, 0.4948063555703344, -0.5748739313170251, 0.000283298354255,
        -0.6516798551277398, -0.4948063555703344, 0.5748739313170251, 0.000283298354255,
        -0.6516798551277398, -0.4948063555703344, -0.5748739313170251, 0.000283298354255,
        0.1599598738286338, 0.027923575900489706, 0.986728489845944, 0.000188669556528,
        0.159959873828634, 0.02792357590048974, -0.986728489845944, 0.000188669556528,
        0.1599598738286338, -0.027923575900489706, 0.986728489845944, 0.000188669556528,
        0.159959873828634, -0.02792357590048974, -0.986728489845944, 0.000188669556528,
        -0.1599598738286338, 0.027923575900489717, 0.986728489845944, 0.000188669556528,
        -0.159959873828634, 0.027923575900489748, -0.986728489845944, 0.000188669556528,
        -0.1599598738286338, -0.027923575900489717, 0.986728489845944, 0.000188669556528,
        -0.159959873828634, -0.027923575900489748, -0.986728489845944, 0.000188669556528,
        0.15995987382863422, 0.9867284898459439, 0.02792357590048979, 0.000188669556528,
        0.15995987382863422, 0.9867284898459439, -0.02792357590048989, 0.000188669556528,
        0.15995987382863422, -0.9867284898459439, 0.02792357590048979, 0.000188669556528,
        0.15995987382863422, -0.9867284898459439, -0.02792357590048989, 0.000188669556528,
        -0.15995987382863408, 0.9867284898459439, 0.02792357590048979, 0.000188669556528,
        -0.15995987382863408, 0.9867284898459439, -0.02792357590048989, 0.000188669556528,
        -0.15995987382863408, -0.9867284898459439, 0.02792357590048979, 0.000188669556528,
        -0.15995987382863408, -0.9867284898459439, -0.02792357590048989, 0.000188669556528,
        0.02792357590048978, 0.1599598738286338, 0.986728489845944, 0.000188669556528,
        0.027923575900489814, 0.159959873828634, -0.986728489845944, 0.000188669556528,
        0.02792357590048978, -0.1599598738286338, 0.986728489845944, 0.000188669556528,
        0.027923575900489814, -0.159959873828634, -0.986728489845944, 0.000188669556528,
        -0.027923575900489793, 0.1599598738286338, 0.986728489845944, 0.000188669556528,
        -0.027923575900489828, 0.159959873828634, -0.986728489845944, 0.000188669556528,
        -0.027923575900489793, -0.1599598738286338, 0.986728489845944, 0.000188669556528,
        -0.027923575900489828, -0.159959873828634, -0.986728489845944, 0.000188669556528,
        0.027923575900489803, 0.986728489845944, 0.1599598738286341, 0.000188669556528,
        0.027923575900489803, 0.986728489845944, -0.1599598738286342, 0.000188669556528,
        0.027923575900489803, -0.986728489845944, 0.1599598738286341, 0.000188669556528,
        0.027923575900489803, -0.986728489845944, -0.1599598738286342, 0.000188669556528,
        -0.027923575900489904, 0.986728489845944, 0.1599598738286341, 0.000188669556528,
        -0.027923575900489904, 0.986728489845944, -0.1599598738286342, 0.000188669556528,
        -0.027923575900489904, -0.986728489845944, 0.1599598738286341, 0.000188669556528,
        -0.027923575900489904, -0.986728489845944, -0.1599598738286342, 0.000188669556528,
        0.9867284898459439, 0.1599598738286341, 0.02792357590048979, 0.000188669556528,
        0.9867284898459439, 0.1599598738286341, -0.02792357590048989, 0.000188669556528,
        0.9867284898459439, -0.1599598738286341, 0.02792357590048979, 0.000188669556528,
        0.9867284898459439, -0.1599598738286341, -0.02792357590048989, 0.000188669556528,
        -0.9867284898459439, 0.15995987382863427, 0.02792357590048979, 0.000188669556528,
        -0.9867284898459439, 0.15995987382863427, -0.02792357590048989, 0.000188669556528,
        -0.9867284898459439, -0.15995987382863427, 0.02792357590048979, 0.000188669556528,
        -0.9867284898459439, -0.15995987382863427, -0.02792357590048989, 0.000188669556528,
        0.9867284898459439, 0.027923575900492274, 0.1599598738286341, 0.000188669556528,
        0.9867284898459439, 0.027923575900492274, -0.1599598738286342, 0.000188669556528,
        0.9867284898459439, -0.027923575900492274, 0.1599598738286341, 0.000188669556528,
        0.9867284898459439, -0.027923575900492274, -0.1599598738286342, 0.000188669556528,
        -0.9867284898459439, 0.027923575900492274, 0.1599598738286341, 0.000188669556528,
        -0.9867284898459439, 0.027923575900492274, -0.1599598738286342, 0.000188669556528,
        -0.9867284898459439, -0.027923575900492274, 0.1599598738286341, 0.000188669556528,
        -0.9867284898459439, -0.027923575900492274, -0.1599598738286342, 0.000188669556528,
        0.19980974125009515, 0.058771410381390644, 0.9780705437867722, 0.000208186788275,
        0.19980974125009518, 0.05877141038139065, -0.9780705437867722, 0.000208186788275,
        0.19980974125009515, -0.058771410381390644, 0.9780705437867722, 0.000208186788275,
        0.19980974125009518, -0.05877141038139065, -0.9780705437867722, 0.000208186788275,
        -0.19980974125009515, 0.05877141038139068, 0.9780705437867722, 0.000208186788275,
        -0.19980974125009518, 0.058771410381390686, -0.9780705437867722, 0.000208186788275,
        -0.19980974125009515, -0.05877141038139068, 0.9780705437867722, 0.000208186788275,
        -0.19980974125009518, -0.058771410381390686, -0.9780705437867722, 0.000208186788275,
        0.19980974125009515, 0.9780705437867722, 0.05877141038139073, 0.000208186788275,
        0.19980974125009515, 0.9780705437867722, -0.0587714103813906, 0.000208186788275,
        0.19980974125009515, -0.9780705437867722, 0.05877141038139073, 0.000208186788275,
        0.19980974125009515, -0.9780705437867722, -0.0587714103813906, 0.000208186788275,
        -0.19980974125009504, 0.9780705437867722, 0.05877141038139073, 0.000208186788275,
        -0.19980974125009504, 0.9780705437867722, -0.0587714103813906, 0.000208186788275,
        -0.19980974125009504, -0.9780705437867722, 0.05877141038139073, 0.000208186788275,
        -0.19980974125009504, -0.9780705437867722, -0.0587714103813906, 0.000208186788275,
        0.058771410381390665, 0.19980974125009515, 0.9780705437867722, 0.000208186788275,
        0.05877141038139068, 0.19980974125009518, -0.9780705437867722, 0.000208186788275,
        0.058771410381390665, -0.19980974125009515, 0.9780705437867722, 0.000208186788275,
        0.05877141038139068, -0.19980974125009518, -0.9780705437867722, 0.000208186788275,
        -0.05877141038139068, 0.19980974125009515, 0.9780705437867722, 0.000208186788275,
        -0.058771410381390686, 0.19980974125009518, -0.9780705437867722, 0.000208186788275,
        -0.05877141038139068, -0.19980974125009515, 0.9780705437867722, 0.000208186788275,
        -0.058771410381390686, -0.19980974125009518, -0.9780705437867722, 0.000208186788275,
        0.058771410381390755, 0.9780705437867722, 0.19980974125009507, 0.000208186788275,
        0.058771410381390755, 0.9780705437867722, -0.19980974125009518, 0.000208186788275,
        0.058771410381390755, -0.9780705437867722, 0.19980974125009507, 0.000208186788275,
        0.058771410381390755, -0.9780705437867722, -0.19980974125009518, 0.000208186788275,
        -0.05877141038139085, 0.9780705437867722, 0.19980974125009507, 0.000208186788275,
        -0.05877141038139085, 0.9780705437867722, -0.19980974125009518, 0.000208186788275,
        -0.05877141038139085, -0.9780705437867722, 0.19980974125009507, 0.000208186788275,
        -0.05877141038139085, -0.9780705437867722, -0.19980974125009518, 0.000208186788275,
        0.9780705437867722, 0.1998097412500951, 0.05877141038139073, 0.000208186788275,
        0.9780705437867722, 0.1998097412500951, -0.0587714103813906, 0.000208186788275,
        0.9780705437867722, -0.1998097412500951, 0.05877141038139073, 0.000208186788275,
        0.9780705437867722, -0.1998097412500951, -0.0587714103813906, 0.000208186788275,
        -0.9780705437867722, 0.1998097412500952, 0.05877141038139073, 0.000208186788275,
        -0.9780705437867722, 0.1998097412500952, -0.0587714103813906, 0.000208186788275,
        -0.9780705437867722, -0.1998097412500952, 0.05877141038139073, 0.000208186788275,
        -0.9780705437867722, -0.1998097412500952, -0.0587714103813906, 0.000208186788275,
        0.9780705437867722, 0.05877141038139013, 0.19980974125009507, 0.000208186788275,
        0.9780705437867722, 0.05877141038139013, -0.19980974125009518, 0.000208186788275,
        0.9780705437867722, -0.05877141038139013, 0.19980974125009507, 0.000208186788275,
        0.9780705437867722, -0.05877141038139013, -0.19980974125009518, 0.000208186788275,
        -0.9780705437867722, 0.05877141038138995, 0.19980974125009507, 0.000208186788275,
        -0.9780705437867722, 0.05877141038138995, -0.19980974125009518, 0.000208186788275,
        -0.9780705437867722, -0.05877141038138995, 0.19980974125009507, 0.000208186788275,
        -0.9780705437867722, -0.05877141038138995, -0.19980974125009518, 0.000208186788275,
        0.23962289525662037, 0.09164573914691386, 0.9665308720186079, 0.00022451486806,
        0.23962289525662026, 0.09164573914691382, -0.9665308720186079, 0.00022451486806,
        0.23962289525662037, -0.09164573914691386, 0.9665308720186079, 0.00022451486806,
        0.23962289525662026, -0.09164573914691382, -0.9665308720186079, 0.00022451486806,
        -0.23962289525662037, 0.09164573914691386, 0.9665308720186079, 0.00022451486806,
        -0.23962289525662026, 0.09164573914691382, -0.9665308720186079, 0.00022451486806,
        -0.23962289525662037, -0.09164573914691386, 0.9665308720186079, 0.00022451486806,
        -0.23962289525662026, -0.09164573914691382, -0.9665308720186079, 0.00022451486806,
        0.23962289525662014, 0.966530872018608, 0.09164573914691367, 0.00022451486806,
        0.23962289525662012, 0.9665308720186079, -0.091645739146914, 0.00022451486806,
        0.23962289525662014, -0.966530872018608, 0.09164573914691367, 0.00022451486806,
        0.23962289525662012, -0.9665308720186079, -0.091645739146914, 0.00022451486806,
        -0.23962289525662023, 0.966530872018608, 0.09164573914691367, 0.00022451486806,
        -0.2396228952566202, 0.9665308720186079, -0.091645739146914, 0.00022451486806,
        -0.23962289525662023, -0.966530872018608, 0.09164573914691367, 0.00022451486806,
        -0.2396228952566202, -0.9665308720186079, -0.091645739146914, 0.00022451486806,
        0.09164573914691385, 0.23962289525662037, 0.9665308720186079, 0.00022451486806,
        0.0916457391469138, 0.23962289525662026, -0.9665308720186079, 0.00022451486806,
        0.09164573914691385, -0.23962289525662037, 0.9665308720186079, 0.00022451486806,
        0.0916457391469138, -0.23962289525662026, -0.9665308720186079, 0.00022451486806,
        -0.09164573914691382, 0.2396228952566204, 0.9665308720186079, 0.00022451486806,
        -0.09164573914691378, 0.23962289525662028, -0.9665308720186079, 0.00022451486806,
        -0.09164573914691382, -0.2396228952566204, 0.9665308720186079, 0.00022451486806,
        -0.09164573914691378, -0.23962289525662028, -0.9665308720186079, 0.00022451486806,
        0.0916457391469137, 0.966530872018608, 0.23962289525661992, 0.00022451486806,
        0.09164573914691368, 0.9665308720186079, -0.23962289525662023, 0.00022451486806,
        0.0916457391469137, -0.966530872018608, 0.23962289525661992, 0.00022451486806,
        0.09164573914691368, -0.9665308720186079, -0.23962289525662023, 0.00022451486806,
        -0.091645739146914, 0.966530872018608, 0.23962289525661992, 0.00022451486806,
        -0.09164573914691398, 0.9665308720186079, -0.23962289525662023, 0.00022451486806,
        -0.091645739146914, -0.966530872018608, 0.23962289525661992, 0.00022451486806,
        -0.09164573914691398, -0.9665308720186079, -0.23962289525662023, 0.00022451486806,
        0.966530872018608, 0.23962289525662026, 0.09164573914691367, 0.00022451486806,
        0.9665308720186079, 0.23962289525662023, -0.091645739146914, 0.00022451486806,
        0.966530872018608, -0.23962289525662026, 0.09164573914691367, 0.00022451486806,
        0.9665308720186079, -0.23962289525662023, -0.091645739146914, 0.00022451486806,
        -0.966530872018608, 0.2396228952566204, 0.09164573914691367, 0.00022451486806,
        -0.9665308720186079, 0.23962289525662037, -0.091645739146914, 0.00022451486806,
        -0.966530872018608, -0.2396228952566204, 0.09164573914691367, 0.00022451486806,
        -0.9665308720186079, -0.23962289525662037, -0.091645739146914, 0.00022451486806,
        0.966530872018608, 0.09164573914691405, 0.23962289525661992, 0.00022451486806,
        0.9665308720186079, 0.09164573914691404, -0.23962289525662023, 0.00022451486806,
        0.966530872018608, -0.09164573914691405, 0.23962289525661992, 0.00022451486806,
        0.9665308720186079, -0.09164573914691404, -0.23962289525662023, 0.00022451486806,
        -0.966530872018608, 0.09164573914691418, 0.23962289525661992, 0.00022451486806,
        -0.9665308720186079, 0.09164573914691417, -0.23962289525662023, 0.00022451486806,
        -0.966530872018608, -0.09164573914691418, 0.23962289525661992, 0.00022451486806,
        -0.9665308720186079, -0.09164573914691417, -0.23962289525662023, 0.00022451486806,
        0.2792228341097747, 0.1259049641962687, 0.9519362105217143, 0.000238037049151,
        0.27922283410977483, 0.12590496419626876, -0.9519362105217143, 0.000238037049151,
        0.2792228341097747, -0.1259049641962687, 0.9519362105217143, 0.000238037049151,
        0.27922283410977483, -0.12590496419626876, -0.9519362105217143, 0.000238037049151,
        -0.27922283410977466, 0.1259049641962688, 0.9519362105217143, 0.000238037049151,
        -0.2792228341097748, 0.12590496419626881, -0.9519362105217143, 0.000238037049151,
        -0.27922283410977466, -0.1259049641962688, 0.9519362105217143, 0.000238037049151,
        -0.2792228341097748, -0.12590496419626881, -0.9519362105217143, 0.000238037049151,
        0.27922283410977455, 0.9519362105217144, 0.1259049641962686, 0.000238037049151,
        0.27922283410977455, 0.9519362105217144, -0.12590496419626868, 0.000238037049151,
        0.27922283410977455, -0.9519362105217144, 0.1259049641962686, 0.000238037049151,
        0.27922283410977455, -0.9519362105217144, -0.12590496419626868, 0.000238037049151,
        -0.2792228341097749, 0.9519362105217143, 0.1259049641962686, 0.000238037049151,
        -0.2792228341097749, 0.9519362105217143, -0.12590496419626868, 0.000238037049151,
        -0.2792228341097749, -0.9519362105217143, 0.1259049641962686, 0.000238037049151,
        -0.2792228341097749, -0.9519362105217143, -0.12590496419626868, 0.000238037049151,
        0.1259049641962687, 0.2792228341097747, 0.9519362105217143, 0.000238037049151,
        0.12590496419626873, 0.27922283410977483, -0.9519362105217143, 0.000238037049151,
        0.1259049641962687, -0.2792228341097747, 0.9519362105217143, 0.000238037049151,
        0.12590496419626873, -0.27922283410977483, -0.9519362105217143, 0.000238037049151,
        -0.12590496419626873, 0.2792228341097747, 0.9519362105217143, 0.000238037049151,
        -0.1259049641962688, 0.27922283410977483, -0.9519362105217143, 0.000238037049151,
        -0.12590496419626873, -0.2792228341097747, 0.9519362105217143, 0.000238037049151,
        -0.1259049641962688, -0.27922283410977483, -0.9519362105217143, 0.000238037049151,
        0.1259049641962687, 0.9519362105217143, 0.27922283410977466, 0.000238037049151,
        0.1259049641962687, 0.9519362105217143, -0.27922283410977455, 0.000238037049151,
        0.1259049641962687, -0.9519362105217143, 0.27922283410977466, 0.000238037049151,
        0.1259049641962687, -0.9519362105217143, -0.27922283410977455, 0.000238037049151,
        -0.1259049641962688, 0.9519362105217143, 0.27922283410977466, 0.000238037049151,
        -0.1259049641962688, 0.9519362105217143, -0.27922283410977455, 0.000238037049151,
        -0.1259049641962688, -0.9519362105217143, 0.27922283410977466, 0.000238037049151,
        -0.1259049641962688, -0.9519362105217143, -0.27922283410977455, 0.000238037049151,
        0.9519362105217143, 0.2792228341097748, 0.1259049641962686, 0.000238037049151,
        0.9519362105217143, 0.2792228341097748, -0.12590496419626868, 0.000238037049151,
        0.9519362105217143, -0.2792228341097748, 0.1259049641962686, 0.000238037049151,
        0.9519362105217143, -0.2792228341097748, -0.12590496419626868, 0.000238037049151,
        -0.9519362105217145, 0.2792228341097742, 0.1259049641962686, 0.000238037049151,
        -0.9519362105217145, 0.2792228341097742, -0.12590496419626868, 0.000238037049151,
        -0.9519362105217145, -0.2792228341097742, 0.1259049641962686, 0.000238037049151,
        -0.9519362105217145, -0.2792228341097742, -0.12590496419626868, 0.000238037049151,
        0.9519362105217143, 0.1259049641962685, 0.27922283410977466, 0.000238037049151,
        0.9519362105217143, 0.1259049641962685, -0.27922283410977455, 0.000238037049151,
        0.9519362105217143, -0.1259049641962685, 0.27922283410977466, 0.000238037049151,
        0.9519362105217143, -0.1259049641962685, -0.27922283410977455, 0.000238037049151,
        -0.9519362105217143, 0.12590496419626834, 0.27922283410977466, 0.000238037049151,
        -0.9519362105217143, 0.12590496419626834, -0.27922283410977455, 0.000238037049151,
        -0.9519362105217143, -0.12590496419626834, 0.27922283410977466, 0.000238037049151,
        -0.9519362105217143, -0.12590496419626834, -0.27922283410977455, 0.000238037049151,
        0.3184251107546741, 0.16105948234008624, 0.9341655591966646, 0.000249139804185,
        0.31842511075467395, 0.16105948234008616, -0.9341655591966646, 0.000249139804185,
        0.3184251107546741, -0.16105948234008624, 0.9341655591966646, 0.000249139804185,
        0.31842511075467395, -0.16105948234008616, -0.9341655591966646, 0.000249139804185,
        -0.3184251107546741, 0.1610594823400862, 0.9341655591966646, 0.000249139804185,
        -0.31842511075467395, 0.16105948234008616, -0.9341655591966646, 0.000249139804185,
        -0.3184251107546741, -0.1610594823400862, 0.9341655591966646, 0.000249139804185,
        -0.31842511075467395, -0.16105948234008616, -0.9341655591966646, 0.000249139804185,
        0.31842511075467406, 0.9341655591966646, 0.16105948234008638, 0.000249139804185,
        0.31842511075467406, 0.9341655591966646, -0.1610594823400865, 0.000249139804185,
        0.31842511075467406, -0.9341655591966646, 0.16105948234008638, 0.000249139804185,
        0.31842511075467406, -0.9341655591966646, -0.1610594823400865, 0.000249139804185,
        -0.31842511075467417, 0.9341655591966644, 0.16105948234008638, 0.000249139804185,
        -0.31842511075467417, 0.9341655591966644, -0.1610594823400865, 0.000249139804185,
        -0.31842511075467417, -0.9341655591966644, 0.16105948234008638, 0.000249139804185,
        -0.31842511075467417, -0.9341655591966644, -0.1610594823400865, 0.000249139804185,
        0.16105948234008627, 0.3184251107546741, 0.9341655591966646, 0.000249139804185,
        0.1610594823400862, 0.31842511075467395, -0.9341655591966646, 0.000249139804185,
        0.16105948234008627, -0.3184251107546741, 0.9341655591966646, 0.000249139804185,
        0.1610594823400862, -0.31842511075467395, -0.9341655591966646, 0.000249139804185,
        -0.1610594823400863, 0.31842511075467406, 0.9341655591966646, 0.000249139804185,
        -0.16105948234008624, 0.3184251107546739, -0.9341655591966646, 0.000249139804185,
        -0.1610594823400863, -0.31842511075467406, 0.9341655591966646, 0.000249139804185,
        -0.16105948234008624, -0.3184251107546739, -0.9341655591966646, 0.000249139804185,
        0.16105948234008627, 0.9341655591966646, 0.318425110754674, 0.000249139804185,
        0.16105948234008627, 0.9341655591966646, -0.3184251107546741, 0.000249139804185,
        0.16105948234008627, -0.9341655591966646, 0.318425110754674, 0.000249139804185,
        0.16105948234008627, -0.9341655591966646, -0.3184251107546741, 0.000249139804185,
        -0.16105948234008635, 0.9341655591966646, 0.318425110754674, 0.000249139804185,
        -0.16105948234008635, 0.9341655591966646, -0.3184251107546741, 0.000249139804185,
        -0.16105948234008635, -0.9341655591966646, 0.318425110754674, 0.000249139804185,
        -0.16105948234008635, -0.9341655591966646, -0.3184251107546741, 0.000249139804185,
        0.9341655591966646, 0.318425110754674, 0.16105948234008638, 0.000249139804185,
        0.9341655591966646, 0.318425110754674, -0.1610594823400865, 0.000249139804185,
        0.9341655591966646, -0.318425110754674, 0.16105948234008638, 0.000249139804185,
        0.9341655591966646, -0.318425110754674, -0.1610594823400865, 0.000249139804185,
        -0.9341655591966646, 0.31842511075467395, 0.16105948234008638, 0.000249139804185,
        -0.9341655591966646, 0.31842511075467395, -0.1610594823400865, 0.000249139804185,
        -0.9341655591966646, -0.31842511075467395, 0.16105948234008638, 0.000249139804185,
        -0.9341655591966646, -0.31842511075467395, -0.1610594823400865, 0.000249139804185,
        0.9341655591966646, 0.16105948234008607, 0.318425110754674, 0.000249139804185,
        0.9341655591966646, 0.16105948234008607, -0.3184251107546741, 0.000249139804185,
        0.9341655591966646, -0.16105948234008607, 0.318425110754674, 0.000249139804185,
        0.9341655591966646, -0.16105948234008607, -0.3184251107546741, 0.000249139804185,
        -0.9341655591966646, 0.16105948234008588, 0.318425110754674, 0.000249139804185,
        -0.9341655591966646, 0.16105948234008588, -0.3184251107546741, 0.000249139804185,
        -0.9341655591966646, -0.16105948234008588, 0.318425110754674, 0.000249139804185,
        -0.9341655591966646, -0.16105948234008588, -0.3184251107546741, 0.000249139804185,
        0.35704811644262446, 0.19671516534608988, 0.9131373315485654, 0.000258163240588,
        0.3570481164426246, 0.1967151653460899, -0.9131373315485654, 0.000258163240588,
        0.35704811644262446, -0.19671516534608988, 0.9131373315485654, 0.000258163240588,
        0.3570481164426246, -0.1967151653460899, -0.9131373315485654, 0.000258163240588,
        -0.3570481164426246, 0.1967151653460897, 0.9131373315485654, 0.000258163240588,
        -0.3570481164426247, 0.19671516534608977, -0.9131373315485654, 0.000258163240588,
        -0.3570481164426246, -0.1967151653460897, 0.9131373315485654, 0.000258163240588,
        -0.3570481164426247, -0.19671516534608977, -0.9131373315485654, 0.000258163240588,
        0.3570481164426244, 0.9131373315485655, 0.1967151653460896, 0.000258163240588,
        0.3570481164426244, 0.9131373315485654, -0.19671516534608968, 0.000258163240588,
        0.3570481164426244, -0.9131373315485655, 0.1967151653460896, 0.000258163240588,
        0.3570481164426244, -0.9131373315485654, -0.19671516534608968, 0.000258163240588,
        -0.3570481164426245, 0.9131373315485655, 0.1967151653460896, 0.000258163240588,
        -0.3570481164426245, 0.9131373315485654, -0.19671516534608968, 0.000258163240588,
        -0.3570481164426245, -0.9131373315485655, 0.1967151653460896, 0.000258163240588,
        -0.3570481164426245, -0.9131373315485654, -0.19671516534608968, 0.000258163240588,
        0.19671516534608985, 0.35704811644262446, 0.9131373315485654, 0.000258163240588,
        0.1967151653460899, 0.3570481164426246, -0.9131373315485654, 0.000258163240588,
        0.19671516534608985, -0.35704811644262446, 0.9131373315485654, 0.000258163240588,
        0.1967151653460899, -0.3570481164426246, -0.9131373315485654, 0.000258163240588,
        -0.1967151653460898, 0.3570481164426245, 0.9131373315485654, 0.000258163240588,
        -0.19671516534608985, 0.35704811644262463, -0.9131373315485654, 0.000258163240588,
        -0.1967151653460898, -0.3570481164426245, 0.9131373315485654, 0.000258163240588,
        -0.19671516534608985, -0.35704811644262463, -0.9131373315485654, 0.000258163240588,
        0.1967151653460898, 0.9131373315485654, 0.35704811644262446, 0.000258163240588,
        0.1967151653460898, 0.9131373315485655, -0.35704811644262435, 0.000258163240588,
        0.1967151653460898, -0.9131373315485654, 0.35704811644262446, 0.000258163240588,
        0.1967151653460898, -0.9131373315485655, -0.35704811644262435, 0.000258163240588,
        -0.1967151653460901, 0.9131373315485654, 0.35704811644262446, 0.000258163240588,
        -0.19671516534609013, 0.9131373315485655, -0.35704811644262435, 0.000258163240588,
        -0.1967151653460901, -0.9131373315485654, 0.35704811644262446, 0.000258163240588,
        -0.19671516534609013, -0.9131373315485655, -0.35704811644262435, 0.000258163240588,
        0.9131373315485655, 0.3570481164426245, 0.1967151653460896, 0.000258163240588,
        0.9131373315485654, 0.3570481164426245, -0.19671516534608968, 0.000258163240588,
        0.9131373315485655, -0.3570481164426245, 0.1967151653460896, 0.000258163240588,
        0.9131373315485654, -0.3570481164426245, -0.19671516534608968, 0.000258163240588,
        -0.9131373315485654, 0.3570481164426247, 0.1967151653460896, 0.000258163240588,
        -0.9131373315485652, 0.35704811644262463, -0.19671516534608968, 0.000258163240588,
        -0.9131373315485654, -0.3570481164426247, 0.1967151653460896, 0.000258163240588,
        -0.9131373315485652, -0.35704811644262463, -0.19671516534608968, 0.000258163240588,
        0.9131373315485654, 0.19671516534608996, 0.35704811644262446, 0.000258163240588,
        0.9131373315485655, 0.19671516534609, -0.35704811644262435, 0.000258163240588,
        0.9131373315485654, -0.19671516534608996, 0.35704811644262446, 0.000258163240588,
        0.9131373315485655, -0.19671516534609, -0.35704811644262435, 0.000258163240588,
        -0.9131373315485655, 0.19671516534608965, 0.35704811644262446, 0.000258163240588,
        -0.9131373315485656, 0.19671516534608968, -0.35704811644262435, 0.000258163240588,
        -0.9131373315485655, -0.19671516534608965, 0.35704811644262446, 0.000258163240588,
        -0.9131373315485656, -0.19671516534608968, -0.35704811644262435, 0.000258163240588,
        0.3949164710492144, 0.23254046061751674, 0.8888002672534635, 0.000265396550623,
        0.3949164710492145, 0.2325404606175168, -0.8888002672534635, 0.000265396550623,
        0.3949164710492144, -0.23254046061751674, 0.8888002672534635, 0.000265396550623,
        0.3949164710492145, -0.2325404606175168, -0.8888002672534635, 0.000265396550623,
        -0.3949164710492144, 0.23254046061751674, 0.8888002672534635, 0.000265396550623,
        -0.3949164710492145, 0.2325404606175168, -0.8888002672534635, 0.000265396550623,
        -0.3949164710492144, -0.23254046061751674, 0.8888002672534635, 0.000265396550623,
        -0.3949164710492145, -0.2325404606175168, -0.8888002672534635, 0.000265396550623,
        0.3949164710492144, 0.8888002672534635, 0.23254046061751685, 0.000265396550623,
        0.3949164710492144, 0.8888002672534635, -0.2325404606175167, 0.000265396550623,
        0.3949164710492144, -0.8888002672534635, 0.23254046061751685, 0.000265396550623,
        0.3949164710492144, -0.8888002672534635, -0.2325404606175167, 0.000265396550623,
        -0.3949164710492147, 0.8888002672534634, 0.23254046061751685, 0.000265396550623,
        -0.3949164710492147, 0.8888002672534634, -0.2325404606175167, 0.000265396550623,
        -0.3949164710492147, -0.8888002672534634, 0.23254046061751685, 0.000265396550623,
        -0.3949164710492147, -0.8888002672534634, -0.2325404606175167, 0.000265396550623,
        0.23254046061751676, 0.39491647104921435, 0.8888002672534635, 0.000265396550623,
        0.23254046061751682, 0.39491647104921446, -0.8888002672534635, 0.000265396550623,
        0.23254046061751676, -0.39491647104921435, 0.8888002672534635, 0.000265396550623,
        0.23254046061751682, -0.39491647104921446, -0.8888002672534635, 0.000265396550623,
        -0.23254046061751682, 0.39491647104921435, 0.8888002672534635, 0.000265396550623,
        -0.23254046061751688, 0.39491647104921446, -0.8888002672534635, 0.000265396550623,
        -0.23254046061751682, -0.39491647104921435, 0.8888002672534635, 0.000265396550623,
        -0.23254046061751688, -0.39491647104921446, -0.8888002672534635, 0.000265396550623,
        0.2325404606175168, 0.8888002672534635, 0.39491647104921446, 0.000265396550623,
        0.2325404606175168, 0.8888002672534635, -0.39491647104921435, 0.000265396550623,
        0.2325404606175168, -0.8888002672534635, 0.39491647104921446, 0.000265396550623,
        0.2325404606175168, -0.8888002672534635, -0.39491647104921435, 0.000265396550623,
        -0.2325404606175169, 0.8888002672534635, 0.39491647104921446, 0.000265396550623,
        -0.2325404606175169, 0.8888002672534635, -0.39491647104921435, 0.000265396550623,
        -0.2325404606175169, -0.8888002672534635, 0.39491647104921446, 0.000265396550623,
        -0.2325404606175169, -0.8888002672534635, -0.39491647104921435, 0.000265396550623,
        0.8888002672534635, 0.3949164710492144, 0.23254046061751685, 0.000265396550623,
        0.8888002672534635, 0.3949164710492144, -0.2325404606175167, 0.000265396550623,
        0.8888002672534635, -0.3949164710492144, 0.23254046061751685, 0.000265396550623,
        0.8888002672534635, -0.3949164710492144, -0.2325404606175167, 0.000265396550623,
        -0.8888002672534636, 0.39491647104921407, 0.23254046061751685, 0.000265396550623,
        -0.8888002672534636, 0.39491647104921407, -0.2325404606175167, 0.000265396550623,
        -0.8888002672534636, -0.39491647104921407, 0.23254046061751685, 0.000265396550623,
        -0.8888002672534636, -0.39491647104921407, -0.2325404606175167, 0.000265396550623,
        0.8888002672534635, 0.2325404606175169, 0.39491647104921446, 0.000265396550623,
        0.8888002672534635, 0.2325404606175169, -0.39491647104921435, 0.000265396550623,
        0.8888002672534635, -0.2325404606175169, 0.39491647104921446, 0.000265396550623,
        0.8888002672534635, -0.2325404606175169, -0.39491647104921435, 0.000265396550623,
        -0.8888002672534636, 0.23254046061751643, 0.39491647104921446, 0.000265396550623,
        -0.8888002672534636, 0.23254046061751643, -0.39491647104921435, 0.000265396550623,
        -0.8888002672534636, -0.23254046061751643, 0.39491647104921446, 0.000265396550623,
        -0.8888002672534636, -0.23254046061751643, -0.39491647104921435, 0.000265396550623,
        0.4318617293970504, 0.2682461141151438, 0.8611268599598517, 0.000271085721675,
        0.43186172939705025, 0.2682461141151437, -0.8611268599598518, 0.000271085721675,
        0.4318617293970504, -0.2682461141151438, 0.8611268599598517, 0.000271085721675,
        0.43186172939705025, -0.2682461141151437, -0.8611268599598518, 0.000271085721675,
        -0.43186172939705036, 0.2682461141151439, 0.8611268599598517, 0.000271085721675,
        -0.4318617293970502, 0.26824611411514376, -0.8611268599598518, 0.000271085721675,
        -0.43186172939705036, -0.2682461141151439, 0.8611268599598517, 0.000271085721675,
        -0.4318617293970502, -0.26824611411514376, -0.8611268599598518, 0.000271085721675,
        0.4318617293970502, 0.8611268599598517, 0.268246114115144, 0.000271085721675,
        0.4318617293970502, 0.8611268599598517, -0.2682461141151438, 0.000271085721675,
        0.4318617293970502, -0.8611268599598517, 0.268246114115144, 0.000271085721675,
        0.4318617293970502, -0.8611268599598517, -0.2682461141151438, 0.000271085721675,
        -0.43186172939705053, 0.8611268599598516, 0.268246114115144, 0.000271085721675,
        -0.43186172939705053, 0.8611268599598516, -0.2682461141151438, 0.000271085721675,
        -0.43186172939705053, -0.8611268599598516, 0.268246114115144, 0.000271085721675,
        -0.43186172939705053, -0.8611268599598516, -0.2682461141151438, 0.000271085721675,
        0.26824611411514393, 0.43186172939705036, 0.8611268599598517, 0.000271085721675,
        0.2682461141151438, 0.4318617293970502, -0.8611268599598518, 0.000271085721675,
        0.26824611411514393, -0.43186172939705036, 0.8611268599598517, 0.000271085721675,
        0.2682461141151438, -0.4318617293970502, -0.8611268599598518, 0.000271085721675,
        -0.268246114115144, 0.4318617293970503, 0.8611268599598517, 0.000271085721675,
        -0.2682461141151439, 0.43186172939705014, -0.8611268599598518, 0.000271085721675,
        -0.268246114115144, -0.4318617293970503, 0.8611268599598517, 0.000271085721675,
        -0.2682461141151439, -0.43186172939705014, -0.8611268599598518, 0.000271085721675,
        0.26824611411514393, 0.8611268599598517, 0.43186172939705036, 0.000271085721675,
        0.2682461141151439, 0.8611268599598516, -0.4318617293970505, 0.000271085721675,
        0.26824611411514393, -0.8611268599598517, 0.43186172939705036, 0.000271085721675,
        0.2682461141151439, -0.8611268599598516, -0.4318617293970505, 0.000271085721675,
        -0.26824611411514404, 0.8611268599598517, 0.43186172939705036, 0.000271085721675,
        -0.268246114115144, 0.8611268599598516, -0.4318617293970505, 0.000271085721675,
        -0.26824611411514404, -0.8611268599598517, 0.43186172939705036, 0.000271085721675,
        -0.268246114115144, -0.8611268599598516, -0.4318617293970505, 0.000271085721675,
        0.8611268599598517, 0.43186172939705036, 0.268246114115144, 0.000271085721675,
        0.8611268599598517, 0.43186172939705036, -0.2682461141151438, 0.000271085721675,
        0.8611268599598517, -0.43186172939705036, 0.268246114115144, 0.000271085721675,
        0.8611268599598517, -0.43186172939705036, -0.2682461141151438, 0.000271085721675,
        -0.8611268599598517, 0.43186172939705025, 0.268246114115144, 0.000271085721675,
        -0.8611268599598517, 0.43186172939705025, -0.2682461141151438, 0.000271085721675,
        -0.8611268599598517, -0.43186172939705025, 0.268246114115144, 0.000271085721675,
        -0.8611268599598517, -0.43186172939705025, -0.2682461141151438, 0.000271085721675,
        0.8611268599598517, 0.268246114115144, 0.43186172939705036, 0.000271085721675,
        0.8611268599598516, 0.26824611411514393, -0.4318617293970505, 0.000271085721675,
        0.8611268599598517, -0.268246114115144, 0.43186172939705036, 0.000271085721675,
        0.8611268599598516, -0.26824611411514393, -0.4318617293970505, 0.000271085721675,
        -0.8611268599598516, 0.26824611411514415, 0.43186172939705036, 0.000271085721675,
        -0.8611268599598515, 0.26824611411514415, -0.4318617293970505, 0.000271085721675,
        -0.8611268599598516, -0.26824611411514415, 0.43186172939705036, 0.000271085721675,
        -0.8611268599598515, -0.26824611411514415, -0.4318617293970505, 0.000271085721675,
        0.4677221009931679, 0.30357201160119734, 0.8301084688249719, 0.00027544340939,
        0.46772210099316797, 0.3035720116011974, -0.8301084688249718, 0.00027544340939,
        0.4677221009931679, -0.30357201160119734, 0.8301084688249719, 0.00027544340939,
        0.46772210099316797, -0.3035720116011974, -0.8301084688249718, 0.00027544340939,
        -0.4677221009931678, 0.30357201160119746, 0.8301084688249719, 0.00027544340939,
        -0.4677221009931679, 0.3035720116011975, -0.8301084688249718, 0.00027544340939,
        -0.4677221009931678, -0.30357201160119746, 0.8301084688249719, 0.00027544340939,
        -0.4677221009931679, -0.3035720116011975, -0.8301084688249718, 0.00027544340939,
        0.46772210099316786, 0.830108468824972, 0.30357201160119723, 0.00027544340939,
        0.4677221009931678, 0.8301084688249719, -0.30357201160119757, 0.00027544340939,
        0.46772210099316786, -0.830108468824972, 0.30357201160119723, 0.00027544340939,
        0.4677221009931678, -0.8301084688249719, -0.30357201160119757, 0.00027544340939,
        -0.46772210099316797, 0.830108468824972, 0.30357201160119723, 0.00027544340939,
        -0.4677221009931679, 0.8301084688249719, -0.30357201160119757, 0.00027544340939,
        -0.46772210099316797, -0.830108468824972, 0.30357201160119723, 0.00027544340939,
        -0.4677221009931679, -0.8301084688249719, -0.30357201160119757, 0.00027544340939,
        0.30357201160119734, 0.4677221009931679, 0.8301084688249719, 0.00027544340939,
        0.3035720116011974, 0.46772210099316797, -0.8301084688249718, 0.00027544340939,
        0.30357201160119734, -0.4677221009931679, 0.8301084688249719, 0.00027544340939,
        0.3035720116011974, -0.46772210099316797, -0.8301084688249718, 0.00027544340939,
        -0.3035720116011973, 0.4677221009931679, 0.8301084688249719, 0.00027544340939,
        -0.30357201160119734, 0.46772210099316797, -0.8301084688249718, 0.00027544340939,
        -0.3035720116011973, -0.4677221009931679, 0.8301084688249719, 0.00027544340939,
        -0.30357201160119734, -0.46772210099316797, -0.8301084688249718, 0.00027544340939,
        0.30357201160119734, 0.830108468824972, 0.4677221009931678, 0.00027544340939,
        0.30357201160119734, 0.830108468824972, -0.4677221009931679, 0.00027544340939,
        0.30357201160119734, -0.830108468824972, 0.4677221009931678, 0.00027544340939,
        0.30357201160119734, -0.830108468824972, -0.4677221009931679, 0.00027544340939,
        -0.3035720116011973, 0.830108468824972, 0.4677221009931678, 0.00027544340939,
        -0.3035720116011973, 0.830108468824972, -0.4677221009931679, 0.00027544340939,
        -0.3035720116011973, -0.830108468824972, 0.4677221009931678, 0.00027544340939,
        -0.3035720116011973, -0.830108468824972, -0.4677221009931679, 0.00027544340939,
        0.830108468824972, 0.4677221009931679, 0.30357201160119723, 0.00027544340939,
        0.8301084688249719, 0.46772210099316786, -0.30357201160119757, 0.00027544340939,
        0.830108468824972, -0.4677221009931679, 0.30357201160119723, 0.00027544340939,
        0.8301084688249719, -0.46772210099316786, -0.30357201160119757, 0.00027544340939,
        -0.8301084688249721, 0.4677221009931677, 0.30357201160119723, 0.00027544340939,
        -0.830108468824972, 0.46772210099316763, -0.30357201160119757, 0.00027544340939,
        -0.8301084688249721, -0.4677221009931677, 0.30357201160119723, 0.00027544340939,
        -0.830108468824972, -0.46772210099316763, -0.30357201160119757, 0.00027544340939,
        0.830108468824972, 0.3035720116011973, 0.4677221009931678, 0.00027544340939,
        0.830108468824972, 0.3035720116011973, -0.4677221009931679, 0.00027544340939,
        0.830108468824972, -0.3035720116011973, 0.4677221009931678, 0.00027544340939,
        0.830108468824972, -0.3035720116011973, -0.4677221009931679, 0.00027544340939,
        -0.830108468824972, 0.3035720116011974, 0.4677221009931678, 0.00027544340939,
        -0.830108468824972, 0.3035720116011974, -0.4677221009931679, 0.00027544340939,
        -0.830108468824972, -0.3035720116011974, 0.4677221009931678, 0.00027544340939,
        -0.830108468824972, -0.3035720116011974, -0.4677221009931679, 0.00027544340939,
        0.5023417939270955, 0.3382781859197438, 0.7957515887542762, 0.000278657993252,
        0.5023417939270954, 0.33827818591974373, -0.7957515887542763, 0.000278657993252,
        0.5023417939270955, -0.3382781859197438, 0.7957515887542762, 0.000278657993252,
        0.5023417939270954, -0.33827818591974373, -0.7957515887542763, 0.000278657993252,
        -0.5023417939270958, 0.33827818591974357, 0.7957515887542762, 0.000278657993252,
        -0.5023417939270957, 0.3382781859197435, -0.7957515887542763, 0.000278657993252,
        -0.5023417939270958, -0.33827818591974357, 0.7957515887542762, 0.000278657993252,
        -0.5023417939270957, -0.3382781859197435, -0.7957515887542763, 0.000278657993252,
        0.5023417939270953, 0.7957515887542762, 0.33827818591974396, 0.000278657993252,
        0.5023417939270953, 0.7957515887542762, -0.338278185919744, 0.000278657993252,
        0.5023417939270953, -0.7957515887542762, 0.33827818591974396, 0.000278657993252,
        0.5023417939270953, -0.7957515887542762, -0.338278185919744, 0.000278657993252,
        -0.5023417939270954, 0.7957515887542762, 0.33827818591974396, 0.000278657993252,
        -0.5023417939270954, 0.7957515887542762, -0.338278185919744, 0.000278657993252,
        -0.5023417939270954, -0.7957515887542762, 0.33827818591974396, 0.000278657993252,
        -0.5023417939270954, -0.7957515887542762, -0.338278185919744, 0.000278657993252,
        0.33827818591974385, 0.5023417939270954, 0.7957515887542762, 0.000278657993252,
        0.3382781859197438, 0.5023417939270954, -0.7957515887542763, 0.000278657993252,
        0.33827818591974385, -0.5023417939270954, 0.7957515887542762, 0.000278657993252,
        0.3382781859197438, -0.5023417939270954, -0.7957515887542763, 0.000278657993252,
        -0.3382781859197439, 0.5023417939270954, 0.7957515887542762, 0.000278657993252,
        -0.33827818591974385, 0.5023417939270954, -0.7957515887542763, 0.000278657993252,
        -0.3382781859197439, -0.5023417939270954, 0.7957515887542762, 0.000278657993252,
        -0.33827818591974385, -0.5023417939270954, -0.7957515887542763, 0.000278657993252,
        0.3382781859197439, 0.7957515887542762, 0.5023417939270954, 0.000278657993252,
        0.3382781859197439, 0.7957515887542762, -0.5023417939270953, 0.000278657993252,
        0.3382781859197439, -0.7957515887542762, 0.5023417939270954, 0.000278657993252,
        0.3382781859197439, -0.7957515887542762, -0.5023417939270953, 0.000278657993252,
        -0.33827818591974396, 0.7957515887542761, 0.5023417939270954, 0.000278657993252,
        -0.33827818591974396, 0.7957515887542761, -0.5023417939270953, 0.000278657993252,
        -0.33827818591974396, -0.7957515887542761, 0.5023417939270954, 0.000278657993252,
        -0.33827818591974396, -0.7957515887542761, -0.5023417939270953, 0.000278657993252,
        0.7957515887542761, 0.5023417939270955, 0.33827818591974396, 0.000278657993252,
        0.7957515887542761, 0.5023417939270955, -0.338278185919744, 0.000278657993252,
        0.7957515887542761, -0.5023417939270955, 0.33827818591974396, 0.000278657993252,
        0.7957515887542761, -0.5023417939270955, -0.338278185919744, 0.000278657993252,
        -0.7957515887542761, 0.5023417939270955, 0.33827818591974396, 0.000278657993252,
        -0.7957515887542761, 0.5023417939270955, -0.338278185919744, 0.000278657993252,
        -0.7957515887542761, -0.5023417939270955, 0.33827818591974396, 0.000278657993252,
        -0.7957515887542761, -0.5023417939270955, -0.338278185919744, 0.000278657993252,
        0.7957515887542762, 0.33827818591974385, 0.5023417939270954, 0.000278657993252,
        0.7957515887542762, 0.33827818591974385, -0.5023417939270953, 0.000278657993252,
        0.7957515887542762, -0.33827818591974385, 0.5023417939270954, 0.000278657993252,
        0.7957515887542762, -0.33827818591974385, -0.5023417939270953, 0.000278657993252,
        -0.7957515887542764, 0.3382781859197434, 0.5023417939270954, 0.000278657993252,
        -0.7957515887542764, 0.3382781859197434, -0.5023417939270953, 0.000278657993252,
        -0.7957515887542764, -0.3382781859197434, 0.5023417939270954, 0.000278657993252,
        -0.7957515887542764, -0.3382781859197434, -0.5023417939270953, 0.000278657993252,
        0.5355701836636128, 0.37213830656259417, 0.7580749693528, 0.000280901108068,
        0.5355701836636129, 0.3721383065625942, -0.7580749693527999, 0.000280901108068,
        0.5355701836636128, -0.37213830656259417, 0.7580749693528, 0.000280901108068,
        0.5355701836636129, -0.3721383065625942, -0.7580749693527999, 0.000280901108068,
        -0.5355701836636128, 0.37213830656259417, 0.7580749693528, 0.000280901108068,
        -0.5355701836636129, 0.3721383065625942, -0.7580749693527999, 0.000280901108068,
        -0.5355701836636128, -0.37213830656259417, 0.7580749693528, 0.000280901108068,
        -0.5355701836636129, -0.3721383065625942, -0.7580749693527999, 0.000280901108068,
        0.5355701836636128, 0.7580749693528, 0.3721383065625943, 0.000280901108068,
        0.5355701836636128, 0.7580749693528, -0.37213830656259417, 0.000280901108068,
        0.5355701836636128, -0.7580749693528, 0.3721383065625943, 0.000280901108068,
        0.5355701836636128, -0.7580749693528, -0.37213830656259417, 0.000280901108068,
        -0.5355701836636126, 0.7580749693528002, 0.3721383065625943, 0.000280901108068,
        -0.5355701836636126, 0.7580749693528002, -0.37213830656259417, 0.000280901108068,
        -0.5355701836636126, -0.7580749693528002, 0.3721383065625943, 0.000280901108068,
        -0.5355701836636126, -0.7580749693528002, -0.37213830656259417, 0.000280901108068,
        0.3721383065625943, 0.5355701836636128, 0.7580749693528, 0.000280901108068,
        0.37213830656259433, 0.5355701836636129, -0.7580749693527999, 0.000280901108068,
        0.3721383065625943, -0.5355701836636128, 0.7580749693528, 0.000280901108068,
        0.37213830656259433, -0.5355701836636129, -0.7580749693527999, 0.000280901108068,
        -0.37213830656259433, 0.5355701836636126, 0.7580749693528, 0.000280901108068,
        -0.3721383065625944, 0.5355701836636128, -0.7580749693527999, 0.000280901108068,
        -0.37213830656259433, -0.5355701836636126, 0.7580749693528, 0.000280901108068,
        -0.3721383065625944, -0.5355701836636128, -0.7580749693527999, 0.000280901108068,
        0.3721383065625941, 0.7580749693528, 0.5355701836636129, 0.000280901108068,
        0.3721383065625941, 0.7580749693528, -0.5355701836636128, 0.000280901108068,
        0.3721383065625941, -0.7580749693528, 0.5355701836636129, 0.000280901108068,
        0.3721383065625941, -0.7580749693528, -0.5355701836636128, 0.000280901108068,
        -0.3721383065625942, 0.7580749693528, 0.5355701836636129, 0.000280901108068,
        -0.3721383065625942, 0.7580749693528, -0.5355701836636128, 0.000280901108068,
        -0.3721383065625942, -0.7580749693528, 0.5355701836636129, 0.000280901108068,
        -0.3721383065625942, -0.7580749693528, -0.5355701836636128, 0.000280901108068,
        0.7580749693528, 0.5355701836636129, 0.3721383065625943, 0.000280901108068,
        0.7580749693528, 0.5355701836636129, -0.37213830656259417, 0.000280901108068,
        0.7580749693528, -0.5355701836636129, 0.3721383065625943, 0.000280901108068,
        0.7580749693528, -0.5355701836636129, -0.37213830656259417, 0.000280901108068,
        -0.7580749693528002, 0.5355701836636128, 0.3721383065625943, 0.000280901108068,
        -0.7580749693528002, 0.5355701836636128, -0.37213830656259417, 0.000280901108068,
        -0.7580749693528002, -0.5355701836636128, 0.3721383065625943, 0.000280901108068,
        -0.7580749693528002, -0.5355701836636128, -0.37213830656259417, 0.000280901108068,
        0.7580749693528, 0.3721383065625941, 0.5355701836636129, 0.000280901108068,
        0.7580749693528, 0.3721383065625941, -0.5355701836636128, 0.000280901108068,
        0.7580749693528, -0.3721383065625941, 0.5355701836636129, 0.000280901108068,
        0.7580749693528, -0.3721383065625941, -0.5355701836636128, 0.000280901108068,
        -0.7580749693528, 0.372138306562594, 0.5355701836636129, 0.000280901108068,
        -0.7580749693528, 0.372138306562594, -0.5355701836636128, 0.000280901108068,
        -0.7580749693528, -0.372138306562594, 0.5355701836636129, 0.000280901108068,
        -0.7580749693528, -0.372138306562594, -0.5355701836636128, 0.000280901108068,
        0.5672608451328772, 0.40493463604660546, 0.7171074355415212, 0.000282333618456,
        0.5672608451328772, 0.40493463604660557, -0.7171074355415212, 0.000282333618456,
        0.5672608451328772, -0.40493463604660546, 0.7171074355415212, 0.000282333618456,
        0.5672608451328772, -0.40493463604660557, -0.7171074355415212, 0.000282333618456,
        -0.5672608451328772, 0.4049346360466054, 0.7171074355415212, 0.000282333618456,
        -0.5672608451328773, 0.40493463604660546, -0.7171074355415212, 0.000282333618456,
        -0.5672608451328772, -0.4049346360466054, 0.7171074355415212, 0.000282333618456,
        -0.5672608451328773, -0.40493463604660546, -0.7171074355415212, 0.000282333618456,
        0.5672608451328772, 0.7171074355415212, 0.40493463604660557, 0.000282333618456,
        0.5672608451328772, 0.7171074355415212, -0.40493463604660546, 0.000282333618456,
        0.5672608451328772, -0.7171074355415212, 0.40493463604660557, 0.000282333618456,
        0.5672608451328772, -0.7171074355415212, -0.40493463604660546, 0.000282333618456,
        -0.5672608451328773, 0.7171074355415211, 0.40493463604660557, 0.000282333618456,
        -0.5672608451328773, 0.7171074355415211, -0.40493463604660546, 0.000282333618456,
        -0.5672608451328773, -0.7171074355415211, 0.40493463604660557, 0.000282333618456,
        -0.5672608451328773, -0.7171074355415211, -0.40493463604660546, 0.000282333618456,
        0.40493463604660557, 0.5672608451328772, 0.7171074355415212, 0.000282333618456,
        0.4049346360466056, 0.5672608451328772, -0.7171074355415212, 0.000282333618456,
        0.40493463604660557, -0.5672608451328772, 0.7171074355415212, 0.000282333618456,
        0.4049346360466056, -0.5672608451328772, -0.7171074355415212, 0.000282333618456,
        -0.40493463604660557, 0.5672608451328772, 0.7171074355415212, 0.000282333618456,
        -0.4049346360466056, 0.5672608451328772, -0.7171074355415212, 0.000282333618456,
        -0.40493463604660557, -0.5672608451328772, 0.7171074355415212, 0.000282333618456,
        -0.4049346360466056, -0.5672608451328772, -0.7171074355415212, 0.000282333618456,
        0.40493463604660546, 0.7171074355415212, 0.5672608451328771, 0.000282333618456,
        0.40493463604660546, 0.7171074355415212, -0.5672608451328772, 0.000282333618456,
        0.40493463604660546, -0.7171074355415212, 0.5672608451328771, 0.000282333618456,
        0.40493463604660546, -0.7171074355415212, -0.5672608451328772, 0.000282333618456,
        -0.4049346360466055, 0.7171074355415212, 0.5672608451328771, 0.000282333618456,
        -0.4049346360466055, 0.7171074355415212, -0.5672608451328772, 0.000282333618456,
        -0.4049346360466055, -0.7171074355415212, 0.5672608451328771, 0.000282333618456,
        -0.4049346360466055, -0.7171074355415212, -0.5672608451328772, 0.000282333618456,
        0.7171074355415213, 0.5672608451328771, 0.40493463604660557, 0.000282333618456,
        0.7171074355415213, 0.5672608451328771, -0.40493463604660546, 0.000282333618456,
        0.7171074355415213, -0.5672608451328771, 0.40493463604660557, 0.000282333618456,
        0.7171074355415213, -0.5672608451328771, -0.40493463604660546, 0.000282333618456,
        -0.7171074355415213, 0.5672608451328771, 0.40493463604660557, 0.000282333618456,
        -0.7171074355415213, 0.5672608451328771, -0.40493463604660546, 0.000282333618456,
        -0.7171074355415213, -0.5672608451328771, 0.40493463604660557, 0.000282333618456,
        -0.7171074355415213, -0.5672608451328771, -0.40493463604660546, 0.000282333618456,
        0.7171074355415212, 0.40493463604660557, 0.5672608451328771, 0.000282333618456,
        0.7171074355415212, 0.40493463604660557, -0.5672608451328772, 0.000282333618456,
        0.7171074355415212, -0.40493463604660557, 0.5672608451328771, 0.000282333618456,
        0.7171074355415212, -0.40493463604660557, -0.5672608451328772, 0.000282333618456,
        -0.7171074355415212, 0.40493463604660535, 0.5672608451328771, 0.000282333618456,
        -0.7171074355415212, 0.40493463604660535, -0.5672608451328772, 0.000282333618456,
        -0.7171074355415212, -0.40493463604660535, 0.5672608451328771, 0.000282333618456,
        -0.7171074355415212, -0.40493463604660535, -0.5672608451328772, 0.000282333618456,
        0.5972704202540162, 0.43645380986338017, 0.6728864071634463, 0.000283110117581,
        0.5972704202540163, 0.4364538098633803, -0.6728864071634462, 0.000283110117581,
        0.5972704202540162, -0.43645380986338017, 0.6728864071634463, 0.000283110117581,
        0.5972704202540163, -0.4364538098633803, -0.6728864071634462, 0.000283110117581,
        -0.5972704202540162, 0.4364538098633803, 0.6728864071634463, 0.000283110117581,
        -0.5972704202540163, 0.43645380986338034, -0.6728864071634462, 0.000283110117581,
        -0.5972704202540162, -0.4364538098633803, 0.6728864071634463, 0.000283110117581,
        -0.5972704202540163, -0.43645380986338034, -0.6728864071634462, 0.000283110117581,
        0.5972704202540162, 0.6728864071634463, 0.43645380986338017, 0.000283110117581,
        0.5972704202540162, 0.6728864071634463, -0.43645380986338006, 0.000283110117581,
        0.5972704202540162, -0.6728864071634463, 0.43645380986338017, 0.000283110117581,
        0.5972704202540162, -0.6728864071634463, -0.43645380986338006, 0.000283110117581,
        -0.5972704202540167, 0.6728864071634459, 0.43645380986338017, 0.000283110117581,
        -0.5972704202540168, 0.672886407163446, -0.43645380986338006, 0.000283110117581,
        -0.5972704202540167, -0.6728864071634459, 0.43645380986338017, 0.000283110117581,
        -0.5972704202540168, -0.672886407163446, -0.43645380986338006, 0.000283110117581,
        0.43645380986338017, 0.5972704202540162, 0.6728864071634463, 0.000283110117581,
        0.4364538098633803, 0.5972704202540163, -0.6728864071634462, 0.000283110117581,
        0.43645380986338017, -0.5972704202540162, 0.6728864071634463, 0.000283110117581,
        0.4364538098633803, -0.5972704202540163, -0.6728864071634462, 0.000283110117581,
        -0.43645380986338017, 0.5972704202540163, 0.6728864071634463, 0.000283110117581,
        -0.4364538098633803, 0.5972704202540163, -0.6728864071634462, 0.000283110117581,
        -0.43645380986338017, -0.5972704202540163, 0.6728864071634463, 0.000283110117581,
        -0.4364538098633803, -0.5972704202540163, -0.6728864071634462, 0.000283110117581,
        0.4364538098633801, 0.6728864071634463, 0.5972704202540162, 0.000283110117581,
        0.4364538098633801, 0.6728864071634463, -0.5972704202540162, 0.000283110117581,
        0.4364538098633801, -0.6728864071634463, 0.5972704202540162, 0.000283110117581,
        0.4364538098633801, -0.6728864071634463, -0.5972704202540162, 0.000283110117581,
        -0.43645380986338034, 0.6728864071634462, 0.5972704202540162, 0.000283110117581,
        -0.43645380986338034, 0.6728864071634462, -0.5972704202540162, 0.000283110117581,
        -0.43645380986338034, -0.6728864071634462, 0.5972704202540162, 0.000283110117581,
        -0.43645380986338034, -0.6728864071634462, -0.5972704202540162, 0.000283110117581,
        0.6728864071634462, 0.5972704202540163, 0.43645380986338017, 0.000283110117581,
        0.6728864071634463, 0.5972704202540163, -0.43645380986338006, 0.000283110117581,
        0.6728864071634462, -0.5972704202540163, 0.43645380986338017, 0.000283110117581,
        0.6728864071634463, -0.5972704202540163, -0.43645380986338006, 0.000283110117581,
        -0.6728864071634464, 0.5972704202540162, 0.43645380986338017, 0.000283110117581,
        -0.6728864071634464, 0.5972704202540162, -0.43645380986338006, 0.000283110117581,
        -0.6728864071634464, -0.5972704202540162, 0.43645380986338017, 0.000283110117581,
        -0.6728864071634464, -0.5972704202540162, -0.43645380986338006, 0.000283110117581,
        0.6728864071634462, 0.43645380986338034, 0.5972704202540162, 0.000283110117581,
        0.6728864071634462, 0.43645380986338034, -0.5972704202540162, 0.000283110117581,
        0.6728864071634462, -0.43645380986338034, 0.5972704202540162, 0.000283110117581,
        0.6728864071634462, -0.43645380986338034, -0.5972704202540162, 0.000283110117581,
        -0.6728864071634463, 0.4364538098633801, 0.5972704202540162, 0.000283110117581,
        -0.6728864071634463, 0.4364538098633801, -0.5972704202540162, 0.000283110117581,
        -0.6728864071634463, -0.4364538098633801, 0.5972704202540162, 0.000283110117581,
        -0.6728864071634463, -0.4364538098633801, -0.5972704202540162, 0.000283110117581,
        0.24616870223335963, 0.03070423166833367, 0.9687405329593682, 0.000222167997035,
        0.2461687022333591, 0.03070423166833361, -0.9687405329593684, 0.000222167997035,
        0.24616870223335963, -0.03070423166833367, 0.9687405329593682, 0.000222167997035,
        0.2461687022333591, -0.03070423166833361, -0.9687405329593684, 0.000222167997035,
        -0.24616870223335963, 0.030704231668333692, 0.9687405329593682, 0.000222167997035,
        -0.2461687022333591, 0.03070423166833363, -0.9687405329593684, 0.000222167997035,
        -0.24616870223335963, -0.030704231668333692, 0.9687405329593682, 0.000222167997035,
        -0.2461687022333591, -0.03070423166833363, -0.9687405329593684, 0.000222167997035,
        0.2461687022333596, 0.9687405329593684, 0.03070423166833367, 0.000222167997035,
        0.2461687022333596, 0.9687405329593684, -0.030704231668333772, 0.000222167997035,
        0.2461687022333596, -0.9687405329593684, 0.03070423166833367, 0.000222167997035,
        0.2461687022333596, -0.9687405329593684, -0.030704231668333772, 0.000222167997035,
        -0.2461687022333597, 0.9687405329593682, 0.03070423166833367, 0.000222167997035,
        -0.2461687022333597, 0.9687405329593682, -0.030704231668333772, 0.000222167997035,
        -0.2461687022333597, -0.9687405329593682, 0.03070423166833367, 0.000222167997035,
        -0.2461687022333597, -0.9687405329593682, -0.030704231668333772, 0.000222167997035,
        0.03070423166833368, 0.24616870223335963, 0.9687405329593682, 0.000222167997035,
        0.030704231668333616, 0.2461687022333591, -0.9687405329593684, 0.000222167997035,
        0.03070423166833368, -0.24616870223335963, 0.9687405329593682, 0.000222167997035,
        0.030704231668333616, -0.2461687022333591, -0.9687405329593684, 0.000222167997035,
        -0.030704231668333703, 0.24616870223335963, 0.9687405329593682, 0.000222167997035,
        -0.03070423166833364, 0.2461687022333591, -0.9687405329593684, 0.000222167997035,
        -0.030704231668333703, -0.24616870223335963, 0.9687405329593682, 0.000222167997035,
        -0.03070423166833364, -0.2461687022333591, -0.9687405329593684, 0.000222167997035,
        0.03070423166833362, 0.9687405329593682, 0.24616870223335965, 0.000222167997035,
        0.030704231668333623, 0.9687405329593684, -0.24616870223335952, 0.000222167997035,
        0.03070423166833362, -0.9687405329593682, 0.24616870223335965, 0.000222167997035,
        0.030704231668333623, -0.9687405329593684, -0.24616870223335952, 0.000222167997035,
        -0.03070423166833393, 0.9687405329593682, 0.24616870223335965, 0.000222167997035,
        -0.030704231668333932, 0.9687405329593684, -0.24616870223335952, 0.000222167997035,
        -0.03070423166833393, -0.9687405329593682, 0.24616870223335965, 0.000222167997035,
        -0.030704231668333932, -0.9687405329593684, -0.24616870223335952, 0.000222167997035,
        0.9687405329593682, 0.24616870223335993, 0.03070423166833367, 0.000222167997035,
        0.9687405329593682, 0.24616870223335993, -0.030704231668333772, 0.000222167997035,
        0.9687405329593682, -0.24616870223335993, 0.03070423166833367, 0.000222167997035,
        0.9687405329593682, -0.24616870223335993, -0.030704231668333772, 0.000222167997035,
        -0.9687405329593682, 0.2461687022333601, 0.03070423166833367, 0.000222167997035,
        -0.9687405329593682, 0.2461687022333601, -0.030704231668333772, 0.000222167997035,
        -0.9687405329593682, -0.2461687022333601, 0.03070423166833367, 0.000222167997035,
        -0.9687405329593682, -0.2461687022333601, -0.030704231668333772, 0.000222167997035,
        0.9687405329593682, 0.030704231668333252, 0.24616870223335965, 0.000222167997035,
        0.9687405329593684, 0.030704231668333255, -0.24616870223335952, 0.000222167997035,
        0.9687405329593682, -0.030704231668333252, 0.24616870223335965, 0.000222167997035,
        0.9687405329593684, -0.030704231668333255, -0.24616870223335952, 0.000222167997035,
        -0.9687405329593682, 0.030704231668333252, 0.24616870223335965, 0.000222167997035,
        -0.9687405329593684, 0.030704231668333255, -0.24616870223335952, 0.000222167997035,
        -0.9687405329593682, -0.030704231668333252, 0.24616870223335965, 0.000222167997035,
        -0.9687405329593684, -0.030704231668333255, -0.24616870223335952, 0.000222167997035,
        0.2881774566286834, 0.06338034669281882, 0.9554772028385196, 0.000235618573427,
        0.28817745662868316, 0.06338034669281878, -0.9554772028385196, 0.000235618573427,
        0.2881774566286834, -0.06338034669281882, 0.9554772028385196, 0.000235618573427,
        0.28817745662868316, -0.06338034669281878, -0.9554772028385196, 0.000235618573427,
        -0.2881774566286834, 0.06338034669281868, 0.9554772028385196, 0.000235618573427,
        -0.2881774566286832, 0.06338034669281864, -0.9554772028385196, 0.000235618573427,
        -0.2881774566286834, -0.06338034669281868, 0.9554772028385196, 0.000235618573427,
        -0.2881774566286832, -0.06338034669281864, -0.9554772028385196, 0.000235618573427,
        0.288177456628683, 0.9554772028385197, 0.0633803466928188, 0.000235618573427,
        0.28817745662868294, 0.9554772028385197, -0.06338034669281913, 0.000235618573427,
        0.288177456628683, -0.9554772028385197, 0.0633803466928188, 0.000235618573427,
        0.28817745662868294, -0.9554772028385197, -0.06338034669281913, 0.000235618573427,
        -0.2881774566286831, 0.9554772028385197, 0.0633803466928188, 0.000235618573427,
        -0.28817745662868305, 0.9554772028385197, -0.06338034669281913, 0.000235618573427,
        -0.2881774566286831, -0.9554772028385197, 0.0633803466928188, 0.000235618573427,
        -0.28817745662868305, -0.9554772028385197, -0.06338034669281913, 0.000235618573427,
        0.06338034669281893, 0.2881774566286833, 0.9554772028385196, 0.000235618573427,
        0.06338034669281888, 0.2881774566286831, -0.9554772028385196, 0.000235618573427,
        0.06338034669281893, -0.2881774566286833, 0.9554772028385196, 0.000235618573427,
        0.06338034669281888, -0.2881774566286831, -0.9554772028385196, 0.000235618573427,
        -0.06338034669281895, 0.2881774566286833, 0.9554772028385196, 0.000235618573427,
        -0.0633803466928189, 0.2881774566286831, -0.9554772028385196, 0.000235618573427,
        -0.06338034669281895, -0.2881774566286833, 0.9554772028385196, 0.000235618573427,
        -0.0633803466928189, -0.2881774566286831, -0.9554772028385196, 0.000235618573427,
        0.0633803466928188, 0.9554772028385197, 0.288177456628683, 0.000235618573427,
        0.06338034669281879, 0.9554772028385196, -0.2881774566286831, 0.000235618573427,
        0.0633803466928188, -0.9554772028385197, 0.288177456628683, 0.000235618573427,
        0.06338034669281879, -0.9554772028385196, -0.2881774566286831, 0.000235618573427,
        -0.0633803466928189, 0.9554772028385197, 0.288177456628683, 0.000235618573427,
        -0.06338034669281889, 0.9554772028385196, -0.2881774566286831, 0.000235618573427,
        -0.0633803466928189, -0.9554772028385197, 0.288177456628683, 0.000235618573427,
        -0.06338034669281889, -0.9554772028385196, -0.2881774566286831, 0.000235618573427,
        0.9554772028385196, 0.28817745662868327, 0.0633803466928188, 0.000235618573427,
        0.9554772028385196, 0.2881774566286832, -0.06338034669281913, 0.000235618573427,
        0.9554772028385196, -0.28817745662868327, 0.0633803466928188, 0.000235618573427,
        0.9554772028385196, -0.2881774566286832, -0.06338034669281913, 0.000235618573427,
        -0.9554772028385196, 0.2881774566286835, 0.0633803466928188, 0.000235618573427,
        -0.9554772028385196, 0.28817745662868344, -0.06338034669281913, 0.000235618573427,
        -0.9554772028385196, -0.2881774566286835, 0.0633803466928188, 0.000235618573427,
        -0.9554772028385196, -0.28817745662868344, -0.06338034669281913, 0.000235618573427,
        0.9554772028385197, 0.06338034669281932, 0.288177456628683, 0.000235618573427,
        0.9554772028385196, 0.06338034669281932, -0.2881774566286831, 0.000235618573427,
        0.9554772028385197, -0.06338034669281932, 0.288177456628683, 0.000235618573427,
        0.9554772028385196, -0.06338034669281932, -0.2881774566286831, 0.000235618573427,
        -0.9554772028385197, 0.06338034669281907, 0.288177456628683, 0.000235618573427,
        -0.9554772028385196, 0.06338034669281907, -0.2881774566286831, 0.000235618573427,
        -0.9554772028385197, -0.06338034669281907, 0.288177456628683, 0.000235618573427,
        -0.9554772028385196, -0.06338034669281907, -0.2881774566286831, 0.000235618573427,
        0.32939636041169773, 0.09742862487067937, 0.9391515856363846, 0.000246922834481,
        0.32939636041169756, 0.09742862487067933, -0.9391515856363847, 0.000246922834481,
        0.32939636041169773, -0.09742862487067937, 0.9391515856363846, 0.000246922834481,
        0.32939636041169756, -0.09742862487067933, -0.9391515856363847, 0.000246922834481,
        -0.32939636041169773, 0.0974286248706793, 0.9391515856363846, 0.000246922834481,
        -0.32939636041169756, 0.09742862487067924, -0.9391515856363847, 0.000246922834481,
        -0.32939636041169773, -0.0974286248706793, 0.9391515856363846, 0.000246922834481,
        -0.32939636041169756, -0.09742862487067924, -0.9391515856363847, 0.000246922834481,
        0.3293963604116979, 0.9391515856363846, 0.09742862487067927, 0.000246922834481,
        0.3293963604116979, 0.9391515856363846, -0.09742862487067937, 0.000246922834481,
        0.3293963604116979, -0.9391515856363846, 0.09742862487067927, 0.000246922834481,
        0.3293963604116979, -0.9391515856363846, -0.09742862487067937, 0.000246922834481,
        -0.3293963604116978, 0.9391515856363846, 0.09742862487067927, 0.000246922834481,
        -0.3293963604116978, 0.9391515856363846, -0.09742862487067937, 0.000246922834481,
        -0.3293963604116978, -0.9391515856363846, 0.09742862487067927, 0.000246922834481,
        -0.3293963604116978, -0.9391515856363846, -0.09742862487067937, 0.000246922834481,
        0.09742862487067935, 0.32939636041169773, 0.9391515856363846, 0.000246922834481,
        0.0974286248706793, 0.32939636041169756, -0.9391515856363847, 0.000246922834481,
        0.09742862487067935, -0.32939636041169773, 0.9391515856363846, 0.000246922834481,
        0.0974286248706793, -0.32939636041169756, -0.9391515856363847, 0.000246922834481,
        -0.09742862487067938, 0.32939636041169773, 0.9391515856363846, 0.000246922834481,
        -0.09742862487067934, 0.32939636041169756, -0.9391515856363847, 0.000246922834481,
        -0.09742862487067938, -0.32939636041169773, 0.9391515856363846, 0.000246922834481,
        -0.09742862487067934, -0.32939636041169756, -0.9391515856363847, 0.000246922834481,
        0.09742862487067948, 0.9391515856363847, 0.3293963604116976, 0.000246922834481,
        0.09742862487067948, 0.9391515856363847, -0.3293963604116977, 0.000246922834481,
        0.09742862487067948, -0.9391515856363847, 0.3293963604116976, 0.000246922834481,
        0.09742862487067948, -0.9391515856363847, -0.3293963604116977, 0.000246922834481,
        -0.09742862487067938, 0.9391515856363847, 0.3293963604116976, 0.000246922834481,
        -0.09742862487067938, 0.9391515856363847, -0.3293963604116977, 0.000246922834481,
        -0.09742862487067938, -0.9391515856363847, 0.3293963604116976, 0.000246922834481,
        -0.09742862487067938, -0.9391515856363847, -0.3293963604116977, 0.000246922834481,
        0.9391515856363846, 0.3293963604116978, 0.09742862487067927, 0.000246922834481,
        0.9391515856363846, 0.3293963604116978, -0.09742862487067937, 0.000246922834481,
        0.9391515856363846, -0.3293963604116978, 0.09742862487067927, 0.000246922834481,
        0.9391515856363846, -0.3293963604116978, -0.09742862487067937, 0.000246922834481,
        -0.9391515856363845, 0.32939636041169795, 0.09742862487067927, 0.000246922834481,
        -0.9391515856363845, 0.32939636041169795, -0.09742862487067937, 0.000246922834481,
        -0.9391515856363845, -0.32939636041169795, 0.09742862487067927, 0.000246922834481,
        -0.9391515856363845, -0.32939636041169795, -0.09742862487067937, 0.000246922834481,
        0.9391515856363847, 0.09742862487067834, 0.3293963604116976, 0.000246922834481,
        0.9391515856363847, 0.09742862487067834, -0.3293963604116977, 0.000246922834481,
        0.9391515856363847, -0.09742862487067834, 0.3293963604116976, 0.000246922834481,
        0.9391515856363847, -0.09742862487067834, -0.3293963604116977, 0.000246922834481,
        -0.9391515856363847, 0.09742862487067808, 0.3293963604116976, 0.000246922834481,
        -0.9391515856363847, 0.09742862487067808, -0.3293963604116977, 0.000246922834481,
        -0.9391515856363847, -0.09742862487067808, 0.3293963604116976, 0.000246922834481,
        -0.9391515856363847, -0.09742862487067808, -0.3293963604116977, 0.000246922834481,
        0.3697303822241376, 0.13237995322822896, 0.9196602592499499, 0.000256272634864,
        0.3697303822241378, 0.132379953228229, -0.9196602592499498, 0.000256272634864,
        0.3697303822241376, -0.13237995322822896, 0.9196602592499499, 0.000256272634864,
        0.3697303822241378, -0.132379953228229, -0.9196602592499498, 0.000256272634864,
        -0.3697303822241376, 0.132379953228229, 0.9196602592499499, 0.000256272634864,
        -0.36973038222413773, 0.13237995322822907, -0.9196602592499498, 0.000256272634864,
        -0.3697303822241376, -0.132379953228229, 0.9196602592499499, 0.000256272634864,
        -0.36973038222413773, -0.13237995322822907, -0.9196602592499498, 0.000256272634864,
        0.36973038222413745, 0.9196602592499499, 0.13237995322822912, 0.000256272634864,
        0.3697303822241374, 0.9196602592499498, -0.13237995322822924, 0.000256272634864,
        0.36973038222413745, -0.9196602592499499, 0.13237995322822912, 0.000256272634864,
        0.3697303822241374, -0.9196602592499498, -0.13237995322822924, 0.000256272634864,
        -0.3697303822241378, 0.9196602592499498, 0.13237995322822912, 0.000256272634864,
        -0.36973038222413773, 0.9196602592499498, -0.13237995322822924, 0.000256272634864,
        -0.3697303822241378, -0.9196602592499498, 0.13237995322822912, 0.000256272634864,
        -0.36973038222413773, -0.9196602592499498, -0.13237995322822924, 0.000256272634864,
        0.13237995322822893, 0.3697303822241376, 0.9196602592499499, 0.000256272634864,
        0.13237995322822899, 0.3697303822241378, -0.9196602592499498, 0.000256272634864,
        0.13237995322822893, -0.3697303822241376, 0.9196602592499499, 0.000256272634864,
        0.13237995322822899, -0.3697303822241378, -0.9196602592499498, 0.000256272634864,
        -0.13237995322822896, 0.3697303822241376, 0.9196602592499499, 0.000256272634864,
        -0.132379953228229, 0.3697303822241378, -0.9196602592499498, 0.000256272634864,
        -0.13237995322822896, -0.3697303822241376, 0.9196602592499499, 0.000256272634864,
        -0.132379953228229, -0.3697303822241378, -0.9196602592499498, 0.000256272634864,
        0.13237995322822887, 0.91966025924995, 0.3697303822241376, 0.000256272634864,
        0.13237995322822887, 0.9196602592499499, -0.36973038222413795, 0.000256272634864,
        0.13237995322822887, -0.91966025924995, 0.3697303822241376, 0.000256272634864,
        0.13237995322822887, -0.9196602592499499, -0.36973038222413795, 0.000256272634864,
        -0.13237995322822899, 0.91966025924995, 0.3697303822241376, 0.000256272634864,
        -0.13237995322822899, 0.9196602592499499, -0.36973038222413795, 0.000256272634864,
        -0.13237995322822899, -0.91966025924995, 0.3697303822241376, 0.000256272634864,
        -0.13237995322822899, -0.9196602592499499, -0.36973038222413795, 0.000256272634864,
        0.9196602592499499, 0.3697303822241376, 0.13237995322822912, 0.000256272634864,
        0.9196602592499498, 0.36973038222413757, -0.13237995322822924, 0.000256272634864,
        0.9196602592499499, -0.3697303822241376, 0.13237995322822912, 0.000256272634864,
        0.9196602592499498, -0.36973038222413757, -0.13237995322822924, 0.000256272634864,
        -0.9196602592499498, 0.36973038222413773, 0.13237995322822912, 0.000256272634864,
        -0.9196602592499498, 0.3697303822241377, -0.13237995322822924, 0.000256272634864,
        -0.9196602592499498, -0.36973038222413773, 0.13237995322822912, 0.000256272634864,
        -0.9196602592499498, -0.3697303822241377, -0.13237995322822924, 0.000256272634864,
        0.9196602592499499, 0.13237995322822957, 0.3697303822241376, 0.000256272634864,
        0.9196602592499498, 0.13237995322822954, -0.36973038222413795, 0.000256272634864,
        0.9196602592499499, -0.13237995322822957, 0.3697303822241376, 0.000256272634864,
        0.9196602592499498, -0.13237995322822954, -0.36973038222413795, 0.000256272634864,
        -0.9196602592499499, 0.13237995322822957, 0.3697303822241376, 0.000256272634864,
        -0.9196602592499498, 0.13237995322822954, -0.36973038222413795, 0.000256272634864,
        -0.9196602592499499, -0.13237995322822957, 0.3697303822241376, 0.000256272634864,
        -0.9196602592499498, -0.13237995322822954, -0.36973038222413795, 0.000256272634864,
        0.4090663023135127, 0.16784970181293363, 0.8969343554089447, 0.000263875672675,
        0.4090663023135125, 0.16784970181293354, -0.8969343554089448, 0.000263875672675,
        0.4090663023135127, -0.16784970181293363, 0.8969343554089447, 0.000263875672675,
        0.4090663023135125, -0.16784970181293354, -0.8969343554089448, 0.000263875672675,
        -0.40906630231351276, 0.16784970181293354, 0.8969343554089447, 0.000263875672675,
        -0.40906630231351254, 0.16784970181293346, -0.8969343554089448, 0.000263875672675,
        -0.40906630231351276, -0.16784970181293354, 0.8969343554089447, 0.000263875672675,
        -0.40906630231351254, -0.16784970181293346, -0.8969343554089448, 0.000263875672675,
        0.4090663023135128, 0.8969343554089447, 0.16784970181293352, 0.000263875672675,
        0.4090663023135128, 0.8969343554089447, -0.16784970181293382, 0.000263875672675,
        0.4090663023135128, -0.8969343554089447, 0.16784970181293352, 0.000263875672675,
        0.4090663023135128, -0.8969343554089447, -0.16784970181293382, 0.000263875672675,
        -0.4090663023135129, 0.8969343554089446, 0.16784970181293352, 0.000263875672675,
        -0.4090663023135129, 0.8969343554089446, -0.16784970181293382, 0.000263875672675,
        -0.4090663023135129, -0.8969343554089446, 0.16784970181293352, 0.000263875672675,
        -0.4090663023135129, -0.8969343554089446, -0.16784970181293382, 0.000263875672675,
        0.1678497018129336, 0.4090663023135127, 0.8969343554089447, 0.000263875672675,
        0.16784970181293352, 0.4090663023135125, -0.8969343554089448, 0.000263875672675,
        0.1678497018129336, -0.4090663023135127, 0.8969343554089447, 0.000263875672675,
        0.16784970181293352, -0.4090663023135125, -0.8969343554089448, 0.000263875672675,
        -0.16784970181293363, 0.4090663023135127, 0.8969343554089447, 0.000263875672675,
        -0.16784970181293354, 0.4090663023135125, -0.8969343554089448, 0.000263875672675,
        -0.16784970181293363, -0.4090663023135127, 0.8969343554089447, 0.000263875672675,
        -0.16784970181293354, -0.4090663023135125, -0.8969343554089448, 0.000263875672675,
        0.16784970181293346, 0.8969343554089446, 0.4090663023135127, 0.000263875672675,
        0.16784970181293346, 0.8969343554089446, -0.4090663023135128, 0.000263875672675,
        0.16784970181293346, -0.8969343554089446, 0.4090663023135127, 0.000263875672675,
        0.16784970181293346, -0.8969343554089446, -0.4090663023135128, 0.000263875672675,
        -0.16784970181293357, 0.8969343554089446, 0.4090663023135127, 0.000263875672675,
        -0.16784970181293357, 0.8969343554089446, -0.4090663023135128, 0.000263875672675,
        -0.16784970181293357, -0.8969343554089446, 0.4090663023135127, 0.000263875672675,
        -0.16784970181293357, -0.8969343554089446, -0.4090663023135128, 0.000263875672675,
        0.8969343554089447, 0.4090663023135127, 0.16784970181293352, 0.000263875672675,
        0.8969343554089447, 0.4090663023135127, -0.16784970181293382, 0.000263875672675,
        0.8969343554089447, -0.4090663023135127, 0.16784970181293352, 0.000263875672675,
        0.8969343554089447, -0.4090663023135127, -0.16784970181293382, 0.000263875672675,
        -0.896934355408945, 0.4090663023135123, 0.16784970181293352, 0.000263875672675,
        -0.896934355408945, 0.4090663023135123, -0.16784970181293382, 0.000263875672675,
        -0.896934355408945, -0.4090663023135123, 0.16784970181293352, 0.000263875672675,
        -0.896934355408945, -0.4090663023135123, -0.16784970181293382, 0.000263875672675,
        0.8969343554089446, 0.16784970181293413, 0.4090663023135127, 0.000263875672675,
        0.8969343554089446, 0.16784970181293413, -0.4090663023135128, 0.000263875672675,
        0.8969343554089446, -0.16784970181293413, 0.4090663023135127, 0.000263875672675,
        0.8969343554089446, -0.16784970181293413, -0.4090663023135128, 0.000263875672675,
        -0.8969343554089446, 0.16784970181293374, 0.4090663023135127, 0.000263875672675,
        -0.8969343554089446, 0.16784970181293374, -0.4090663023135128, 0.000263875672675,
        -0.8969343554089446, -0.16784970181293374, 0.4090663023135127, 0.000263875672675,
        -0.8969343554089446, -0.16784970181293374, -0.4090663023135128, 0.000263875672675,
        0.4472819355411711, 0.20350951053261138, 0.8709321151854033, 0.000269931115739,
        0.4472819355411711, 0.20350951053261138, -0.8709321151854033, 0.000269931115739,
        0.4472819355411711, -0.20350951053261138, 0.8709321151854033, 0.000269931115739,
        0.4472819355411711, -0.20350951053261138, -0.8709321151854033, 0.000269931115739,
        -0.4472819355411711, 0.20350951053261138, 0.8709321151854033, 0.000269931115739,
        -0.4472819355411711, 0.20350951053261138, -0.8709321151854033, 0.000269931115739,
        -0.4472819355411711, -0.20350951053261138, 0.8709321151854033, 0.000269931115739,
        -0.4472819355411711, -0.20350951053261138, -0.8709321151854033, 0.000269931115739,
        0.4472819355411712, 0.8709321151854034, 0.20350951053261132, 0.000269931115739,
        0.4472819355411711, 0.8709321151854033, -0.2035095105326114, 0.000269931115739,
        0.4472819355411712, -0.8709321151854034, 0.20350951053261132, 0.000269931115739,
        0.4472819355411711, -0.8709321151854033, -0.2035095105326114, 0.000269931115739,
        -0.44728193554117124, 0.8709321151854033, 0.20350951053261132, 0.000269931115739,
        -0.4472819355411712, 0.8709321151854031, -0.2035095105326114, 0.000269931115739,
        -0.44728193554117124, -0.8709321151854033, 0.20350951053261132, 0.000269931115739,
        -0.4472819355411712, -0.8709321151854031, -0.2035095105326114, 0.000269931115739,
        0.20350951053261143, 0.44728193554117107, 0.8709321151854033, 0.000269931115739,
        0.20350951053261143, 0.44728193554117107, -0.8709321151854033, 0.000269931115739,
        0.20350951053261143, -0.44728193554117107, 0.8709321151854033, 0.000269931115739,
        0.20350951053261143, -0.44728193554117107, -0.8709321151854033, 0.000269931115739,
        -0.20350951053261138, 0.4472819355411711, 0.8709321151854033, 0.000269931115739,
        -0.20350951053261138, 0.4472819355411711, -0.8709321151854033, 0.000269931115739,
        -0.20350951053261138, -0.4472819355411711, 0.8709321151854033, 0.000269931115739,
        -0.20350951053261138, -0.4472819355411711, -0.8709321151854033, 0.000269931115739,
        0.20350951053261135, 0.8709321151854031, 0.44728193554117124, 0.000269931115739,
        0.20350951053261138, 0.8709321151854033, -0.4472819355411711, 0.000269931115739,
        0.20350951053261135, -0.8709321151854031, 0.44728193554117124, 0.000269931115739,
        0.20350951053261138, -0.8709321151854033, -0.4472819355411711, 0.000269931115739,
        -0.20350951053261143, 0.8709321151854031, 0.44728193554117124, 0.000269931115739,
        -0.20350951053261146, 0.8709321151854033, -0.4472819355411711, 0.000269931115739,
        -0.20350951053261143, -0.8709321151854031, 0.44728193554117124, 0.000269931115739,
        -0.20350951053261146, -0.8709321151854033, -0.4472819355411711, 0.000269931115739,
        0.8709321151854033, 0.44728193554117135, 0.20350951053261132, 0.000269931115739,
        0.8709321151854031, 0.4472819355411713, -0.2035095105326114, 0.000269931115739,
        0.8709321151854033, -0.44728193554117135, 0.20350951053261132, 0.000269931115739,
        0.8709321151854031, -0.4472819355411713, -0.2035095105326114, 0.000269931115739,
        -0.8709321151854033, 0.4472819355411714, 0.20350951053261132, 0.000269931115739,
        -0.8709321151854031, 0.44728193554117135, -0.2035095105326114, 0.000269931115739,
        -0.8709321151854033, -0.4472819355411714, 0.20350951053261132, 0.000269931115739,
        -0.8709321151854031, -0.44728193554117135, -0.2035095105326114, 0.000269931115739,
        0.8709321151854031, 0.2035095105326114, 0.44728193554117124, 0.000269931115739,
        0.8709321151854033, 0.20350951053261143, -0.4472819355411711, 0.000269931115739,
        0.8709321151854031, -0.2035095105326114, 0.44728193554117124, 0.000269931115739,
        0.8709321151854033, -0.20350951053261143, -0.4472819355411711, 0.000269931115739,
        -0.8709321151854031, 0.2035095105326114, 0.44728193554117124, 0.000269931115739,
        -0.8709321151854033, 0.20350951053261143, -0.4472819355411711, 0.000269931115739,
        -0.8709321151854031, -0.2035095105326114, 0.44728193554117124, 0.000269931115739,
        -0.8709321151854033, -0.20350951053261143, -0.4472819355411711, 0.000269931115739,
        0.4842513377231437, 0.23906925666720905, 0.8416332529254853, 0.00027462332684,
        0.48425133772314344, 0.2390692566672089, -0.8416332529254855, 0.00027462332684,
        0.4842513377231437, -0.23906925666720905, 0.8416332529254853, 0.00027462332684,
        0.48425133772314344, -0.2390692566672089, -0.8416332529254855, 0.00027462332684,
        -0.48425133772314366, 0.2390692566672091, 0.8416332529254853, 0.00027462332684,
        -0.4842513377231434, 0.23906925666720896, -0.8416332529254855, 0.00027462332684,
        -0.48425133772314366, -0.2390692566672091, 0.8416332529254853, 0.00027462332684,
        -0.4842513377231434, -0.23906925666720896, -0.8416332529254855, 0.00027462332684,
        0.4842513377231437, 0.8416332529254853, 0.23906925666720905, 0.00027462332684,
        0.4842513377231437, 0.8416332529254853, -0.23906925666720913, 0.00027462332684,
        0.4842513377231437, -0.8416332529254853, 0.23906925666720905, 0.00027462332684,
        0.4842513377231437, -0.8416332529254853, -0.23906925666720913, 0.00027462332684,
        -0.4842513377231436, 0.8416332529254853, 0.23906925666720905, 0.00027462332684,
        -0.4842513377231436, 0.8416332529254853, -0.23906925666720913, 0.00027462332684,
        -0.4842513377231436, -0.8416332529254853, 0.23906925666720905, 0.00027462332684,
        -0.4842513377231436, -0.8416332529254853, -0.23906925666720913, 0.00027462332684,
        0.23906925666720907, 0.4842513377231437, 0.8416332529254853, 0.00027462332684,
        0.23906925666720893, 0.48425133772314344, -0.8416332529254855, 0.00027462332684,
        0.23906925666720907, -0.4842513377231437, 0.8416332529254853, 0.00027462332684,
        0.23906925666720893, -0.48425133772314344, -0.8416332529254855, 0.00027462332684,
        -0.23906925666720902, 0.4842513377231437, 0.8416332529254853, 0.00027462332684,
        -0.23906925666720888, 0.48425133772314344, -0.8416332529254855, 0.00027462332684,
        -0.23906925666720902, -0.4842513377231437, 0.8416332529254853, 0.00027462332684,
        -0.23906925666720888, -0.48425133772314344, -0.8416332529254855, 0.00027462332684,
        0.23906925666720916, 0.8416332529254854, 0.48425133772314366, 0.00027462332684,
        0.23906925666720916, 0.8416332529254854, -0.4842513377231436, 0.00027462332684,
        0.23906925666720916, -0.8416332529254854, 0.48425133772314366, 0.00027462332684,
        0.23906925666720916, -0.8416332529254854, -0.4842513377231436, 0.00027462332684,
        -0.2390692566672092, 0.8416332529254853, 0.48425133772314366, 0.00027462332684,
        -0.2390692566672092, 0.8416332529254853, -0.4842513377231436, 0.00027462332684,
        -0.2390692566672092, -0.8416332529254853, 0.48425133772314366, 0.00027462332684,
        -0.2390692566672092, -0.8416332529254853, -0.4842513377231436, 0.00027462332684,
        0.8416332529254853, 0.48425133772314377, 0.23906925666720905, 0.00027462332684,
        0.8416332529254853, 0.48425133772314377, -0.23906925666720913, 0.00027462332684,
        0.8416332529254853, -0.48425133772314377, 0.23906925666720905, 0.00027462332684,
        0.8416332529254853, -0.48425133772314377, -0.23906925666720913, 0.00027462332684,
        -0.8416332529254853, 0.48425133772314377, 0.23906925666720905, 0.00027462332684,
        -0.8416332529254853, 0.48425133772314377, -0.23906925666720913, 0.00027462332684,
        -0.8416332529254853, -0.48425133772314377, 0.23906925666720905, 0.00027462332684,
        -0.8416332529254853, -0.48425133772314377, -0.23906925666720913, 0.00027462332684,
        0.8416332529254854, 0.23906925666720902, 0.48425133772314366, 0.00027462332684,
        0.8416332529254854, 0.23906925666720902, -0.4842513377231436, 0.00027462332684,
        0.8416332529254854, -0.23906925666720902, 0.48425133772314366, 0.00027462332684,
        0.8416332529254854, -0.23906925666720902, -0.4842513377231436, 0.00027462332684,
        -0.8416332529254854, 0.23906925666720902, 0.48425133772314366, 0.00027462332684,
        -0.8416332529254854, 0.23906925666720902, -0.4842513377231436, 0.00027462332684,
        -0.8416332529254854, -0.23906925666720902, 0.48425133772314366, 0.00027462332684,
        -0.8416332529254854, -0.23906925666720902, -0.4842513377231436, 0.00027462332684,
        0.5198477629962927, 0.27426498180761477, 0.8090346241427613, 0.000278122567445,
        0.5198477629962927, 0.27426498180761477, -0.8090346241427614, 0.000278122567445,
        0.5198477629962927, -0.27426498180761477, 0.8090346241427613, 0.000278122567445,
        0.5198477629962927, -0.27426498180761477, -0.8090346241427614, 0.000278122567445,
        -0.5198477629962927, 0.2742649818076148, 0.8090346241427613, 0.000278122567445,
        -0.5198477629962927, 0.2742649818076148, -0.8090346241427614, 0.000278122567445,
        -0.5198477629962927, -0.2742649818076148, 0.8090346241427613, 0.000278122567445,
        -0.5198477629962927, -0.2742649818076148, -0.8090346241427614, 0.000278122567445,
        0.5198477629962928, 0.8090346241427612, 0.2742649818076148, 0.000278122567445,
        0.5198477629962928, 0.8090346241427612, -0.27426498180761494, 0.000278122567445,
        0.5198477629962928, -0.8090346241427612, 0.2742649818076148, 0.000278122567445,
        0.5198477629962928, -0.8090346241427612, -0.27426498180761494, 0.000278122567445,
        -0.5198477629962929, 0.8090346241427611, 0.2742649818076148, 0.000278122567445,
        -0.5198477629962929, 0.8090346241427611, -0.27426498180761494, 0.000278122567445,
        -0.5198477629962929, -0.8090346241427611, 0.2742649818076148, 0.000278122567445,
        -0.5198477629962929, -0.8090346241427611, -0.27426498180761494, 0.000278122567445,
        0.27426498180761477, 0.5198477629962927, 0.8090346241427613, 0.000278122567445,
        0.27426498180761477, 0.5198477629962927, -0.8090346241427614, 0.000278122567445,
        0.27426498180761477, -0.5198477629962927, 0.8090346241427613, 0.000278122567445,
        0.27426498180761477, -0.5198477629962927, -0.8090346241427614, 0.000278122567445,
        -0.27426498180761477, 0.5198477629962927, 0.8090346241427613, 0.000278122567445,
        -0.27426498180761477, 0.5198477629962927, -0.8090346241427614, 0.000278122567445,
        -0.27426498180761477, -0.5198477629962927, 0.8090346241427613, 0.000278122567445,
        -0.27426498180761477, -0.5198477629962927, -0.8090346241427614, 0.000278122567445,
        0.27426498180761494, 0.8090346241427612, 0.5198477629962929, 0.000278122567445,
        0.27426498180761494, 0.8090346241427612, -0.5198477629962928, 0.000278122567445,
        0.27426498180761494, -0.8090346241427612, 0.5198477629962929, 0.000278122567445,
        0.27426498180761494, -0.8090346241427612, -0.5198477629962928, 0.000278122567445,
        -0.2742649818076148, 0.8090346241427612, 0.5198477629962929, 0.000278122567445,
        -0.2742649818076148, 0.8090346241427612, -0.5198477629962928, 0.000278122567445,
        -0.2742649818076148, -0.8090346241427612, 0.5198477629962929, 0.000278122567445,
        -0.2742649818076148, -0.8090346241427612, -0.5198477629962928, 0.000278122567445,
        0.8090346241427612, 0.5198477629962928, 0.2742649818076148, 0.000278122567445,
        0.8090346241427612, 0.5198477629962928, -0.27426498180761494, 0.000278122567445,
        0.8090346241427612, -0.5198477629962928, 0.2742649818076148, 0.000278122567445,
        0.8090346241427612, -0.5198477629962928, -0.27426498180761494, 0.000278122567445,
        -0.8090346241427612, 0.5198477629962927, 0.2742649818076148, 0.000278122567445,
        -0.8090346241427612, 0.5198477629962927, -0.27426498180761494, 0.000278122567445,
        -0.8090346241427612, -0.5198477629962927, 0.2742649818076148, 0.000278122567445,
        -0.8090346241427612, -0.5198477629962927, -0.27426498180761494, 0.000278122567445,
        0.8090346241427612, 0.2742649818076149, 0.5198477629962929, 0.000278122567445,
        0.8090346241427612, 0.2742649818076149, -0.5198477629962928, 0.000278122567445,
        0.8090346241427612, -0.2742649818076149, 0.5198477629962929, 0.000278122567445,
        0.8090346241427612, -0.2742649818076149, -0.5198477629962928, 0.000278122567445,
        -0.8090346241427612, 0.2742649818076148, 0.5198477629962929, 0.000278122567445,
        -0.8090346241427612, 0.2742649818076148, -0.5198477629962928, 0.000278122567445,
        -0.8090346241427612, -0.2742649818076148, 0.5198477629962929, 0.000278122567445,
        -0.8090346241427612, -0.2742649818076148, -0.5198477629962928, 0.000278122567445,
        0.5539453011883145, 0.30885038065800935, 0.7731468461157881, 0.000280588125405,
        0.5539453011883143, 0.3088503806580092, -0.7731468461157884, 0.000280588125405,
        0.5539453011883145, -0.30885038065800935, 0.7731468461157881, 0.000280588125405,
        0.5539453011883143, -0.3088503806580092, -0.7731468461157884, 0.000280588125405,
        -0.5539453011883145, 0.3088503806580094, 0.7731468461157881, 0.000280588125405,
        -0.5539453011883143, 0.30885038065800924, -0.7731468461157884, 0.000280588125405,
        -0.5539453011883145, -0.3088503806580094, 0.7731468461157881, 0.000280588125405,
        -0.5539453011883143, -0.30885038065800924, -0.7731468461157884, 0.000280588125405,
        0.5539453011883146, 0.7731468461157882, 0.3088503806580094, 0.000280588125405,
        0.5539453011883145, 0.7731468461157881, -0.3088503806580097, 0.000280588125405,
        0.5539453011883146, -0.7731468461157882, 0.3088503806580094, 0.000280588125405,
        0.5539453011883145, -0.7731468461157881, -0.3088503806580097, 0.000280588125405,
        -0.5539453011883146, 0.7731468461157882, 0.3088503806580094, 0.000280588125405,
        -0.5539453011883145, 0.7731468461157881, -0.3088503806580097, 0.000280588125405,
        -0.5539453011883146, -0.7731468461157882, 0.3088503806580094, 0.000280588125405,
        -0.5539453011883145, -0.7731468461157881, -0.3088503806580097, 0.000280588125405,
        0.3088503806580094, 0.5539453011883145, 0.7731468461157881, 0.000280588125405,
        0.30885038065800924, 0.5539453011883143, -0.7731468461157884, 0.000280588125405,
        0.3088503806580094, -0.5539453011883145, 0.7731468461157881, 0.000280588125405,
        0.30885038065800924, -0.5539453011883143, -0.7731468461157884, 0.000280588125405,
        -0.30885038065800935, 0.5539453011883146, 0.7731468461157881, 0.000280588125405,
        -0.3088503806580092, 0.5539453011883143, -0.7731468461157884, 0.000280588125405,
        -0.30885038065800935, -0.5539453011883146, 0.7731468461157881, 0.000280588125405,
        -0.3088503806580092, -0.5539453011883143, -0.7731468461157884, 0.000280588125405,
        0.3088503806580095, 0.773146846115788, 0.5539453011883145, 0.000280588125405,
        0.3088503806580095, 0.773146846115788, -0.5539453011883146, 0.000280588125405,
        0.3088503806580095, -0.773146846115788, 0.5539453011883145, 0.000280588125405,
        0.3088503806580095, -0.773146846115788, -0.5539453011883146, 0.000280588125405,
        -0.3088503806580094, 0.7731468461157881, 0.5539453011883145, 0.000280588125405,
        -0.3088503806580094, 0.7731468461157881, -0.5539453011883146, 0.000280588125405,
        -0.3088503806580094, -0.7731468461157881, 0.5539453011883145, 0.000280588125405,
        -0.3088503806580094, -0.7731468461157881, -0.5539453011883146, 0.000280588125405,
        0.7731468461157882, 0.5539453011883146, 0.3088503806580094, 0.000280588125405,
        0.7731468461157881, 0.5539453011883145, -0.3088503806580097, 0.000280588125405,
        0.7731468461157882, -0.5539453011883146, 0.3088503806580094, 0.000280588125405,
        0.7731468461157881, -0.5539453011883145, -0.3088503806580097, 0.000280588125405,
        -0.7731468461157881, 0.5539453011883146, 0.3088503806580094, 0.000280588125405,
        -0.773146846115788, 0.5539453011883146, -0.3088503806580097, 0.000280588125405,
        -0.7731468461157881, -0.5539453011883146, 0.3088503806580094, 0.000280588125405,
        -0.773146846115788, -0.5539453011883146, -0.3088503806580097, 0.000280588125405,
        0.7731468461157881, 0.30885038065800935, 0.5539453011883145, 0.000280588125405,
        0.7731468461157881, 0.30885038065800935, -0.5539453011883146, 0.000280588125405,
        0.7731468461157881, -0.30885038065800935, 0.5539453011883145, 0.000280588125405,
        0.7731468461157881, -0.30885038065800935, -0.5539453011883146, 0.000280588125405,
        -0.7731468461157882, 0.3088503806580092, 0.5539453011883145, 0.000280588125405,
        -0.7731468461157882, 0.3088503806580092, -0.5539453011883146, 0.000280588125405,
        -0.7731468461157882, -0.3088503806580092, 0.5539453011883145, 0.000280588125405,
        -0.7731468461157882, -0.3088503806580092, -0.5539453011883146, 0.000280588125405,
        0.5864196762401251, 0.34259042459066125, 0.7339916650052759, 0.0002821719877,
        0.586419676240125, 0.3425904245906612, -0.733991665005276, 0.0002821719877,
        0.5864196762401251, -0.34259042459066125, 0.7339916650052759, 0.0002821719877,
        0.586419676240125, -0.3425904245906612, -0.733991665005276, 0.0002821719877,
        -0.5864196762401251, 0.34259042459066125, 0.7339916650052759, 0.0002821719877,
        -0.586419676240125, 0.3425904245906612, -0.733991665005276, 0.0002821719877,
        -0.5864196762401251, -0.34259042459066125, 0.7339916650052759, 0.0002821719877,
        -0.586419676240125, -0.3425904245906612, -0.733991665005276, 0.0002821719877,
        0.5864196762401251, 0.7339916650052759, 0.34259042459066136, 0.0002821719877,
        0.5864196762401251, 0.7339916650052759, -0.34259042459066147, 0.0002821719877,
        0.5864196762401251, -0.7339916650052759, 0.34259042459066136, 0.0002821719877,
        0.5864196762401251, -0.7339916650052759, -0.34259042459066147, 0.0002821719877,
        -0.586419676240125, 0.733991665005276, 0.34259042459066136, 0.0002821719877,
        -0.586419676240125, 0.733991665005276, -0.34259042459066147, 0.0002821719877,
        -0.586419676240125, -0.733991665005276, 0.34259042459066136, 0.0002821719877,
        -0.586419676240125, -0.733991665005276, -0.34259042459066147, 0.0002821719877,
        0.34259042459066147, 0.586419676240125, 0.7339916650052759, 0.0002821719877,
        0.3425904245906614, 0.5864196762401249, -0.733991665005276, 0.0002821719877,
        0.34259042459066147, -0.586419676240125, 0.7339916650052759, 0.0002821719877,
        0.3425904245906614, -0.5864196762401249, -0.733991665005276, 0.0002821719877,
        -0.3425904245906614, 0.586419676240125, 0.7339916650052759, 0.0002821719877,
        -0.34259042459066136, 0.586419676240125, -0.733991665005276, 0.0002821719877,
        -0.3425904245906614, -0.586419676240125, 0.7339916650052759, 0.0002821719877,
        -0.34259042459066136, -0.586419676240125, -0.733991665005276, 0.0002821719877,
        0.3425904245906612, 0.7339916650052761, 0.586419676240125, 0.0002821719877,
        0.34259042459066114, 0.7339916650052759, -0.5864196762401253, 0.0002821719877,
        0.3425904245906612, -0.7339916650052761, 0.586419676240125, 0.0002821719877,
        0.34259042459066114, -0.7339916650052759, -0.5864196762401253, 0.0002821719877,
        -0.3425904245906614, 0.7339916650052759, 0.586419676240125, 0.0002821719877,
        -0.34259042459066136, 0.7339916650052757, -0.5864196762401253, 0.0002821719877,
        -0.3425904245906614, -0.7339916650052759, 0.586419676240125, 0.0002821719877,
        -0.34259042459066136, -0.7339916650052757, -0.5864196762401253, 0.0002821719877,
        0.7339916650052759, 0.5864196762401253, 0.34259042459066136, 0.0002821719877,
        0.7339916650052759, 0.5864196762401253, -0.34259042459066147, 0.0002821719877,
        0.7339916650052759, -0.5864196762401253, 0.34259042459066136, 0.0002821719877,
        0.7339916650052759, -0.5864196762401253, -0.34259042459066147, 0.0002821719877,
        -0.7339916650052759, 0.5864196762401253, 0.34259042459066136, 0.0002821719877,
        -0.7339916650052759, 0.5864196762401253, -0.34259042459066147, 0.0002821719877,
        -0.7339916650052759, -0.5864196762401253, 0.34259042459066136, 0.0002821719877,
        -0.7339916650052759, -0.5864196762401253, -0.34259042459066147, 0.0002821719877,
        0.7339916650052759, 0.34259042459066147, 0.586419676240125, 0.0002821719877,
        0.7339916650052757, 0.34259042459066136, -0.5864196762401253, 0.0002821719877,
        0.7339916650052759, -0.34259042459066147, 0.586419676240125, 0.0002821719877,
        0.7339916650052757, -0.34259042459066136, -0.5864196762401253, 0.0002821719877,
        -0.7339916650052759, 0.3425904245906616, 0.586419676240125, 0.0002821719877,
        -0.7339916650052757, 0.34259042459066147, -0.5864196762401253, 0.0002821719877,
        -0.7339916650052759, -0.3425904245906616, 0.586419676240125, 0.0002821719877,
        -0.7339916650052757, -0.34259042459066147, -0.5864196762401253, 0.0002821719877,
        0.617148446666839, 0.37525622947894705, 0.6915999978412027, 0.000283022250233,
        0.6171484466668387, 0.3752562294789469, -0.6915999978412031, 0.000283022250233,
        0.617148446666839, -0.37525622947894705, 0.6915999978412027, 0.000283022250233,
        0.6171484466668387, -0.3752562294789469, -0.6915999978412031, 0.000283022250233,
        -0.6171484466668392, 0.37525622947894677, 0.6915999978412027, 0.000283022250233,
        -0.6171484466668389, 0.37525622947894655, -0.6915999978412031, 0.000283022250233,
        -0.6171484466668392, -0.37525622947894677, 0.6915999978412027, 0.000283022250233,
        -0.6171484466668389, -0.37525622947894655, -0.6915999978412031, 0.000283022250233,
        0.6171484466668391, 0.6915999978412029, 0.37525622947894677, 0.000283022250233,
        0.617148446666839, 0.6915999978412027, -0.3752562294789469, 0.000283022250233,
        0.6171484466668391, -0.6915999978412029, 0.37525622947894677, 0.000283022250233,
        0.617148446666839, -0.6915999978412027, -0.3752562294789469, 0.000283022250233,
        -0.617148446666839, 0.691599997841203, 0.37525622947894677, 0.000283022250233,
        -0.6171484466668389, 0.6915999978412029, -0.3752562294789469, 0.000283022250233,
        -0.617148446666839, -0.691599997841203, 0.37525622947894677, 0.000283022250233,
        -0.6171484466668389, -0.6915999978412029, -0.3752562294789469, 0.000283022250233,
        0.3752562294789468, 0.6171484466668391, 0.6915999978412027, 0.000283022250233,
        0.37525622947894666, 0.6171484466668389, -0.6915999978412031, 0.000283022250233,
        0.3752562294789468, -0.6171484466668391, 0.6915999978412027, 0.000283022250233,
        0.37525622947894666, -0.6171484466668389, -0.6915999978412031, 0.000283022250233,
        -0.3752562294789469, 0.617148446666839, 0.6915999978412027, 0.000283022250233,
        -0.3752562294789467, 0.6171484466668388, -0.6915999978412031, 0.000283022250233,
        -0.3752562294789469, -0.617148446666839, 0.6915999978412027, 0.000283022250233,
        -0.3752562294789467, -0.6171484466668388, -0.6915999978412031, 0.000283022250233,
        0.37525622947894693, 0.6915999978412029, 0.617148446666839, 0.000283022250233,
        0.37525622947894677, 0.6915999978412026, -0.6171484466668393, 0.000283022250233,
        0.37525622947894693, -0.6915999978412029, 0.617148446666839, 0.000283022250233,
        0.37525622947894677, -0.6915999978412026, -0.6171484466668393, 0.000283022250233,
        -0.3752562294789468, 0.6915999978412029, 0.617148446666839, 0.000283022250233,
        -0.37525622947894666, 0.6915999978412026, -0.6171484466668393, 0.000283022250233,
        -0.3752562294789468, -0.6915999978412029, 0.617148446666839, 0.000283022250233,
        -0.37525622947894666, -0.6915999978412026, -0.6171484466668393, 0.000283022250233,
        0.691599997841203, 0.6171484466668391, 0.37525622947894677, 0.000283022250233,
        0.6915999978412029, 0.617148446666839, -0.3752562294789469, 0.000283022250233,
        0.691599997841203, -0.6171484466668391, 0.37525622947894677, 0.000283022250233,
        0.6915999978412029, -0.617148446666839, -0.3752562294789469, 0.000283022250233,
        -0.6915999978412029, 0.6171484466668391, 0.37525622947894677, 0.000283022250233,
        -0.6915999978412027, 0.617148446666839, -0.3752562294789469, 0.000283022250233,
        -0.6915999978412029, -0.6171484466668391, 0.37525622947894677, 0.000283022250233,
        -0.6915999978412027, -0.617148446666839, -0.3752562294789469, 0.000283022250233,
        0.691599997841203, 0.3752562294789467, 0.617148446666839, 0.000283022250233,
        0.6915999978412027, 0.37525622947894655, -0.6171484466668393, 0.000283022250233,
        0.691599997841203, -0.3752562294789467, 0.617148446666839, 0.000283022250233,
        0.6915999978412027, -0.37525622947894655, -0.6171484466668393, 0.000283022250233,
        -0.691599997841203, 0.37525622947894666, 0.617148446666839, 0.000283022250233,
        -0.6915999978412027, 0.3752562294789465, -0.6171484466668393, 0.000283022250233,
        -0.691599997841203, -0.37525622947894666, 0.617148446666839, 0.000283022250233,
        -0.6915999978412027, -0.3752562294789465, -0.6171484466668393, 0.000283022250233,
        0.33503378305657266, 0.03261589934634742, 0.9416414218377558, 0.000245799595674,
        0.33503378305657255, 0.032615899346347406, -0.9416414218377558, 0.000245799595674,
        0.33503378305657266, -0.03261589934634742, 0.9416414218377558, 0.000245799595674,
        0.33503378305657255, -0.032615899346347406, -0.9416414218377558, 0.000245799595674,
        -0.33503378305657266, 0.0326158993463474, 0.9416414218377558, 0.000245799595674,
        -0.33503378305657255, 0.032615899346347385, -0.9416414218377558, 0.000245799595674,
        -0.33503378305657266, -0.0326158993463474, 0.9416414218377558, 0.000245799595674,
        -0.33503378305657255, -0.032615899346347385, -0.9416414218377558, 0.000245799595674,
        0.3350337830565725, 0.9416414218377558, 0.03261589934634747, 0.000245799595674,
        0.3350337830565725, 0.9416414218377558, -0.03261589934634757, 0.000245799595674,
        0.3350337830565725, -0.9416414218377558, 0.03261589934634747, 0.000245799595674,
        0.3350337830565725, -0.9416414218377558, -0.03261589934634757, 0.000245799595674,
        -0.33503378305657283, 0.9416414218377557, 0.03261589934634747, 0.000245799595674,
        -0.33503378305657283, 0.9416414218377557, -0.03261589934634757, 0.000245799595674,
        -0.33503378305657283, -0.9416414218377557, 0.03261589934634747, 0.000245799595674,
        -0.33503378305657283, -0.9416414218377557, -0.03261589934634757, 0.000245799595674,
        0.03261589934634737, 0.33503378305657266, 0.9416414218377558, 0.000245799595674,
        0.032615899346347364, 0.33503378305657255, -0.9416414218377558, 0.000245799595674,
        0.03261589934634737, -0.33503378305657266, 0.9416414218377558, 0.000245799595674,
        0.032615899346347364, -0.33503378305657255, -0.9416414218377558, 0.000245799595674,
        -0.03261589934634748, 0.33503378305657266, 0.9416414218377558, 0.000245799595674,
        -0.03261589934634747, 0.33503378305657255, -0.9416414218377558, 0.000245799595674,
        -0.03261589934634748, -0.33503378305657266, 0.9416414218377558, 0.000245799595674,
        -0.03261589934634747, -0.33503378305657255, -0.9416414218377558, 0.000245799595674,
        0.03261589934634745, 0.9416414218377558, 0.33503378305657255, 0.000245799595674,
        0.03261589934634745, 0.9416414218377558, -0.3350337830565726, 0.000245799595674,
        0.03261589934634745, -0.9416414218377558, 0.33503378305657255, 0.000245799595674,
        0.03261589934634745, -0.9416414218377558, -0.3350337830565726, 0.000245799595674,
        -0.03261589934634754, 0.9416414218377558, 0.33503378305657255, 0.000245799595674,
        -0.03261589934634754, 0.9416414218377558, -0.3350337830565726, 0.000245799595674,
        -0.03261589934634754, -0.9416414218377558, 0.33503378305657255, 0.000245799595674,
        -0.03261589934634754, -0.9416414218377558, -0.3350337830565726, 0.000245799595674,
        0.9416414218377558, 0.33503378305657255, 0.03261589934634747, 0.000245799595674,
        0.9416414218377558, 0.33503378305657255, -0.03261589934634757, 0.000245799595674,
        0.9416414218377558, -0.33503378305657255, 0.03261589934634747, 0.000245799595674,
        0.9416414218377558, -0.33503378305657255, -0.03261589934634757, 0.000245799595674,
        -0.9416414218377558, 0.33503378305657255, 0.03261589934634747, 0.000245799595674,
        -0.9416414218377558, 0.33503378305657255, -0.03261589934634757, 0.000245799595674,
        -0.9416414218377558, -0.33503378305657255, 0.03261589934634747, 0.000245799595674,
        -0.9416414218377558, -0.33503378305657255, -0.03261589934634757, 0.000245799595674,
        0.9416414218377559, 0.03261589934634541, 0.33503378305657255, 0.000245799595674,
        0.9416414218377559, 0.03261589934634541, -0.3350337830565726, 0.000245799595674,
        0.9416414218377559, -0.03261589934634541, 0.33503378305657255, 0.000245799595674,
        0.9416414218377559, -0.03261589934634541, -0.3350337830565726, 0.000245799595674,
        -0.9416414218377559, 0.032615899346345414, 0.33503378305657255, 0.000245799595674,
        -0.9416414218377559, 0.032615899346345414, -0.3350337830565726, 0.000245799595674,
        -0.9416414218377559, -0.032615899346345414, 0.33503378305657255, 0.000245799595674,
        -0.9416414218377559, -0.032615899346345414, -0.3350337830565726, 0.000245799595674,
        0.3775773224758284, 0.06658438928081567, 0.9235810114202679, 0.00025514744075,
        0.3775773224758285, 0.06658438928081568, -0.9235810114202679, 0.00025514744075,
        0.3775773224758284, -0.06658438928081567, 0.9235810114202679, 0.00025514744075,
        0.3775773224758285, -0.06658438928081568, -0.9235810114202679, 0.00025514744075,
        -0.3775773224758284, 0.06658438928081563, 0.9235810114202679, 0.00025514744075,
        -0.3775773224758285, 0.06658438928081564, -0.9235810114202679, 0.00025514744075,
        -0.3775773224758284, -0.06658438928081563, 0.9235810114202679, 0.00025514744075,
        -0.3775773224758285, -0.06658438928081564, -0.9235810114202679, 0.00025514744075,
        0.3775773224758285, 0.9235810114202679, 0.06658438928081571, 0.00025514744075,
        0.3775773224758285, 0.9235810114202679, -0.06658438928081581, 0.00025514744075,
        0.3775773224758285, -0.9235810114202679, 0.06658438928081571, 0.00025514744075,
        0.3775773224758285, -0.9235810114202679, -0.06658438928081581, 0.00025514744075,
        -0.37757732247582837, 0.9235810114202679, 0.06658438928081571, 0.00025514744075,
        -0.37757732247582837, 0.9235810114202679, -0.06658438928081581, 0.00025514744075,
        -0.37757732247582837, -0.9235810114202679, 0.06658438928081571, 0.00025514744075,
        -0.37757732247582837, -0.9235810114202679, -0.06658438928081581, 0.00025514744075,
        0.06658438928081568, 0.3775773224758284, 0.9235810114202679, 0.00025514744075,
        0.06658438928081568, 0.3775773224758285, -0.9235810114202679, 0.00025514744075,
        0.06658438928081568, -0.3775773224758284, 0.9235810114202679, 0.00025514744075,
        0.06658438928081568, -0.3775773224758285, -0.9235810114202679, 0.00025514744075,
        -0.06658438928081573, 0.3775773224758284, 0.9235810114202679, 0.00025514744075,
        -0.06658438928081574, 0.3775773224758285, -0.9235810114202679, 0.00025514744075,
        -0.06658438928081573, -0.3775773224758284, 0.9235810114202679, 0.00025514744075,
        -0.06658438928081574, -0.3775773224758285, -0.9235810114202679, 0.00025514744075,
        0.06658438928081568, 0.9235810114202679, 0.3775773224758285, 0.00025514744075,
        0.06658438928081568, 0.9235810114202679, -0.37757732247582837, 0.00025514744075,
        0.06658438928081568, -0.9235810114202679, 0.3775773224758285, 0.00025514744075,
        0.06658438928081568, -0.9235810114202679, -0.37757732247582837, 0.00025514744075,
        -0.06658438928081578, 0.9235810114202679, 0.3775773224758285, 0.00025514744075,
        -0.06658438928081578, 0.9235810114202679, -0.37757732247582837, 0.00025514744075,
        -0.06658438928081578, -0.9235810114202679, 0.3775773224758285, 0.00025514744075,
        -0.06658438928081578, -0.9235810114202679, -0.37757732247582837, 0.00025514744075,
        0.9235810114202678, 0.37757732247582865, 0.06658438928081571, 0.00025514744075,
        0.9235810114202678, 0.37757732247582865, -0.06658438928081581, 0.00025514744075,
        0.9235810114202678, -0.37757732247582865, 0.06658438928081571, 0.00025514744075,
        0.9235810114202678, -0.37757732247582865, -0.06658438928081581, 0.00025514744075,
        -0.9235810114202678, 0.3775773224758287, 0.06658438928081571, 0.00025514744075,
        -0.9235810114202678, 0.3775773224758287, -0.06658438928081581, 0.00025514744075,
        -0.9235810114202678, -0.3775773224758287, 0.06658438928081571, 0.00025514744075,
        -0.9235810114202678, -0.3775773224758287, -0.06658438928081581, 0.00025514744075,
        0.9235810114202679, 0.06658438928081536, 0.3775773224758285, 0.00025514744075,
        0.9235810114202679, 0.06658438928081536, -0.37757732247582837, 0.00025514744075,
        0.9235810114202679, -0.06658438928081536, 0.3775773224758285, 0.00025514744075,
        0.9235810114202679, -0.06658438928081536, -0.37757732247582837, 0.00025514744075,
        -0.9235810114202679, 0.06658438928081553, 0.3775773224758285, 0.00025514744075,
        -0.9235810114202679, 0.06658438928081553, -0.37757732247582837, 0.00025514744075,
        -0.9235810114202679, -0.06658438928081553, 0.3775773224758285, 0.00025514744075,
        -0.9235810114202679, -0.06658438928081553, -0.37757732247582837, 0.00025514744075,
        0.4188155229848974, 0.10145657971579546, 0.9023857934050488, 0.00026290653352,
        0.4188155229848973, 0.10145657971579546, -0.9023857934050488, 0.00026290653352,
        0.4188155229848974, -0.10145657971579546, 0.9023857934050488, 0.00026290653352,
        0.4188155229848973, -0.10145657971579546, -0.9023857934050488, 0.00026290653352,
        -0.4188155229848974, 0.10145657971579554, 0.9023857934050488, 0.00026290653352,
        -0.4188155229848973, 0.10145657971579554, -0.9023857934050488, 0.00026290653352,
        -0.4188155229848974, -0.10145657971579554, 0.9023857934050488, 0.00026290653352,
        -0.4188155229848973, -0.10145657971579554, -0.9023857934050488, 0.00026290653352,
        0.4188155229848974, 0.9023857934050489, 0.10145657971579547, 0.00026290653352,
        0.4188155229848974, 0.9023857934050489, -0.10145657971579534, 0.00026290653352,
        0.4188155229848974, -0.9023857934050489, 0.10145657971579547, 0.00026290653352,
        0.4188155229848974, -0.9023857934050489, -0.10145657971579534, 0.00026290653352,
        -0.41881552298489744, 0.9023857934050488, 0.10145657971579547, 0.00026290653352,
        -0.41881552298489744, 0.9023857934050488, -0.10145657971579534, 0.00026290653352,
        -0.41881552298489744, -0.9023857934050488, 0.10145657971579547, 0.00026290653352,
        -0.41881552298489744, -0.9023857934050488, -0.10145657971579534, 0.00026290653352,
        0.10145657971579543, 0.4188155229848974, 0.9023857934050488, 0.00026290653352,
        0.10145657971579541, 0.4188155229848973, -0.9023857934050488, 0.00026290653352,
        0.10145657971579543, -0.4188155229848974, 0.9023857934050488, 0.00026290653352,
        0.10145657971579541, -0.4188155229848973, -0.9023857934050488, 0.00026290653352,
        -0.10145657971579537, 0.4188155229848974, 0.9023857934050488, 0.00026290653352,
        -0.10145657971579536, 0.4188155229848973, -0.9023857934050488, 0.00026290653352,
        -0.10145657971579537, -0.4188155229848974, 0.9023857934050488, 0.00026290653352,
        -0.10145657971579536, -0.4188155229848973, -0.9023857934050488, 0.00026290653352,
        0.10145657971579533, 0.9023857934050489, 0.4188155229848972, 0.00026290653352,
        0.10145657971579532, 0.9023857934050488, -0.4188155229848973, 0.00026290653352,
        0.10145657971579533, -0.9023857934050489, 0.4188155229848972, 0.00026290653352,
        0.10145657971579532, -0.9023857934050488, -0.4188155229848973, 0.00026290653352,
        -0.10145657971579562, 0.9023857934050488, 0.4188155229848972, 0.00026290653352,
        -0.10145657971579561, 0.9023857934050487, -0.4188155229848973, 0.00026290653352,
        -0.10145657971579562, -0.9023857934050488, 0.4188155229848972, 0.00026290653352,
        -0.10145657971579561, -0.9023857934050487, -0.4188155229848973, 0.00026290653352,
        0.9023857934050488, 0.41881552298489755, 0.10145657971579547, 0.00026290653352,
        0.9023857934050488, 0.41881552298489755, -0.10145657971579534, 0.00026290653352,
        0.9023857934050488, -0.41881552298489755, 0.10145657971579547, 0.00026290653352,
        0.9023857934050488, -0.41881552298489755, -0.10145657971579534, 0.00026290653352,
        -0.9023857934050487, 0.4188155229848976, 0.10145657971579547, 0.00026290653352,
        -0.9023857934050487, 0.4188155229848976, -0.10145657971579534, 0.00026290653352,
        -0.9023857934050487, -0.4188155229848976, 0.10145657971579547, 0.00026290653352,
        -0.9023857934050487, -0.4188155229848976, -0.10145657971579534, 0.00026290653352,
        0.9023857934050489, 0.10145657971579507, 0.4188155229848972, 0.00026290653352,
        0.9023857934050488, 0.10145657971579505, -0.4188155229848973, 0.00026290653352,
        0.9023857934050489, -0.10145657971579507, 0.4188155229848972, 0.00026290653352,
        0.9023857934050488, -0.10145657971579505, -0.4188155229848973, 0.00026290653352,
        -0.9023857934050489, 0.10145657971579478, 0.4188155229848972, 0.00026290653352,
        -0.9023857934050488, 0.10145657971579476, -0.4188155229848973, 0.00026290653352,
        -0.9023857934050489, -0.10145657971579478, 0.4188155229848972, 0.00026290653352,
        -0.9023857934050488, -0.10145657971579476, -0.4188155229848973, 0.00026290653352,
        0.45868058920093446, 0.1368573320843822, 0.8779989679635328, 0.000269190044993,
        0.4586805892009343, 0.13685733208438214, -0.8779989679635329, 0.000269190044993,
        0.45868058920093446, -0.1368573320843822, 0.8779989679635328, 0.000269190044993,
        0.4586805892009343, -0.13685733208438214, -0.8779989679635329, 0.000269190044993,
        -0.45868058920093446, 0.13685733208438225, 0.8779989679635328, 0.000269190044993,
        -0.4586805892009343, 0.1368573320843822, -0.8779989679635329, 0.000269190044993,
        -0.45868058920093446, -0.13685733208438225, 0.8779989679635328, 0.000269190044993,
        -0.4586805892009343, -0.1368573320843822, -0.8779989679635329, 0.000269190044993,
        0.45868058920093435, 0.8779989679635329, 0.1368573320843819, 0.000269190044993,
        0.4586805892009343, 0.8779989679635328, -0.13685733208438222, 0.000269190044993,
        0.45868058920093435, -0.8779989679635329, 0.1368573320843819, 0.000269190044993,
        0.4586805892009343, -0.8779989679635328, -0.13685733208438222, 0.000269190044993,
        -0.4586805892009347, 0.8779989679635328, 0.1368573320843819, 0.000269190044993,
        -0.45868058920093463, 0.8779989679635327, -0.13685733208438222, 0.000269190044993,
        -0.4586805892009347, -0.8779989679635328, 0.1368573320843819, 0.000269190044993,
        -0.45868058920093463, -0.8779989679635327, -0.13685733208438222, 0.000269190044993,
        0.13685733208438222, 0.45868058920093446, 0.8779989679635328, 0.000269190044993,
        0.13685733208438217, 0.4586805892009343, -0.8779989679635329, 0.000269190044993,
        0.13685733208438222, -0.45868058920093446, 0.8779989679635328, 0.000269190044993,
        0.13685733208438217, -0.4586805892009343, -0.8779989679635329, 0.000269190044993,
        -0.13685733208438225, 0.45868058920093446, 0.8779989679635328, 0.000269190044993,
        -0.1368573320843822, 0.4586805892009343, -0.8779989679635329, 0.000269190044993,
        -0.13685733208438225, -0.45868058920093446, 0.8779989679635328, 0.000269190044993,
        -0.1368573320843822, -0.4586805892009343, -0.8779989679635329, 0.000269190044993,
        0.13685733208438222, 0.8779989679635329, 0.45868058920093446, 0.000269190044993,
        0.13685733208438222, 0.8779989679635329, -0.45868058920093435, 0.000269190044993,
        0.13685733208438222, -0.8779989679635329, 0.45868058920093446, 0.000269190044993,
        0.13685733208438222, -0.8779989679635329, -0.45868058920093435, 0.000269190044993,
        -0.1368573320843823, 0.8779989679635329, 0.45868058920093446, 0.000269190044993,
        -0.1368573320843823, 0.8779989679635329, -0.45868058920093435, 0.000269190044993,
        -0.1368573320843823, -0.8779989679635329, 0.45868058920093446, 0.000269190044993,
        -0.1368573320843823, -0.8779989679635329, -0.45868058920093435, 0.000269190044993,
        0.8779989679635329, 0.4586805892009344, 0.1368573320843819, 0.000269190044993,
        0.8779989679635328, 0.45868058920093435, -0.13685733208438222, 0.000269190044993,
        0.8779989679635329, -0.4586805892009344, 0.1368573320843819, 0.000269190044993,
        0.8779989679635328, -0.45868058920093435, -0.13685733208438222, 0.000269190044993,
        -0.8779989679635329, 0.4586805892009344, 0.1368573320843819, 0.000269190044993,
        -0.8779989679635328, 0.45868058920093435, -0.13685733208438222, 0.000269190044993,
        -0.8779989679635329, -0.4586805892009344, 0.1368573320843819, 0.000269190044993,
        -0.8779989679635328, -0.45868058920093435, -0.13685733208438222, 0.000269190044993,
        0.8779989679635329, 0.13685733208438214, 0.45868058920093446, 0.000269190044993,
        0.8779989679635329, 0.13685733208438214, -0.45868058920093435, 0.000269190044993,
        0.8779989679635329, -0.13685733208438214, 0.45868058920093446, 0.000269190044993,
        0.8779989679635329, -0.13685733208438214, -0.45868058920093435, 0.000269190044993,
        -0.8779989679635329, 0.13685733208438228, 0.45868058920093446, 0.000269190044993,
        -0.8779989679635329, 0.13685733208438228, -0.45868058920093435, 0.000269190044993,
        -0.8779989679635329, -0.13685733208438228, 0.45868058920093446, 0.000269190044993,
        -0.8779989679635329, -0.13685733208438228, -0.45868058920093435, 0.000269190044993,
        0.4970895714224235, 0.17246148519516083, 0.8503875552401685, 0.000274127548575,
        0.4970895714224237, 0.1724614851951609, -0.8503875552401684, 0.000274127548575,
        0.4970895714224235, -0.17246148519516083, 0.8503875552401685, 0.000274127548575,
        0.4970895714224237, -0.1724614851951609, -0.8503875552401684, 0.000274127548575,
        -0.49708957142242344, 0.17246148519516094, 0.8503875552401685, 0.000274127548575,
        -0.49708957142242366, 0.17246148519516102, -0.8503875552401684, 0.000274127548575,
        -0.49708957142242344, -0.17246148519516094, 0.8503875552401685, 0.000274127548575,
        -0.49708957142242366, -0.17246148519516102, -0.8503875552401684, 0.000274127548575,
        0.4970895714224235, 0.8503875552401685, 0.17246148519516083, 0.000274127548575,
        0.49708957142242355, 0.8503875552401685, -0.17246148519516072, 0.000274127548575,
        0.4970895714224235, -0.8503875552401685, 0.17246148519516083, 0.000274127548575,
        0.49708957142242355, -0.8503875552401685, -0.17246148519516072, 0.000274127548575,
        -0.4970895714224234, 0.8503875552401685, 0.17246148519516083, 0.000274127548575,
        -0.49708957142242344, 0.8503875552401685, -0.17246148519516072, 0.000274127548575,
        -0.4970895714224234, -0.8503875552401685, 0.17246148519516083, 0.000274127548575,
        -0.49708957142242344, -0.8503875552401685, -0.17246148519516072, 0.000274127548575,
        0.1724614851951608, 0.4970895714224235, 0.8503875552401685, 0.000274127548575,
        0.17246148519516089, 0.4970895714224237, -0.8503875552401684, 0.000274127548575,
        0.1724614851951608, -0.4970895714224235, 0.8503875552401685, 0.000274127548575,
        0.17246148519516089, -0.4970895714224237, -0.8503875552401684, 0.000274127548575,
        -0.17246148519516086, 0.4970895714224235, 0.8503875552401685, 0.000274127548575,
        -0.17246148519516094, 0.4970895714224237, -0.8503875552401684, 0.000274127548575,
        -0.17246148519516086, -0.4970895714224235, 0.8503875552401685, 0.000274127548575,
        -0.17246148519516094, -0.4970895714224237, -0.8503875552401684, 0.000274127548575,
        0.17246148519516083, 0.8503875552401685, 0.4970895714224235, 0.000274127548575,
        0.17246148519516083, 0.8503875552401685, -0.4970895714224234, 0.000274127548575,
        0.17246148519516083, -0.8503875552401685, 0.4970895714224235, 0.000274127548575,
        0.17246148519516083, -0.8503875552401685, -0.4970895714224234, 0.000274127548575,
        -0.17246148519516075, 0.8503875552401685, 0.4970895714224235, 0.000274127548575,
        -0.17246148519516075, 0.8503875552401685, -0.4970895714224234, 0.000274127548575,
        -0.17246148519516075, -0.8503875552401685, 0.4970895714224235, 0.000274127548575,
        -0.17246148519516075, -0.8503875552401685, -0.4970895714224234, 0.000274127548575,
        0.8503875552401685, 0.4970895714224235, 0.17246148519516083, 0.000274127548575,
        0.8503875552401685, 0.49708957142242355, -0.17246148519516072, 0.000274127548575,
        0.8503875552401685, -0.4970895714224235, 0.17246148519516083, 0.000274127548575,
        0.8503875552401685, -0.49708957142242355, -0.17246148519516072, 0.000274127548575,
        -0.8503875552401684, 0.4970895714224236, 0.17246148519516083, 0.000274127548575,
        -0.8503875552401684, 0.49708957142242366, -0.17246148519516072, 0.000274127548575,
        -0.8503875552401684, -0.4970895714224236, 0.17246148519516083, 0.000274127548575,
        -0.8503875552401684, -0.49708957142242366, -0.17246148519516072, 0.000274127548575,
        0.8503875552401685, 0.17246148519516089, 0.4970895714224235, 0.000274127548575,
        0.8503875552401685, 0.17246148519516089, -0.4970895714224234, 0.000274127548575,
        0.8503875552401685, -0.17246148519516089, 0.4970895714224235, 0.000274127548575,
        0.8503875552401685, -0.17246148519516089, -0.4970895714224234, 0.000274127548575,
        -0.8503875552401685, 0.17246148519516089, 0.4970895714224235, 0.000274127548575,
        -0.8503875552401685, 0.17246148519516089, -0.4970895714224234, 0.000274127548575,
        -0.8503875552401685, -0.17246148519516089, 0.4970895714224235, 0.000274127548575,
        -0.8503875552401685, -0.17246148519516089, -0.4970895714224234, 0.000274127548575,
        0.5339505133960747, 0.20797793814164134, 0.8195376907076452, 0.000277853097012,
        0.5339505133960747, 0.20797793814164134, -0.8195376907076452, 0.000277853097012,
        0.5339505133960747, -0.20797793814164134, 0.8195376907076452, 0.000277853097012,
        0.5339505133960747, -0.20797793814164134, -0.8195376907076452, 0.000277853097012,
        -0.5339505133960747, 0.20797793814164126, 0.8195376907076452, 0.000277853097012,
        -0.5339505133960747, 0.20797793814164126, -0.8195376907076452, 0.000277853097012,
        -0.5339505133960747, -0.20797793814164126, 0.8195376907076452, 0.000277853097012,
        -0.5339505133960747, -0.20797793814164126, -0.8195376907076452, 0.000277853097012,
        0.5339505133960747, 0.8195376907076453, 0.2079779381416411, 0.000277853097012,
        0.5339505133960747, 0.8195376907076452, -0.2079779381416412, 0.000277853097012,
        0.5339505133960747, -0.8195376907076453, 0.2079779381416411, 0.000277853097012,
        0.5339505133960747, -0.8195376907076452, -0.2079779381416412, 0.000277853097012,
        -0.5339505133960748, 0.8195376907076452, 0.2079779381416411, 0.000277853097012,
        -0.5339505133960748, 0.819537690707645, -0.2079779381416412, 0.000277853097012,
        -0.5339505133960748, -0.8195376907076452, 0.2079779381416411, 0.000277853097012,
        -0.5339505133960748, -0.819537690707645, -0.2079779381416412, 0.000277853097012,
        0.2079779381416411, 0.5339505133960748, 0.8195376907076452, 0.000277853097012,
        0.2079779381416411, 0.5339505133960748, -0.8195376907076452, 0.000277853097012,
        0.2079779381416411, -0.5339505133960748, 0.8195376907076452, 0.000277853097012,
        0.2079779381416411, -0.5339505133960748, -0.8195376907076452, 0.000277853097012,
        -0.20797793814164114, 0.5339505133960748, 0.8195376907076452, 0.000277853097012,
        -0.20797793814164114, 0.5339505133960748, -0.8195376907076452, 0.000277853097012,
        -0.20797793814164114, -0.5339505133960748, 0.8195376907076452, 0.000277853097012,
        -0.20797793814164114, -0.5339505133960748, -0.8195376907076452, 0.000277853097012,
        0.2079779381416412, 0.8195376907076452, 0.5339505133960748, 0.000277853097012,
        0.2079779381416412, 0.8195376907076452, -0.5339505133960749, 0.000277853097012,
        0.2079779381416412, -0.8195376907076452, 0.5339505133960748, 0.000277853097012,
        0.2079779381416412, -0.8195376907076452, -0.5339505133960749, 0.000277853097012,
        -0.20797793814164112, 0.8195376907076452, 0.5339505133960748, 0.000277853097012,
        -0.20797793814164112, 0.8195376907076452, -0.5339505133960749, 0.000277853097012,
        -0.20797793814164112, -0.8195376907076452, 0.5339505133960748, 0.000277853097012,
        -0.20797793814164112, -0.8195376907076452, -0.5339505133960749, 0.000277853097012,
        0.8195376907076453, 0.5339505133960747, 0.2079779381416411, 0.000277853097012,
        0.8195376907076452, 0.5339505133960747, -0.2079779381416412, 0.000277853097012,
        0.8195376907076453, -0.5339505133960747, 0.2079779381416411, 0.000277853097012,
        0.8195376907076452, -0.5339505133960747, -0.2079779381416412, 0.000277853097012,
        -0.8195376907076453, 0.5339505133960746, 0.2079779381416411, 0.000277853097012,
        -0.8195376907076452, 0.5339505133960746, -0.2079779381416412, 0.000277853097012,
        -0.8195376907076453, -0.5339505133960746, 0.2079779381416411, 0.000277853097012,
        -0.8195376907076452, -0.5339505133960746, -0.2079779381416412, 0.000277853097012,
        0.8195376907076452, 0.20797793814164114, 0.5339505133960748, 0.000277853097012,
        0.8195376907076452, 0.20797793814164114, -0.5339505133960749, 0.000277853097012,
        0.8195376907076452, -0.20797793814164114, 0.5339505133960748, 0.000277853097012,
        0.8195376907076452, -0.20797793814164114, -0.5339505133960749, 0.000277853097012,
        -0.8195376907076452, 0.20797793814164126, 0.5339505133960748, 0.000277853097012,
        -0.8195376907076452, 0.20797793814164126, -0.5339505133960749, 0.000277853097012,
        -0.8195376907076452, -0.20797793814164126, 0.5339505133960748, 0.000277853097012,
        -0.8195376907076452, -0.20797793814164126, -0.5339505133960749, 0.000277853097012,
        0.5691665792531438, 0.24313857883222867, 0.785450849222737, 0.000280501056765,
        0.5691665792531437, 0.24313857883222864, -0.7854508492227371, 0.000280501056765,
        0.5691665792531438, -0.24313857883222867, 0.785450849222737, 0.000280501056765,
        0.5691665792531437, -0.24313857883222864, -0.7854508492227371, 0.000280501056765,
        -0.5691665792531438, 0.2431385788322286, 0.785450849222737, 0.000280501056765,
        -0.5691665792531437, 0.24313857883222856, -0.7854508492227371, 0.000280501056765,
        -0.5691665792531438, -0.2431385788322286, 0.785450849222737, 0.000280501056765,
        -0.5691665792531437, -0.24313857883222856, -0.7854508492227371, 0.000280501056765,
        0.569166579253144, 0.785450849222737, 0.24313857883222853, 0.000280501056765,
        0.5691665792531438, 0.785450849222737, -0.24313857883222884, 0.000280501056765,
        0.569166579253144, -0.785450849222737, 0.24313857883222853, 0.000280501056765,
        0.5691665792531438, -0.785450849222737, -0.24313857883222884, 0.000280501056765,
        -0.5691665792531441, 0.785450849222737, 0.24313857883222853, 0.000280501056765,
        -0.569166579253144, 0.7854508492227369, -0.24313857883222884, 0.000280501056765,
        -0.5691665792531441, -0.785450849222737, 0.24313857883222853, 0.000280501056765,
        -0.569166579253144, -0.7854508492227369, -0.24313857883222884, 0.000280501056765,
        0.24313857883222884, 0.5691665792531438, 0.785450849222737, 0.000280501056765,
        0.2431385788322288, 0.5691665792531437, -0.7854508492227371, 0.000280501056765,
        0.24313857883222884, -0.5691665792531438, 0.785450849222737, 0.000280501056765,
        0.2431385788322288, -0.5691665792531437, -0.7854508492227371, 0.000280501056765,
        -0.2431385788322289, 0.5691665792531438, 0.785450849222737, 0.000280501056765,
        -0.24313857883222884, 0.5691665792531437, -0.7854508492227371, 0.000280501056765,
        -0.2431385788322289, -0.5691665792531438, 0.785450849222737, 0.000280501056765,
        -0.24313857883222884, -0.5691665792531437, -0.7854508492227371, 0.000280501056765,
        0.24313857883222892, 0.785450849222737, 0.569166579253144, 0.000280501056765,
        0.24313857883222892, 0.785450849222737, -0.569166579253144, 0.000280501056765,
        0.24313857883222892, -0.785450849222737, 0.569166579253144, 0.000280501056765,
        0.24313857883222892, -0.785450849222737, -0.569166579253144, 0.000280501056765,
        -0.24313857883222884, 0.785450849222737, 0.569166579253144, 0.000280501056765,
        -0.24313857883222884, 0.785450849222737, -0.569166579253144, 0.000280501056765,
        -0.24313857883222884, -0.785450849222737, 0.569166579253144, 0.000280501056765,
        -0.24313857883222884, -0.785450849222737, -0.569166579253144, 0.000280501056765,
        0.785450849222737, 0.5691665792531442, 0.24313857883222853, 0.000280501056765,
        0.7854508492227369, 0.5691665792531441, -0.24313857883222884, 0.000280501056765,
        0.785450849222737, -0.5691665792531442, 0.24313857883222853, 0.000280501056765,
        0.7854508492227369, -0.5691665792531441, -0.24313857883222884, 0.000280501056765,
        -0.7854508492227371, 0.5691665792531438, 0.24313857883222853, 0.000280501056765,
        -0.7854508492227371, 0.5691665792531437, -0.24313857883222884, 0.000280501056765,
        -0.7854508492227371, -0.5691665792531438, 0.24313857883222853, 0.000280501056765,
        -0.7854508492227371, -0.5691665792531437, -0.24313857883222884, 0.000280501056765,
        0.785450849222737, 0.24313857883222892, 0.569166579253144, 0.000280501056765,
        0.785450849222737, 0.24313857883222892, -0.569166579253144, 0.000280501056765,
        0.785450849222737, -0.24313857883222892, 0.569166579253144, 0.000280501056765,
        0.785450849222737, -0.24313857883222892, -0.569166579253144, 0.000280501056765,
        -0.785450849222737, 0.24313857883222878, 0.569166579253144, 0.000280501056765,
        -0.785450849222737, 0.24313857883222878, -0.569166579253144, 0.000280501056765,
        -0.785450849222737, -0.24313857883222878, 0.569166579253144, 0.000280501056765,
        -0.785450849222737, -0.24313857883222878, -0.569166579253144, 0.000280501056765,
        0.6026387682680377, 0.27769018830498543, 0.7481408118125384, 0.000282205583403,
        0.6026387682680376, 0.2776901883049854, -0.7481408118125386, 0.000282205583403,
        0.6026387682680377, -0.27769018830498543, 0.7481408118125384, 0.000282205583403,
        0.6026387682680376, -0.2776901883049854, -0.7481408118125386, 0.000282205583403,
        -0.6026387682680377, 0.2776901883049855, 0.7481408118125384, 0.000282205583403,
        -0.6026387682680376, 0.27769018830498543, -0.7481408118125386, 0.000282205583403,
        -0.6026387682680377, -0.2776901883049855, 0.7481408118125384, 0.000282205583403,
        -0.6026387682680376, -0.27769018830498543, -0.7481408118125386, 0.000282205583403,
        0.6026387682680377, 0.7481408118125386, 0.2776901883049853, 0.000282205583403,
        0.6026387682680376, 0.7481408118125384, -0.27769018830498543, 0.000282205583403,
        0.6026387682680377, -0.7481408118125386, 0.2776901883049853, 0.000282205583403,
        0.6026387682680376, -0.7481408118125384, -0.27769018830498543, 0.000282205583403,
        -0.6026387682680376, 0.7481408118125387, 0.2776901883049853, 0.000282205583403,
        -0.6026387682680375, 0.7481408118125386, -0.27769018830498543, 0.000282205583403,
        -0.6026387682680376, -0.7481408118125387, 0.2776901883049853, 0.000282205583403,
        -0.6026387682680375, -0.7481408118125386, -0.27769018830498543, 0.000282205583403,
        0.27769018830498526, 0.6026387682680379, 0.7481408118125384, 0.000282205583403,
        0.2776901883049852, 0.6026387682680377, -0.7481408118125386, 0.000282205583403,
        0.27769018830498526, -0.6026387682680379, 0.7481408118125384, 0.000282205583403,
        0.2776901883049852, -0.6026387682680377, -0.7481408118125386, 0.000282205583403,
        -0.2776901883049853, 0.6026387682680379, 0.7481408118125384, 0.000282205583403,
        -0.27769018830498526, 0.6026387682680377, -0.7481408118125386, 0.000282205583403,
        -0.2776901883049853, -0.6026387682680379, 0.7481408118125384, 0.000282205583403,
        -0.27769018830498526, -0.6026387682680377, -0.7481408118125386, 0.000282205583403,
        0.27769018830498526, 0.7481408118125384, 0.6026387682680377, 0.000282205583403,
        0.2776901883049852, 0.7481408118125383, -0.6026387682680379, 0.000282205583403,
        0.27769018830498526, -0.7481408118125384, 0.6026387682680377, 0.000282205583403,
        0.2776901883049852, -0.7481408118125383, -0.6026387682680379, 0.000282205583403,
        -0.2776901883049853, 0.7481408118125383, 0.6026387682680377, 0.000282205583403,
        -0.2776901883049853, 0.7481408118125382, -0.6026387682680379, 0.000282205583403,
        -0.2776901883049853, -0.7481408118125383, 0.6026387682680377, 0.000282205583403,
        -0.2776901883049853, -0.7481408118125382, -0.6026387682680379, 0.000282205583403,
        0.7481408118125384, 0.6026387682680379, 0.2776901883049853, 0.000282205583403,
        0.7481408118125383, 0.6026387682680377, -0.27769018830498543, 0.000282205583403,
        0.7481408118125384, -0.6026387682680379, 0.2776901883049853, 0.000282205583403,
        0.7481408118125383, -0.6026387682680377, -0.27769018830498543, 0.000282205583403,
        -0.7481408118125386, 0.6026387682680377, 0.2776901883049853, 0.000282205583403,
        -0.7481408118125384, 0.6026387682680376, -0.27769018830498543, 0.000282205583403,
        -0.7481408118125386, -0.6026387682680377, 0.2776901883049853, 0.000282205583403,
        -0.7481408118125384, -0.6026387682680376, -0.27769018830498543, 0.000282205583403,
        0.7481408118125384, 0.27769018830498526, 0.6026387682680377, 0.000282205583403,
        0.7481408118125383, 0.2776901883049852, -0.6026387682680379, 0.000282205583403,
        0.7481408118125384, -0.27769018830498526, 0.6026387682680377, 0.000282205583403,
        0.7481408118125383, -0.2776901883049852, -0.6026387682680379, 0.000282205583403,
        -0.7481408118125384, 0.27769018830498515, 0.6026387682680377, 0.000282205583403,
        -0.7481408118125383, 0.27769018830498515, -0.6026387682680379, 0.000282205583403,
        -0.7481408118125384, -0.27769018830498515, 0.6026387682680377, 0.000282205583403,
        -0.7481408118125383, -0.27769018830498515, -0.6026387682680379, 0.000282205583403,
        0.6342676150163307, 0.3113881356386632, 0.7076312751178917, 0.000283101690124,
        0.6342676150163304, 0.3113881356386631, -0.7076312751178918, 0.000283101690124,
        0.6342676150163307, -0.3113881356386632, 0.7076312751178917, 0.000283101690124,
        0.6342676150163304, -0.3113881356386631, -0.7076312751178918, 0.000283101690124,
        -0.6342676150163308, 0.31138813563866286, 0.7076312751178917, 0.000283101690124,
        -0.6342676150163307, 0.31138813563866274, -0.7076312751178918, 0.000283101690124,
        -0.6342676150163308, -0.31138813563866286, 0.7076312751178917, 0.000283101690124,
        -0.6342676150163307, -0.31138813563866274, -0.7076312751178918, 0.000283101690124,
        0.6342676150163306, 0.7076312751178917, 0.3113881356386632, 0.000283101690124,
        0.6342676150163306, 0.7076312751178917, -0.31138813563866324, 0.000283101690124,
        0.6342676150163306, -0.7076312751178917, 0.3113881356386632, 0.000283101690124,
        0.6342676150163306, -0.7076312751178917, -0.31138813563866324, 0.000283101690124,
        -0.634267615016331, 0.7076312751178914, 0.3113881356386632, 0.000283101690124,
        -0.634267615016331, 0.7076312751178914, -0.31138813563866324, 0.000283101690124,
        -0.634267615016331, -0.7076312751178914, 0.3113881356386632, 0.000283101690124,
        -0.634267615016331, -0.7076312751178914, -0.31138813563866324, 0.000283101690124,
        0.31138813563866324, 0.6342676150163306, 0.7076312751178917, 0.000283101690124,
        0.31138813563866313, 0.6342676150163303, -0.7076312751178918, 0.000283101690124,
        0.31138813563866324, -0.6342676150163306, 0.7076312751178917, 0.000283101690124,
        0.31138813563866313, -0.6342676150163303, -0.7076312751178918, 0.000283101690124,
        -0.3113881356386633, 0.6342676150163306, 0.7076312751178917, 0.000283101690124,
        -0.3113881356386632, 0.6342676150163303, -0.7076312751178918, 0.000283101690124,
        -0.3113881356386633, -0.6342676150163306, 0.7076312751178917, 0.000283101690124,
        -0.3113881356386632, -0.6342676150163303, -0.7076312751178918, 0.000283101690124,
        0.311388135638663, 0.7076312751178917, 0.6342676150163307, 0.000283101690124,
        0.311388135638663, 0.7076312751178917, -0.6342676150163307, 0.000283101690124,
        0.311388135638663, -0.7076312751178917, 0.6342676150163307, 0.000283101690124,
        0.311388135638663, -0.7076312751178917, -0.6342676150163307, 0.000283101690124,
        -0.311388135638663, 0.7076312751178917, 0.6342676150163307, 0.000283101690124,
        -0.311388135638663, 0.7076312751178917, -0.6342676150163307, 0.000283101690124,
        -0.311388135638663, -0.7076312751178917, 0.6342676150163307, 0.000283101690124,
        -0.311388135638663, -0.7076312751178917, -0.6342676150163307, 0.000283101690124,
        0.7076312751178917, 0.6342676150163306, 0.3113881356386632, 0.000283101690124,
        0.7076312751178917, 0.6342676150163306, -0.31138813563866324, 0.000283101690124,
        0.7076312751178917, -0.6342676150163306, 0.3113881356386632, 0.000283101690124,
        0.7076312751178917, -0.6342676150163306, -0.31138813563866324, 0.000283101690124,
        -0.7076312751178917, 0.6342676150163306, 0.3113881356386632, 0.000283101690124,
        -0.7076312751178917, 0.6342676150163306, -0.31138813563866324, 0.000283101690124,
        -0.7076312751178917, -0.6342676150163306, 0.3113881356386632, 0.000283101690124,
        -0.7076312751178917, -0.6342676150163306, -0.31138813563866324, 0.000283101690124,
        0.7076312751178916, 0.31138813563866324, 0.6342676150163307, 0.000283101690124,
        0.7076312751178916, 0.31138813563866324, -0.6342676150163307, 0.000283101690124,
        0.7076312751178916, -0.31138813563866324, 0.6342676150163307, 0.000283101690124,
        0.7076312751178916, -0.31138813563866324, -0.6342676150163307, 0.000283101690124,
        -0.7076312751178916, 0.31138813563866335, 0.6342676150163307, 0.000283101690124,
        -0.7076312751178916, 0.31138813563866335, -0.6342676150163307, 0.000283101690124,
        -0.7076312751178916, -0.31138813563866335, 0.6342676150163307, 0.000283101690124,
        -0.7076312751178916, -0.31138813563866335, -0.6342676150163307, 0.000283101690124,
        0.4237951119537068, 0.03394877848664351, 0.9051216401807052, 0.000262447490113,
        0.42379511195370684, 0.033948778486643516, -0.9051216401807052, 0.000262447490113,
        0.4237951119537068, -0.03394877848664351, 0.9051216401807052, 0.000262447490113,
        0.42379511195370684, -0.033948778486643516, -0.9051216401807052, 0.000262447490113,
        -0.4237951119537068, 0.0339487784866433, 0.9051216401807052, 0.000262447490113,
        -0.42379511195370684, 0.03394877848664331, -0.9051216401807052, 0.000262447490113,
        -0.4237951119537068, -0.0339487784866433, 0.9051216401807052, 0.000262447490113,
        -0.42379511195370684, -0.03394877848664331, -0.9051216401807052, 0.000262447490113,
        0.4237951119537068, 0.9051216401807053, 0.03394877848664348, 0.000262447490113,
        0.4237951119537068, 0.9051216401807053, -0.03394877848664358, 0.000262447490113,
        0.4237951119537068, -0.9051216401807053, 0.03394877848664348, 0.000262447490113,
        0.4237951119537068, -0.9051216401807053, -0.03394877848664358, 0.000262447490113,
        -0.42379511195370667, 0.9051216401807053, 0.03394877848664348, 0.000262447490113,
        -0.42379511195370667, 0.9051216401807053, -0.03394877848664358, 0.000262447490113,
        -0.42379511195370667, -0.9051216401807053, 0.03394877848664348, 0.000262447490113,
        -0.42379511195370667, -0.9051216401807053, -0.03394877848664358, 0.000262447490113,
        0.033948778486643565, 0.4237951119537068, 0.9051216401807052, 0.000262447490113,
        0.033948778486643565, 0.42379511195370684, -0.9051216401807052, 0.000262447490113,
        0.033948778486643565, -0.4237951119537068, 0.9051216401807052, 0.000262447490113,
        0.033948778486643565, -0.42379511195370684, -0.9051216401807052, 0.000262447490113,
        -0.03394877848664351, 0.4237951119537068, 0.9051216401807052, 0.000262447490113,
        -0.033948778486643516, 0.42379511195370684, -0.9051216401807052, 0.000262447490113,
        -0.03394877848664351, -0.4237951119537068, 0.9051216401807052, 0.000262447490113,
        -0.033948778486643516, -0.42379511195370684, -0.9051216401807052, 0.000262447490113,
        0.03394877848664342, 0.9051216401807052, 0.4237951119537068, 0.000262447490113,
        0.03394877848664341, 0.9051216401807051, -0.4237951119537069, 0.000262447490113,
        0.03394877848664342, -0.9051216401807052, 0.4237951119537068, 0.000262447490113,
        0.03394877848664341, -0.9051216401807051, -0.4237951119537069, 0.000262447490113,
        -0.033948778486643516, 0.9051216401807052, 0.4237951119537068, 0.000262447490113,
        -0.03394877848664351, 0.9051216401807051, -0.4237951119537069, 0.000262447490113,
        -0.033948778486643516, -0.9051216401807052, 0.4237951119537068, 0.000262447490113,
        -0.03394877848664351, -0.9051216401807051, -0.4237951119537069, 0.000262447490113,
        0.9051216401807053, 0.4237951119537067, 0.03394877848664348, 0.000262447490113,
        0.9051216401807053, 0.4237951119537067, -0.03394877848664358, 0.000262447490113,
        0.9051216401807053, -0.4237951119537067, 0.03394877848664348, 0.000262447490113,
        0.9051216401807053, -0.4237951119537067, -0.03394877848664358, 0.000262447490113,
        -0.9051216401807052, 0.42379511195370684, 0.03394877848664348, 0.000262447490113,
        -0.9051216401807052, 0.42379511195370684, -0.03394877848664358, 0.000262447490113,
        -0.9051216401807052, -0.42379511195370684, 0.03394877848664348, 0.000262447490113,
        -0.9051216401807052, -0.42379511195370684, -0.03394877848664358, 0.000262447490113,
        0.9051216401807052, 0.033948778486645875, 0.4237951119537068, 0.000262447490113,
        0.9051216401807051, 0.033948778486645875, -0.4237951119537069, 0.000262447490113,
        0.9051216401807052, -0.033948778486645875, 0.4237951119537068, 0.000262447490113,
        0.9051216401807051, -0.033948778486645875, -0.4237951119537069, 0.000262447490113,
        -0.9051216401807052, 0.03394877848664569, 0.4237951119537068, 0.000262447490113,
        -0.9051216401807051, 0.03394877848664568, -0.4237951119537069, 0.000262447490113,
        -0.9051216401807052, -0.03394877848664569, 0.4237951119537068, 0.000262447490113,
        -0.9051216401807051, -0.03394877848664568, -0.4237951119537069, 0.000262447490113,
        0.4656918683234929, 0.06880219556291445, 0.8822682934703576, 0.000268803416304,
        0.46569186832349285, 0.06880219556291445, -0.8822682934703576, 0.000268803416304,
        0.4656918683234929, -0.06880219556291445, 0.8822682934703576, 0.000268803416304,
        0.46569186832349285, -0.06880219556291445, -0.8822682934703576, 0.000268803416304,
        -0.4656918683234929, 0.0688021955629144, 0.8822682934703576, 0.000268803416304,
        -0.46569186832349285, 0.0688021955629144, -0.8822682934703576, 0.000268803416304,
        -0.4656918683234929, -0.0688021955629144, 0.8822682934703576, 0.000268803416304,
        -0.46569186832349285, -0.0688021955629144, -0.8822682934703576, 0.000268803416304,
        0.46569186832349285, 0.8822682934703576, 0.06880219556291452, 0.000268803416304,
        0.46569186832349285, 0.8822682934703576, -0.06880219556291439, 0.000268803416304,
        0.46569186832349285, -0.8822682934703576, 0.06880219556291452, 0.000268803416304,
        0.46569186832349285, -0.8822682934703576, -0.06880219556291439, 0.000268803416304,
        -0.46569186832349274, 0.8822682934703576, 0.06880219556291452, 0.000268803416304,
        -0.46569186832349274, 0.8822682934703576, -0.06880219556291439, 0.000268803416304,
        -0.46569186832349274, -0.8822682934703576, 0.06880219556291452, 0.000268803416304,
        -0.46569186832349274, -0.8822682934703576, -0.06880219556291439, 0.000268803416304,
        0.06880219556291448, 0.4656918683234929, 0.8822682934703576, 0.000268803416304,
        0.06880219556291448, 0.46569186832349285, -0.8822682934703576, 0.000268803416304,
        0.06880219556291448, -0.4656918683234929, 0.8822682934703576, 0.000268803416304,
        0.06880219556291448, -0.46569186832349285, -0.8822682934703576, 0.000268803416304,
        -0.06880219556291442, 0.4656918683234929, 0.8822682934703576, 0.000268803416304,
        -0.06880219556291442, 0.46569186832349285, -0.8822682934703576, 0.000268803416304,
        -0.06880219556291442, -0.4656918683234929, 0.8822682934703576, 0.000268803416304,
        -0.06880219556291442, -0.46569186832349285, -0.8822682934703576, 0.000268803416304,
        0.06880219556291438, 0.8822682934703575, 0.46569186832349296, 0.000268803416304,
        0.06880219556291439, 0.8822682934703576, -0.46569186832349285, 0.000268803416304,
        0.06880219556291438, -0.8822682934703575, 0.46569186832349296, 0.000268803416304,
        0.06880219556291439, -0.8822682934703576, -0.46569186832349285, 0.000268803416304,
        -0.06880219556291448, 0.8822682934703575, 0.46569186832349296, 0.000268803416304,
        -0.06880219556291448, 0.8822682934703576, -0.46569186832349285, 0.000268803416304,
        -0.06880219556291448, -0.8822682934703575, 0.46569186832349296, 0.000268803416304,
        -0.06880219556291448, -0.8822682934703576, -0.46569186832349285, 0.000268803416304,
        0.8822682934703576, 0.46569186832349285, 0.06880219556291452, 0.000268803416304,
        0.8822682934703576, 0.46569186832349285, -0.06880219556291439, 0.000268803416304,
        0.8822682934703576, -0.46569186832349285, 0.06880219556291452, 0.000268803416304,
        0.8822682934703576, -0.46569186832349285, -0.06880219556291439, 0.000268803416304,
        -0.8822682934703576, 0.4656918683234929, 0.06880219556291452, 0.000268803416304,
        -0.8822682934703576, 0.4656918683234929, -0.06880219556291439, 0.000268803416304,
        -0.8822682934703576, -0.4656918683234929, 0.06880219556291452, 0.000268803416304,
        -0.8822682934703576, -0.4656918683234929, -0.06880219556291439, 0.000268803416304,
        0.8822682934703575, 0.06880219556291467, 0.46569186832349296, 0.000268803416304,
        0.8822682934703576, 0.06880219556291467, -0.46569186832349285, 0.000268803416304,
        0.8822682934703575, -0.06880219556291467, 0.46569186832349296, 0.000268803416304,
        0.8822682934703576, -0.06880219556291467, -0.46569186832349285, 0.000268803416304,
        -0.8822682934703575, 0.06880219556291482, 0.46569186832349296, 0.000268803416304,
        -0.8822682934703576, 0.06880219556291484, -0.46569186832349285, 0.000268803416304,
        -0.8822682934703575, -0.06880219556291482, 0.46569186832349296, 0.000268803416304,
        -0.8822682934703576, -0.06880219556291484, -0.46569186832349285, 0.000268803416304,
        0.505885706918598, 0.10419468597216337, 0.8562844848241924, 0.000273893275129,
        0.5058857069185979, 0.10419468597216336, -0.8562844848241925, 0.000273893275129,
        0.505885706918598, -0.10419468597216337, 0.8562844848241924, 0.000273893275129,
        0.5058857069185979, -0.10419468597216336, -0.8562844848241925, 0.000273893275129,
        -0.505885706918598, 0.10419468597216335, 0.8562844848241924, 0.000273893275129,
        -0.5058857069185979, 0.10419468597216332, -0.8562844848241925, 0.000273893275129,
        -0.505885706918598, -0.10419468597216335, 0.8562844848241924, 0.000273893275129,
        -0.5058857069185979, -0.10419468597216332, -0.8562844848241925, 0.000273893275129,
        0.505885706918598, 0.8562844848241924, 0.10419468597216353, 0.000273893275129,
        0.505885706918598, 0.8562844848241924, -0.1041946859721634, 0.000273893275129,
        0.505885706918598, -0.8562844848241924, 0.10419468597216353, 0.000273893275129,
        0.505885706918598, -0.8562844848241924, -0.1041946859721634, 0.000273893275129,
        -0.5058857069185981, 0.8562844848241923, 0.10419468597216353, 0.000273893275129,
        -0.5058857069185981, 0.8562844848241923, -0.1041946859721634, 0.000273893275129,
        -0.5058857069185981, -0.8562844848241923, 0.10419468597216353, 0.000273893275129,
        -0.5058857069185981, -0.8562844848241923, -0.1041946859721634, 0.000273893275129,
        0.10419468597216355, 0.505885706918598, 0.8562844848241924, 0.000273893275129,
        0.10419468597216353, 0.5058857069185979, -0.8562844848241925, 0.000273893275129,
        0.10419468597216355, -0.505885706918598, 0.8562844848241924, 0.000273893275129,
        0.10419468597216353, -0.5058857069185979, -0.8562844848241925, 0.000273893275129,
        -0.10419468597216347, 0.505885706918598, 0.8562844848241924, 0.000273893275129,
        -0.10419468597216346, 0.5058857069185979, -0.8562844848241925, 0.000273893275129,
        -0.10419468597216347, -0.505885706918598, 0.8562844848241924, 0.000273893275129,
        -0.10419468597216346, -0.5058857069185979, -0.8562844848241925, 0.000273893275129,
        0.10419468597216353, 0.8562844848241923, 0.5058857069185981, 0.000273893275129,
        0.10419468597216353, 0.8562844848241923, -0.5058857069185982, 0.000273893275129,
        0.10419468597216353, -0.8562844848241923, 0.5058857069185981, 0.000273893275129,
        0.10419468597216353, -0.8562844848241923, -0.5058857069185982, 0.000273893275129,
        -0.10419468597216341, 0.8562844848241924, 0.5058857069185981, 0.000273893275129,
        -0.10419468597216341, 0.8562844848241924, -0.5058857069185982, 0.000273893275129,
        -0.10419468597216341, -0.8562844848241924, 0.5058857069185981, 0.000273893275129,
        -0.10419468597216341, -0.8562844848241924, -0.5058857069185982, 0.000273893275129,
        0.8562844848241924, 0.505885706918598, 0.10419468597216353, 0.000273893275129,
        0.8562844848241924, 0.505885706918598, -0.1041946859721634, 0.000273893275129,
        0.8562844848241924, -0.505885706918598, 0.10419468597216353, 0.000273893275129,
        0.8562844848241924, -0.505885706918598, -0.1041946859721634, 0.000273893275129,
        -0.8562844848241924, 0.5058857069185979, 0.10419468597216353, 0.000273893275129,
        -0.8562844848241924, 0.5058857069185979, -0.1041946859721634, 0.000273893275129,
        -0.8562844848241924, -0.5058857069185979, 0.10419468597216353, 0.000273893275129,
        -0.8562844848241924, -0.5058857069185979, -0.1041946859721634, 0.000273893275129,
        0.8562844848241924, 0.10419468597216311, 0.5058857069185981, 0.000273893275129,
        0.8562844848241924, 0.10419468597216311, -0.5058857069185982, 0.000273893275129,
        0.8562844848241924, -0.10419468597216311, 0.5058857069185981, 0.000273893275129,
        0.8562844848241924, -0.10419468597216311, -0.5058857069185982, 0.000273893275129,
        -0.8562844848241924, 0.10419468597216319, 0.5058857069185981, 0.000273893275129,
        -0.8562844848241924, 0.10419468597216319, -0.5058857069185982, 0.000273893275129,
        -0.8562844848241924, -0.10419468597216319, 0.5058857069185981, 0.000273893275129,
        -0.8562844848241924, -0.10419468597216319, -0.5058857069185982, 0.000273893275129,
        0.5443204666713997, 0.13980397387363916, 0.8271457419655671, 0.000277794479124,
        0.5443204666713994, 0.1398039738736391, -0.8271457419655672, 0.000277794479124,
        0.5443204666713997, -0.13980397387363916, 0.8271457419655671, 0.000277794479124,
        0.5443204666713994, -0.1398039738736391, -0.8271457419655672, 0.000277794479124,
        -0.5443204666713997, 0.13980397387363921, 0.8271457419655671, 0.000277794479124,
        -0.5443204666713994, 0.13980397387363916, -0.8271457419655672, 0.000277794479124,
        -0.5443204666713997, -0.13980397387363921, 0.8271457419655671, 0.000277794479124,
        -0.5443204666713994, -0.13980397387363916, -0.8271457419655672, 0.000277794479124,
        0.5443204666713997, 0.8271457419655672, 0.1398039738736391, 0.000277794479124,
        0.5443204666713997, 0.8271457419655672, -0.13980397387363921, 0.000277794479124,
        0.5443204666713997, -0.8271457419655672, 0.1398039738736391, 0.000277794479124,
        0.5443204666713997, -0.8271457419655672, -0.13980397387363921, 0.000277794479124,
        -0.5443204666713997, 0.8271457419655672, 0.1398039738736391, 0.000277794479124,
        -0.5443204666713997, 0.8271457419655672, -0.13980397387363921, 0.000277794479124,
        -0.5443204666713997, -0.8271457419655672, 0.1398039738736391, 0.000277794479124,
        -0.5443204666713997, -0.8271457419655672, -0.13980397387363921, 0.000277794479124,
        0.1398039738736393, 0.5443204666713997, 0.8271457419655671, 0.000277794479124,
        0.13980397387363924, 0.5443204666713994, -0.8271457419655672, 0.000277794479124,
        0.1398039738736393, -0.5443204666713997, 0.8271457419655671, 0.000277794479124,
        0.13980397387363924, -0.5443204666713994, -0.8271457419655672, 0.000277794479124,
        -0.13980397387363946, 0.5443204666713997, 0.8271457419655671, 0.000277794479124,
        -0.1398039738736394, 0.5443204666713994, -0.8271457419655672, 0.000277794479124,
        -0.13980397387363946, -0.5443204666713997, 0.8271457419655671, 0.000277794479124,
        -0.1398039738736394, -0.5443204666713994, -0.8271457419655672, 0.000277794479124,
        0.13980397387363924, 0.8271457419655673, 0.5443204666713994, 0.000277794479124,
        0.13980397387363921, 0.8271457419655671, -0.5443204666713997, 0.000277794479124,
        0.13980397387363924, -0.8271457419655673, 0.5443204666713994, 0.000277794479124,
        0.13980397387363921, -0.8271457419655671, -0.5443204666713997, 0.000277794479124,
        -0.13980397387363952, 0.8271457419655672, 0.5443204666713994, 0.000277794479124,
        -0.13980397387363946, 0.827145741965567, -0.5443204666713997, 0.000277794479124,
        -0.13980397387363952, -0.8271457419655672, 0.5443204666713994, 0.000277794479124,
        -0.13980397387363946, -0.827145741965567, -0.5443204666713997, 0.000277794479124,
        0.8271457419655672, 0.5443204666713995, 0.1398039738736391, 0.000277794479124,
        0.8271457419655672, 0.5443204666713995, -0.13980397387363921, 0.000277794479124,
        0.8271457419655672, -0.5443204666713995, 0.1398039738736391, 0.000277794479124,
        0.8271457419655672, -0.5443204666713995, -0.13980397387363921, 0.000277794479124,
        -0.8271457419655673, 0.5443204666713994, 0.1398039738736391, 0.000277794479124,
        -0.8271457419655673, 0.5443204666713994, -0.13980397387363921, 0.000277794479124,
        -0.8271457419655673, -0.5443204666713994, 0.1398039738736391, 0.000277794479124,
        -0.8271457419655673, -0.5443204666713994, -0.13980397387363921, 0.000277794479124,
        0.8271457419655672, 0.13980397387363958, 0.5443204666713994, 0.000277794479124,
        0.827145741965567, 0.13980397387363955, -0.5443204666713997, 0.000277794479124,
        0.8271457419655672, -0.13980397387363958, 0.5443204666713994, 0.000277794479124,
        0.827145741965567, -0.13980397387363955, -0.5443204666713997, 0.000277794479124,
        -0.8271457419655672, 0.13980397387363966, 0.5443204666713994, 0.000277794479124,
        -0.827145741965567, 0.13980397387363963, -0.5443204666713997, 0.000277794479124,
        -0.8271457419655672, -0.13980397387363966, 0.5443204666713994, 0.000277794479124,
        -0.827145741965567, -0.13980397387363963, -0.5443204666713997, 0.000277794479124,
        0.5809298813759741, 0.17533733811961566, 0.7948441927734166, 0.000280601166166,
        0.5809298813759742, 0.1753373381196157, -0.7948441927734164, 0.000280601166166,
        0.5809298813759741, -0.17533733811961566, 0.7948441927734166, 0.000280601166166,
        0.5809298813759742, -0.1753373381196157, -0.7948441927734164, 0.000280601166166,
        -0.5809298813759741, 0.17533733811961566, 0.7948441927734166, 0.000280601166166,
        -0.5809298813759742, 0.1753373381196157, -0.7948441927734164, 0.000280601166166,
        -0.5809298813759741, -0.17533733811961566, 0.7948441927734166, 0.000280601166166,
        -0.5809298813759742, -0.1753373381196157, -0.7948441927734164, 0.000280601166166,
        0.5809298813759741, 0.7948441927734166, 0.17533733811961555, 0.000280601166166,
        0.5809298813759741, 0.7948441927734166, -0.17533733811961544, 0.000280601166166,
        0.5809298813759741, -0.7948441927734166, 0.17533733811961555, 0.000280601166166,
        0.5809298813759741, -0.7948441927734166, -0.17533733811961544, 0.000280601166166,
        -0.580929881375974, 0.7948441927734166, 0.17533733811961555, 0.000280601166166,
        -0.580929881375974, 0.7948441927734166, -0.17533733811961544, 0.000280601166166,
        -0.580929881375974, -0.7948441927734166, 0.17533733811961555, 0.000280601166166,
        -0.580929881375974, -0.7948441927734166, -0.17533733811961544, 0.000280601166166,
        0.1753373381196155, 0.5809298813759742, 0.7948441927734166, 0.000280601166166,
        0.17533733811961552, 0.5809298813759743, -0.7948441927734164, 0.000280601166166,
        0.1753373381196155, -0.5809298813759742, 0.7948441927734166, 0.000280601166166,
        0.17533733811961552, -0.5809298813759743, -0.7948441927734164, 0.000280601166166,
        -0.17533733811961544, 0.5809298813759742, 0.7948441927734166, 0.000280601166166,
        -0.17533733811961547, 0.5809298813759743, -0.7948441927734164, 0.000280601166166,
        -0.17533733811961544, -0.5809298813759742, 0.7948441927734166, 0.000280601166166,
        -0.17533733811961547, -0.5809298813759743, -0.7948441927734164, 0.000280601166166,
        0.17533733811961527, 0.7948441927734166, 0.5809298813759742, 0.000280601166166,
        0.17533733811961527, 0.7948441927734166, -0.5809298813759742, 0.000280601166166,
        0.17533733811961527, -0.7948441927734166, 0.5809298813759742, 0.000280601166166,
        0.17533733811961527, -0.7948441927734166, -0.5809298813759742, 0.000280601166166,
        -0.17533733811961555, 0.7948441927734166, 0.5809298813759742, 0.000280601166166,
        -0.17533733811961555, 0.7948441927734166, -0.5809298813759742, 0.000280601166166,
        -0.17533733811961555, -0.7948441927734166, 0.5809298813759742, 0.000280601166166,
        -0.17533733811961555, -0.7948441927734166, -0.5809298813759742, 0.000280601166166,
        0.7948441927734164, 0.5809298813759742, 0.17533733811961555, 0.000280601166166,
        0.7948441927734164, 0.5809298813759742, -0.17533733811961544, 0.000280601166166,
        0.7948441927734164, -0.5809298813759742, 0.17533733811961555, 0.000280601166166,
        0.7948441927734164, -0.5809298813759742, -0.17533733811961544, 0.000280601166166,
        -0.7948441927734166, 0.5809298813759741, 0.17533733811961555, 0.000280601166166,
        -0.7948441927734166, 0.5809298813759741, -0.17533733811961544, 0.000280601166166,
        -0.7948441927734166, -0.5809298813759741, 0.17533733811961555, 0.000280601166166,
        -0.7948441927734166, -0.5809298813759741, -0.17533733811961544, 0.000280601166166,
        0.7948441927734166, 0.1753373381196154, 0.5809298813759742, 0.000280601166166,
        0.7948441927734166, 0.1753373381196154, -0.5809298813759742, 0.000280601166166,
        0.7948441927734166, -0.1753373381196154, 0.5809298813759742, 0.000280601166166,
        0.7948441927734166, -0.1753373381196154, -0.5809298813759742, 0.000280601166166,
        -0.7948441927734166, 0.1753373381196155, 0.5809298813759742, 0.000280601166166,
        -0.7948441927734166, 0.1753373381196155, -0.5809298813759742, 0.000280601166166,
        -0.7948441927734166, -0.1753373381196155, 0.5809298813759742, 0.000280601166166,
        -0.7948441927734166, -0.1753373381196155, -0.5809298813759742, 0.000280601166166,
        0.6156416039447128, 0.2105215793514011, 0.7593853304612705, 0.00028241814566,
        0.6156416039447128, 0.2105215793514011, -0.7593853304612705, 0.00028241814566,
        0.6156416039447128, -0.2105215793514011, 0.7593853304612705, 0.00028241814566,
        0.6156416039447128, -0.2105215793514011, -0.7593853304612705, 0.00028241814566,
        -0.6156416039447129, 0.21052157935140098, 0.7593853304612705, 0.00028241814566,
        -0.6156416039447129, 0.21052157935140098, -0.7593853304612705, 0.00028241814566,
        -0.6156416039447129, -0.21052157935140098, 0.7593853304612705, 0.00028241814566,
        -0.6156416039447129, -0.21052157935140098, -0.7593853304612705, 0.00028241814566,
        0.6156416039447128, 0.7593853304612707, 0.21052157935140092, 0.00028241814566,
        0.6156416039447128, 0.7593853304612707, -0.21052157935140103, 0.00028241814566,
        0.6156416039447128, -0.7593853304612707, 0.21052157935140092, 0.00028241814566,
        0.6156416039447128, -0.7593853304612707, -0.21052157935140103, 0.00028241814566,
        -0.6156416039447127, 0.7593853304612707, 0.21052157935140092, 0.00028241814566,
        -0.6156416039447127, 0.7593853304612707, -0.21052157935140103, 0.00028241814566,
        -0.6156416039447127, -0.7593853304612707, 0.21052157935140092, 0.00028241814566,
        -0.6156416039447127, -0.7593853304612707, -0.21052157935140103, 0.00028241814566,
        0.2105215793514011, 0.6156416039447128, 0.7593853304612705, 0.00028241814566,
        0.2105215793514011, 0.6156416039447128, -0.7593853304612705, 0.00028241814566,
        0.2105215793514011, -0.6156416039447128, 0.7593853304612705, 0.00028241814566,
        0.2105215793514011, -0.6156416039447128, -0.7593853304612705, 0.00028241814566,
        -0.21052157935140098, 0.6156416039447129, 0.7593853304612705, 0.00028241814566,
        -0.21052157935140098, 0.6156416039447129, -0.7593853304612705, 0.00028241814566,
        -0.21052157935140098, -0.6156416039447129, 0.7593853304612705, 0.00028241814566,
        -0.21052157935140098, -0.6156416039447129, -0.7593853304612705, 0.00028241814566,
        0.21052157935140095, 0.7593853304612707, 0.6156416039447128, 0.00028241814566,
        0.21052157935140095, 0.7593853304612707, -0.6156416039447129, 0.00028241814566,
        0.21052157935140095, -0.7593853304612707, 0.6156416039447128, 0.00028241814566,
        0.21052157935140095, -0.7593853304612707, -0.6156416039447129, 0.00028241814566,
        -0.21052157935140087, 0.7593853304612707, 0.6156416039447128, 0.00028241814566,
        -0.21052157935140087, 0.7593853304612707, -0.6156416039447129, 0.00028241814566,
        -0.21052157935140087, -0.7593853304612707, 0.6156416039447128, 0.00028241814566,
        -0.21052157935140087, -0.7593853304612707, -0.6156416039447129, 0.00028241814566,
        0.7593853304612705, 0.6156416039447129, 0.21052157935140092, 0.00028241814566,
        0.7593853304612705, 0.6156416039447129, -0.21052157935140103, 0.00028241814566,
        0.7593853304612705, -0.6156416039447129, 0.21052157935140092, 0.00028241814566,
        0.7593853304612705, -0.6156416039447129, -0.21052157935140103, 0.00028241814566,
        -0.7593853304612705, 0.6156416039447129, 0.21052157935140092, 0.00028241814566,
        -0.7593853304612705, 0.6156416039447129, -0.21052157935140103, 0.00028241814566,
        -0.7593853304612705, -0.6156416039447129, 0.21052157935140092, 0.00028241814566,
        -0.7593853304612705, -0.6156416039447129, -0.21052157935140103, 0.00028241814566,
        0.7593853304612705, 0.21052157935140117, 0.6156416039447128, 0.00028241814566,
        0.7593853304612705, 0.21052157935140117, -0.6156416039447129, 0.00028241814566,
        0.7593853304612705, -0.21052157935140117, 0.6156416039447128, 0.00028241814566,
        0.7593853304612705, -0.21052157935140117, -0.6156416039447129, 0.00028241814566,
        -0.7593853304612705, 0.210521579351401, 0.6156416039447128, 0.00028241814566,
        -0.7593853304612705, 0.210521579351401, -0.6156416039447129, 0.00028241814566,
        -0.7593853304612705, -0.210521579351401, 0.6156416039447128, 0.00028241814566,
        -0.7593853304612705, -0.210521579351401, -0.6156416039447129, 0.00028241814566,
        0.6483801351066603, 0.24509533121570506, 0.7207853210320898, 0.000283358521658,
        0.6483801351066599, 0.24509533121570493, -0.7207853210320901, 0.000283358521658,
        0.6483801351066603, -0.24509533121570506, 0.7207853210320898, 0.000283358521658,
        0.6483801351066599, -0.24509533121570493, -0.7207853210320901, 0.000283358521658,
        -0.6483801351066603, 0.2450953312157049, 0.7207853210320898, 0.000283358521658,
        -0.6483801351066599, 0.2450953312157048, -0.7207853210320901, 0.000283358521658,
        -0.6483801351066603, -0.2450953312157049, 0.7207853210320898, 0.000283358521658,
        -0.6483801351066599, -0.2450953312157048, -0.7207853210320901, 0.000283358521658,
        0.6483801351066604, 0.7207853210320897, 0.24509533121570512, 0.000283358521658,
        0.6483801351066604, 0.7207853210320897, -0.24509533121570498, 0.000283358521658,
        0.6483801351066604, -0.7207853210320897, 0.24509533121570512, 0.000283358521658,
        0.6483801351066604, -0.7207853210320897, -0.24509533121570498, 0.000283358521658,
        -0.6483801351066603, 0.7207853210320898, 0.24509533121570512, 0.000283358521658,
        -0.6483801351066603, 0.7207853210320898, -0.24509533121570498, 0.000283358521658,
        -0.6483801351066603, -0.7207853210320898, 0.24509533121570512, 0.000283358521658,
        -0.6483801351066603, -0.7207853210320898, -0.24509533121570498, 0.000283358521658,
        0.245095331215705, 0.6483801351066603, 0.7207853210320898, 0.000283358521658,
        0.2450953312157049, 0.6483801351066599, -0.7207853210320901, 0.000283358521658,
        0.245095331215705, -0.6483801351066603, 0.7207853210320898, 0.000283358521658,
        0.2450953312157049, -0.6483801351066599, -0.7207853210320901, 0.000283358521658,
        -0.2450953312157051, 0.6483801351066603, 0.7207853210320898, 0.000283358521658,
        -0.24509533121570498, 0.6483801351066599, -0.7207853210320901, 0.000283358521658,
        -0.2450953312157051, -0.6483801351066603, 0.7207853210320898, 0.000283358521658,
        -0.24509533121570498, -0.6483801351066599, -0.7207853210320901, 0.000283358521658,
        0.24509533121570506, 0.7207853210320898, 0.6483801351066604, 0.000283358521658,
        0.245095331215705, 0.7207853210320897, -0.6483801351066605, 0.000283358521658,
        0.24509533121570506, -0.7207853210320898, 0.6483801351066604, 0.000283358521658,
        0.245095331215705, -0.7207853210320897, -0.6483801351066605, 0.000283358521658,
        -0.24509533121570515, 0.7207853210320898, 0.6483801351066604, 0.000283358521658,
        -0.2450953312157051, 0.7207853210320897, -0.6483801351066605, 0.000283358521658,
        -0.24509533121570515, -0.7207853210320898, 0.6483801351066604, 0.000283358521658,
        -0.2450953312157051, -0.7207853210320897, -0.6483801351066605, 0.000283358521658,
        0.7207853210320898, 0.6483801351066603, 0.24509533121570512, 0.000283358521658,
        0.7207853210320898, 0.6483801351066603, -0.24509533121570498, 0.000283358521658,
        0.7207853210320898, -0.6483801351066603, 0.24509533121570512, 0.000283358521658,
        0.7207853210320898, -0.6483801351066603, -0.24509533121570498, 0.000283358521658,
        -0.7207853210320897, 0.6483801351066604, 0.24509533121570512, 0.000283358521658,
        -0.7207853210320897, 0.6483801351066604, -0.24509533121570498, 0.000283358521658,
        -0.7207853210320897, -0.6483801351066604, 0.24509533121570512, 0.000283358521658,
        -0.7207853210320897, -0.6483801351066604, -0.24509533121570498, 0.000283358521658,
        0.7207853210320898, 0.24509533121570493, 0.6483801351066604, 0.000283358521658,
        0.7207853210320897, 0.2450953312157049, -0.6483801351066605, 0.000283358521658,
        0.7207853210320898, -0.24509533121570493, 0.6483801351066604, 0.000283358521658,
        0.7207853210320897, -0.2450953312157049, -0.6483801351066605, 0.000283358521658,
        -0.7207853210320898, 0.24509533121570493, 0.6483801351066604, 0.000283358521658,
        -0.7207853210320897, 0.2450953312157049, -0.6483801351066605, 0.000283358521658,
        -0.7207853210320898, -0.24509533121570493, 0.6483801351066604, 0.000283358521658,
        -0.7207853210320897, -0.2450953312157049, -0.6483801351066605, 0.000283358521658,
        0.5103616577251688, 0.03485560643800656, 0.8592532019281955, 0.000273816523696,
        0.5103616577251688, 0.03485560643800656, -0.8592532019281955, 0.000273816523696,
        0.5103616577251688, -0.03485560643800656, 0.8592532019281955, 0.000273816523696,
        0.5103616577251688, -0.03485560643800656, -0.8592532019281955, 0.000273816523696,
        -0.5103616577251688, 0.03485560643800656, 0.8592532019281955, 0.000273816523696,
        -0.5103616577251688, 0.03485560643800656, -0.8592532019281955, 0.000273816523696,
        -0.5103616577251688, -0.03485560643800656, 0.8592532019281955, 0.000273816523696,
        -0.5103616577251688, -0.03485560643800656, -0.8592532019281955, 0.000273816523696,
        0.5103616577251688, 0.8592532019281955, 0.03485560643800721, 0.000273816523696,
        0.5103616577251688, 0.8592532019281955, -0.03485560643800709, 0.000273816523696,
        0.5103616577251688, -0.8592532019281955, 0.03485560643800721, 0.000273816523696,
        0.5103616577251688, -0.8592532019281955, -0.03485560643800709, 0.000273816523696,
        -0.510361657725169, 0.8592532019281955, 0.03485560643800721, 0.000273816523696,
        -0.510361657725169, 0.8592532019281955, -0.03485560643800709, 0.000273816523696,
        -0.510361657725169, -0.8592532019281955, 0.03485560643800721, 0.000273816523696,
        -0.510361657725169, -0.8592532019281955, -0.03485560643800709, 0.000273816523696,
        0.03485560643800721, 0.5103616577251688, 0.8592532019281955, 0.000273816523696,
        0.03485560643800721, 0.5103616577251688, -0.8592532019281955, 0.000273816523696,
        0.03485560643800721, -0.5103616577251688, 0.8592532019281955, 0.000273816523696,
        0.03485560643800721, -0.5103616577251688, -0.8592532019281955, 0.000273816523696,
        -0.03485560643800715, 0.5103616577251688, 0.8592532019281955, 0.000273816523696,
        -0.03485560643800715, 0.5103616577251688, -0.8592532019281955, 0.000273816523696,
        -0.03485560643800715, -0.5103616577251688, 0.8592532019281955, 0.000273816523696,
        -0.03485560643800715, -0.5103616577251688, -0.8592532019281955, 0.000273816523696,
        0.034855606438007225, 0.8592532019281957, 0.5103616577251687, 0.000273816523696,
        0.03485560643800723, 0.8592532019281958, -0.5103616577251686, 0.000273816523696,
        0.034855606438007225, -0.8592532019281957, 0.5103616577251687, 0.000273816523696,
        0.03485560643800723, -0.8592532019281958, -0.5103616577251686, 0.000273816523696,
        -0.034855606438007114, 0.8592532019281957, 0.5103616577251687, 0.000273816523696,
        -0.03485560643800712, 0.8592532019281958, -0.5103616577251686, 0.000273816523696,
        -0.034855606438007114, -0.8592532019281957, 0.5103616577251687, 0.000273816523696,
        -0.03485560643800712, -0.8592532019281958, -0.5103616577251686, 0.000273816523696,
        0.8592532019281955, 0.5103616577251688, 0.03485560643800721, 0.000273816523696,
        0.8592532019281955, 0.5103616577251688, -0.03485560643800709, 0.000273816523696,
        0.8592532019281955, -0.5103616577251688, 0.03485560643800721, 0.000273816523696,
        0.8592532019281955, -0.5103616577251688, -0.03485560643800709, 0.000273816523696,
        -0.8592532019281957, 0.5103616577251686, 0.03485560643800721, 0.000273816523696,
        -0.8592532019281957, 0.5103616577251686, -0.03485560643800709, 0.000273816523696,
        -0.8592532019281957, -0.5103616577251686, 0.03485560643800721, 0.000273816523696,
        -0.8592532019281957, -0.5103616577251686, -0.03485560643800709, 0.000273816523696,
        0.8592532019281957, 0.03485560643800622, 0.5103616577251687, 0.000273816523696,
        0.8592532019281958, 0.03485560643800622, -0.5103616577251686, 0.000273816523696,
        0.8592532019281957, -0.03485560643800622, 0.5103616577251687, 0.000273816523696,
        0.8592532019281958, -0.03485560643800622, -0.5103616577251686, 0.000273816523696,
        -0.8592532019281957, 0.034855606438006136, 0.5103616577251687, 0.000273816523696,
        -0.8592532019281958, 0.034855606438006136, -0.5103616577251686, 0.000273816523696,
        -0.8592532019281957, -0.034855606438006136, 0.5103616577251687, 0.000273816523696,
        -0.8592532019281958, -0.034855606438006136, -0.5103616577251686, 0.000273816523696,
        0.5506738792580682, 0.07026308631512036, 0.83175800411198, 0.00027783652082,
        0.5506738792580682, 0.07026308631512036, -0.83175800411198, 0.00027783652082,
        0.5506738792580682, -0.07026308631512036, 0.83175800411198, 0.00027783652082,
        0.5506738792580682, -0.07026308631512036, -0.83175800411198, 0.00027783652082,
        -0.5506738792580682, 0.07026308631512036, 0.83175800411198, 0.00027783652082,
        -0.5506738792580682, 0.07026308631512036, -0.83175800411198, 0.00027783652082,
        -0.5506738792580682, -0.07026308631512036, 0.83175800411198, 0.00027783652082,
        -0.5506738792580682, -0.07026308631512036, -0.83175800411198, 0.00027783652082,
        0.5506738792580681, 0.83175800411198, 0.07026308631512002, 0.00027783652082,
        0.5506738792580681, 0.83175800411198, -0.07026308631512033, 0.00027783652082,
        0.5506738792580681, -0.83175800411198, 0.07026308631512002, 0.00027783652082,
        0.5506738792580681, -0.83175800411198, -0.07026308631512033, 0.00027783652082,
        -0.550673879258068, 0.8317580041119801, 0.07026308631512002, 0.00027783652082,
        -0.550673879258068, 0.8317580041119801, -0.07026308631512033, 0.00027783652082,
        -0.550673879258068, -0.8317580041119801, 0.07026308631512002, 0.00027783652082,
        -0.550673879258068, -0.8317580041119801, -0.07026308631512033, 0.00027783652082,
        0.07026308631512032, 0.5506738792580682, 0.83175800411198, 0.00027783652082,
        0.07026308631512032, 0.5506738792580682, -0.83175800411198, 0.00027783652082,
        0.07026308631512032, -0.5506738792580682, 0.83175800411198, 0.00027783652082,
        0.07026308631512032, -0.5506738792580682, -0.83175800411198, 0.00027783652082,
        -0.07026308631512038, 0.5506738792580682, 0.83175800411198, 0.00027783652082,
        -0.07026308631512038, 0.5506738792580682, -0.83175800411198, 0.00027783652082,
        -0.07026308631512038, -0.5506738792580682, 0.83175800411198, 0.00027783652082,
        -0.07026308631512038, -0.5506738792580682, -0.83175800411198, 0.00027783652082,
        0.07026308631512042, 0.8317580041119801, 0.5506738792580681, 0.00027783652082,
        0.0702630863151204, 0.83175800411198, -0.5506738792580682, 0.00027783652082,
        0.07026308631512042, -0.8317580041119801, 0.5506738792580681, 0.00027783652082,
        0.0702630863151204, -0.83175800411198, -0.5506738792580682, 0.00027783652082,
        -0.07026308631512031, 0.8317580041119801, 0.5506738792580681, 0.00027783652082,
        -0.07026308631512031, 0.83175800411198, -0.5506738792580682, 0.00027783652082,
        -0.07026308631512031, -0.8317580041119801, 0.5506738792580681, 0.00027783652082,
        -0.07026308631512031, -0.83175800411198, -0.5506738792580682, 0.00027783652082,
        0.83175800411198, 0.5506738792580682, 0.07026308631512002, 0.00027783652082,
        0.83175800411198, 0.5506738792580682, -0.07026308631512033, 0.00027783652082,
        0.83175800411198, -0.5506738792580682, 0.07026308631512002, 0.00027783652082,
        0.83175800411198, -0.5506738792580682, -0.07026308631512033, 0.00027783652082,
        -0.83175800411198, 0.5506738792580681, 0.07026308631512002, 0.00027783652082,
        -0.83175800411198, 0.5506738792580681, -0.07026308631512033, 0.00027783652082,
        -0.83175800411198, -0.5506738792580681, 0.07026308631512002, 0.00027783652082,
        -0.83175800411198, -0.5506738792580681, -0.07026308631512033, 0.00027783652082,
        0.8317580041119801, 0.07026308631512, 0.5506738792580681, 0.00027783652082,
        0.83175800411198, 0.07026308631511999, -0.5506738792580682, 0.00027783652082,
        0.8317580041119801, -0.07026308631512, 0.5506738792580681, 0.00027783652082,
        0.83175800411198, -0.07026308631511999, -0.5506738792580682, 0.00027783652082,
        -0.8317580041119801, 0.07026308631512009, 0.5506738792580681, 0.00027783652082,
        -0.83175800411198, 0.07026308631512009, -0.5506738792580682, 0.00027783652082,
        -0.8317580041119801, -0.07026308631512009, 0.5506738792580681, 0.00027783652082,
        -0.83175800411198, -0.07026308631512009, -0.5506738792580682, 0.00027783652082,
        0.5889573040995292, 0.10590350612964015, 0.8011951955280711, 0.000280785294042,
        0.5889573040995287, 0.10590350612964008, -0.8011951955280714, 0.000280785294042,
        0.5889573040995292, -0.10590350612964015, 0.8011951955280711, 0.000280785294042,
        0.5889573040995287, -0.10590350612964008, -0.8011951955280714, 0.000280785294042,
        -0.5889573040995292, 0.1059035061296402, 0.8011951955280711, 0.000280785294042,
        -0.5889573040995287, 0.10590350612964011, -0.8011951955280714, 0.000280785294042,
        -0.5889573040995292, -0.1059035061296402, 0.8011951955280711, 0.000280785294042,
        -0.5889573040995287, -0.10590350612964011, -0.8011951955280714, 0.000280785294042,
        0.5889573040995292, 0.8011951955280711, 0.10590350612964028, 0.000280785294042,
        0.5889573040995292, 0.8011951955280711, -0.1059035061296406, 0.000280785294042,
        0.5889573040995292, -0.8011951955280711, 0.10590350612964028, 0.000280785294042,
        0.5889573040995292, -0.8011951955280711, -0.1059035061296406, 0.000280785294042,
        -0.5889573040995294, 0.801195195528071, 0.10590350612964028, 0.000280785294042,
        -0.5889573040995294, 0.801195195528071, -0.1059035061296406, 0.000280785294042,
        -0.5889573040995294, -0.801195195528071, 0.10590350612964028, 0.000280785294042,
        -0.5889573040995294, -0.801195195528071, -0.1059035061296406, 0.000280785294042,
        0.10590350612964014, 0.5889573040995292, 0.8011951955280711, 0.000280785294042,
        0.10590350612964006, 0.5889573040995287, -0.8011951955280714, 0.000280785294042,
        0.10590350612964014, -0.5889573040995292, 0.8011951955280711, 0.000280785294042,
        0.10590350612964006, -0.5889573040995287, -0.8011951955280714, 0.000280785294042,
        -0.10590350612964033, 0.5889573040995292, 0.8011951955280711, 0.000280785294042,
        -0.10590350612964027, 0.5889573040995287, -0.8011951955280714, 0.000280785294042,
        -0.10590350612964033, -0.5889573040995292, 0.8011951955280711, 0.000280785294042,
        -0.10590350612964027, -0.5889573040995287, -0.8011951955280714, 0.000280785294042,
        0.10590350612964022, 0.8011951955280711, 0.5889573040995292, 0.000280785294042,
        0.10590350612964022, 0.8011951955280711, -0.5889573040995292, 0.000280785294042,
        0.10590350612964022, -0.8011951955280711, 0.5889573040995292, 0.000280785294042,
        0.10590350612964022, -0.8011951955280711, -0.5889573040995292, 0.000280785294042,
        -0.10590350612964032, 0.8011951955280711, 0.5889573040995292, 0.000280785294042,
        -0.10590350612964032, 0.8011951955280711, -0.5889573040995292, 0.000280785294042,
        -0.10590350612964032, -0.8011951955280711, 0.5889573040995292, 0.000280785294042,
        -0.10590350612964032, -0.8011951955280711, -0.5889573040995292, 0.000280785294042,
        0.801195195528071, 0.5889573040995293, 0.10590350612964028, 0.000280785294042,
        0.801195195528071, 0.5889573040995293, -0.1059035061296406, 0.000280785294042,
        0.801195195528071, -0.5889573040995293, 0.10590350612964028, 0.000280785294042,
        0.801195195528071, -0.5889573040995293, -0.1059035061296406, 0.000280785294042,
        -0.8011951955280712, 0.5889573040995292, 0.10590350612964028, 0.000280785294042,
        -0.8011951955280712, 0.5889573040995292, -0.1059035061296406, 0.000280785294042,
        -0.8011951955280712, -0.5889573040995292, 0.10590350612964028, 0.000280785294042,
        -0.8011951955280712, -0.5889573040995292, -0.1059035061296406, 0.000280785294042,
        0.8011951955280711, 0.10590350612964028, 0.5889573040995292, 0.000280785294042,
        0.8011951955280711, 0.10590350612964028, -0.5889573040995292, 0.000280785294042,
        0.8011951955280711, -0.10590350612964028, 0.5889573040995292, 0.000280785294042,
        0.8011951955280711, -0.10590350612964028, -0.5889573040995292, 0.000280785294042,
        -0.8011951955280711, 0.10590350612964028, 0.5889573040995292, 0.000280785294042,
        -0.8011951955280711, 0.10590350612964028, -0.5889573040995292, 0.000280785294042,
        -0.8011951955280711, -0.10590350612964028, 0.5889573040995292, 0.000280785294042,
        -0.8011951955280711, -0.10590350612964028, -0.5889573040995292, 0.000280785294042,
        0.6251641589516931, 0.1414823925236028, 0.767562705560933, 0.000282724594967,
        0.6251641589516929, 0.14148239252360278, -0.7675627055609331, 0.000282724594967,
        0.6251641589516931, -0.1414823925236028, 0.767562705560933, 0.000282724594967,
        0.6251641589516929, -0.14148239252360278, -0.7675627055609331, 0.000282724594967,
        -0.6251641589516931, 0.14148239252360287, 0.767562705560933, 0.000282724594967,
        -0.6251641589516929, 0.1414823925236028, -0.7675627055609331, 0.000282724594967,
        -0.6251641589516931, -0.14148239252360287, 0.767562705560933, 0.000282724594967,
        -0.6251641589516929, -0.1414823925236028, -0.7675627055609331, 0.000282724594967,
        0.625164158951693, 0.7675627055609331, 0.14148239252360245, 0.000282724594967,
        0.625164158951693, 0.7675627055609331, -0.14148239252360253, 0.000282724594967,
        0.625164158951693, -0.7675627055609331, 0.14148239252360245, 0.000282724594967,
        0.625164158951693, -0.7675627055609331, -0.14148239252360253, 0.000282724594967,
        -0.6251641589516929, 0.7675627055609332, 0.14148239252360245, 0.000282724594967,
        -0.6251641589516929, 0.7675627055609332, -0.14148239252360253, 0.000282724594967,
        -0.6251641589516929, -0.7675627055609332, 0.14148239252360245, 0.000282724594967,
        -0.6251641589516929, -0.7675627055609332, -0.14148239252360253, 0.000282724594967,
        0.14148239252360256, 0.6251641589516932, 0.767562705560933, 0.000282724594967,
        0.1414823925236025, 0.625164158951693, -0.7675627055609331, 0.000282724594967,
        0.14148239252360256, -0.6251641589516932, 0.767562705560933, 0.000282724594967,
        0.1414823925236025, -0.625164158951693, -0.7675627055609331, 0.000282724594967,
        -0.14148239252360262, 0.6251641589516932, 0.767562705560933, 0.000282724594967,
        -0.14148239252360256, 0.625164158951693, -0.7675627055609331, 0.000282724594967,
        -0.14148239252360262, -0.6251641589516932, 0.767562705560933, 0.000282724594967,
        -0.14148239252360256, -0.625164158951693, -0.7675627055609331, 0.000282724594967,
        0.1414823925236025, 0.767562705560933, 0.625164158951693, 0.000282724594967,
        0.14148239252360248, 0.7675627055609328, -0.6251641589516934, 0.000282724594967,
        0.1414823925236025, -0.767562705560933, 0.625164158951693, 0.000282724594967,
        0.14148239252360248, -0.7675627055609328, -0.6251641589516934, 0.000282724594967,
        -0.1414823925236026, 0.767562705560933, 0.625164158951693, 0.000282724594967,
        -0.14148239252360256, 0.7675627055609328, -0.6251641589516934, 0.000282724594967,
        -0.1414823925236026, -0.767562705560933, 0.625164158951693, 0.000282724594967,
        -0.14148239252360256, -0.7675627055609328, -0.6251641589516934, 0.000282724594967,
        0.767562705560933, 0.6251641589516931, 0.14148239252360245, 0.000282724594967,
        0.767562705560933, 0.6251641589516931, -0.14148239252360253, 0.000282724594967,
        0.767562705560933, -0.6251641589516931, 0.14148239252360245, 0.000282724594967,
        0.767562705560933, -0.6251641589516931, -0.14148239252360253, 0.000282724594967,
        -0.7675627055609331, 0.625164158951693, 0.14148239252360245, 0.000282724594967,
        -0.7675627055609331, 0.625164158951693, -0.14148239252360253, 0.000282724594967,
        -0.7675627055609331, -0.625164158951693, 0.14148239252360245, 0.000282724594967,
        -0.7675627055609331, -0.625164158951693, -0.14148239252360253, 0.000282724594967,
        0.767562705560933, 0.14148239252360265, 0.625164158951693, 0.000282724594967,
        0.7675627055609328, 0.1414823925236026, -0.6251641589516934, 0.000282724594967,
        0.767562705560933, -0.14148239252360265, 0.625164158951693, 0.000282724594967,
        0.7675627055609328, -0.1414823925236026, -0.6251641589516934, 0.000282724594967,
        -0.767562705560933, 0.14148239252360256, 0.625164158951693, 0.000282724594967,
        -0.7675627055609328, 0.1414823925236025, -0.6251641589516934, 0.000282724594967,
        -0.767562705560933, -0.14148239252360256, 0.625164158951693, 0.000282724594967,
        -0.7675627055609328, -0.1414823925236025, -0.6251641589516934, 0.000282724594967,
        0.6592414921570179, 0.17672079082145312, 0.730869630720848, 0.000283734234483,
        0.6592414921570179, 0.17672079082145312, -0.730869630720848, 0.000283734234483,
        0.6592414921570179, -0.17672079082145312, 0.730869630720848, 0.000283734234483,
        0.6592414921570179, -0.17672079082145312, -0.730869630720848, 0.000283734234483,
        -0.6592414921570178, 0.17672079082145326, 0.730869630720848, 0.000283734234483,
        -0.6592414921570178, 0.17672079082145326, -0.730869630720848, 0.000283734234483,
        -0.6592414921570178, -0.17672079082145326, 0.730869630720848, 0.000283734234483,
        -0.6592414921570178, -0.17672079082145326, -0.730869630720848, 0.000283734234483,
        0.6592414921570179, 0.7308696307208481, 0.176720790821453, 0.000283734234483,
        0.6592414921570179, 0.7308696307208481, -0.1767207908214531, 0.000283734234483,
        0.6592414921570179, -0.7308696307208481, 0.176720790821453, 0.000283734234483,
        0.6592414921570179, -0.7308696307208481, -0.1767207908214531, 0.000283734234483,
        -0.6592414921570183, 0.7308696307208477, 0.176720790821453, 0.000283734234483,
        -0.6592414921570183, 0.7308696307208477, -0.1767207908214531, 0.000283734234483,
        -0.6592414921570183, -0.7308696307208477, 0.176720790821453, 0.000283734234483,
        -0.6592414921570183, -0.7308696307208477, -0.1767207908214531, 0.000283734234483,
        0.1767207908214531, 0.6592414921570179, 0.730869630720848, 0.000283734234483,
        0.1767207908214531, 0.6592414921570179, -0.730869630720848, 0.000283734234483,
        0.1767207908214531, -0.6592414921570179, 0.730869630720848, 0.000283734234483,
        0.1767207908214531, -0.6592414921570179, -0.730869630720848, 0.000283734234483,
        -0.176720790821453, 0.6592414921570179, 0.730869630720848, 0.000283734234483,
        -0.176720790821453, 0.6592414921570179, -0.730869630720848, 0.000283734234483,
        -0.176720790821453, -0.6592414921570179, 0.730869630720848, 0.000283734234483,
        -0.176720790821453, -0.6592414921570179, -0.730869630720848, 0.000283734234483,
        0.17672079082145295, 0.7308696307208482, 0.6592414921570178, 0.000283734234483,
        0.17672079082145292, 0.7308696307208481, -0.6592414921570179, 0.000283734234483,
        0.17672079082145295, -0.7308696307208482, 0.6592414921570178, 0.000283734234483,
        0.17672079082145292, -0.7308696307208481, -0.6592414921570179, 0.000283734234483,
        -0.176720790821453, 0.7308696307208482, 0.6592414921570178, 0.000283734234483,
        -0.17672079082145298, 0.7308696307208481, -0.6592414921570179, 0.000283734234483,
        -0.176720790821453, -0.7308696307208482, 0.6592414921570178, 0.000283734234483,
        -0.17672079082145298, -0.7308696307208481, -0.6592414921570179, 0.000283734234483,
        0.7308696307208482, 0.6592414921570177, 0.176720790821453, 0.000283734234483,
        0.7308696307208482, 0.6592414921570177, -0.1767207908214531, 0.000283734234483,
        0.7308696307208482, -0.6592414921570177, 0.176720790821453, 0.000283734234483,
        0.7308696307208482, -0.6592414921570177, -0.1767207908214531, 0.000283734234483,
        -0.7308696307208482, 0.6592414921570178, 0.176720790821453, 0.000283734234483,
        -0.7308696307208482, 0.6592414921570178, -0.1767207908214531, 0.000283734234483,
        -0.7308696307208482, -0.6592414921570178, 0.176720790821453, 0.000283734234483,
        -0.7308696307208482, -0.6592414921570178, -0.1767207908214531, 0.000283734234483,
        0.7308696307208482, 0.1767207908214528, 0.6592414921570178, 0.000283734234483,
        0.7308696307208481, 0.17672079082145278, -0.6592414921570179, 0.000283734234483,
        0.7308696307208482, -0.1767207908214528, 0.6592414921570178, 0.000283734234483,
        0.7308696307208481, -0.17672079082145278, -0.6592414921570179, 0.000283734234483,
        -0.7308696307208483, 0.17672079082145234, 0.6592414921570178, 0.000283734234483,
        -0.7308696307208482, 0.1767207908214523, -0.6592414921570179, 0.000283734234483,
        -0.7308696307208483, -0.17672079082145234, 0.6592414921570178, 0.000283734234483,
        -0.7308696307208482, -0.1767207908214523, -0.6592414921570179, 0.000283734234483,
        0.5930314017533383, 0.03542189339561555, 0.8043998048251505, 0.000280923390761,
        0.5930314017533383, 0.03542189339561555, -0.8043998048251505, 0.000280923390761,
        0.5930314017533383, -0.03542189339561555, 0.8043998048251505, 0.000280923390761,
        0.5930314017533383, -0.03542189339561555, -0.8043998048251505, 0.000280923390761,
        -0.5930314017533383, 0.03542189339561555, 0.8043998048251505, 0.000280923390761,
        -0.5930314017533383, 0.03542189339561555, -0.8043998048251505, 0.000280923390761,
        -0.5930314017533383, -0.03542189339561555, 0.8043998048251505, 0.000280923390761,
        -0.5930314017533383, -0.03542189339561555, -0.8043998048251505, 0.000280923390761,
        0.5930314017533383, 0.8043998048251505, 0.035421893395616626, 0.000280923390761,
        0.5930314017533383, 0.8043998048251505, -0.03542189339561673, 0.000280923390761,
        0.5930314017533383, -0.8043998048251505, 0.035421893395616626, 0.000280923390761,
        0.5930314017533383, -0.8043998048251505, -0.03542189339561673, 0.000280923390761,
        -0.5930314017533386, 0.8043998048251504, 0.035421893395616626, 0.000280923390761,
        -0.5930314017533386, 0.8043998048251504, -0.03542189339561673, 0.000280923390761,
        -0.5930314017533386, -0.8043998048251504, 0.035421893395616626, 0.000280923390761,
        -0.5930314017533386, -0.8043998048251504, -0.03542189339561673, 0.000280923390761,
        0.035421893395616695, 0.5930314017533383, 0.8043998048251505, 0.000280923390761,
        0.035421893395616695, 0.5930314017533383, -0.8043998048251505, 0.000280923390761,
        0.035421893395616695, -0.5930314017533383, 0.8043998048251505, 0.000280923390761,
        0.035421893395616695, -0.5930314017533383, -0.8043998048251505, 0.000280923390761,
        -0.03542189339561676, 0.5930314017533383, 0.8043998048251505, 0.000280923390761,
        -0.03542189339561676, 0.5930314017533383, -0.8043998048251505, 0.000280923390761,
        -0.03542189339561676, -0.5930314017533383, 0.8043998048251505, 0.000280923390761,
        -0.03542189339561676, -0.5930314017533383, -0.8043998048251505, 0.000280923390761,
        0.03542189339561676, 0.8043998048251505, 0.5930314017533383, 0.000280923390761,
        0.03542189339561676, 0.8043998048251505, -0.5930314017533383, 0.000280923390761,
        0.03542189339561676, -0.8043998048251505, 0.5930314017533383, 0.000280923390761,
        0.03542189339561676, -0.8043998048251505, -0.5930314017533383, 0.000280923390761,
        -0.03542189339561666, 0.8043998048251505, 0.5930314017533383, 0.000280923390761,
        -0.03542189339561666, 0.8043998048251505, -0.5930314017533383, 0.000280923390761,
        -0.03542189339561666, -0.8043998048251505, 0.5930314017533383, 0.000280923390761,
        -0.03542189339561666, -0.8043998048251505, -0.5930314017533383, 0.000280923390761,
        0.8043998048251505, 0.5930314017533383, 0.035421893395616626, 0.000280923390761,
        0.8043998048251505, 0.5930314017533383, -0.03542189339561673, 0.000280923390761,
        0.8043998048251505, -0.5930314017533383, 0.035421893395616626, 0.000280923390761,
        0.8043998048251505, -0.5930314017533383, -0.03542189339561673, 0.000280923390761,
        -0.8043998048251507, 0.5930314017533379, 0.035421893395616626, 0.000280923390761,
        -0.8043998048251507, 0.5930314017533379, -0.03542189339561673, 0.000280923390761,
        -0.8043998048251507, -0.5930314017533379, 0.035421893395616626, 0.000280923390761,
        -0.8043998048251507, -0.5930314017533379, -0.03542189339561673, 0.000280923390761,
        0.8043998048251505, 0.03542189339561698, 0.5930314017533383, 0.000280923390761,
        0.8043998048251505, 0.03542189339561698, -0.5930314017533383, 0.000280923390761,
        0.8043998048251505, -0.03542189339561698, 0.5930314017533383, 0.000280923390761,
        0.8043998048251505, -0.03542189339561698, -0.5930314017533383, 0.000280923390761,
        -0.8043998048251505, 0.03542189339561698, 0.5930314017533383, 0.000280923390761,
        -0.8043998048251505, 0.03542189339561698, -0.5930314017533383, 0.000280923390761,
        -0.8043998048251505, -0.03542189339561698, 0.5930314017533383, 0.000280923390761,
        -0.8043998048251505, -0.03542189339561698, -0.5930314017533383, 0.000280923390761,
        0.6309812253390173, 0.07109574040369589, 0.7725335520002496, 0.000282993080974,
        0.6309812253390175, 0.07109574040369589, -0.7725335520002495, 0.000282993080974,
        0.6309812253390173, -0.07109574040369589, 0.7725335520002496, 0.000282993080974,
        0.6309812253390175, -0.07109574040369589, -0.7725335520002495, 0.000282993080974,
        -0.6309812253390173, 0.07109574040369569, 0.7725335520002496, 0.000282993080974,
        -0.6309812253390175, 0.0710957404036957, -0.7725335520002495, 0.000282993080974,
        -0.6309812253390173, -0.07109574040369569, 0.7725335520002496, 0.000282993080974,
        -0.6309812253390175, -0.0710957404036957, -0.7725335520002495, 0.000282993080974,
        0.6309812253390173, 0.7725335520002498, 0.07109574040369543, 0.000282993080974,
        0.6309812253390173, 0.7725335520002498, -0.07109574040369554, 0.000282993080974,
        0.6309812253390173, -0.7725335520002498, 0.07109574040369543, 0.000282993080974,
        0.6309812253390173, -0.7725335520002498, -0.07109574040369554, 0.000282993080974,
        -0.6309812253390175, 0.7725335520002496, 0.07109574040369543, 0.000282993080974,
        -0.6309812253390175, 0.7725335520002496, -0.07109574040369554, 0.000282993080974,
        -0.6309812253390175, -0.7725335520002496, 0.07109574040369543, 0.000282993080974,
        -0.6309812253390175, -0.7725335520002496, -0.07109574040369554, 0.000282993080974,
        0.07109574040369551, 0.6309812253390175, 0.7725335520002496, 0.000282993080974,
        0.07109574040369553, 0.6309812253390176, -0.7725335520002495, 0.000282993080974,
        0.07109574040369551, -0.6309812253390175, 0.7725335520002496, 0.000282993080974,
        0.07109574040369553, -0.6309812253390176, -0.7725335520002495, 0.000282993080974,
        -0.07109574040369544, 0.6309812253390175, 0.7725335520002496, 0.000282993080974,
        -0.07109574040369546, 0.6309812253390176, -0.7725335520002495, 0.000282993080974,
        -0.07109574040369544, -0.6309812253390175, 0.7725335520002496, 0.000282993080974,
        -0.07109574040369546, -0.6309812253390176, -0.7725335520002495, 0.000282993080974,
        0.07109574040369554, 0.7725335520002496, 0.6309812253390175, 0.000282993080974,
        0.07109574040369553, 0.7725335520002495, -0.6309812253390177, 0.000282993080974,
        0.07109574040369554, -0.7725335520002496, 0.6309812253390175, 0.000282993080974,
        0.07109574040369553, -0.7725335520002495, -0.6309812253390177, 0.000282993080974,
        -0.07109574040369544, 0.7725335520002496, 0.6309812253390175, 0.000282993080974,
        -0.07109574040369543, 0.7725335520002495, -0.6309812253390177, 0.000282993080974,
        -0.07109574040369544, -0.7725335520002496, 0.6309812253390175, 0.000282993080974,
        -0.07109574040369543, -0.7725335520002495, -0.6309812253390177, 0.000282993080974,
        0.7725335520002496, 0.6309812253390175, 0.07109574040369543, 0.000282993080974,
        0.7725335520002496, 0.6309812253390175, -0.07109574040369554, 0.000282993080974,
        0.7725335520002496, -0.6309812253390175, 0.07109574040369543, 0.000282993080974,
        0.7725335520002496, -0.6309812253390175, -0.07109574040369554, 0.000282993080974,
        -0.7725335520002496, 0.6309812253390176, 0.07109574040369543, 0.000282993080974,
        -0.7725335520002496, 0.6309812253390176, -0.07109574040369554, 0.000282993080974,
        -0.7725335520002496, -0.6309812253390176, 0.07109574040369543, 0.000282993080974,
        -0.7725335520002496, -0.6309812253390176, -0.07109574040369554, 0.000282993080974,
        0.7725335520002495, 0.07109574040369666, 0.6309812253390175, 0.000282993080974,
        0.7725335520002494, 0.07109574040369666, -0.6309812253390177, 0.000282993080974,
        0.7725335520002495, -0.07109574040369666, 0.6309812253390175, 0.000282993080974,
        0.7725335520002494, -0.07109574040369666, -0.6309812253390177, 0.000282993080974,
        -0.7725335520002495, 0.07109574040369679, 0.6309812253390175, 0.000282993080974,
        -0.7725335520002494, 0.07109574040369677, -0.6309812253390177, 0.000282993080974,
        -0.7725335520002495, -0.07109574040369679, 0.6309812253390175, 0.000282993080974,
        -0.7725335520002494, -0.07109574040369677, -0.6309812253390177, 0.000282993080974,
        0.6666296011353231, 0.10672597922827314, 0.7377089807288009, 0.000284109787411,
        0.6666296011353231, 0.10672597922827314, -0.7377089807288009, 0.000284109787411,
        0.6666296011353231, -0.10672597922827314, 0.7377089807288009, 0.000284109787411,
        0.6666296011353231, -0.10672597922827314, -0.7377089807288009, 0.000284109787411,
        -0.6666296011353231, 0.106725979228273, 0.7377089807288009, 0.000284109787411,
        -0.6666296011353231, 0.106725979228273, -0.7377089807288009, 0.000284109787411,
        -0.6666296011353231, -0.106725979228273, 0.7377089807288009, 0.000284109787411,
        -0.6666296011353231, -0.106725979228273, -0.7377089807288009, 0.000284109787411,
        0.666629601135323, 0.7377089807288009, 0.10672597922827301, 0.000284109787411,
        0.666629601135323, 0.737708980728801, -0.10672597922827289, 0.000284109787411,
        0.666629601135323, -0.7377089807288009, 0.10672597922827301, 0.000284109787411,
        0.666629601135323, -0.737708980728801, -0.10672597922827289, 0.000284109787411,
        -0.6666296011353231, 0.7377089807288009, 0.10672597922827301, 0.000284109787411,
        -0.6666296011353231, 0.737708980728801, -0.10672597922827289, 0.000284109787411,
        -0.6666296011353231, -0.7377089807288009, 0.10672597922827301, 0.000284109787411,
        -0.6666296011353231, -0.737708980728801, -0.10672597922827289, 0.000284109787411,
        0.10672597922827279, 0.6666296011353231, 0.7377089807288009, 0.000284109787411,
        0.10672597922827279, 0.6666296011353231, -0.7377089807288009, 0.000284109787411,
        0.10672597922827279, -0.6666296011353231, 0.7377089807288009, 0.000284109787411,
        0.10672597922827279, -0.6666296011353231, -0.7377089807288009, 0.000284109787411,
        -0.10672597922827301, 0.6666296011353231, 0.7377089807288009, 0.000284109787411,
        -0.10672597922827301, 0.6666296011353231, -0.7377089807288009, 0.000284109787411,
        -0.10672597922827301, -0.6666296011353231, 0.7377089807288009, 0.000284109787411,
        -0.10672597922827301, -0.6666296011353231, -0.7377089807288009, 0.000284109787411,
        0.10672597922827304, 0.737708980728801, 0.666629601135323, 0.000284109787411,
        0.10672597922827304, 0.737708980728801, -0.6666296011353229, 0.000284109787411,
        0.10672597922827304, -0.737708980728801, 0.666629601135323, 0.000284109787411,
        0.10672597922827304, -0.737708980728801, -0.6666296011353229, 0.000284109787411,
        -0.10672597922827295, 0.737708980728801, 0.666629601135323, 0.000284109787411,
        -0.10672597922827295, 0.737708980728801, -0.6666296011353229, 0.000284109787411,
        -0.10672597922827295, -0.737708980728801, 0.666629601135323, 0.000284109787411,
        -0.10672597922827295, -0.737708980728801, -0.6666296011353229, 0.000284109787411,
        0.7377089807288009, 0.666629601135323, 0.10672597922827301, 0.000284109787411,
        0.737708980728801, 0.666629601135323, -0.10672597922827289, 0.000284109787411,
        0.7377089807288009, -0.666629601135323, 0.10672597922827301, 0.000284109787411,
        0.737708980728801, -0.666629601135323, -0.10672597922827289, 0.000284109787411,
        -0.7377089807288008, 0.6666296011353232, 0.10672597922827301, 0.000284109787411,
        -0.7377089807288009, 0.6666296011353232, -0.10672597922827289, 0.000284109787411,
        -0.7377089807288008, -0.6666296011353232, 0.10672597922827301, 0.000284109787411,
        -0.7377089807288009, -0.6666296011353232, -0.10672597922827289, 0.000284109787411,
        0.737708980728801, 0.10672597922827318, 0.666629601135323, 0.000284109787411,
        0.737708980728801, 0.10672597922827318, -0.6666296011353229, 0.000284109787411,
        0.737708980728801, -0.10672597922827318, 0.666629601135323, 0.000284109787411,
        0.737708980728801, -0.10672597922827318, -0.6666296011353229, 0.000284109787411,
        -0.737708980728801, 0.10672597922827291, 0.666629601135323, 0.000284109787411,
        -0.737708980728801, 0.10672597922827291, -0.6666296011353229, 0.000284109787411,
        -0.737708980728801, -0.10672597922827291, 0.666629601135323, 0.000284109787411,
        -0.737708980728801, -0.10672597922827291, -0.6666296011353229, 0.000284109787411,
        0.6703715271049921, 0.03569455268820761, 0.7411665902854159, 0.000284345520601,
        0.6703715271049921, 0.03569455268820761, -0.741166590285416, 0.000284345520601,
        0.6703715271049921, -0.03569455268820761, 0.7411665902854159, 0.000284345520601,
        0.6703715271049921, -0.03569455268820761, -0.741166590285416, 0.000284345520601,
        -0.6703715271049921, 0.03569455268820761, 0.7411665902854159, 0.000284345520601,
        -0.6703715271049921, 0.03569455268820761, -0.741166590285416, 0.000284345520601,
        -0.6703715271049921, -0.03569455268820761, 0.7411665902854159, 0.000284345520601,
        -0.6703715271049921, -0.03569455268820761, -0.741166590285416, 0.000284345520601,
        0.670371527104992, 0.741166590285416, 0.03569455268820812, 0.000284345520601,
        0.670371527104992, 0.741166590285416, -0.035694552688208224, 0.000284345520601,
        0.670371527104992, -0.741166590285416, 0.03569455268820812, 0.000284345520601,
        0.670371527104992, -0.741166590285416, -0.035694552688208224, 0.000284345520601,
        -0.6703715271049921, 0.741166590285416, 0.03569455268820812, 0.000284345520601,
        -0.6703715271049921, 0.741166590285416, -0.035694552688208224, 0.000284345520601,
        -0.6703715271049921, -0.741166590285416, 0.03569455268820812, 0.000284345520601,
        -0.6703715271049921, -0.741166590285416, -0.035694552688208224, 0.000284345520601,
        0.03569455268820817, 0.6703715271049921, 0.7411665902854159, 0.000284345520601,
        0.03569455268820817, 0.6703715271049921, -0.741166590285416, 0.000284345520601,
        0.03569455268820817, -0.6703715271049921, 0.7411665902854159, 0.000284345520601,
        0.03569455268820817, -0.6703715271049921, -0.741166590285416, 0.000284345520601,
        -0.03569455268820808, 0.6703715271049921, 0.7411665902854159, 0.000284345520601,
        -0.03569455268820808, 0.6703715271049921, -0.741166590285416, 0.000284345520601,
        -0.03569455268820808, -0.6703715271049921, 0.7411665902854159, 0.000284345520601,
        -0.03569455268820808, -0.6703715271049921, -0.741166590285416, 0.000284345520601,
        0.0356945526882081, 0.7411665902854159, 0.6703715271049921, 0.000284345520601,
        0.03569455268820808, 0.7411665902854154, -0.6703715271049926, 0.000284345520601,
        0.0356945526882081, -0.7411665902854159, 0.6703715271049921, 0.000284345520601,
        0.03569455268820808, -0.7411665902854154, -0.6703715271049926, 0.000284345520601,
        -0.03569455268820801, 0.741166590285416, 0.6703715271049921, 0.000284345520601,
        -0.03569455268820799, 0.7411665902854155, -0.6703715271049926, 0.000284345520601,
        -0.03569455268820801, -0.741166590285416, 0.6703715271049921, 0.000284345520601,
        -0.03569455268820799, -0.7411665902854155, -0.6703715271049926, 0.000284345520601,
        0.7411665902854159, 0.6703715271049921, 0.03569455268820812, 0.000284345520601,
        0.7411665902854159, 0.6703715271049921, -0.035694552688208224, 0.000284345520601,
        0.7411665902854159, -0.6703715271049921, 0.03569455268820812, 0.000284345520601,
        0.7411665902854159, -0.6703715271049921, -0.035694552688208224, 0.000284345520601,
        -0.7411665902854159, 0.6703715271049923, 0.03569455268820812, 0.000284345520601,
        -0.7411665902854159, 0.6703715271049923, -0.035694552688208224, 0.000284345520601,
        -0.7411665902854159, -0.6703715271049923, 0.03569455268820812, 0.000284345520601,
        -0.7411665902854159, -0.6703715271049923, -0.035694552688208224, 0.000284345520601,
        0.7411665902854159, 0.035694552688208855, 0.6703715271049921, 0.000284345520601,
        0.7411665902854154, 0.035694552688208835, -0.6703715271049926, 0.000284345520601,
        0.7411665902854159, -0.035694552688208855, 0.6703715271049921, 0.000284345520601,
        0.7411665902854154, -0.035694552688208835, -0.6703715271049926, 0.000284345520601,
        -0.7411665902854159, 0.035694552688208966, 0.6703715271049921, 0.000284345520601,
        -0.7411665902854154, 0.035694552688208946, -0.6703715271049926, 0.000284345520601,
        -0.7411665902854159, -0.035694552688208966, 0.6703715271049921, 0.000284345520601,
        -0.7411665902854154, -0.035694552688208946, -0.6703715271049926, 0.000284345520601
    };
}
