"""ComicInfo Reprints (Alternates) Schema Mixin."""

from types import MappingProxyType

from glom import Fill, T

from comicbox.schemas.comicbox import (
    ISSUE_KEY,
    NAME_KEY,
    REPRINTS_KEY,
    SERIES_KEY,
    VOLUME_ISSUE_COUNT_KEY,
    VOLUME_KEY,
)
from comicbox.schemas.comicinfo import (
    ALTERNATE_COUNT_TAG,
    ALTERNATE_NUMBER_TAG,
    ALTERNATE_SERIES_TAG,
)
from comicbox.transforms.spec import MetaSpec

_REPRINTS_KEY_MAP = {
    ISSUE_KEY: ALTERNATE_NUMBER_TAG,
    SERIES_KEY: {NAME_KEY: ALTERNATE_SERIES_TAG},
    VOLUME_KEY: {VOLUME_ISSUE_COUNT_KEY: ALTERNATE_COUNT_TAG},
}
COMICINFO_REPRINTS_TO_CB = MetaSpec(
    key_map={
        REPRINTS_KEY: (ALTERNATE_SERIES_TAG, ALTERNATE_COUNT_TAG, ALTERNATE_NUMBER_TAG)
    },
    spec=(_REPRINTS_KEY_MAP, Fill([T])),
)

_FIRST_REPRINT_KEYPATH = f"{REPRINTS_KEY}.0."
_FIRST_REPRINT_SERIES_NAME_KEYPATH = _FIRST_REPRINT_KEYPATH + f"{SERIES_KEY}.{NAME_KEY}"
_FIRST_REPRINT_ISSUE_KEYPATH = _FIRST_REPRINT_KEYPATH + ISSUE_KEY
_FIRST_REPRINT_VOLUME_COUNT_KEYPATH = (
    _FIRST_REPRINT_KEYPATH + f"{VOLUME_KEY}.{VOLUME_ISSUE_COUNT_KEY}"
)
_ALTERNATES_KEY_MAP = MappingProxyType(
    {
        ALTERNATE_SERIES_TAG: _FIRST_REPRINT_SERIES_NAME_KEYPATH,
        ALTERNATE_NUMBER_TAG: _FIRST_REPRINT_ISSUE_KEYPATH,
        ALTERNATE_COUNT_TAG: _FIRST_REPRINT_VOLUME_COUNT_KEYPATH,
    }
)
COMICINFO_REPRINTS_FROM_CB = MetaSpec(key_map=_ALTERNATES_KEY_MAP)
