"""# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = 'yomix'
copyright = '2024, nicolas perrin gilbert'
author = 'nicolas perrin gilbert'
release = '0.0.1'

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = []

templates_path = ['_templates']
exclude_patterns = []



# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = 'alabaster'
html_static_path = ['_static']
"""

# Licensed under the BSD 3-Clause License.

import sys
from os.path import abspath

sys.path.insert(0, abspath(".."))

# -- General configuration ------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.coverage",
    "sphinx-mathjax-offline",
    "sphinx.ext.napoleon",  # before sphinx_autodoc_typehints
    "sphinx_autodoc_typehints",
    "sphinx.ext.autosummary",  # summary table
]

# List of modules to be mocked up
autodoc_mock_imports = []

# Configure sphinx.ext.autosummary
autosummary_generate = True
autoclass_content = "both"  # add __init__ docstrings to class summaries
html_show_sourcelink = False  # remove "view source code" from top of page
autodoc_inherit_docstrings = True  # if no docstring, inherit from base class
set_type_checking_flag = True  # 'expensive' imports (sphinx_autodoc_typehints)
nbsphinx_allow_errors = True  # continue through Jupyter errors
add_module_names = False  # remove namespaces from class/method signatures

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "yomix"
copyright = "2024 "
author = "Nicolas Perrin-Gilbert"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ""

# The full version, including alpha/beta/rc tags.
release = ""

""" #Read version info directly from the module's __init__.py
init_path = join(dirname(dirname(str(abspath(__file__)))), "yomix")
with open(f"{init_path}/__init__.py", "r") as fh:
    for line in fh:
        match = re.match('__version__ = "((\\d.\\d).\\d)[a-z0-9\\-]*".*', line)
        if match is not None:
            release = match.group(1)
            version = match.group(2)
            break"""

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_templates"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {}

# Output file base name for HTML help builder.
htmlhelp_basename = "yomixdoc"
