from sentence_transformers import SentenceTransformer
import os
from dotenv import load_dotenv

load_dotenv()

class HFEmbeddings:
    def __init__(self, model: str = "sentence-transformers/all-MiniLM-L6-v2"):
        """Initialize with a Hugging Face Sentence Transformer model."""
        self.model = SentenceTransformer(model)

    def embed(self, text: str) -> list[float]:
        """Generates an embedding vector for the given text."""
        return self.model.encode(text).tolist()

# Example usage
if __name__ == "__main__":
    embeddings = HFEmbeddings()
    vector = embeddings.embed("What is the meaning of life?")
    print(vector)  # Output should be a list of floating-point numbers
