from http import HTTPStatus
from typing import Any

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.create_filesystem_response_200 import CreateFilesystemResponse200
from ...models.create_filesystem_response_400 import CreateFilesystemResponse400
from ...models.create_filesystem_response_401 import CreateFilesystemResponse401
from ...models.create_filesystem_response_403 import CreateFilesystemResponse403
from ...models.filesystem_create_request import FilesystemCreateRequest
from ...types import Response


def _get_kwargs(
    *,
    body: FilesystemCreateRequest,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": "/api/v1/filesystems",
    }

    _kwargs["json"] = body.to_dict()

    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> (
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
    | None
):
    if response.status_code == 200:
        response_200 = CreateFilesystemResponse200.from_dict(response.json())

        return response_200

    if response.status_code == 400:
        response_400 = CreateFilesystemResponse400.from_dict(response.json())

        return response_400

    if response.status_code == 401:
        response_401 = CreateFilesystemResponse401.from_dict(response.json())

        return response_401

    if response.status_code == 403:
        response_403 = CreateFilesystemResponse403.from_dict(response.json())

        return response_403

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> Response[
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    body: FilesystemCreateRequest,
) -> Response[
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
]:
    """Create filesystem

     Creates a new filesystem.

    Args:
        body (FilesystemCreateRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[CreateFilesystemResponse200 | CreateFilesystemResponse400 | CreateFilesystemResponse401 | CreateFilesystemResponse403]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
    body: FilesystemCreateRequest,
) -> (
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
    | None
):
    """Create filesystem

     Creates a new filesystem.

    Args:
        body (FilesystemCreateRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        CreateFilesystemResponse200 | CreateFilesystemResponse400 | CreateFilesystemResponse401 | CreateFilesystemResponse403
    """

    return sync_detailed(
        client=client,
        body=body,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    body: FilesystemCreateRequest,
) -> Response[
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
]:
    """Create filesystem

     Creates a new filesystem.

    Args:
        body (FilesystemCreateRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[CreateFilesystemResponse200 | CreateFilesystemResponse400 | CreateFilesystemResponse401 | CreateFilesystemResponse403]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    body: FilesystemCreateRequest,
) -> (
    CreateFilesystemResponse200
    | CreateFilesystemResponse400
    | CreateFilesystemResponse401
    | CreateFilesystemResponse403
    | None
):
    """Create filesystem

     Creates a new filesystem.

    Args:
        body (FilesystemCreateRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        CreateFilesystemResponse200 | CreateFilesystemResponse400 | CreateFilesystemResponse401 | CreateFilesystemResponse403
    """

    return (
        await asyncio_detailed(
            client=client,
            body=body,
        )
    ).parsed
