# coding: utf-8

"""
    Phoenix API

    Base API for Glumanda and other services.

    The version of the OpenAPI document: Alpha
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from phoenix_sdk.models.device_config_min import DeviceConfigMin
from phoenix_sdk.models.unit_schema_min import UnitSchemaMin
from typing import Optional, Set
from typing_extensions import Self

class DeviceSchemaOUT(BaseModel):
    """
    DeviceSchemaOUT
    """ # noqa: E501
    created_by_id: StrictStr
    id: StrictStr
    created_at: datetime
    updated_at: datetime
    conf: Optional[Dict[str, Any]] = None
    config_id: StrictStr
    app_key: Optional[StrictStr] = None
    unit_id: Optional[StrictStr] = None
    company_id: Optional[StrictStr] = None
    config: DeviceConfigMin
    unit: Optional[UnitSchemaMin] = None
    last_seen: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["created_by_id", "id", "created_at", "updated_at", "conf", "config_id", "app_key", "unit_id", "company_id", "config", "unit", "last_seen"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceSchemaOUT from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unit
        if self.unit:
            _dict['unit'] = self.unit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceSchemaOUT from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_by_id": obj.get("created_by_id"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "conf": obj.get("conf"),
            "config_id": obj.get("config_id"),
            "app_key": obj.get("app_key"),
            "unit_id": obj.get("unit_id"),
            "company_id": obj.get("company_id"),
            "config": DeviceConfigMin.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "unit": UnitSchemaMin.from_dict(obj["unit"]) if obj.get("unit") is not None else None,
            "last_seen": obj.get("last_seen")
        })
        return _obj


