"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import weaveapi.auth.v1.session_pb2
import weaveapi.auth.v1.usage_pb2
import weaveapi.auth.v1.user_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class InitiateOAuthRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ProviderParamsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    PROVIDER_FIELD_NUMBER: builtins.int
    REDIRECT_URI_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    PROVIDER_PARAMS_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """github, google, microsoft, gitlab"""
    redirect_uri: builtins.str
    """Optional custom redirect"""
    state: builtins.str
    """CSRF protection"""
    scope: builtins.str
    """OAuth scopes (provider-specific)"""
    @property
    def provider_params(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional provider-specific params"""

    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        redirect_uri: builtins.str = ...,
        state: builtins.str = ...,
        scope: builtins.str = ...,
        provider_params: collections.abc.Mapping[builtins.str, builtins.str]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "provider",
            b"provider",
            "provider_params",
            b"provider_params",
            "redirect_uri",
            b"redirect_uri",
            "scope",
            b"scope",
            "state",
            b"state",
        ],
    ) -> None: ...

global___InitiateOAuthRequest = InitiateOAuthRequest

@typing.final
class InitiateOAuthResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_URL_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CODE_VERIFIER_FIELD_NUMBER: builtins.int
    PROVIDER_FIELD_NUMBER: builtins.int
    auth_url: builtins.str
    """OAuth provider URL to redirect to"""
    state: builtins.str
    """State parameter for CSRF"""
    code_verifier: builtins.str
    """For PKCE flow (if supported)"""
    provider: builtins.str
    """Provider name for confirmation"""
    def __init__(
        self,
        *,
        auth_url: builtins.str = ...,
        state: builtins.str = ...,
        code_verifier: builtins.str = ...,
        provider: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "auth_url",
            b"auth_url",
            "code_verifier",
            b"code_verifier",
            "provider",
            b"provider",
            "state",
            b"state",
        ],
    ) -> None: ...

global___InitiateOAuthResponse = InitiateOAuthResponse

@typing.final
class HandleOAuthCallbackRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CODE_VERIFIER_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    ERROR_DESCRIPTION_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """github, google, microsoft, gitlab"""
    code: builtins.str
    """OAuth authorization code"""
    state: builtins.str
    """CSRF state parameter"""
    code_verifier: builtins.str
    """For PKCE flow (if supported)"""
    error: builtins.str
    """OAuth error if any"""
    error_description: builtins.str
    """Error details"""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        code: builtins.str = ...,
        state: builtins.str = ...,
        code_verifier: builtins.str = ...,
        error: builtins.str = ...,
        error_description: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "code",
            b"code",
            "code_verifier",
            b"code_verifier",
            "error",
            b"error",
            "error_description",
            b"error_description",
            "provider",
            b"provider",
            "state",
            b"state",
        ],
    ) -> None: ...

global___HandleOAuthCallbackRequest = HandleOAuthCallbackRequest

@typing.final
class HandleOAuthCallbackResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    EXPIRES_IN_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    IS_NEW_USER_FIELD_NUMBER: builtins.int
    REDIRECT_URL_FIELD_NUMBER: builtins.int
    LINKED_PROVIDER_FIELD_NUMBER: builtins.int
    ACCOUNT_LINKED_FIELD_NUMBER: builtins.int
    access_token: builtins.str
    """JWT access token"""
    refresh_token: builtins.str
    """JWT refresh token"""
    expires_in: builtins.int
    """Seconds until access token expires"""
    is_new_user: builtins.bool
    """True if user was just created"""
    redirect_url: builtins.str
    """Where to redirect in the UI"""
    linked_provider: builtins.str
    """Which provider was used"""
    account_linked: builtins.bool
    """True if linked to existing account"""
    @property
    def user(self) -> weaveapi.auth.v1.user_pb2.User:
        """User profile"""

    def __init__(
        self,
        *,
        access_token: builtins.str = ...,
        refresh_token: builtins.str = ...,
        expires_in: builtins.int = ...,
        user: weaveapi.auth.v1.user_pb2.User | None = ...,
        is_new_user: builtins.bool = ...,
        redirect_url: builtins.str = ...,
        linked_provider: builtins.str = ...,
        account_linked: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["user", b"user"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "access_token",
            b"access_token",
            "account_linked",
            b"account_linked",
            "expires_in",
            b"expires_in",
            "is_new_user",
            b"is_new_user",
            "linked_provider",
            b"linked_provider",
            "redirect_url",
            b"redirect_url",
            "refresh_token",
            b"refresh_token",
            "user",
            b"user",
        ],
    ) -> None: ...

global___HandleOAuthCallbackResponse = HandleOAuthCallbackResponse

@typing.final
class GetOAuthProvidersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_ONLY_FIELD_NUMBER: builtins.int
    enabled_only: builtins.bool
    """Only return enabled providers"""
    def __init__(
        self,
        *,
        enabled_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["enabled_only", b"enabled_only"]
    ) -> None: ...

global___GetOAuthProvidersRequest = GetOAuthProvidersRequest

@typing.final
class GetOAuthProvidersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDERS_FIELD_NUMBER: builtins.int
    PRIMARY_PROVIDER_FIELD_NUMBER: builtins.int
    primary_provider: builtins.str
    """Recommended provider"""
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.auth.v1.user_pb2.OAuthProvider
    ]: ...
    def __init__(
        self,
        *,
        providers: collections.abc.Iterable[weaveapi.auth.v1.user_pb2.OAuthProvider]
        | None = ...,
        primary_provider: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "primary_provider", b"primary_provider", "providers", b"providers"
        ],
    ) -> None: ...

global___GetOAuthProvidersResponse = GetOAuthProvidersResponse

@typing.final
class LinkOAuthProviderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    REDIRECT_URI_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """Provider to link"""
    redirect_uri: builtins.str
    """Where to redirect after linking"""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        redirect_uri: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "provider", b"provider", "redirect_uri", b"redirect_uri"
        ],
    ) -> None: ...

global___LinkOAuthProviderRequest = LinkOAuthProviderRequest

@typing.final
class LinkOAuthProviderResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_URL_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    auth_url: builtins.str
    """OAuth URL to start linking flow"""
    state: builtins.str
    """CSRF state"""
    def __init__(
        self,
        *,
        auth_url: builtins.str = ...,
        state: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["auth_url", b"auth_url", "state", b"state"]
    ) -> None: ...

global___LinkOAuthProviderResponse = LinkOAuthProviderResponse

@typing.final
class UnlinkOAuthProviderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """Provider to unlink"""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["provider", b"provider"]
    ) -> None: ...

global___UnlinkOAuthProviderRequest = UnlinkOAuthProviderRequest

@typing.final
class UnlinkOAuthProviderResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    REMAINING_PROVIDERS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    remaining_providers: builtins.int
    """Number of providers still linked"""
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
        remaining_providers: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message",
            b"message",
            "remaining_providers",
            b"remaining_providers",
            "success",
            b"success",
        ],
    ) -> None: ...

global___UnlinkOAuthProviderResponse = UnlinkOAuthProviderResponse

@typing.final
class RefreshTokenRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    refresh_token: builtins.str
    def __init__(
        self,
        *,
        refresh_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["refresh_token", b"refresh_token"]
    ) -> None: ...

global___RefreshTokenRequest = RefreshTokenRequest

@typing.final
class RefreshTokenResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    EXPIRES_IN_FIELD_NUMBER: builtins.int
    access_token: builtins.str
    refresh_token: builtins.str
    """New refresh token"""
    expires_in: builtins.int
    def __init__(
        self,
        *,
        access_token: builtins.str = ...,
        refresh_token: builtins.str = ...,
        expires_in: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "access_token",
            b"access_token",
            "expires_in",
            b"expires_in",
            "refresh_token",
            b"refresh_token",
        ],
    ) -> None: ...

global___RefreshTokenResponse = RefreshTokenResponse

@typing.final
class RevokeTokenRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    refresh_token: builtins.str
    def __init__(
        self,
        *,
        refresh_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["refresh_token", b"refresh_token"]
    ) -> None: ...

global___RevokeTokenRequest = RevokeTokenRequest

@typing.final
class RevokeTokenResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["message", b"message", "success", b"success"]
    ) -> None: ...

global___RevokeTokenResponse = RevokeTokenResponse

@typing.final
class ValidateTokenRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    access_token: builtins.str
    def __init__(
        self,
        *,
        access_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["access_token", b"access_token"]
    ) -> None: ...

global___ValidateTokenRequest = ValidateTokenRequest

@typing.final
class ValidateTokenResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    TIER_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    user_id: builtins.str
    tier: builtins.str
    """free, pro"""
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
        user_id: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        tier: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["expires_at", b"expires_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "expires_at",
            b"expires_at",
            "scopes",
            b"scopes",
            "tier",
            b"tier",
            "user_id",
            b"user_id",
            "valid",
            b"valid",
        ],
    ) -> None: ...

global___ValidateTokenResponse = ValidateTokenResponse

@typing.final
class GetCurrentUserRequest(google.protobuf.message.Message):
    """Uses JWT from Authorization header"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetCurrentUserRequest = GetCurrentUserRequest

@typing.final
class GetCurrentUserResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> weaveapi.auth.v1.user_pb2.User: ...
    def __init__(
        self,
        *,
        user: weaveapi.auth.v1.user_pb2.User | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["user", b"user"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["user", b"user"]) -> None: ...

global___GetCurrentUserResponse = GetCurrentUserResponse

@typing.final
class UpdateUserRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FULL_NAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    PREFERENCES_FIELD_NUMBER: builtins.int
    full_name: builtins.str
    email: builtins.str
    @property
    def preferences(self) -> weaveapi.auth.v1.user_pb2.UserPreferences: ...
    def __init__(
        self,
        *,
        full_name: builtins.str = ...,
        email: builtins.str = ...,
        preferences: weaveapi.auth.v1.user_pb2.UserPreferences | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["preferences", b"preferences"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "email", b"email", "full_name", b"full_name", "preferences", b"preferences"
        ],
    ) -> None: ...

global___UpdateUserRequest = UpdateUserRequest

@typing.final
class UpdateUserResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> weaveapi.auth.v1.user_pb2.User: ...
    def __init__(
        self,
        *,
        user: weaveapi.auth.v1.user_pb2.User | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["user", b"user"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["user", b"user"]) -> None: ...

global___UpdateUserResponse = UpdateUserResponse

@typing.final
class DeleteUserRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIRMATION_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    confirmation: builtins.str
    """Must be "DELETE" """
    password: builtins.str
    """For extra security"""
    def __init__(
        self,
        *,
        confirmation: builtins.str = ...,
        password: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "confirmation", b"confirmation", "password", b"password"
        ],
    ) -> None: ...

global___DeleteUserRequest = DeleteUserRequest

@typing.final
class DeleteUserResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    SCHEDULED_DELETION_AT_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    @property
    def scheduled_deletion_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """30-day grace period"""

    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
        scheduled_deletion_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal["scheduled_deletion_at", b"scheduled_deletion_at"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message",
            b"message",
            "scheduled_deletion_at",
            b"scheduled_deletion_at",
            "success",
            b"success",
        ],
    ) -> None: ...

global___DeleteUserResponse = DeleteUserResponse

@typing.final
class ListAPIKeysRequest(google.protobuf.message.Message):
    """API Key management messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ACTIVE_ONLY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    page_token: builtins.str
    active_only: builtins.bool
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        active_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_only",
            b"active_only",
            "page_size",
            b"page_size",
            "page_token",
            b"page_token",
        ],
    ) -> None: ...

global___ListAPIKeysRequest = ListAPIKeysRequest

@typing.final
class ListAPIKeysResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEYS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    total_count: builtins.int
    @property
    def api_keys(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.auth.v1.user_pb2.APIKey
    ]: ...
    def __init__(
        self,
        *,
        api_keys: collections.abc.Iterable[weaveapi.auth.v1.user_pb2.APIKey]
        | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_keys",
            b"api_keys",
            "next_page_token",
            b"next_page_token",
            "total_count",
            b"total_count",
        ],
    ) -> None: ...

global___ListAPIKeysResponse = ListAPIKeysResponse

@typing.final
class CreateAPIKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    ALLOWED_ENDPOINTS_FIELD_NUMBER: builtins.int
    ALLOWED_IPS_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    name: builtins.str
    description: builtins.str
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """read, write"""

    @property
    def allowed_endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional endpoint restrictions"""

    @property
    def allowed_ips(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional IP whitelist"""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Optional expiration"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_ips: collections.abc.Iterable[builtins.str] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["expires_at", b"expires_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "allowed_endpoints",
            b"allowed_endpoints",
            "allowed_ips",
            b"allowed_ips",
            "description",
            b"description",
            "expires_at",
            b"expires_at",
            "name",
            b"name",
            "scopes",
            b"scopes",
        ],
    ) -> None: ...

global___CreateAPIKeyRequest = CreateAPIKeyRequest

@typing.final
class CreateAPIKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    SECRET_KEY_FIELD_NUMBER: builtins.int
    WARNING_FIELD_NUMBER: builtins.int
    secret_key: builtins.str
    """Full key, only shown once"""
    warning: builtins.str
    """"Store this key securely, it won't be shown again" """
    @property
    def api_key(self) -> weaveapi.auth.v1.user_pb2.APIKey: ...
    def __init__(
        self,
        *,
        api_key: weaveapi.auth.v1.user_pb2.APIKey | None = ...,
        secret_key: builtins.str = ...,
        warning: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["api_key", b"api_key"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_key", b"api_key", "secret_key", b"secret_key", "warning", b"warning"
        ],
    ) -> None: ...

global___CreateAPIKeyResponse = CreateAPIKeyResponse

@typing.final
class GetAPIKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key_id", b"key_id"]) -> None: ...

global___GetAPIKeyRequest = GetAPIKeyRequest

@typing.final
class GetAPIKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    @property
    def api_key(self) -> weaveapi.auth.v1.user_pb2.APIKey: ...
    def __init__(
        self,
        *,
        api_key: weaveapi.auth.v1.user_pb2.APIKey | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["api_key", b"api_key"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_key", b"api_key"]) -> None: ...

global___GetAPIKeyResponse = GetAPIKeyResponse

@typing.final
class UpdateAPIKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ALLOWED_ENDPOINTS_FIELD_NUMBER: builtins.int
    ALLOWED_IPS_FIELD_NUMBER: builtins.int
    IS_ACTIVE_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    name: builtins.str
    description: builtins.str
    is_active: builtins.bool
    @property
    def allowed_endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    @property
    def allowed_ips(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        allowed_endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_ips: collections.abc.Iterable[builtins.str] | None = ...,
        is_active: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "allowed_endpoints",
            b"allowed_endpoints",
            "allowed_ips",
            b"allowed_ips",
            "description",
            b"description",
            "is_active",
            b"is_active",
            "key_id",
            b"key_id",
            "name",
            b"name",
        ],
    ) -> None: ...

global___UpdateAPIKeyRequest = UpdateAPIKeyRequest

@typing.final
class UpdateAPIKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    @property
    def api_key(self) -> weaveapi.auth.v1.user_pb2.APIKey: ...
    def __init__(
        self,
        *,
        api_key: weaveapi.auth.v1.user_pb2.APIKey | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["api_key", b"api_key"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_key", b"api_key"]) -> None: ...

global___UpdateAPIKeyResponse = UpdateAPIKeyResponse

@typing.final
class RevokeAPIKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key_id", b"key_id"]) -> None: ...

global___RevokeAPIKeyRequest = RevokeAPIKeyRequest

@typing.final
class RevokeAPIKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["message", b"message", "success", b"success"]
    ) -> None: ...

global___RevokeAPIKeyResponse = RevokeAPIKeyResponse

@typing.final
class ValidateAPIKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    IP_ADDRESS_FIELD_NUMBER: builtins.int
    api_key: builtins.str
    """Full API key"""
    endpoint: builtins.str
    """Endpoint being accessed"""
    ip_address: builtins.str
    """Request IP"""
    def __init__(
        self,
        *,
        api_key: builtins.str = ...,
        endpoint: builtins.str = ...,
        ip_address: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_key", b"api_key", "endpoint", b"endpoint", "ip_address", b"ip_address"
        ],
    ) -> None: ...

global___ValidateAPIKeyRequest = ValidateAPIKeyRequest

@typing.final
class ValidateAPIKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    TIER_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    RATE_LIMIT_FIELD_NUMBER: builtins.int
    REJECTION_REASON_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    user_id: builtins.str
    tier: builtins.str
    """free, pro"""
    rejection_reason: builtins.str
    """If invalid"""
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    @property
    def rate_limit(self) -> global___RateLimitInfo: ...
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
        user_id: builtins.str = ...,
        tier: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        rate_limit: global___RateLimitInfo | None = ...,
        rejection_reason: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["rate_limit", b"rate_limit"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "rate_limit",
            b"rate_limit",
            "rejection_reason",
            b"rejection_reason",
            "scopes",
            b"scopes",
            "tier",
            b"tier",
            "user_id",
            b"user_id",
            "valid",
            b"valid",
        ],
    ) -> None: ...

global___ValidateAPIKeyResponse = ValidateAPIKeyResponse

@typing.final
class GetUsageStatsRequest(google.protobuf.message.Message):
    """Usage messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERIOD_FIELD_NUMBER: builtins.int
    API_KEY_ID_FIELD_NUMBER: builtins.int
    period: builtins.str
    """today, week, month, all"""
    api_key_id: builtins.str
    """Optional: filter by specific key"""
    def __init__(
        self,
        *,
        period: builtins.str = ...,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["api_key_id", b"api_key_id", "period", b"period"],
    ) -> None: ...

global___GetUsageStatsRequest = GetUsageStatsRequest

@typing.final
class GetUsageStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_PERIOD_FIELD_NUMBER: builtins.int
    HISTORICAL_FIELD_NUMBER: builtins.int
    LIMITS_FIELD_NUMBER: builtins.int
    @property
    def current_period(self) -> weaveapi.auth.v1.usage_pb2.UsageStats: ...
    @property
    def historical(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.auth.v1.usage_pb2.UsageStats
    ]:
        """Past periods"""

    @property
    def limits(self) -> weaveapi.auth.v1.usage_pb2.UsageLimits: ...
    def __init__(
        self,
        *,
        current_period: weaveapi.auth.v1.usage_pb2.UsageStats | None = ...,
        historical: collections.abc.Iterable[weaveapi.auth.v1.usage_pb2.UsageStats]
        | None = ...,
        limits: weaveapi.auth.v1.usage_pb2.UsageLimits | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "current_period", b"current_period", "limits", b"limits"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "current_period",
            b"current_period",
            "historical",
            b"historical",
            "limits",
            b"limits",
        ],
    ) -> None: ...

global___GetUsageStatsResponse = GetUsageStatsResponse

@typing.final
class GetRateLimitStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """Optional: check specific key"""
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["api_key_id", b"api_key_id"]
    ) -> None: ...

global___GetRateLimitStatusRequest = GetRateLimitStatusRequest

@typing.final
class GetRateLimitStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_FIELD_NUMBER: builtins.int
    BY_ENDPOINT_FIELD_NUMBER: builtins.int
    @property
    def current(self) -> global___RateLimitInfo: ...
    @property
    def by_endpoint(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___RateLimitInfo
    ]: ...
    def __init__(
        self,
        *,
        current: global___RateLimitInfo | None = ...,
        by_endpoint: collections.abc.Iterable[global___RateLimitInfo] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["current", b"current"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "by_endpoint", b"by_endpoint", "current", b"current"
        ],
    ) -> None: ...

global___GetRateLimitStatusResponse = GetRateLimitStatusResponse

@typing.final
class RateLimitInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIER_FIELD_NUMBER: builtins.int
    WINDOW_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    REMAINING_FIELD_NUMBER: builtins.int
    RESET_AT_FIELD_NUMBER: builtins.int
    IS_LIMITED_FIELD_NUMBER: builtins.int
    tier: builtins.str
    window: builtins.str
    """hour, minute"""
    limit: builtins.int
    remaining: builtins.int
    is_limited: builtins.bool
    @property
    def reset_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        tier: builtins.str = ...,
        window: builtins.str = ...,
        limit: builtins.int = ...,
        remaining: builtins.int = ...,
        reset_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_limited: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["reset_at", b"reset_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "is_limited",
            b"is_limited",
            "limit",
            b"limit",
            "remaining",
            b"remaining",
            "reset_at",
            b"reset_at",
            "tier",
            b"tier",
            "window",
            b"window",
        ],
    ) -> None: ...

global___RateLimitInfo = RateLimitInfo

@typing.final
class ListSessionsRequest(google.protobuf.message.Message):
    """Session management messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    page_token: builtins.str
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "page_size", b"page_size", "page_token", b"page_token"
        ],
    ) -> None: ...

global___ListSessionsRequest = ListSessionsRequest

@typing.final
class ListSessionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    CURRENT_SESSION_ID_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    total_count: builtins.int
    current_session_id: builtins.str
    @property
    def sessions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.auth.v1.session_pb2.Session
    ]: ...
    def __init__(
        self,
        *,
        sessions: collections.abc.Iterable[weaveapi.auth.v1.session_pb2.Session]
        | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
        current_session_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "current_session_id",
            b"current_session_id",
            "next_page_token",
            b"next_page_token",
            "sessions",
            b"sessions",
            "total_count",
            b"total_count",
        ],
    ) -> None: ...

global___ListSessionsResponse = ListSessionsResponse

@typing.final
class RevokeSessionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["session_id", b"session_id"]
    ) -> None: ...

global___RevokeSessionRequest = RevokeSessionRequest

@typing.final
class RevokeSessionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["message", b"message", "success", b"success"]
    ) -> None: ...

global___RevokeSessionResponse = RevokeSessionResponse

@typing.final
class RevokeAllSessionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEEP_CURRENT_FIELD_NUMBER: builtins.int
    keep_current: builtins.bool
    """Keep the session making this request"""
    def __init__(
        self,
        *,
        keep_current: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["keep_current", b"keep_current"]
    ) -> None: ...

global___RevokeAllSessionsRequest = RevokeAllSessionsRequest

@typing.final
class RevokeAllSessionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REVOKED_COUNT_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    revoked_count: builtins.int
    message: builtins.str
    def __init__(
        self,
        *,
        revoked_count: builtins.int = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message", b"message", "revoked_count", b"revoked_count"
        ],
    ) -> None: ...

global___RevokeAllSessionsResponse = RevokeAllSessionsResponse
