# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._communication_network_traversal_operations import build_issue_relay_configuration_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class CommunicationNetworkTraversalOperations:
    """CommunicationNetworkTraversalOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.communication.networktraversal.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def issue_relay_configuration(
        self,
        id: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs: Any
    ) -> "_models.CommunicationRelayConfiguration":
        """Issue a configuration for an STUN/TURN server for an existing identity.

        Issue a configuration for an STUN/TURN server for an existing identity.

        :param id: An existing ACS identity.
        :type id: str
        :param route_type: The routing methodology to where the ICE server will be located from the
         client.
        :type route_type: str or ~azure.communication.networktraversal.models.RouteType
        :keyword api_version: Api Version. The default value is "2021-10-08-preview". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CommunicationRelayConfiguration, or the result of cls(response)
        :rtype: ~azure.communication.networktraversal.models.CommunicationRelayConfiguration
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CommunicationRelayConfiguration"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-08-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _body = _models.CommunicationRelayConfigurationRequest(id=id, route_type=route_type)
        if _body is not None:
            json = self._serialize.body(_body, 'CommunicationRelayConfigurationRequest')
        else:
            json = None

        request = build_issue_relay_configuration_request(
            api_version=api_version,
            content_type=content_type,
            json=json,
            template_url=self.issue_relay_configuration.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CommunicationRelayConfiguration', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    issue_relay_configuration.metadata = {'url': '/networktraversal/:issueRelayConfiguration'}  # type: ignore

