from cryptography.hazmat.primitives.asymmetric.types import CertificateIssuerPrivateKeyTypes, PrivateKeyTypes
from cryptography.x509 import Certificate, CertificateSigningRequest, Name
from dataclasses import dataclass, field
from datetime import datetime
from pathlib import Path
from radkit_common.access.exceptions import RADKitCertificateError
from radkit_common.identities import ClientID, EndpointID, ServiceID
from radkit_common.types import CustomSecretStr

__all__ = ['EndpointCertificateBundlePaths', 'RADKitEndpointCertificate', 'RADKitServiceCertificate', 'RADKitClientCertificate', 'RADKitClientCSR', 'new_service_csr', 'new_client_csr', 'sign_challenge', 'get_bundle_dir_path', 'parse_certificate_chain', 'CertificateValidationError']

class CertificateBundleError(RADKitCertificateError):
    message: str

class CertificateLoadingError(RADKitCertificateError):
    message: str

class CertificateValidationError(RADKitCertificateError):
    message: str

def parse_certificate_chain(chain_pem: str) -> list[Certificate]: ...
def get_bundle_dir_path(domain_auth_hostname: str, identity: EndpointID) -> Path: ...

@dataclass
class EndpointCertificateBundlePaths:
    identity: EndpointID | None = ...
    auth_hostname: str | None = ...
    ca_path: Path | None = field(default=None, repr=False)
    cert_path: Path | None = field(default=None, repr=False)
    key_path: Path | None = field(default=None, repr=False)
    admin: bool = ...
    using_custom_paths = ...
    default_bundle_directory: Path | None = ...
    def __post_init__(self) -> None: ...
    @property
    def private_key_path(self) -> Path: ...
    @property
    def certificate_pem_path(self) -> Path: ...
    @property
    def chain_pem_path(self) -> Path: ...
    def all_files_exist(self) -> bool: ...
    def any_file_exists(self) -> bool: ...

@dataclass
class RADKitEndpointCertificate:
    certificate: Certificate
    private_key: PrivateKeyTypes
    chain: list[Certificate]
    warnings: list[str] = field(default_factory=list)
    logger = ...
    revoked: bool | None = ...
    def __post_init__(self) -> None: ...
    @property
    def subject_name(self) -> str: ...
    @property
    def serial_number(self) -> str: ...
    @property
    def endpoint_type(self) -> str: ...
    @property
    def identity(self) -> EndpointID: ...
    @property
    def owner(self) -> str: ...
    @property
    def requester(self) -> str: ...
    @property
    def expires_in(self) -> int: ...
    @property
    def is_admin(self) -> bool: ...
    @property
    def validated(self) -> datetime | None: ...
    def expired(self, now: datetime) -> bool: ...
    def save_to_file(self, auth_hostname: str, private_key_password: CustomSecretStr, overwrite: bool = False) -> EndpointCertificateBundlePaths: ...
    def any_file_exists(self, auth_hostname: str) -> bool: ...
    def all_files_exist(self, auth_hostname: str) -> bool: ...
    @classmethod
    def load_from_file(cls, identity: EndpointID, private_key_password: CustomSecretStr, auth_hostname: str | None = None, paths: EndpointCertificateBundlePaths | None = None, admin: bool = False) -> RADKitEndpointCertificate: ...
    async def validate(self, now: datetime) -> None: ...

@dataclass
class RADKitServiceCertificate(RADKitEndpointCertificate): ...
@dataclass
class RADKitClientCertificate(RADKitEndpointCertificate): ...

@dataclass
class RADKitClientCSR:
    subject_name: Name
    key: CertificateIssuerPrivateKeyTypes = field(default_factory=_default_private_key_generator)
    def sign(self) -> CertificateSigningRequest: ...
    @property
    def pem(self) -> bytes: ...
    @property
    def der(self) -> bytes: ...
    @property
    def base64(self) -> bytes: ...
    @property
    def private_key_pem(self) -> bytes: ...

def new_service_csr(service_id: ServiceID | None) -> RADKitClientCSR: ...
def new_client_csr(client_id: ClientID | None) -> RADKitClientCSR: ...
def sign_challenge(certificate: RADKitEndpointCertificate, challenge: bytes) -> tuple[str, str]: ...
