# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceMetastoreConfigsResult',
    'AwaitableGetBdsInstanceMetastoreConfigsResult',
    'get_bds_instance_metastore_configs',
    'get_bds_instance_metastore_configs_output',
]

@pulumi.output_type
class GetBdsInstanceMetastoreConfigsResult:
    """
    A collection of values returned by getBdsInstanceMetastoreConfigs.
    """
    def __init__(__self__, bds_api_key_id=None, bds_instance_id=None, bds_metastore_configurations=None, display_name=None, filters=None, id=None, metastore_id=None, metastore_type=None, state=None):
        if bds_api_key_id and not isinstance(bds_api_key_id, str):
            raise TypeError("Expected argument 'bds_api_key_id' to be a str")
        pulumi.set(__self__, "bds_api_key_id", bds_api_key_id)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if bds_metastore_configurations and not isinstance(bds_metastore_configurations, list):
            raise TypeError("Expected argument 'bds_metastore_configurations' to be a list")
        pulumi.set(__self__, "bds_metastore_configurations", bds_metastore_configurations)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if metastore_type and not isinstance(metastore_type, str):
            raise TypeError("Expected argument 'metastore_type' to be a str")
        pulumi.set(__self__, "metastore_type", metastore_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsApiKeyId")
    def bds_api_key_id(self) -> Optional[str]:
        """
        The ID of BDS API Key used for metastore configuration. Set only if metastore's type is EXTERNAL.
        """
        return pulumi.get(self, "bds_api_key_id")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="bdsMetastoreConfigurations")
    def bds_metastore_configurations(self) -> Sequence['outputs.GetBdsInstanceMetastoreConfigsBdsMetastoreConfigurationResult']:
        """
        The list of bds_metastore_configurations.
        """
        return pulumi.get(self, "bds_metastore_configurations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of metastore configuration
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceMetastoreConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[str]:
        """
        The OCID of the Data Catalog metastore. Set only if metastore's type is EXTERNAL.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="metastoreType")
    def metastore_type(self) -> Optional[str]:
        """
        The type of the metastore in the metastore configuration.
        """
        return pulumi.get(self, "metastore_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        the lifecycle state of the metastore configuration.
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstanceMetastoreConfigsResult(GetBdsInstanceMetastoreConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceMetastoreConfigsResult(
            bds_api_key_id=self.bds_api_key_id,
            bds_instance_id=self.bds_instance_id,
            bds_metastore_configurations=self.bds_metastore_configurations,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            metastore_id=self.metastore_id,
            metastore_type=self.metastore_type,
            state=self.state)


def get_bds_instance_metastore_configs(bds_api_key_id: Optional[str] = None,
                                       bds_instance_id: Optional[str] = None,
                                       display_name: Optional[str] = None,
                                       filters: Optional[Sequence[pulumi.InputType['GetBdsInstanceMetastoreConfigsFilterArgs']]] = None,
                                       metastore_id: Optional[str] = None,
                                       metastore_type: Optional[str] = None,
                                       state: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceMetastoreConfigsResult:
    """
    This data source provides the list of Bds Instance Metastore Configs in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of metastore configurations ssociated with this Big Data Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_metastore_configs = oci.BigDataService.get_bds_instance_metastore_configs(bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"],
        bds_api_key_id=oci_identity_api_key["test_api_key"]["id"],
        display_name=var["bds_instance_metastore_config_display_name"],
        metastore_id=oci_datacatalog_metastore["test_metastore"]["id"],
        metastore_type=var["bds_instance_metastore_config_metastore_type"],
        state=var["bds_instance_metastore_config_state"])
    ```


    :param str bds_api_key_id: The ID of the API key that is associated with the external metastore in the metastore configuration
    :param str bds_instance_id: The OCID of the cluster.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str metastore_id: The OCID of the Data Catalog metastore in the metastore configuration
    :param str metastore_type: The type of the metastore in the metastore configuration
    :param str state: The lifecycle state of the metastore in the metastore configuration
    """
    __args__ = dict()
    __args__['bdsApiKeyId'] = bds_api_key_id
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['metastoreId'] = metastore_id
    __args__['metastoreType'] = metastore_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceMetastoreConfigs:getBdsInstanceMetastoreConfigs', __args__, opts=opts, typ=GetBdsInstanceMetastoreConfigsResult).value

    return AwaitableGetBdsInstanceMetastoreConfigsResult(
        bds_api_key_id=pulumi.get(__ret__, 'bds_api_key_id'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        bds_metastore_configurations=pulumi.get(__ret__, 'bds_metastore_configurations'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        metastore_type=pulumi.get(__ret__, 'metastore_type'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_bds_instance_metastore_configs)
def get_bds_instance_metastore_configs_output(bds_api_key_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              bds_instance_id: Optional[pulumi.Input[str]] = None,
                                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetBdsInstanceMetastoreConfigsFilterArgs']]]]] = None,
                                              metastore_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              metastore_type: Optional[pulumi.Input[Optional[str]]] = None,
                                              state: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBdsInstanceMetastoreConfigsResult]:
    """
    This data source provides the list of Bds Instance Metastore Configs in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of metastore configurations ssociated with this Big Data Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_metastore_configs = oci.BigDataService.get_bds_instance_metastore_configs(bds_instance_id=oci_bds_bds_instance["test_bds_instance"]["id"],
        bds_api_key_id=oci_identity_api_key["test_api_key"]["id"],
        display_name=var["bds_instance_metastore_config_display_name"],
        metastore_id=oci_datacatalog_metastore["test_metastore"]["id"],
        metastore_type=var["bds_instance_metastore_config_metastore_type"],
        state=var["bds_instance_metastore_config_state"])
    ```


    :param str bds_api_key_id: The ID of the API key that is associated with the external metastore in the metastore configuration
    :param str bds_instance_id: The OCID of the cluster.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str metastore_id: The OCID of the Data Catalog metastore in the metastore configuration
    :param str metastore_type: The type of the metastore in the metastore configuration
    :param str state: The lifecycle state of the metastore in the metastore configuration
    """
    ...
