# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAssociationResult',
    'AwaitableGetAssociationResult',
    'get_association',
    'get_association_output',
]

@pulumi.output_type
class GetAssociationResult:
    """
    A collection of values returned by getAssociation.
    """
    def __init__(__self__, associated_resource_id=None, association_id=None, association_type=None, certificates_resource_id=None, compartment_id=None, id=None, name=None, state=None, time_created=None):
        if associated_resource_id and not isinstance(associated_resource_id, str):
            raise TypeError("Expected argument 'associated_resource_id' to be a str")
        pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if association_type and not isinstance(association_type, str):
            raise TypeError("Expected argument 'association_type' to be a str")
        pulumi.set(__self__, "association_type", association_type)
        if certificates_resource_id and not isinstance(certificates_resource_id, str):
            raise TypeError("Expected argument 'certificates_resource_id' to be a str")
        pulumi.set(__self__, "certificates_resource_id", certificates_resource_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> str:
        """
        The OCID of the associated resource.
        """
        return pulumi.get(self, "associated_resource_id")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> str:
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> str:
        """
        Type of the association.
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="certificatesResourceId")
    def certificates_resource_id(self) -> str:
        """
        The OCID of the certificate-related resource associated with another Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "certificates_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID of the association, which is strongly tied to the compartment OCID of the certificate-related resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name generated by the service for the association, expressed in a format that follows the pattern: [certificatesResourceEntityType]-[associatedResourceEntityType]-UUID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A property indicating when the association was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetAssociationResult(GetAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssociationResult(
            associated_resource_id=self.associated_resource_id,
            association_id=self.association_id,
            association_type=self.association_type,
            certificates_resource_id=self.certificates_resource_id,
            compartment_id=self.compartment_id,
            id=self.id,
            name=self.name,
            state=self.state,
            time_created=self.time_created)


def get_association(association_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssociationResult:
    """
    This data source provides details about a specific Association resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_association = oci.CertificatesManagement.get_association(association_id=oci_certificates_management_association["test_association"]["id"])
    ```


    :param str association_id: The OCID of an association between a certificate-related resource and another Oracle Cloud Infrastructure resource.
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getAssociation:getAssociation', __args__, opts=opts, typ=GetAssociationResult).value

    return AwaitableGetAssociationResult(
        associated_resource_id=pulumi.get(__ret__, 'associated_resource_id'),
        association_id=pulumi.get(__ret__, 'association_id'),
        association_type=pulumi.get(__ret__, 'association_type'),
        certificates_resource_id=pulumi.get(__ret__, 'certificates_resource_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_association)
def get_association_output(association_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssociationResult]:
    """
    This data source provides details about a specific Association resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_association = oci.CertificatesManagement.get_association(association_id=oci_certificates_management_association["test_association"]["id"])
    ```


    :param str association_id: The OCID of an association between a certificate-related resource and another Oracle Cloud Infrastructure resource.
    """
    ...
