# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAtCustomerCccUpgradeScheduleResult',
    'AwaitableGetAtCustomerCccUpgradeScheduleResult',
    'get_at_customer_ccc_upgrade_schedule',
    'get_at_customer_ccc_upgrade_schedule_output',
]

@pulumi.output_type
class GetAtCustomerCccUpgradeScheduleResult:
    """
    A collection of values returned by getAtCustomerCccUpgradeSchedule.
    """
    def __init__(__self__, ccc_upgrade_schedule_id=None, compartment_id=None, defined_tags=None, description=None, display_name=None, events=None, freeform_tags=None, id=None, infrastructure_ids=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if ccc_upgrade_schedule_id and not isinstance(ccc_upgrade_schedule_id, str):
            raise TypeError("Expected argument 'ccc_upgrade_schedule_id' to be a str")
        pulumi.set(__self__, "ccc_upgrade_schedule_id", ccc_upgrade_schedule_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if events and not isinstance(events, list):
            raise TypeError("Expected argument 'events' to be a list")
        pulumi.set(__self__, "events", events)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_ids and not isinstance(infrastructure_ids, list):
            raise TypeError("Expected argument 'infrastructure_ids' to be a list")
        pulumi.set(__self__, "infrastructure_ids", infrastructure_ids)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="cccUpgradeScheduleId")
    def ccc_upgrade_schedule_id(self) -> str:
        return pulumi.get(self, "ccc_upgrade_schedule_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Compute Cloud@Customer upgrade schedule.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the Compute Cloud@Customer upgrade schedule time block.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Compute Cloud@Customer upgrade schedule display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetAtCustomerCccUpgradeScheduleEventResult']:
        """
        List of preferred times for Compute Cloud@Customer infrastructures associated with this schedule to be upgraded.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Upgrade schedule [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). This cannot be changed once created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="infrastructureIds")
    def infrastructure_ids(self) -> Sequence[str]:
        """
        List of Compute Cloud@Customer infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that are using this upgrade schedule.
        """
        return pulumi.get(self, "infrastructure_ids")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, the message can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the upgrade schedule was created, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the upgrade schedule was updated, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAtCustomerCccUpgradeScheduleResult(GetAtCustomerCccUpgradeScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAtCustomerCccUpgradeScheduleResult(
            ccc_upgrade_schedule_id=self.ccc_upgrade_schedule_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            events=self.events,
            freeform_tags=self.freeform_tags,
            id=self.id,
            infrastructure_ids=self.infrastructure_ids,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_at_customer_ccc_upgrade_schedule(ccc_upgrade_schedule_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAtCustomerCccUpgradeScheduleResult:
    """
    This data source provides details about a specific Ccc Upgrade Schedule resource in Oracle Cloud Infrastructure Compute Cloud At Customer service.

    Gets a Compute Cloud@Customer upgrade schedule by the specified
    [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ccc_upgrade_schedule = oci.ComputeCloud.get_at_customer_ccc_upgrade_schedule(ccc_upgrade_schedule_id=oci_compute_cloud_at_customer_ccc_upgrade_schedule["test_ccc_upgrade_schedule"]["id"])
    ```


    :param str ccc_upgrade_schedule_id: Compute Cloud@Customer upgrade schedule [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['cccUpgradeScheduleId'] = ccc_upgrade_schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ComputeCloud/getAtCustomerCccUpgradeSchedule:getAtCustomerCccUpgradeSchedule', __args__, opts=opts, typ=GetAtCustomerCccUpgradeScheduleResult).value

    return AwaitableGetAtCustomerCccUpgradeScheduleResult(
        ccc_upgrade_schedule_id=pulumi.get(__ret__, 'ccc_upgrade_schedule_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        events=pulumi.get(__ret__, 'events'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_ids=pulumi.get(__ret__, 'infrastructure_ids'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_at_customer_ccc_upgrade_schedule)
def get_at_customer_ccc_upgrade_schedule_output(ccc_upgrade_schedule_id: Optional[pulumi.Input[str]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAtCustomerCccUpgradeScheduleResult]:
    """
    This data source provides details about a specific Ccc Upgrade Schedule resource in Oracle Cloud Infrastructure Compute Cloud At Customer service.

    Gets a Compute Cloud@Customer upgrade schedule by the specified
    [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ccc_upgrade_schedule = oci.ComputeCloud.get_at_customer_ccc_upgrade_schedule(ccc_upgrade_schedule_id=oci_compute_cloud_at_customer_ccc_upgrade_schedule["test_ccc_upgrade_schedule"]["id"])
    ```


    :param str ccc_upgrade_schedule_id: Compute Cloud@Customer upgrade schedule [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
