# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetBootVolumeReplicaResult',
    'AwaitableGetBootVolumeReplicaResult',
    'get_boot_volume_replica',
    'get_boot_volume_replica_output',
]

@pulumi.output_type
class GetBootVolumeReplicaResult:
    """
    A collection of values returned by getBootVolumeReplica.
    """
    def __init__(__self__, availability_domain=None, boot_volume_id=None, boot_volume_replica_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_id=None, size_in_gbs=None, state=None, time_created=None, time_last_synced=None, volume_group_replica_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if boot_volume_id and not isinstance(boot_volume_id, str):
            raise TypeError("Expected argument 'boot_volume_id' to be a str")
        pulumi.set(__self__, "boot_volume_id", boot_volume_id)
        if boot_volume_replica_id and not isinstance(boot_volume_replica_id, str):
            raise TypeError("Expected argument 'boot_volume_replica_id' to be a str")
        pulumi.set(__self__, "boot_volume_replica_id", boot_volume_replica_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if size_in_gbs and not isinstance(size_in_gbs, str):
            raise TypeError("Expected argument 'size_in_gbs' to be a str")
        pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_synced and not isinstance(time_last_synced, str):
            raise TypeError("Expected argument 'time_last_synced' to be a str")
        pulumi.set(__self__, "time_last_synced", time_last_synced)
        if volume_group_replica_id and not isinstance(volume_group_replica_id, str):
            raise TypeError("Expected argument 'volume_group_replica_id' to be a str")
        pulumi.set(__self__, "volume_group_replica_id", volume_group_replica_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the boot volume replica.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> str:
        """
        The OCID of the source boot volume.
        """
        return pulumi.get(self, "boot_volume_id")

    @property
    @pulumi.getter(name="bootVolumeReplicaId")
    def boot_volume_replica_id(self) -> str:
        return pulumi.get(self, "boot_volume_replica_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the boot volume replica.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The image OCID used to create the boot volume the replica is replicated from.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> str:
        """
        The size of the source boot volume, in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of a boot volume replica.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the boot volume replica was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> str:
        """
        The date and time the boot volume replica was last synced from the source boot volume. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_synced")

    @property
    @pulumi.getter(name="volumeGroupReplicaId")
    def volume_group_replica_id(self) -> str:
        return pulumi.get(self, "volume_group_replica_id")


class AwaitableGetBootVolumeReplicaResult(GetBootVolumeReplicaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBootVolumeReplicaResult(
            availability_domain=self.availability_domain,
            boot_volume_id=self.boot_volume_id,
            boot_volume_replica_id=self.boot_volume_replica_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_id=self.image_id,
            size_in_gbs=self.size_in_gbs,
            state=self.state,
            time_created=self.time_created,
            time_last_synced=self.time_last_synced,
            volume_group_replica_id=self.volume_group_replica_id)


def get_boot_volume_replica(boot_volume_replica_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBootVolumeReplicaResult:
    """
    This data source provides details about a specific Boot Volume Replica resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified boot volume replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume_replica = oci.Core.get_boot_volume_replica(boot_volume_replica_id=oci_core_boot_volume_replica["test_boot_volume_replica"]["id"])
    ```


    :param str boot_volume_replica_id: The OCID of the boot volume replica.
    """
    __args__ = dict()
    __args__['bootVolumeReplicaId'] = boot_volume_replica_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getBootVolumeReplica:getBootVolumeReplica', __args__, opts=opts, typ=GetBootVolumeReplicaResult).value

    return AwaitableGetBootVolumeReplicaResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        boot_volume_id=pulumi.get(__ret__, 'boot_volume_id'),
        boot_volume_replica_id=pulumi.get(__ret__, 'boot_volume_replica_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        size_in_gbs=pulumi.get(__ret__, 'size_in_gbs'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_synced=pulumi.get(__ret__, 'time_last_synced'),
        volume_group_replica_id=pulumi.get(__ret__, 'volume_group_replica_id'))


@_utilities.lift_output_func(get_boot_volume_replica)
def get_boot_volume_replica_output(boot_volume_replica_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBootVolumeReplicaResult]:
    """
    This data source provides details about a specific Boot Volume Replica resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified boot volume replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume_replica = oci.Core.get_boot_volume_replica(boot_volume_replica_id=oci_core_boot_volume_replica["test_boot_volume_replica"]["id"])
    ```


    :param str boot_volume_replica_id: The OCID of the boot volume replica.
    """
    ...
