# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemsResult',
    'AwaitableGetDbSystemsResult',
    'get_db_systems',
    'get_db_systems_output',
]

@pulumi.output_type
class GetDbSystemsResult:
    """
    A collection of values returned by getDbSystems.
    """
    def __init__(__self__, availability_domain=None, backup_id=None, compartment_id=None, db_systems=None, display_name=None, filters=None, id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_systems and not isinstance(db_systems, list):
            raise TypeError("Expected argument 'db_systems' to be a list")
        pulumi.set(__self__, "db_systems", db_systems)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The name of the availability domain that the DB system is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbSystems")
    def db_systems(self) -> Sequence['outputs.GetDbSystemsDbSystemResult']:
        """
        The list of db_systems.
        """
        return pulumi.get(self, "db_systems")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DB system.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbSystemsResult(GetDbSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemsResult(
            availability_domain=self.availability_domain,
            backup_id=self.backup_id,
            compartment_id=self.compartment_id,
            db_systems=self.db_systems,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_db_systems(availability_domain: Optional[str] = None,
                   backup_id: Optional[str] = None,
                   compartment_id: Optional[str] = None,
                   display_name: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetDbSystemsFilterArgs']]] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemsResult:
    """
    This data source provides the list of Db Systems in Oracle Cloud Infrastructure Database service.

    Lists the DB systems in the specified compartment. You can specify a `backupId` to list only the DB systems that support creating a database using this backup in this compartment.

    **Note:** Deprecated for Exadata Cloud Service systems. Use the [new resource model APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem.htm#exaflexsystem_topic-resource_model) instead.

    For Exadata Cloud Service instances, support for this API will end on May 15th, 2021. See [Switching an Exadata DB System to the New Resource Model and APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem_topic-resource_model_conversion.htm) for details on converting existing Exadata DB systems to the new resource model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems = oci.Database.get_db_systems(compartment_id=var["compartment_id"],
        availability_domain=var["db_system_availability_domain"],
        backup_id=oci_database_backup["test_backup"]["id"],
        display_name=var["db_system_display_name"],
        state=var["db_system_state"])
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup. Specify a backupId to list only the DB systems or DB homes that support creating a database using this backup in this compartment.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystems:getDbSystems', __args__, opts=opts, typ=GetDbSystemsResult).value

    return AwaitableGetDbSystemsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_id=pulumi.get(__ret__, 'backup_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_systems=pulumi.get(__ret__, 'db_systems'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_db_systems)
def get_db_systems_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                          backup_id: Optional[pulumi.Input[Optional[str]]] = None,
                          compartment_id: Optional[pulumi.Input[str]] = None,
                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbSystemsFilterArgs']]]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbSystemsResult]:
    """
    This data source provides the list of Db Systems in Oracle Cloud Infrastructure Database service.

    Lists the DB systems in the specified compartment. You can specify a `backupId` to list only the DB systems that support creating a database using this backup in this compartment.

    **Note:** Deprecated for Exadata Cloud Service systems. Use the [new resource model APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem.htm#exaflexsystem_topic-resource_model) instead.

    For Exadata Cloud Service instances, support for this API will end on May 15th, 2021. See [Switching an Exadata DB System to the New Resource Model and APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem_topic-resource_model_conversion.htm) for details on converting existing Exadata DB systems to the new resource model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems = oci.Database.get_db_systems(compartment_id=var["compartment_id"],
        availability_domain=var["db_system_availability_domain"],
        backup_id=oci_database_backup["test_backup"]["id"],
        display_name=var["db_system_display_name"],
        state=var["db_system_state"])
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup. Specify a backupId to list only the DB systems or DB homes that support creating a database using this backup in this compartment.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
