# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseResult',
    'AwaitableGetManagedDatabaseResult',
    'get_managed_database',
    'get_managed_database_output',
]

@pulumi.output_type
class GetManagedDatabaseResult:
    """
    A collection of values returned by getManagedDatabase.
    """
    def __init__(__self__, additional_details=None, compartment_id=None, database_status=None, database_sub_type=None, database_type=None, db_system_id=None, deployment_type=None, id=None, is_cluster=None, managed_database_groups=None, managed_database_id=None, management_option=None, name=None, parent_container_id=None, storage_system_id=None, time_created=None, workload_type=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_status and not isinstance(database_status, str):
            raise TypeError("Expected argument 'database_status' to be a str")
        pulumi.set(__self__, "database_status", database_status)
        if database_sub_type and not isinstance(database_sub_type, str):
            raise TypeError("Expected argument 'database_sub_type' to be a str")
        pulumi.set(__self__, "database_sub_type", database_sub_type)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if managed_database_groups and not isinstance(managed_database_groups, list):
            raise TypeError("Expected argument 'managed_database_groups' to be a list")
        pulumi.set(__self__, "managed_database_groups", managed_database_groups)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if management_option and not isinstance(management_option, str):
            raise TypeError("Expected argument 'management_option' to be a str")
        pulumi.set(__self__, "management_option", management_option)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_container_id and not isinstance(parent_container_id, str):
            raise TypeError("Expected argument 'parent_container_id' to be a str")
        pulumi.set(__self__, "parent_container_id", parent_container_id)
        if storage_system_id and not isinstance(storage_system_id, str):
            raise TypeError("Expected argument 'storage_system_id' to be a str")
        pulumi.set(__self__, "storage_system_id", storage_system_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if workload_type and not isinstance(workload_type, str):
            raise TypeError("Expected argument 'workload_type' to be a str")
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> str:
        """
        The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        """
        return pulumi.get(self, "database_status")

    @property
    @pulumi.getter(name="databaseSubType")
    def database_sub_type(self) -> str:
        """
        The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        """
        return pulumi.get(self, "database_sub_type")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        """
        The type of Oracle Database installation.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The infrastructure used to deploy the Oracle Database.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        Indicates whether the Oracle Database is part of a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="managedDatabaseGroups")
    def managed_database_groups(self) -> Sequence['outputs.GetManagedDatabaseManagedDatabaseGroupResult']:
        """
        A list of Managed Database Groups that the Managed Database belongs to.
        """
        return pulumi.get(self, "managed_database_groups")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="managementOption")
    def management_option(self) -> str:
        """
        The management option used when enabling Database Management.
        """
        return pulumi.get(self, "management_option")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentContainerId")
    def parent_container_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        """
        return pulumi.get(self, "parent_container_id")

    @property
    @pulumi.getter(name="storageSystemId")
    def storage_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        """
        return pulumi.get(self, "storage_system_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Managed Database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        The workload type of the Autonomous Database.
        """
        return pulumi.get(self, "workload_type")


class AwaitableGetManagedDatabaseResult(GetManagedDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseResult(
            additional_details=self.additional_details,
            compartment_id=self.compartment_id,
            database_status=self.database_status,
            database_sub_type=self.database_sub_type,
            database_type=self.database_type,
            db_system_id=self.db_system_id,
            deployment_type=self.deployment_type,
            id=self.id,
            is_cluster=self.is_cluster,
            managed_database_groups=self.managed_database_groups,
            managed_database_id=self.managed_database_id,
            management_option=self.management_option,
            name=self.name,
            parent_container_id=self.parent_container_id,
            storage_system_id=self.storage_system_id,
            time_created=self.time_created,
            workload_type=self.workload_type)


def get_managed_database(managed_database_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseResult:
    """
    This data source provides details about a specific Managed Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Managed Database specified by managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database = oci.DatabaseManagement.get_managed_database(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabase:getManagedDatabase', __args__, opts=opts, typ=GetManagedDatabaseResult).value

    return AwaitableGetManagedDatabaseResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_status=pulumi.get(__ret__, 'database_status'),
        database_sub_type=pulumi.get(__ret__, 'database_sub_type'),
        database_type=pulumi.get(__ret__, 'database_type'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        managed_database_groups=pulumi.get(__ret__, 'managed_database_groups'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        management_option=pulumi.get(__ret__, 'management_option'),
        name=pulumi.get(__ret__, 'name'),
        parent_container_id=pulumi.get(__ret__, 'parent_container_id'),
        storage_system_id=pulumi.get(__ret__, 'storage_system_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        workload_type=pulumi.get(__ret__, 'workload_type'))


@_utilities.lift_output_func(get_managed_database)
def get_managed_database_output(managed_database_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseResult]:
    """
    This data source provides details about a specific Managed Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Managed Database specified by managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database = oci.DatabaseManagement.get_managed_database(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    """
    ...
