# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult',
    'AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult',
    'get_managed_database_optimizer_statistics_advisor_execution',
    'get_managed_database_optimizer_statistics_advisor_execution_output',
]

@pulumi.output_type
class GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult:
    """
    A collection of values returned by getManagedDatabaseOptimizerStatisticsAdvisorExecution.
    """
    def __init__(__self__, databases=None, error_message=None, execution_name=None, findings=None, id=None, managed_database_id=None, reports=None, status=None, status_message=None, task_name=None, time_end=None, time_start=None):
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if execution_name and not isinstance(execution_name, str):
            raise TypeError("Expected argument 'execution_name' to be a str")
        pulumi.set(__self__, "execution_name", execution_name)
        if findings and not isinstance(findings, int):
            raise TypeError("Expected argument 'findings' to be a int")
        pulumi.set(__self__, "findings", findings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if reports and not isinstance(reports, list):
            raise TypeError("Expected argument 'reports' to be a list")
        pulumi.set(__self__, "reports", reports)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)
        if task_name and not isinstance(task_name, str):
            raise TypeError("Expected argument 'task_name' to be a str")
        pulumi.set(__self__, "task_name", task_name)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetManagedDatabaseOptimizerStatisticsAdvisorExecutionDatabaseResult']:
        """
        The summary of the Managed Database resource.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The errors in the Optimizer Statistics Advisor execution, if any.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="executionName")
    def execution_name(self) -> str:
        """
        The name of the Optimizer Statistics Advisor execution.
        """
        return pulumi.get(self, "execution_name")

    @property
    @pulumi.getter
    def findings(self) -> int:
        """
        The list of findings for the rule.
        """
        return pulumi.get(self, "findings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def reports(self) -> Sequence['outputs.GetManagedDatabaseOptimizerStatisticsAdvisorExecutionReportResult']:
        """
        A report that includes the rules, findings, recommendations, and actions discovered during the execution of the Optimizer Statistics Advisor.
        """
        return pulumi.get(self, "reports")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Optimizer Statistics Advisor execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The Optimizer Statistics Advisor execution status message, if any.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="taskName")
    def task_name(self) -> str:
        """
        The name of the Optimizer Statistics Advisor task.
        """
        return pulumi.get(self, "task_name")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        """
        The end time of the time range to retrieve the Optimizer Statistics Advisor execution of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        The start time of the time range to retrieve the Optimizer Statistics Advisor execution of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
        """
        return pulumi.get(self, "time_start")


class AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult(GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult(
            databases=self.databases,
            error_message=self.error_message,
            execution_name=self.execution_name,
            findings=self.findings,
            id=self.id,
            managed_database_id=self.managed_database_id,
            reports=self.reports,
            status=self.status,
            status_message=self.status_message,
            task_name=self.task_name,
            time_end=self.time_end,
            time_start=self.time_start)


def get_managed_database_optimizer_statistics_advisor_execution(execution_name: Optional[str] = None,
                                                                managed_database_id: Optional[str] = None,
                                                                task_name: Optional[str] = None,
                                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult:
    """
    This data source provides details about a specific Managed Database Optimizer Statistics Advisor Execution resource in Oracle Cloud Infrastructure Database Management service.

    Gets a comprehensive report of the Optimizer Statistics Advisor execution, which includes details of the
    Managed Database, findings, recommendations, rationale, and examples.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_advisor_execution = oci.DatabaseManagement.get_managed_database_optimizer_statistics_advisor_execution(execution_name=var["managed_database_optimizer_statistics_advisor_execution_execution_name"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        task_name=var["managed_database_optimizer_statistics_advisor_execution_task_name"])
    ```


    :param str execution_name: The name of the Optimizer Statistics Advisor execution.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str task_name: The name of the optimizer statistics collection execution task.
    """
    __args__ = dict()
    __args__['executionName'] = execution_name
    __args__['managedDatabaseId'] = managed_database_id
    __args__['taskName'] = task_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseOptimizerStatisticsAdvisorExecution:getManagedDatabaseOptimizerStatisticsAdvisorExecution', __args__, opts=opts, typ=GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult).value

    return AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult(
        databases=pulumi.get(__ret__, 'databases'),
        error_message=pulumi.get(__ret__, 'error_message'),
        execution_name=pulumi.get(__ret__, 'execution_name'),
        findings=pulumi.get(__ret__, 'findings'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        reports=pulumi.get(__ret__, 'reports'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'),
        task_name=pulumi.get(__ret__, 'task_name'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_managed_database_optimizer_statistics_advisor_execution)
def get_managed_database_optimizer_statistics_advisor_execution_output(execution_name: Optional[pulumi.Input[str]] = None,
                                                                       managed_database_id: Optional[pulumi.Input[str]] = None,
                                                                       task_name: Optional[pulumi.Input[str]] = None,
                                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseOptimizerStatisticsAdvisorExecutionResult]:
    """
    This data source provides details about a specific Managed Database Optimizer Statistics Advisor Execution resource in Oracle Cloud Infrastructure Database Management service.

    Gets a comprehensive report of the Optimizer Statistics Advisor execution, which includes details of the
    Managed Database, findings, recommendations, rationale, and examples.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_advisor_execution = oci.DatabaseManagement.get_managed_database_optimizer_statistics_advisor_execution(execution_name=var["managed_database_optimizer_statistics_advisor_execution_execution_name"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        task_name=var["managed_database_optimizer_statistics_advisor_execution_task_name"])
    ```


    :param str execution_name: The name of the Optimizer Statistics Advisor execution.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str task_name: The name of the optimizer statistics collection execution task.
    """
    ...
