# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'IntegrationInstanceAlternateCustomEndpoint',
    'IntegrationInstanceAttachment',
    'IntegrationInstanceCustomEndpoint',
    'IntegrationInstanceIdcsInfo',
    'IntegrationInstanceNetworkEndpointDetails',
    'IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn',
    'GetIntegrationInstanceAlternateCustomEndpointResult',
    'GetIntegrationInstanceAttachmentResult',
    'GetIntegrationInstanceCustomEndpointResult',
    'GetIntegrationInstanceIdcsInfoResult',
    'GetIntegrationInstanceNetworkEndpointDetailResult',
    'GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
    'GetIntegrationInstancesFilterResult',
    'GetIntegrationInstancesIntegrationInstanceResult',
    'GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult',
    'GetIntegrationInstancesIntegrationInstanceAttachmentResult',
    'GetIntegrationInstancesIntegrationInstanceCustomEndpointResult',
    'GetIntegrationInstancesIntegrationInstanceIdcsInfoResult',
    'GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult',
    'GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
]

@pulumi.output_type
class IntegrationInstanceAlternateCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceAlternateCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 alias: Optional[str] = None,
                 certificate_secret_id: Optional[str] = None,
                 certificate_secret_version: Optional[int] = None):
        """
        :param str hostname: (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class IntegrationInstanceAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isImplicit":
            suggest = "is_implicit"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "targetInstanceUrl":
            suggest = "target_instance_url"
        elif key == "targetRole":
            suggest = "target_role"
        elif key == "targetServiceType":
            suggest = "target_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_implicit: Optional[bool] = None,
                 target_id: Optional[str] = None,
                 target_instance_url: Optional[str] = None,
                 target_role: Optional[str] = None,
                 target_service_type: Optional[str] = None):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        if is_implicit is not None:
            pulumi.set(__self__, "is_implicit", is_implicit)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_instance_url is not None:
            pulumi.set(__self__, "target_instance_url", target_instance_url)
        if target_role is not None:
            pulumi.set(__self__, "target_role", target_role)
        if target_service_type is not None:
            pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> Optional[bool]:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> Optional[str]:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> Optional[str]:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> Optional[str]:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class IntegrationInstanceCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 alias: Optional[str] = None,
                 certificate_secret_id: Optional[str] = None,
                 certificate_secret_version: Optional[int] = None):
        """
        :param str hostname: (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class IntegrationInstanceIdcsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idcsAppDisplayName":
            suggest = "idcs_app_display_name"
        elif key == "idcsAppId":
            suggest = "idcs_app_id"
        elif key == "idcsAppLocationUrl":
            suggest = "idcs_app_location_url"
        elif key == "idcsAppName":
            suggest = "idcs_app_name"
        elif key == "instancePrimaryAudienceUrl":
            suggest = "instance_primary_audience_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceIdcsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceIdcsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceIdcsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idcs_app_display_name: Optional[str] = None,
                 idcs_app_id: Optional[str] = None,
                 idcs_app_location_url: Optional[str] = None,
                 idcs_app_name: Optional[str] = None,
                 instance_primary_audience_url: Optional[str] = None):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string
        """
        if idcs_app_display_name is not None:
            pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        if idcs_app_id is not None:
            pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        if idcs_app_location_url is not None:
            pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        if idcs_app_name is not None:
            pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        if instance_primary_audience_url is not None:
            pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> Optional[str]:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> Optional[str]:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> Optional[str]:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> Optional[str]:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> Optional[str]:
        """
        The URL used as the primary audience for integration flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class IntegrationInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "allowlistedHttpIps":
            suggest = "allowlisted_http_ips"
        elif key == "allowlistedHttpVcns":
            suggest = "allowlisted_http_vcns"
        elif key == "isIntegrationVcnAllowlisted":
            suggest = "is_integration_vcn_allowlisted"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: str,
                 allowlisted_http_ips: Optional[Sequence[str]] = None,
                 allowlisted_http_vcns: Optional[Sequence['outputs.IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn']] = None,
                 is_integration_vcn_allowlisted: Optional[bool] = None):
        """
        :param str network_endpoint_type: The type of network endpoint.
        :param Sequence[str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if allowlisted_http_ips is not None:
            pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        if allowlisted_http_vcns is not None:
            pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        if is_integration_vcn_allowlisted is not None:
            pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Optional[Sequence[str]]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Optional[Sequence['outputs.IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn']]:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> Optional[bool]:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")


@pulumi.output_type
class IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistedIps":
            suggest = "allowlisted_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 allowlisted_ips: Optional[Sequence[str]] = None):
        """
        :param str id: The Virtual Cloud Network OCID.
        :param Sequence[str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        pulumi.set(__self__, "id", id)
        if allowlisted_ips is not None:
            pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Optional[Sequence[str]]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")


@pulumi.output_type
class GetIntegrationInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetIntegrationInstanceAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: bool,
                 target_id: str,
                 target_instance_url: str,
                 target_role: str,
                 target_service_type: str):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        pulumi.set(__self__, "is_implicit", is_implicit)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_instance_url", target_instance_url)
        pulumi.set(__self__, "target_role", target_role)
        pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> str:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetIntegrationInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetIntegrationInstanceIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: str,
                 idcs_app_id: str,
                 idcs_app_location_url: str,
                 idcs_app_name: str,
                 instance_primary_audience_url: str):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string
        """
        pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> str:
        """
        The URL used as the primary audience for integration flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetIntegrationInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[str],
                 allowlisted_http_vcns: Sequence['outputs.GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 is_integration_vcn_allowlisted: bool,
                 network_endpoint_type: str):
        """
        :param Sequence[str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        :param str network_endpoint_type: The type of network endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> bool:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")


@pulumi.output_type
class GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ips: Sequence[str],
                 id: str):
        """
        :param Sequence[str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetIntegrationInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceResult(dict):
    def __init__(__self__, *,
                 alternate_custom_endpoints: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult'],
                 attachments: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAttachmentResult'],
                 compartment_id: str,
                 consumption_model: str,
                 custom_endpoints: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceCustomEndpointResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 domain_id: str,
                 enable_process_automation_trigger: int,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idcs_at: str,
                 idcs_infos: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceIdcsInfoResult'],
                 instance_url: str,
                 integration_instance_type: str,
                 is_byol: bool,
                 is_file_server_enabled: bool,
                 is_visual_builder_enabled: bool,
                 message_packs: int,
                 network_endpoint_details: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult'],
                 shape: str,
                 state: str,
                 state_message: str,
                 time_created: str,
                 time_updated: str):
        """
        :param Sequence['GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointArgs'] alternate_custom_endpoints: A list of alternate custom endpoints used for the integration instance URL.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceAttachmentArgs'] attachments: A list of associated attachments to other services
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str consumption_model: The entitlement used for billing purposes.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceCustomEndpointArgs'] custom_endpoints: Details for a custom endpoint for the integration instance.
        :param Mapping[str, Any] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The Virtual Cloud Network OCID.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceIdcsInfoArgs'] idcs_infos: Information for IDCS access
        :param str instance_url: The Integration Instance URL.
        :param str integration_instance_type: Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param bool is_byol: Bring your own license.
        :param bool is_file_server_enabled: The file server is enabled or not.
        :param bool is_visual_builder_enabled: Visual Builder is enabled or not.
        :param int message_packs: The number of configured message packs (if any)
        :param Sequence['GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param str shape: Shape
        :param str state: Life cycle state to query on.
        :param str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str time_created: The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        pulumi.set(__self__, "attachments", attachments)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "consumption_model", consumption_model)
        pulumi.set(__self__, "custom_endpoints", custom_endpoints)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "enable_process_automation_trigger", enable_process_automation_trigger)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_at", idcs_at)
        pulumi.set(__self__, "idcs_infos", idcs_infos)
        pulumi.set(__self__, "instance_url", instance_url)
        pulumi.set(__self__, "integration_instance_type", integration_instance_type)
        pulumi.set(__self__, "is_byol", is_byol)
        pulumi.set(__self__, "is_file_server_enabled", is_file_server_enabled)
        pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        pulumi.set(__self__, "message_packs", message_packs)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the integration instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAttachmentResult']:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceCustomEndpointResult']:
        """
        Details for a custom endpoint for the integration instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="enableProcessAutomationTrigger")
    def enable_process_automation_trigger(self) -> int:
        return pulumi.get(self, "enable_process_automation_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> str:
        return pulumi.get(self, "idcs_at")

    @property
    @pulumi.getter(name="idcsInfos")
    def idcs_infos(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceIdcsInfoResult']:
        """
        Information for IDCS access
        """
        return pulumi.get(self, "idcs_infos")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The Integration Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="integrationInstanceType")
    def integration_instance_type(self) -> str:
        """
        Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        """
        return pulumi.get(self, "integration_instance_type")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> bool:
        """
        Bring your own license.
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isFileServerEnabled")
    def is_file_server_enabled(self) -> bool:
        """
        The file server is enabled or not.
        """
        return pulumi.get(self, "is_file_server_enabled")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="messagePacks")
    def message_packs(self) -> int:
        """
        The number of configured message packs (if any)
        """
        return pulumi.get(self, "message_packs")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Life cycle state to query on.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: bool,
                 target_id: str,
                 target_instance_url: str,
                 target_role: str,
                 target_service_type: str):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        pulumi.set(__self__, "is_implicit", is_implicit)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_instance_url", target_instance_url)
        pulumi.set(__self__, "target_role", target_role)
        pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> str:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: str,
                 idcs_app_id: str,
                 idcs_app_location_url: str,
                 idcs_app_name: str,
                 instance_primary_audience_url: str):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string
        """
        pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> str:
        """
        The URL used as the primary audience for integration flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[str],
                 allowlisted_http_vcns: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 is_integration_vcn_allowlisted: bool,
                 network_endpoint_type: str):
        """
        :param Sequence[str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        :param str network_endpoint_type: The type of network endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> bool:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ips: Sequence[str],
                 id: str):
        """
        :param Sequence[str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


