# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogArgs', 'Log']

@pulumi.input_type
class LogArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 log_group_id: pulumi.Input[str],
                 log_type: pulumi.Input[str],
                 configuration: Optional[pulumi.Input['LogConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 retention_duration: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Log resource.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] log_group_id: (Updatable) OCID of a log group to work with.
        :param pulumi.Input[str] log_type: The logType that the log object is for, whether custom or service.
        :param pulumi.Input['LogConfigurationArgs'] configuration: Log object configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[int] retention_duration: (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_type", log_type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of a log group to work with.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Input[str]:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['LogConfigurationArgs']]:
        """
        Log object configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['LogConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_duration", value)


@pulumi.input_type
class _LogState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input['LogConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 retention_duration: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_modified: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Log resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that the resource belongs to.
        :param pulumi.Input['LogConfigurationArgs'] configuration: Log object configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[str] log_group_id: (Updatable) OCID of a log group to work with.
        :param pulumi.Input[str] log_type: The logType that the log object is for, whether custom or service.
        :param pulumi.Input[int] retention_duration: (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The pipeline state.
        :param pulumi.Input[str] tenancy_id: The OCID of the tenancy.
        :param pulumi.Input[str] time_created: Time the resource was created.
        :param pulumi.Input[str] time_last_modified: Time the resource was last modified.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_modified is not None:
            pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['LogConfigurationArgs']]:
        """
        Log object configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['LogConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of a log group to work with.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")

    @time_last_modified.setter
    def time_last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_modified", value)


class Log(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['LogConfigurationArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 retention_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Log resource in Oracle Cloud Infrastructure Logging service.

        Creates a log within the specified log group. This call fails if a log group has already been created
        with the same displayName or (service, resource, category) triplet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log = oci.logging.Log("testLog",
            display_name=var["log_display_name"],
            log_group_id=oci_logging_log_group["test_log_group"]["id"],
            log_type=var["log_log_type"],
            configuration=oci.logging.LogConfigurationArgs(
                source=oci.logging.LogConfigurationSourceArgs(
                    category=var["log_configuration_source_category"],
                    resource=var["log_configuration_source_resource"],
                    service=var["log_configuration_source_service"],
                    source_type=var["log_configuration_source_source_type"],
                    parameters=var["log_configuration_source_parameters"],
                ),
                compartment_id=var["compartment_id"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_enabled=var["log_is_enabled"],
            retention_duration=var["log_retention_duration"])
        ```

        ## Import

        Logs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Logging/log:Log test_log "logGroupId/{logGroupId}/logId/{logId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LogConfigurationArgs']] configuration: Log object configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[str] log_group_id: (Updatable) OCID of a log group to work with.
        :param pulumi.Input[str] log_type: The logType that the log object is for, whether custom or service.
        :param pulumi.Input[int] retention_duration: (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log resource in Oracle Cloud Infrastructure Logging service.

        Creates a log within the specified log group. This call fails if a log group has already been created
        with the same displayName or (service, resource, category) triplet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log = oci.logging.Log("testLog",
            display_name=var["log_display_name"],
            log_group_id=oci_logging_log_group["test_log_group"]["id"],
            log_type=var["log_log_type"],
            configuration=oci.logging.LogConfigurationArgs(
                source=oci.logging.LogConfigurationSourceArgs(
                    category=var["log_configuration_source_category"],
                    resource=var["log_configuration_source_resource"],
                    service=var["log_configuration_source_service"],
                    source_type=var["log_configuration_source_source_type"],
                    parameters=var["log_configuration_source_parameters"],
                ),
                compartment_id=var["compartment_id"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_enabled=var["log_is_enabled"],
            retention_duration=var["log_retention_duration"])
        ```

        ## Import

        Logs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Logging/log:Log test_log "logGroupId/{logGroupId}/logId/{logId}"
        ```

        :param str resource_name: The name of the resource.
        :param LogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['LogConfigurationArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 retention_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogArgs.__new__(LogArgs)

            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            if log_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_id'")
            __props__.__dict__["log_group_id"] = log_group_id
            if log_type is None and not opts.urn:
                raise TypeError("Missing required property 'log_type'")
            __props__.__dict__["log_type"] = log_type
            __props__.__dict__["retention_duration"] = retention_duration
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_modified"] = None
        super(Log, __self__).__init__(
            'oci:Logging/log:Log',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            configuration: Optional[pulumi.Input[pulumi.InputType['LogConfigurationArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            log_group_id: Optional[pulumi.Input[str]] = None,
            log_type: Optional[pulumi.Input[str]] = None,
            retention_duration: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tenancy_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_modified: Optional[pulumi.Input[str]] = None) -> 'Log':
        """
        Get an existing Log resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[pulumi.InputType['LogConfigurationArgs']] configuration: Log object configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[str] log_group_id: (Updatable) OCID of a log group to work with.
        :param pulumi.Input[str] log_type: The logType that the log object is for, whether custom or service.
        :param pulumi.Input[int] retention_duration: (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The pipeline state.
        :param pulumi.Input[str] tenancy_id: The OCID of the tenancy.
        :param pulumi.Input[str] time_created: Time the resource was created.
        :param pulumi.Input[str] time_last_modified: Time the resource was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogState.__new__(_LogState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_type"] = log_type
        __props__.__dict__["retention_duration"] = retention_duration
        __props__.__dict__["state"] = state
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_modified"] = time_last_modified
        return Log(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.LogConfiguration']:
        """
        Log object configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of a log group to work with.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Output[str]:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> pulumi.Output[int]:
        """
        (Updatable) Log retention duration in 30-day increments (30, 60, 90 and so on until 180).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[str]:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> pulumi.Output[str]:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")

