# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOpensearchClustersResult',
    'AwaitableGetOpensearchClustersResult',
    'get_opensearch_clusters',
    'get_opensearch_clusters_output',
]

@pulumi.output_type
class GetOpensearchClustersResult:
    """
    A collection of values returned by getOpensearchClusters.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, opensearch_cluster_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opensearch_cluster_collections and not isinstance(opensearch_cluster_collections, list):
            raise TypeError("Expected argument 'opensearch_cluster_collections' to be a list")
        pulumi.set(__self__, "opensearch_cluster_collections", opensearch_cluster_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment where the cluster is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOpensearchClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="opensearchClusterCollections")
    def opensearch_cluster_collections(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionResult']:
        """
        The list of opensearch_cluster_collection.
        """
        return pulumi.get(self, "opensearch_cluster_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetOpensearchClustersResult(GetOpensearchClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchClustersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            opensearch_cluster_collections=self.opensearch_cluster_collections,
            state=self.state)


def get_opensearch_clusters(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetOpensearchClustersFilterArgs']]] = None,
                            id: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchClustersResult:
    """
    This data source provides the list of Opensearch Clusters in Oracle Cloud Infrastructure Opensearch service.

    Returns a list of OpensearchClusters.

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment
    ```python
    import pulumi
    ```

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_clusters = oci.Opensearch.get_opensearch_clusters(compartment_id=var["compartment_id"],
        display_name=var["opensearch_cluster_display_name"],
        id=var["opensearch_cluster_id"],
        state=var["opensearch_cluster_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique OpensearchCluster identifier
    :param str state: A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opensearch/getOpensearchClusters:getOpensearchClusters', __args__, opts=opts, typ=GetOpensearchClustersResult).value

    return AwaitableGetOpensearchClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        opensearch_cluster_collections=pulumi.get(__ret__, 'opensearch_cluster_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_opensearch_clusters)
def get_opensearch_clusters_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOpensearchClustersFilterArgs']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpensearchClustersResult]:
    """
    This data source provides the list of Opensearch Clusters in Oracle Cloud Infrastructure Opensearch service.

    Returns a list of OpensearchClusters.

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment
    ```python
    import pulumi
    ```

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_clusters = oci.Opensearch.get_opensearch_clusters(compartment_id=var["compartment_id"],
        display_name=var["opensearch_cluster_display_name"],
        id=var["opensearch_cluster_id"],
        state=var["opensearch_cluster_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique OpensearchCluster identifier
    :param str state: A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
    """
    ...
