# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetContainerScanRecipeResult',
    'AwaitableGetContainerScanRecipeResult',
    'get_container_scan_recipe',
    'get_container_scan_recipe_output',
]

@pulumi.output_type
class GetContainerScanRecipeResult:
    """
    A collection of values returned by getContainerScanRecipe.
    """
    def __init__(__self__, compartment_id=None, container_scan_recipe_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_count=None, scan_settings=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if container_scan_recipe_id and not isinstance(container_scan_recipe_id, str):
            raise TypeError("Expected argument 'container_scan_recipe_id' to be a str")
        pulumi.set(__self__, "container_scan_recipe_id", container_scan_recipe_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_count and not isinstance(image_count, int):
            raise TypeError("Expected argument 'image_count' to be a int")
        pulumi.set(__self__, "image_count", image_count)
        if scan_settings and not isinstance(scan_settings, list):
            raise TypeError("Expected argument 'scan_settings' to be a list")
        pulumi.set(__self__, "scan_settings", scan_settings)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerScanRecipeId")
    def container_scan_recipe_id(self) -> str:
        return pulumi.get(self, "container_scan_recipe_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User friendly name of container scan recipe
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of container scan recipe. Immutable and generated on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> int:
        """
        This field is set equal to the number of images we want to scan in the first go when the recipe is created
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter(name="scanSettings")
    def scan_settings(self) -> Sequence['outputs.GetContainerScanRecipeScanSettingResult']:
        """
        A collection of container scan settings
        """
        return pulumi.get(self, "scan_settings")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetContainerScanRecipeResult(GetContainerScanRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerScanRecipeResult(
            compartment_id=self.compartment_id,
            container_scan_recipe_id=self.container_scan_recipe_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_count=self.image_count,
            scan_settings=self.scan_settings,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_container_scan_recipe(container_scan_recipe_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerScanRecipeResult:
    """
    This data source provides details about a specific Container Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a ContainerScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_recipe = oci.VulnerabilityScanning.get_container_scan_recipe(container_scan_recipe_id=oci_vulnerability_scanning_container_scan_recipe["test_container_scan_recipe"]["id"])
    ```


    :param str container_scan_recipe_id: unique ContainerScanRecipe identifier
    """
    __args__ = dict()
    __args__['containerScanRecipeId'] = container_scan_recipe_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getContainerScanRecipe:getContainerScanRecipe', __args__, opts=opts, typ=GetContainerScanRecipeResult).value

    return AwaitableGetContainerScanRecipeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        container_scan_recipe_id=pulumi.get(__ret__, 'container_scan_recipe_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_count=pulumi.get(__ret__, 'image_count'),
        scan_settings=pulumi.get(__ret__, 'scan_settings'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_container_scan_recipe)
def get_container_scan_recipe_output(container_scan_recipe_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContainerScanRecipeResult]:
    """
    This data source provides details about a specific Container Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a ContainerScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_recipe = oci.VulnerabilityScanning.get_container_scan_recipe(container_scan_recipe_id=oci_vulnerability_scanning_container_scan_recipe["test_container_scan_recipe"]["id"])
    ```


    :param str container_scan_recipe_id: unique ContainerScanRecipe identifier
    """
    ...
